/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileHistoryUiFactory
implements VcsLogManager.VcsLogUiFactory<FileHistoryUi> {
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myHash;

    FileHistoryUiFactory(@NotNull FilePath path, @NotNull VirtualFile root, @Nullable Hash hash) {
        if (path == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(0);
        }
        if (root == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(1);
        }
        this.myFilePath = path;
        this.myRoot = root;
        this.myHash = hash;
    }

    @Override
    @NotNull
    public FileHistoryUi createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
        if (project == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(2);
        }
        if (logData == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(3);
        }
        FileHistoryUiProperties properties = (FileHistoryUiProperties)project.getService(FileHistoryUiProperties.class);
        VcsLogFilterCollection filters = FileHistoryFilterer.createFilters(this.myFilePath, this.myHash, this.myRoot);
        String logId = FileHistoryUi.getFileHistoryLogId(this.myFilePath, this.myHash);
        final VisiblePackRefresherImpl visiblePackRefresher = new VisiblePackRefresherImpl(project, logData, filters, (PermanentGraph.Options)PermanentGraph.Options.Default, new FileHistoryFilterer(logData, logId), logId);
        VcsLogProvider provider = Objects.requireNonNull(logData.getLogProviders().get(this.myRoot));
        FileHistoryUi ui = new FileHistoryUi(logData, properties, visiblePackRefresher, this.myFilePath, this.myHash, this.myRoot, logId, filters, Objects.requireNonNull(provider.getDiffHandler()));
        RegistryValueListener registryValueListener = new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                visiblePackRefresher.onRefresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/vcs/log/history/FileHistoryUiFactory$1", "afterValueChanged"));
            }
        };
        FileHistoryBuilder.refineValue.addListener(registryValueListener, (Disposable)ui);
        FileHistoryBuilder.removeTrivialMergesValue.addListener(registryValueListener, (Disposable)ui);
        FileHistoryUi fileHistoryUi = ui;
        if (fileHistoryUi == null) {
            FileHistoryUiFactory.$$$reportNull$$$0(4);
        }
        return fileHistoryUi;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUiFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUiFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLogUi";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

