#!/usr/bin/env python

# xfcemintConfig
#	No Copyright (What for?) 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; Version 2
# of the License.
#
# This program is made from the mintConfig in Linux Mint 3.0. 


import sys
try:
     import pygtk
     pygtk.require("2.0")
except:
      pass
try:
    import gtk
    import gtk.glade
    import pango
    import os
    import gconf
    import gettext
    import locale

except:
    print "You do not have all the dependencies!"
    sys.exit(1)
# i18n
gettext.install("messages", "/usr/lib/linuxmint/xfcemintConfig/locale") 

class switch(object):
    def __init__(self, value):
        self.value = value
        self.fall = False

    def __iter__(self):
        """Return the match method once, then stop"""
        yield self.match
        raise StopIteration

    def match(self, *args):
        """Indicate whether or not to enter a case suite"""
        if self.fall or not args:
            return True
        elif self.value in args:
            self.fall = True
            return True
        else:
            return False


class mintConfigWindow:
    """This is the main class for the application"""

    def __init__(self):

        locale.setlocale(locale.LC_ALL, '')
        loc = locale.getlocale() # get current locale
        self.MyLoc = loc[0]

        client = gconf.client_get_default()
        if not client.dir_exists ('/apps/xfcemintConfig'):
            client.add_dir ('/apps/xfcemintConfig', gconf.CLIENT_PRELOAD_NONE)


        overide_locale = client.get_bool('/apps/xfcemintConfig/override_locale')
        for case in switch(overide_locale):
            if case(True):
                self.MyLoc = client.get_string('/apps/xfcemintConfig/locale_to_use')
                break
            if case(False):
                client.set_bool('/apps/xfcemintConfig/override_locale',False)
                client.set_string('/apps/xfcemintConfig/locale_to_use','en')
                break

	try:
		back_color = client.get_string('/apps/xfcemintConfig/back_color')
		if self.evalcolor(back_color) == False:
			client.set_string('/apps/xfcemintConfig/back_color',"#ffffff")
			back_color = client.get_string('/apps/xfcemintConfig/back_color')
	except:
		client.set_string('/apps/xfcemintConfig/back_color',"#ffffff")
		back_color = client.get_string('/apps/xfcemintConfig/back_color')

        
        
        #Set the Glade file
        self.gladefile = "/usr/lib/linuxmint/xfcemintConfig/mintConfig_frontend.glade"
        self.wTree = gtk.glade.XML(self.gladefile,"window1")

        #Create tooltips
        self.CCTips = gtk.Tooltips()

        client.add_dir('/apps/xfcemintConfig', gconf.CLIENT_PRELOAD_NONE)
        client.notify_add('/apps/xfcemintConfig/groups_pos',self.SetGroupLocation)
        client.notify_add('/apps/xfcemintConfig/hide_group_label',self.SetGroupLocation)
        client.notify_add('/apps/xfcemintConfig/use_tabs_instead',self.SetGroupLocation)

        self.SetGroupLocation(client)
        self.RememberGroups(client)

        show_tips = client.get_bool('/apps/xfcemintConfig/use_tabs_instead')
        for case in switch(show_tips):
            if case(True):
                self.CCTips.enable()
                break
            if case(False):
                self.CCTips.disable()
                client.set_bool('/apps/xfcemintConfig/use_tabs_instead',False)
                break

        show_tips = client.get_bool('/apps/xfcemintConfig/show_tips')
        for case in switch(show_tips):
            if case(True):
                self.CCTips.enable()
                break
            if case(False):
                self.CCTips.disable()
                client.set_bool('/apps/xfcemintConfig/show_tips',False)
                break


        # Add standard Items
        print "Adding standard items"
        self.add_button("hbuttonbox7","/usr/share/applications/hardinfo.desktop",True,"")
	self.add_button("hbuttonbox8","/usr/share/applications/palimpsest.desktop",True,"")         	
	self.add_button("hbuttonbox7","/usr/share/applications/ndisgtk.desktop",True,"")
        self.add_button("hbuttonbox8","/usr/share/applications/jockey-gtk.desktop",True,"")        
        self.add_button("hbuttonbox7","/usr/share/applications/chestnut-dialer-gtk2.desktop",True,"")	

        self.add_button("hbuttonbox10","/usr/share/applications/xfce-display-settings.desktop",True,"")
	self.add_button("hbuttonbox10","/usr/share/applications/xfce-keyboard-settings.desktop",True,"")
        self.add_button("hbuttonbox11","/usr/share/applications/xfprint-settings.desktop",True,"")
        self.add_button("hbuttonbox12","/usr/share/applications/system-config-printer.desktop",True,"")
	self.add_button("hbuttonbox11","/usr/share/applications/xfce-mouse-settings.desktop",True,"")
        self.add_button("hbuttonbox12","/usr/share/applications/xfce4-mixer.desktop",True,"")
        self.add_button("hbuttonbox11","/usr/share/applications/thunar-volman-settings.desktop",True,"")
        self.add_button("hbuttonbox12","/usr/share/applications/bluetooth-properties.desktop",True,"")
        self.add_button("hbuttonbox10","/usr/share/applications/scim-setup.desktop",True,"")
	self.add_button("hbuttonbox10","/usr/share/applications/flegita.desktop",True,"")
	self.add_button("hbuttonbox12","/usr/share/applications/nvidia-settings.desktop",True,"")

        self.add_button("hbuttonbox13","/usr/share/applications/nm-connection-editor.desktop",True,"") 
        self.add_button("hbuttonbox14","/usr/share/applications/network.desktop",True,"")
	self.add_button("hbuttonbox14","/usr/share/applications/mintNanny.desktop",True,"")
        self.add_button("hbuttonbox13","/usr/share/applications/gnome-network-properties.desktop",True,"")
	self.add_button("hbuttonbox14","/usr/share/applications/shares.desktop",True,"")
	self.add_button("hbuttonbox14","/usr/share/applications/vino-preferences-xfce.desktop",True,"")
        self.add_button("hbuttonbox13","/usr/share/applications/pyNeighborhood.desktop",True,"")
	self.add_button("hbuttonbox13","/usr/share/applications/gnome-nettool.desktop",True,"")

       
        self.add_button("hbuttonbox16","/usr/share/applications/xfce4-appfinder.desktop",True,"")        
	self.add_button("hbuttonbox18","/usr/share/applications/xfce4-settings-editor.desktop",True,"")
	self.add_button("hbuttonbox17","/usr/share/applications/xfce-xfcalendar-settings.desktop",True,"")
	self.add_button("hbuttonbox17","/usr/share/applications/exo-preferred-applications.desktop",True,"")
        self.add_button("hbuttonbox18","/usr/share/applications/xfce-session-settings.desktop",True,"")
        self.add_button("hbuttonbox18","/usr/share/applications/gnome-system-monitor.desktop",True,"")
        self.add_button("hbuttonbox17","/usr/share/applications/gconf-editor.desktop",True,"")
	self.add_button("hbuttonbox18","/usr/share/applications/seahorse-pgp-preferences.desktop",True,"")
        self.add_button("hbuttonbox16","/usr/share/applications/language-selector.desktop",True,"")
	self.add_button("hbuttonbox17","/usr/share/applications/polkit-gnome-authorization.desktop",True,"")	
        self.add_button("hbuttonbox16","/usr/share/applications/time.desktop",True,"")
	self.add_button("hbuttonbox16","/usr/share/applications/synaptic-mintconfig.desktop",True,"")
	self.add_button("hbuttonbox18","/usr/share/applications/mintUpdate.desktop",True,"")
        self.add_button("hbuttonbox17","/usr/share/applications/users.desktop",True,"")
        self.add_button("hbuttonbox16","/usr/share/applications/mintInstall.desktop",True,"")
        self.add_button("hbuttonbox17","/usr/share/applications/mintBackup.desktop",True,"")
        self.add_button("hbuttonbox18","/usr/share/applications/mintwelcome.desktop",True,"")
        self.add_button("hbuttonbox16","/usr/share/applications/file-uploader.desktop",True,"")
        
	self.add_button("vbuttonbox5","/usr/share/applications/xfce-backdrop-settings.desktop",True,"")
	self.add_button("vbuttonbox5","/usr/share/applications/xfce-ui-settings.desktop",True,"")
        self.add_button("vbuttonbox6","/usr/share/applications/xfce-wm-settings.desktop",True,"")	
	self.add_button("vbuttonbox7","/usr/share/applications/xfce-wmtweaks-settings.desktop",True,"")
        self.add_button("vbuttonbox7","/usr/share/applications/xfce-workspaces-settings.desktop",True,"")
        self.add_button("vbuttonbox5","/usr/share/applications/gdmsetup.desktop",True,"")
	self.add_button("vbuttonbox6","/usr/share/applications/xfcemintDesktop.desktop",True,"")
        self.add_button("vbuttonbox7","/usr/share/applications/emerald-theme-manager.desktop",True,"")
	self.add_button("vbuttonbox5","/usr/share/applications/ccsm.desktop",True,"")	      

	
        custom_list1 = client.get_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING)
        custom_list2 = client.get_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING)
        custom_list3 = client.get_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING)


        # Add Custom Items
        print "Adding Custom items"

        if custom_list1 == 0:
            custom_list1 = client.set_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING,[""])
        if custom_list2 == 0:
            custom_list2 = client.set_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING,[""])
        if custom_list3 == 0:
            custom_list3 = client.set_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING,[""])

        for i in range(len(custom_list1)):
            self.add_button("vbuttonbox2",custom_list1[i],True,"")
        for i in range(len(custom_list2)):
            self.add_button("vbuttonbox3",custom_list2[i],True,"")
        for i in range(len(custom_list3)):
            self.add_button("vbuttonbox4",custom_list3[i],True,"")

        #Set window colors
        self.wTree.get_widget("notebook1").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
        self.wTree.get_widget("viewport1").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
	self.wTree.get_widget("viewport2").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
	self.wTree.get_widget("viewport3").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
	self.wTree.get_widget("viewport4").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
	self.wTree.get_widget("viewport5").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))
	self.wTree.get_widget("viewport6").modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse(back_color))

        #Set a new style for the headings
        HeadingStyle = pango.AttrList()
        attr = pango.AttrSize(13000,0,-1)
        HeadingStyle.insert(attr)
        attr = pango.AttrForeground(24576,34816,41728,0,-1)
        HeadingStyle.insert(attr)
        
        #Translate Labels
        self.wTree.get_widget("label142").set_label(_("Groups"))
	self.wTree.get_widget("label151").set_label(_("Groups"))
	self.wTree.get_widget("label147").set_label(_("Hardware"))
	self.wTree.get_widget("label137").set_label(_("Hardware"))
	self.wTree.get_widget("label50").set_label(_("Hardware"))
	self.wTree.get_widget("label53").set_label(_("Hardware"))
	self.wTree.get_widget("label148").set_label(_("Devices"))
	self.wTree.get_widget("label134").set_label(_("Devices"))
	self.wTree.get_widget("label51").set_label(_("Devices"))
	self.wTree.get_widget("label72").set_label(_("Devices"))
	self.wTree.get_widget("label149").set_label(_("Networking"))
	self.wTree.get_widget("label135").set_label(_("Networking"))
	self.wTree.get_widget("label52").set_label(_("Networking"))
	self.wTree.get_widget("label91").set_label(_("Networking"))
	self.wTree.get_widget("label150").set_label(_("Administration"))
 	self.wTree.get_widget("label136").set_label(_("Administration"))
 	self.wTree.get_widget("label110").set_label(_("Administration"))
 	self.wTree.get_widget("label111").set_label(_("Administration"))
 	self.wTree.get_widget("label156").set_label(_("Desktop"))
 	self.wTree.get_widget("label161").set_label(_("Desktop"))
 	self.wTree.get_widget("label167").set_label(_("Desktop"))
 	self.wTree.get_widget("label168").set_label(_("Desktop"))
 	self.wTree.get_widget("label165").set_label(_("Custom"))
 	self.wTree.get_widget("label166").set_label(_("Custom"))
 	self.wTree.get_widget("label154").set_label(_("Custom"))
 	self.wTree.get_widget("label155").set_label(_("Custom"))
	self.wTree.get_widget("label159").set_label(_("Drag menu items here to add"))
		
        #Apply Style to the selected headings
        MyHeadings = [ "label53", "label72", "label91", "label111", "label142",\
                      "label151", "label155", "label168"]
        for i in range(len(MyHeadings)):
            self.wTree.get_widget(MyHeadings[i]).set_attributes(HeadingStyle)



        #Create our dictionay and connect it
        dic = {"on_hardware_clicked" : (self.ChangeTab,client,0),
               "on_lookandfeel_clicked" : (self.ChangeTab,client,1),
               "on_personal_clicked" : (self.ChangeTab,client,2),
               "on_system_clicked" : (self.ChangeTab,client,3),
	       "on_desktop_clicked" : (self.ChangeTab,client,4),
               "on_custom_clicked" : (self.ChangeTab,client,5),

               "on_vbuttonbox_drag_motion": self.motion_cb,
               "on_vbuttonbox_drag_drop": self.drop_cb,
               "on_vbuttonbox_drag_data_received": self.got_data,
               "on_button81_clicked" : self.PrefsClicked,
               "on_button60_clicked" : gtk.main_quit,
               "on_button78_clicked" : gtk.main_quit,
               "on_window1_destroy" : (self.close_window, client, self.wTree.get_widget("window1").get_size()[0], self.wTree.get_widget("window1").get_size()[1])}
        self.wTree.signal_autoconnect(dic)

        self.wTree.get_widget("vbuttonbox4").drag_dest_set(0, [], 0)
        self.wTree.get_widget("vbuttonbox4").remove(self.wTree.get_widget("vbuttonbox4").get_children()[0])
        self.wTree.get_widget("vbuttonbox2").drag_dest_set(0, [], 0)
        self.wTree.get_widget("vbuttonbox2").remove(self.wTree.get_widget("vbuttonbox2").get_children()[0])
        self.wTree.get_widget("vbuttonbox3").drag_dest_set(0, [], 0)
        self.wTree.get_widget("vbuttonbox3").remove(self.wTree.get_widget("vbuttonbox3").get_children()[0])
       
   	size_x = client.get_int('/apps/xfcemintConfig/size_x')
	size_y = client.get_int('/apps/xfcemintConfig/size_y')
	print size_x
	print size_y
	if ( size_y < 240):
		client.set_int("/apps/xfcemintConfig/size_y", -1)
  	self.wTree.get_widget("window1").set_size_request(size_x, size_y)

    def close_window(self, widget, client, size_x, size_y):
        #Get the window size and record it in gconf
       	client.set_int("/apps/xfcemintConfig/size_x", size_x)
	#print "saving size"
	widget.get_size_request()
	print size_x
	print size_y
	print widget.get_size()
	print widget.get_size_request()
	print widget.get_default_size()
	print widget.get_frame_dimensions()
        client.set_int("/apps/xfcemintConfig/size_x",size_x)
	#client.set_int("/apps/xfcemintConfig/size_y",size_y)
	gtk.main_quit()

    def evalcolor(self, colorToTest):
	if colorToTest[0] != '#' or len(colorToTest) !=7:
		return False
	for i in colorToTest[1:]:
		if i not in ['a','A','b','B','c','C','d','D','e','E','f','F','0','1','2','3','4','5','6','7','8','9']:
			return False
	return True



    def DoTranslate(self,ListofLabels,EnglishPhrase):
       for i in range(len(ListofLabels)):
           self.wTree.get_widget(ListofLabels[i]).set_label(_(EnglishPhrase))

    def FileExists(self,f):
        try:
            if f[:7] == "file://":
                file = open(f[7:])
            else:
                file = open(f)
        except IOError:
            exists = False
        else:
            exists = True
        return exists

    def motion_cb(self, widget, context, x, y, time):
        context.drag_status(gtk.gdk.ACTION_COPY, time)
        return True

    def drop_cb(self, widget, context, x, y, time):
        widget.drag_get_data(context, 'text/uri-list', time)
        print "Item dropped"
        return True

    def got_data(self, widget, context, x, y, selection, targetType, timestamp):
        self.add_button(widget.name,selection.data[:-2],False,"")


    def add_button(self, widgetname, selection, init, iconname):

        MyLoc = self.MyLoc
        LocNameFound = LocCommentFound = False
        MyLocLen =  len(self.MyLoc)


        client = gconf.client_get_default()
        custom_list1 = client.get_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING)
        custom_list2 = client.get_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING)
        custom_list3 = client.get_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING)

        if custom_list1 == 0:
            custom_list1 = client.set_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING,[""])
        if custom_list2 == 0:
            custom_list2 = client.set_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING,[""])
        if custom_list3 == 0:
            custom_list3 = client.set_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING,[""])

        Align1 = gtk.Alignment(0,0.5,0,0)
        Align1.set_padding(0,0,0,0)

        BName = BIcon = BComment = BTip = ""

        if selection != None:
            if selection[-8:] == ".desktop" and self.FileExists(selection)==True:

                path,fi = os.path.split(selection)
                #os.path.join(os.path.expanduser("~"), "Python"
                fi = fi[:-10]

                if selection[:7] == "file://":
                    openfile = open(selection[7:], 'r')
                else:
                    openfile = open(selection, 'r')

                datalist = openfile.readlines()

                for i in range(len(datalist)):
                    datalist[i] = datalist[i][:-1]

                    #print datalist[i][0:7+MyLocLen-3]
                    #print "Name["+MyLoc[:2]+"]="

                    if datalist[i][0:7+MyLocLen] == "Name["+MyLoc+"]=" and LocNameFound == False:
                        if len(datalist[i]) > 32:
                            BName = datalist[i][7+MyLocLen:32] + ".."
                        else:
                            BName = datalist[i][7+MyLocLen:32]
                        LocNameFound = True

                    elif datalist[i][0:4+MyLocLen] == "Name["+MyLoc[:2]+"]=" and LocNameFound == False:
                        if len(datalist[i]) > 32:
                            BName = datalist[i][4+MyLocLen:32] + ".."
                        else:
                            BName = datalist[i][4+MyLocLen:32]
                        #LocNameFound = True

                    elif datalist[i][0:5] == "Name=" and LocNameFound == False:
                        if len(datalist[i]) > 32:
                            BName = datalist[i][5:32] + ".."
                        else:
                            BName = datalist[i][5:32]



                    if datalist[i][0:7+MyLocLen] == "Comment["+MyLoc[:2]+"]=" and LocCommentFound == False:
                        if len(datalist[i]) > 32:
                            BComment = datalist[i][7+MyLocLen:33] + ".."
                        else:
                            BComment = datalist[i][7+MyLocLen:]
                        #LocCommentFound = True
                        BTip = datalist[i][7+MyLocLen:]


                    if datalist[i][0:10+MyLocLen] == "Comment["+MyLoc+"]=" and LocCommentFound == False:
                        if len(datalist[i]) > 32:
                            BComment = datalist[i][10+MyLocLen:33] + ".."
                        else:
                            BComment = datalist[i][10+MyLocLen:]
                        LocCommentFound = True
                        BTip = datalist[i][10+MyLocLen:]

                    elif datalist[i][0:8] == "Comment=" and LocCommentFound == False:
                        if len(datalist[i]) > 32:
                            BComment = datalist[i][8:33] + ".."
                        else:
                            BComment = datalist[i][8:]
                        BTip = datalist[i][8:]






                    if datalist[i][0:5] == "Exec=":
                        BExec = datalist[i][5:]

                    if datalist[i][0:5] == "Icon=":
                        if datalist[i][-4:] in [".png",".xpm",".svg"] and datalist[i][0:6] != "Icon=/":
                            datalist[i] = datalist[i][5:-4]
                            Image1 = gtk.image_new_from_icon_name(datalist[i], gtk.ICON_SIZE_DIALOG)
                            #print datalist[i] + "Ends in .png or .xpm"

                        if datalist[i][-4:] in [".png",".xpm",".svg"] and datalist[i][0:6] == "Icon=/":
                            datalist[i] = datalist[i][5:]
                            Image1 = gtk.Image()
                            if self.FileExists(datalist[i])==True:
                                Image1.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file(datalist[i]).scale_simple(36,36,gtk.gdk.INTERP_BILINEAR))
                            else:
                                print "Warning! - Icon for item not found!"
                                Image1 = gtk.image_new_from_icon_name(None, gtk.ICON_SIZE_DIALOG)
                            #print datalist[i] + "   Starts with / and ends in .png or .xpm"

                        if datalist[i][0:5] == "Icon=":
                            datalist[i] = datalist[i][5:]
                            Image1 = gtk.image_new_from_icon_name(datalist[i], gtk.ICON_SIZE_DIALOG)
                            #print datalist[i] + "Normal themed icon"

                        BIcon = datalist[i]

                    if iconname != "":
                        Image1 = gtk.image_new_from_icon_name(iconname, gtk.ICON_SIZE_DIALOG)



                Button1 = gtk.Button(fi,"ok",True)
                Button1.remove(Button1.get_children()[0])
                Button1.set_size_request(230,60)
                Button1.set_relief(gtk.RELIEF_NONE)
                Button1.set_alignment(0.02,0.5)
                Button1.MyButtonName = selection

                if len(BTip) > 5 :
                    self.CCTips.set_tip(Button1, BTip, tip_private=None)


                HBox1 = gtk.HBox(False,2)
                VBox1 = gtk.VBox(False,2)
                VBox1.set_homogeneous(False)
                Label1 = gtk.Label(BName)
                Label1.justify = gtk.JUSTIFY_LEFT
                Label1.set_alignment(0.02,-1)
                Label2 = gtk.Label(BComment)
                Label2.justify = gtk.JUSTIFY_LEFT
                Label2.set_alignment(0.2,-1)


                #Set a new style for the Items
                ItemStyle = pango.AttrList()
                attr = pango.AttrSize(9000,0,-1)
                ItemStyle.insert(attr)

                #Set a new style for the descriptions
                DescStyle = pango.AttrList()
                attr = pango.AttrForeground(48640,48640,48640,0,-1)
                DescStyle.insert(attr)
                attr = pango.AttrSize(9000,0,-1)
                DescStyle.insert(attr)

                Label1.set_attributes(ItemStyle)
                Label2.set_attributes(DescStyle)

                Image1.show()
                Label1.show()
                Label2.show()
                VBox1.show()
                HBox1.show()
                Align1.show()
                Button1.show()

                VBox1.pack_start(Label1,False,False)
                VBox1.pack_start(Label2,False,False)
                HBox1.add(Image1)
                HBox1.add(VBox1)
                Align1.add(HBox1)
                Button1.add(Align1)

                Button1.connect("button_press_event", self.WhichButtonClicked, BExec, widgetname)


                if init==False:
                    if Button1.MyButtonName in custom_list1 or Button1.MyButtonName in custom_list2 or Button1.MyButtonName in custom_list3:
                        alertDlg = AlertDialog();
                        result = alertDlg.run("That item already exists! Please select another item")
                        print "Item already exists!"
                        Button1.destroy()
                    else:
                        for case in switch(widgetname):
                            if case("vbuttonbox2"):
                               custom_list1.append(selection)
                               client.set_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING,custom_list1)
                               break
                            if case("vbuttonbox3"):
                                custom_list2.append(selection)
                                client.set_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING,custom_list2)
                                break
                            if case("vbuttonbox4"):
                                custom_list3.append(selection)
                                client.set_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING,custom_list3)
                        self.wTree.get_widget(widgetname).pack_start(Button1,False,False,10)

                        if LocNameFound == False:
                            print "No name translation found for your locale. Defaulting to English(en)"
                        if LocCommentFound == False:
                            print "No comment translation found for your locale. Defaulting to English(en)"

                        print "Added - "+ Button1.MyButtonName
                else:
                    self.wTree.get_widget(widgetname).pack_start(Button1,False,False,10)
                    print "Added - "+ Button1.MyButtonName
            else:
                print "Item does not exist -" + selection


    def WhichButtonClicked(self,widget, event, BExec, ButtonBox):

        def DelButton(self,menutogo):
            print "Deleted - " + widget.MyButtonName
            widget.destroy()
            menutogo.get_widget("menu1").destroy()

            client = gconf.client_get_default()
            custom_list1 = client.get_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING)
            custom_list2 = client.get_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING)
            custom_list3 = client.get_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING)

            if custom_list1.count(widget.MyButtonName) > 0:
                custom_list1.remove(widget.MyButtonName)
                client.set_list("/apps/xfcemintConfig/custom_list1",gconf.VALUE_STRING,custom_list1)
            if custom_list2.count(widget.MyButtonName) > 0:
                custom_list2.remove(widget.MyButtonName)
                client.set_list("/apps/xfcemintConfig/custom_list2",gconf.VALUE_STRING,custom_list2)
            if custom_list3.count(widget.MyButtonName) > 0:
                custom_list3.remove(widget.MyButtonName)
                client.set_list("/apps/xfcemintConfig/custom_list3",gconf.VALUE_STRING,custom_list3)


        Editable = ["vbuttonbox2", "vbuttonbox3", "vbuttonbox4"]
        # which button was clicked?
        if event.button == 1:
            ListCmd = BExec.split()
            self.RunControl(self,ListCmd[0], ListCmd[:2])
        elif event.button == 3 and ButtonBox in Editable:

            self.mTree = gtk.glade.XML(self.gladefile,"menu1")
            x = int(event.x)
            y = int(event.y)
            time = event.time
            self.mTree.get_widget("remove1").connect("activate",DelButton, self.mTree)
            self.mTree.get_widget("menu1").popup( None, None, None, event.button, time)
        return 1



    # Set the position of the groups bar
    def SetGroupLocation(self, client, *args, **kwargs):

        MyGconfEntry1 = client.get_string('/apps/xfcemintConfig/groups_pos')

        vertbar = self.wTree.get_widget("vbox64")
        horizbar = self.wTree.get_widget("vbox65")
        horizcontainer = self.wTree.get_widget("hbox73")
        vertcontainer = self.wTree.get_widget("vbox22")

        for case in switch(MyGconfEntry1):
            if case("top"):
                horizbar.show()
                vertbar.hide()
                vertcontainer.reorder_child(horizbar,0)
                break
            if case("bottom"):
                vertbar.hide()
                horizbar.show()
                vertcontainer.reorder_child(horizbar,1)
                break
            if case("left"):
                horizbar.hide()
                vertbar.show()
                horizcontainer.reorder_child(vertbar,0)
                break
            if case("right"):
                horizbar.hide()
                vertbar.show()
                horizcontainer.reorder_child(vertbar,1)
                break
            if case(None):
                client.set_string('/apps/xfcemintConfig/groups_pos',"top")
		client.set_bool('/apps/xfcemintConfig/remember_group', True)
		client.set_bool('/apps/xfcemintConfig/show_tips', True)

        show_tips = client.get_bool('/apps/xfcemintConfig/show_tips')
        for case in switch(show_tips):
            if case(True):
                #self.CCTips.enable()
                break
            if case(False):
                #self.CCTips.disable()
                client.set_bool('/apps/xfcemintConfig/show_tips',False)
                break

        show_hide_label = client.get_bool('/apps/xfcemintConfig/hide_group_label')

        for case in switch(show_hide_label):
            if case(True):
                self.wTree.get_widget("hbox76").hide()
                self.wTree.get_widget("hbox74").hide()
                break
            if case(False):
                self.wTree.get_widget("hbox76").show()
                self.wTree.get_widget("hbox74").show()
                client.set_bool('/apps/xfcemintConfig/hide_group_label',False)
                break

        show_hide_label = client.get_bool('/apps/xfcemintConfig/use_tabs_instead')
        for case in switch(show_hide_label):
            if case(True):
                self.wTree.get_widget("hbuttonbox6").hide()
                self.wTree.get_widget("vbuttonbox1").hide()
                self.wTree.get_widget("notebook1").set_show_tabs(1)
                break
            if case(False):
                self.wTree.get_widget("hbuttonbox6").show()
                self.wTree.get_widget("vbuttonbox1").show()
                self.wTree.get_widget("notebook1").set_show_tabs(0)
                client.set_bool('/apps/xfcemintConfig/use_tabs_instead',False)
                break

    def RememberGroups(self, client, *args, **kwargs):
        MyGconfEntry1 = client.get_bool('/apps/xfcemintConfig/remember_group')
        MyGconfEntry2 = client.get_int('/apps/xfcemintConfig/last_group')


        for case in switch(MyGconfEntry1):
            if case(True):
                self.ChangeTab(self,client,MyGconfEntry2)
                break
            if case(False):
                client.set_int('/apps/xfcemintConfig/last_group',0)
                client.set_bool('/apps/xfcemintConfig/remember_group',False)
                break



    # Change groups when buttons are pressed
    def ChangeTab(self,widget,client,num):
        self.wTree.get_widget("notebook1").set_current_page(num)
        client.set_int('/apps/xfcemintConfig/last_group',num)


    # Actually execute the command
    def RunControl(self,widget,cmd, attr):
         os.spawnvp(os.P_NOWAIT,cmd, attr)

    # Prefs clicked
    def PrefsClicked(self,widget):

        prefsDlg = PrefrenceDialog();
        result = prefsDlg.run()

        if (result == gtk.RESPONSE_OK):
            """The user clicked Ok"""



class InstanceDialog:
    def __init__(self):

        #Set the Glade file
        self.gladefile = "/usr/lib/linuxmint/xfcemintConfig/mintConfig_frontend.glade"

    def run(self,message):
        """This function will show the Instance Dialog"""
        self.wTree = gtk.glade.XML(self.gladefile, "dialog3")
        #Get the actual dialog widget
        self.dlg = self.wTree.get_widget("dialog3")
        self.wTree.get_widget("label164").set_label(_("It seems that mintConfig is already running. Press OK to remove the Lock file and proceed or press Cancel to exit."))
        #run the dialog and store the response
        self.result = self.dlg.run()
        #we are done with the dialog, destroy it
        self.dlg.destroy()
        #return the result
        return self.result

class AlertDialog:
    def __init__(self):

        #Set the Glade file
        self.gladefile = "/usr/lib/linuxmint/xfcemintConfig/mintConfig_frontend.glade"

    def run(self,message):
        """This function will show the Pref Dialog"""

        self.wTree = gtk.glade.XML(self.gladefile, "dialog2")
        #Get the actual dialog widget
        self.dlg = self.wTree.get_widget("dialog2")
        self.wTree.get_widget("label162").set_label(_("That item already exists! Please select another item"))
        #run the dialog and store the response
        self.result = self.dlg.run()
        #we are done with the dialog, destroy it
        self.dlg.destroy()
        #return the result
        return self.result


class PrefrenceDialog:
    def __init__(self):

        #Set the Glade file
        self.gladefile = "/usr/lib/linuxmint/xfcemintConfig/mintConfig_frontend.glade"

    def run(self):
        """This function will show the Pref Dialog"""

        self.wTree = gtk.glade.XML(self.gladefile, "dialog1")
        #Get the actual dialog widget
        self.dlg = self.wTree.get_widget("dialog1")


        #Translate Labels
        self.wTree.get_widget("dialog1").set_title(_("Settings"))
        self.wTree.get_widget("label152").set_label(_("Settings"))
        self.wTree.get_widget("label153").set_label("<b>"+_("Groups Position")+"</b>")
        self.wTree.get_widget("label158").set_label("<b>"+_("Miscellaneous")+"</b>")
        self.wTree.get_widget("radiobutton1").set_label(_("Top"))
        self.wTree.get_widget("radiobutton2").set_label(_("Bottom"))
        self.wTree.get_widget("radiobutton3").set_label(_("Left"))
        self.wTree.get_widget("radiobutton4").set_label(_("Right"))
        self.wTree.get_widget("checkbutton2").set_label(_("Remember last group"))
        self.wTree.get_widget("checkbutton3").set_label(_("Show tooltips"))
        





        #Set a new style for the headings
        HeadingStyle = pango.AttrList()
        attr = pango.AttrSize(13000,0,-1)
        HeadingStyle.insert(attr)
        attr = pango.AttrForeground(24576,34816,41728,0,-1)
        HeadingStyle.insert(attr)

        self.wTree.get_widget("label152").set_attributes(HeadingStyle)

        dic = {"on_radiobutton1_pressed" : (self.RadioButtonClicked, "top"),
               "on_radiobutton2_pressed" : (self.RadioButtonClicked, "bottom"),
               "on_radiobutton3_pressed" : (self.RadioButtonClicked, "left"),
               "on_radiobutton4_pressed" : (self.RadioButtonClicked, "right"),
               "on_checkbutton2_toggled" : (self.CheckButton2Clicked),
               "on_checkbutton3_toggled" : (self.CheckButton3Clicked),
               }
        self.wTree.signal_autoconnect(dic)


        client = gconf.client_get_default()
        MyGconfEntry1 = client.get_string('/apps/xfcemintConfig/groups_pos')
        for case in switch(MyGconfEntry1):
            if case("top"):
                self.wTree.get_widget("radiobutton1").set_active(True)
                break
            if case("bottom"):
                self.wTree.get_widget("radiobutton2").set_active(True)
                break
            if case("left"):
                self.wTree.get_widget("radiobutton3").set_active(True)
                break
            if case("right"):
                self.wTree.get_widget("radiobutton4").set_active(True)
                break
            if case(None):
                client.set_string('/apps/xfcemintConfig/groups_pos',"left")
		client.set_bool('/apps/xfcemintConfig/remember_group', True)
		client.set_bool('/apps/xfcemintConfig/show_tips', True)

        MyGconfEntry2 = client.get_bool('/apps/xfcemintConfig/remember_group')
        for case in switch(MyGconfEntry2):
            if case(True):
                self.wTree.get_widget("checkbutton2").set_active(True)
                break
            if case(False):
                self.wTree.get_widget("checkbutton2").set_active(False)
                break


        show_tips = client.get_bool('/apps/xfcemintConfig/show_tips')
        if show_tips:
            self.wTree.get_widget("checkbutton3").set_active(True)
        else:
            self.wTree.get_widget("checkbutton3").set_active(False)


        #run the dialog and store the response
        self.result = self.dlg.run()
        #we are done with the dialog, destroy it
        self.dlg.destroy()
        #return the result and the wine
        return self.result


    def RadioButtonClicked(self,widget, data=None):
        client = gconf.client_get_default()
        client.set_string('/apps/xfcemintConfig/groups_pos',data)

    def CheckButton2Clicked(self,widget):
        client = gconf.client_get_default()
        if widget.get_active():
            client.set_bool('/apps/xfcemintConfig/remember_group',True)
        else:
            client.set_bool('/apps/xfcemintConfig/remember_group',False)

    def CheckButton3Clicked(self,widget):
        client = gconf.client_get_default()
        if widget.get_active():
            mainwin.CCTips.enable()
            client.set_bool('/apps/xfcemintConfig/show_tips',True)
        else:
            mainwin.CCTips.disable()
            client.set_bool('/apps/xfcemintConfig/show_tips',False)




if __name__ == "__main__":



    try:
        file = open("/tmp/xfcemintConfig.lock")
    except IOError:
        exists = False
        file = open("/tmp/xfcemintConfig.lock","w")
        mainwin = mintConfigWindow()
        gtk.main()
        os.spawnvp(os.P_NOWAIT,"rm", ["rm","/tmp/xfcemintConfig.lock"])
    else:
        exists = True
        InstanceDlg = InstanceDialog();
        result = InstanceDlg.run("It seems that the Linux Mint Control Center is already running. Press OK to remove the Lock file and proceed or press Cancel to exit.")
        if result == -5:
            file = open("/tmp/xfcemintConfig.lock","w")
            mainwin = mintConfigWindow()
            gtk.main()
            os.spawnvp(os.P_NOWAIT,"rm", ["rm","/tmp/xfcemintConfig.lock"])
        else:
            print "Using existing instance"

