#!/usr/bin/env python

import os
import sys
import subprocess
import pygtk
pygtk.require('2.0')
import gtk

class volume_control():
    window_position = (0, 0)
    vol_adjust = range(0, 26)

    def on_clicked(self, widget):
        # Default mixer changed to 'gnome-alsamixer'
        os.system('gnome-alsamixer')

    def __init__(self):
        # Icons/systemtray
        # Now sets a defined icon instead of a stock icon
        self.staticon = gtk.StatusIcon()
        self.staticon.set_from_file("/usr/share/pyvolume/pyvolume.png")

        # Menu
        menu = gtk.Menu()
        menu_about = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
        menu_about.connect('button-press-event', self.show_about_dialog)
        menu_quit = gtk.ImageMenuItem(gtk.STOCK_QUIT)
        menu_quit.connect('button-press-event', gtk.main_quit)
        menu.append(menu_about)
        menu.append(menu_quit)

        # Events
        self.staticon.connect('activate', self.cb_activate_icon)
        self.staticon.connect('popup-menu', self.cb_tray_popup, menu)

        # Initialize
        self.master_slider_window()

    #
    # The volume slider window
    #
    def master_slider_window(self):
        # Window
        self.window = gtk.Window(gtk.WINDOW_POPUP)
        self.window.set_size_request(60, 171)

        # Frame
        frame = gtk.Frame()
        frame.set_border_width(1)

        # Slider
        master_slider = gtk.VScale()
        master_slider.set_inverted(True)
        master_slider.set_range(0, 100)
        master_slider.set_increments(1, 10)
        master_slider.set_digits(0)
        master_slider.set_size_request(34, 120)
        master_slider.set_value_pos(gtk.POS_BOTTOM)
        master_slider.set_value(self.get_master_volume())

	btn = gtk.Button("Mixer")
	btn.set_size_request(50, 30)
	btn.connect('clicked', self.on_clicked)

        # Events
        self.window.connect('destroy', gtk.main_quit)
        master_slider.connect('value-changed', self.cb_master_slider_change)

        # Add widgets
        # Widget layout adjusted from original
        fixed_master_slider = gtk.Fixed()
        fixed_master_slider.put(master_slider, 10, 6)
        fixed_master_slider.put(btn, 1, 132)
        frame.add(fixed_master_slider)
        self.window.add(frame)

    #
    #  Tray icon click
    #
    def cb_activate_icon(self, widget, data=None):
        if self.window.get_property('visible'):
            self.window.hide()
        else:
            self.set_window_position()
            self.window.move(self.window_position[0], self.window_position[1])
            self.window.show_all()
            self.window.present()

    #
    #  System tray menu
    #
    def cb_tray_popup(self, widget, button, time, data = None):
        if button == 3:
            if data:
                data.show_all()
                data.popup(None, None, None, 3, time)

    #
    #  Set master volume
    #
    def cb_master_slider_change(self, widget):
        val = widget.get_value()

        if (val / 4) in self.vol_adjust:
            proc = subprocess.Popen('/usr/bin/amixer sset Master ' + str(val) + '%', shell=True, stdout=subprocess.PIPE)
            proc.wait()

    #
    #  Set window position (just above the system tray icon)
    #
    def set_window_position(self):
        staticon_geometry = self.staticon.get_geometry()[1]

        if staticon_geometry.y <= 200:
            y_coords = staticon_geometry.y
        else:
            y_coords = staticon_geometry.y-180

        self.window_position = (staticon_geometry.x-13, y_coords)

    #
    #  Get Master volume
    #
    #  Section rewritten from the original to work with more default configurations
    #

    def get_master_volume(self):
        import commands
        output = commands.getoutput('/usr/bin/amixer sget Master | grep "%"')
        amixer_stdout = output.split('\n')[0]

        find_start = amixer_stdout.find('[') + 1
        find_end = amixer_stdout.find('%]', find_start)

        return float(amixer_stdout[find_start:find_end])


    #
    #  Original Get Master Volume Section
    #

    #def get_master_volume(self):
    #    proc = subprocess.Popen('/usr/bin/amixer sget Master', shell=True, stdout=subprocess.PIPE)
    #    amixer_stdout = proc.communicate()[0].split('\n')[4]
    #    proc.wait()

    #    find_start = amixer_stdout.find('[') + 1
    #    find_end = amixer_stdout.find('%]', find_start)

    #    return float(amixer_stdout[find_start:find_end])

    #
    #  About dialog
    #
    def show_about_dialog(self, widget, data=None):
        about = gtk.AboutDialog()
        about.set_program_name('Volume Control')
        about.set_version('0.1.1')
        about.set_comments('Volume Control is a simple tool to adjust your Master volume. It uses "amixer" from alsa to set and get the volume.\n\nOriginally written by FSX\nWith edits by Kendall Weaver')
        about.run()
        about.destroy()

volume_control()
gtk.main()
