# Copyright (C) 2003 Konstantin Korikov

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""
  chestnut-dialer is PPP-dialing programm.
  This is the root package.
"""
import locale
import codecs
import os
import os.path
import sys
import glob
import ConfigParser
import chestnut_dialer.config

# public variables

EX_OK          = 0      # successful termination
EX_USAGE       = 1      # command line usage error 
EX_ARGSERR     = 2      # invalid arguments
EX_UNKNOWN     = 3      # unknown error
EX_NODIALTONE  = 4      # no dialtone
EX_BUSY        = 5      # line is busy
EX_NOCARRIER   = 6      # no carrier detected
EX_AUTHFAIL    = 7      # authentication failure
EX_SOFTWARE    = 8      # internal software error 
EX_OSERR       = 9      # system error (e.g., can't fork) 

program_name = chestnut_dialer.config.program_name
program_version = chestnut_dialer.config.program_version
package = chestnut_dialer.config.package
domain = package
exename = os.path.basename(sys.argv[0])
user_config_dir = os.path.expanduser("~/." + package)
config_file = user_config_dir + "/config.xml"
accounts_file = user_config_dir + "/accounts.xml"
session_socket = user_config_dir + "/session_srv"
session_pid_file = user_config_dir + "/session_srv.pid"
session_server = os.path.dirname(__file__) + "/session_srv.py"
session_wait_base = user_config_dir + "/session_wait_"
def_config_file = os.path.dirname(__file__) + "/def_config.xml"
def_accounts_file = os.path.dirname(__file__) + "/def_accounts.xml"
logo_file = os.path.dirname(__file__) + "/logo.xpm"
log_file = user_config_dir + "/connecting.log"
_ = lambda msg: msg
locale_encoding = None

# private variables

_ui_dict = {}
_debug_level = 2
_dockicons_base_dir = os.path.dirname(__file__) + "/dockicons"
_stderr_encoding = 'ascii';

# routines

def set_debug_level(level):
  global _debug_level
  _debug_level = level

def debug_msg(msg, level = 1):
  if _debug_level >= level:
    if level <= 1: fmt = _("%s: error: %s\n")
    elif level == 2: fmt = _("%s: warning: %s\n")
    else: fmt = _("%s: information: %s\n")
    sys.stderr.write(fmt % (exename, msg))

def get_ui_info_list():
  ui_info_list = []
  for ui in _ui_dict.keys():
    ui_d = _ui_dict[ui]
    ui_info = {"name": ui, "package": ui_d["package"]}
    c = ConfigParser.ConfigParser()
    c.read(ui_d["ui_info_file"])    
    for o in c.options("ui_info"):
      if not ui_info.has_key(o):
        ui_info.update({o: c.get("ui_info", o)})
    ui_info_list.append(ui_info)
  return ui_info_list
  
def get_ui_params_info(ui):
  if _ui_dict.has_key(ui):
    ui_params = []
    c = ConfigParser.ConfigParser()
    c.read(_ui_dict[ui]["ui_info_file"])
    for sec in c.sections():
      if sec[:8] == "ui_param":
        ui_p = {}
        for o in c.options(sec):
	  ui_p.update({o: c.get(sec, o)})
        ui_params.append(ui_p)
    return ui_params
  return None

def get_dockicon_file(dockicons_dir, icon_name, 
    exts = (".xpm", ".png", ".gif")):
  full_dir = _dockicons_base_dir + "/" + dockicons_dir
  if os.access(full_dir, os.F_OK):
    full_icon_name = full_dir + "/" + icon_name
    for e in exts:
      if os.access(full_icon_name + e, os.F_OK): 
        return full_icon_name + e
  return None
  
def get_dockicons_dir_list():
  return glob.glob1(_dockicons_base_dir, "*")

def get_html_doc_dir_locale():
  lang, enc = locale.getlocale(locale.LC_MESSAGES)
  if len(lang) >= 3 and lang[2] == '_': lang = lang[:2]
  dir = "%s/html/%s" % (chestnut_dialer.config.doc_dir, lang)
  if os.access(dir, os.F_OK): return dir
  return "%s/html/en" % chestnut_dialer.config.doc_dir

def compare_versions(v1, v2):
  def to_sub_array(val):
    val = str(val); a = []; s = "";
    try: n = val[0].isdigit()
    except IndexError: return []
    for c in val:
      if len(s) and c.isdigit() != n:
	a += [n and int(s) or s]
	s = ""; n = c.isdigit()
      s += c
    if n: return a + [int(s)]
    return a + [s]
  a1 = map(lambda i: to_sub_array(i), str(v1).split("."))
  a2 = map(lambda i: to_sub_array(i), str(v2).split("."))
  return cmp(a1, a2)

def escape_shell(s):
  for c in "\\`~!#$&*()|{};\"'<>?":
    s = s.replace(c, "\\" + c)
  return s

def init_locale():

  # initialize locale settings and translation
  global _
  global domain
  if chestnut_dialer.config.use_nls:
    import gettext
    locale.setlocale(locale.LC_ALL, "")
    try:
      translation = gettext.translation(domain,
          chestnut_dialer.config.locale_dir)
      _ = translation.ugettext
    except IOError: pass
  else:
    domain = None

  # replace sys.stdout and sys.stderr with StreamWriter
  # for transparency recode unicode strings to locale encoding
  # (Python defaults uses ascii when stdin/stderr is not terminal,
  # e.g. redirected to file or pipe, and this raises UnicodeEncodeError)
  global locale_encoding
  locale_encoding = locale.getlocale(locale.LC_CTYPE)[1]
  if locale_encoding:
    try:
      _writer = codecs.getwriter(locale_encoding)
      if (not hasattr(sys.stdout, 'encoding') or
          sys.stdout.encoding != locale_encoding):
        sys.stdout = _writer(sys.stdout, 'replace')
      if (not hasattr(sys.stderr, 'encoding') or
          sys.stderr.encoding != locale_encoding):
        sys.stderr = _writer(sys.stderr, 'replace')
    except LookupError: pass

# initialization code
# get list of installed user interfaces
for _uidir in glob.glob(os.path.dirname(__file__) + "/*_ui"):
  _package = "chestnut_dialer.%s" % os.path.basename(_uidir)
  _c = ConfigParser.ConfigParser()
  try: _c.read(_uidir + "/ui_info")
  except: pass
  if _c.has_section("ui_info"):
    _ui_dict.update({_c.get("ui_info", "name"): 
      {"package": _package, "ui_info_file": _uidir + "/ui_info"}})

