#!/usr/bin/python

import os, sys, commands

archi = sys.argv[1]
curdir = sys.argv[2]
version = sys.argv[3]
abort = False 

release = version
if "+" in version:
    #if "lmde" not in version:
    #    abort = True
    release = version.split("+")[0]   
    
if "~" in version:
    release = version.split("~")[0]

if archi == "amd64":
    archi="linux-x86_64"
else:
    archi="linux-i686"

locales = {}
locales['ar'] = 'ar'
locales['bn-BD'] = 'bn'
locales['ca'] = 'ca'
locales['cs'] = 'cs'
locales['da'] = 'da'
locales['de'] = 'de'
locales['el'] = 'el'
locales['en-GB'] = 'en-gb'
locales['en-US'] = 'en-us'
locales['es-ES'] = 'es'
locales['fi'] = 'fi'
locales['fr'] = 'fr'
locales['he'] = 'he'
locales['hu'] = 'hu'
locales['id'] = 'id'
locales['it'] = 'it'
locales['ja'] = 'ja'
locales['ko'] = 'ko'
locales['nb-NO'] = 'nb'
locales['nl'] = 'nl'
locales['nn-NO'] = 'nn'
locales['pl'] = 'pl'
locales['pt-PT'] = 'pt'
locales['pt-BR'] = 'pt-br'
locales['ro'] = 'ro'
locales['ru'] = 'ru'
locales['sv-SE'] = 'sv'
locales['sk'] = 'sk'
locales['sl'] = 'sl'
locales['tr'] = 'tr'
locales['uk'] = 'uk'
locales['zh-CN'] = 'zh'

for locale in locales:
    if (locale == "en-US"):
        os.system("mkdir -p %s/debian/thunderbird/opt" % curdir)        
        os.chdir("%s/debian/thunderbird/opt" % curdir)
        if not abort:        
            os.system("wget http://ftp.mozilla.org/pub/mozilla.org/thunderbird/releases/%s/%s/%s/thunderbird-%s.tar.bz2" % (release, archi, locale, release))
            if (not os.path.exists("thunderbird-%s.tar.bz2" % release)):
                print "FAILED: Could not download http://ftp.mozilla.org/pub/mozilla.org/thunderbird/releases/%s/%s/%s/thunderbird-%s.tar.bz2" % (release, archi, locale, release)
                sys.exit(1)

            os.system("bzip2 -d thunderbird-%s.tar.bz2" % release)
            os.system("tar xvf thunderbird-%s.tar" % release)
            os.system("rm thunderbird-%s.tar" % release)            

            os.system("mkdir -p %s/debian/thunderbird/usr/share/icons/hicolor" % curdir)
            os.chdir("%s/debian/thunderbird/usr/share/icons/hicolor" % curdir)
            os.system("mkdir -p 16x16/apps 22x22/apps 24x24/apps 32x32/apps 48x48/apps 256x256/apps")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default16.png 16x16/apps/thunderbird.png")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default22.png 22x22/apps/thunderbird.png")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default24.png 24x24/apps/thunderbird.png")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default32.png 32x32/apps/thunderbird.png")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default48.png 48x48/apps/thunderbird.png")
            os.system("ln -s /opt/thunderbird/chrome/icons/default/default256.png 256x256/apps/thunderbird.png")

            os.chdir("%s/debian/thunderbird/opt/thunderbird/defaults/pref" % curdir)
            mailnews = open("mailnews.js", "wb")
            mailnews.write("pref(\"extensions.autoDisableScopes\", 3);\npref(\"intl.locale.matchOS\", true);\n");
            mailnews.close()
            channel = open("channel-prefs.js", "wb")
            channel.write("pref(\"app.update.channel\", \"default\");\n");
            channel.close()
    else:
        os.system("mkdir -p %s/debian/thunderbird-l10n-%s/opt/thunderbird/extensions" % (curdir, locales[locale]))
        os.chdir("%s/debian/thunderbird-l10n-%s/opt/thunderbird/extensions" % (curdir,locales[locale]))
        if not abort:
            os.system("wget http://ftp.mozilla.org/pub/mozilla.org/thunderbird/releases/%s/%s/xpi/%s.xpi" % (release, archi, locale))
            if (not os.path.exists("%s.xpi" % locale)):
                print "FAILED: Could not download http://ftp.mozilla.org/pub/mozilla.org/thunderbird/releases/%s/%s/xpi/%s.xpi" % (release, archi, locale)
                sys.exit(1)
            os.system("mv ./%s.xpi ./langpack-%s@thunderbird.mozilla.org.xpi" % (locale, locale))

os.chdir(curdir)
