#!/bin/bash

# Script to remove patches on the mozilla source code 

SCRIPT_DIR=`dirname $0`

# 290. Patch to clear selection after delete event. Fixes problem with delete
#      event getting fired multiple times. Upstream bug #334181.
patch -p2 -N -R < $SCRIPT_DIR/334181_calendar_clear_selection_after_delete.patch

# 280. Fix problem with alarms dialog not getting dismissed with dismiss all.
#      Upstream bug #449567.
patch -p0 -N -R < $SCRIPT_DIR/449567_alarms_dismiss_all_fix.patch

# 270. Fix several buffer overflows caused because of maxpathlen being too
#      small. Upstream bug #412610.
patch -p1 -N -R < $SCRIPT_DIR/412610_maxpathlen_too_small_buffer_overflow.patch

# 260. Fix the persist for sound file folder in mail general prefs
patch -p0 -N -R < $SCRIPT_DIR/mail_prefs_sound_file_browse.patch

# 250. Add more smileys to mozITXTToHTMLConv
patch -p0 -N -R < $SCRIPT_DIR/streamconv_more_smileys.patch

# 240. Changes to csTimezoneService.js to get timezones.sqlite from install dir
patch -p0 -N -R < $SCRIPT_DIR/timezone-service.patch

# 230. Minimonth flex changes (Bug 965)
patch -p0 -N -R < $SCRIPT_DIR/minimonth_styling_changes.patch

# 220. Patch alarm dialog code to launch item details (Bug 992)
patch -p0 -N -R < $SCRIPT_DIR/alarm-dialog.patch

# 210. Patch to fix outlook express import
patch -p0 -N -R < $SCRIPT_DIR/oexpress_import.patch

# 200. Patch to create new directory type (IMDirectory)
patch -p0 -N -R < $SCRIPT_DIR/addrbook_imdirectory.patch

# 190. Patch to use applications.manifest in profile directory for chome loading
patch -p0 -N -R < $SCRIPT_DIR/use_applications_manifest_from_profile.patch

# 180. Patch to fix outlook settings import
patch -p0 -N -R < $SCRIPT_DIR/450854_outlook_settings_import.patch

# 170. Patch to fix outlook mail import
patch -p0 -N -R < $SCRIPT_DIR/408323_outlook_mail_import.patch

# 160. Patch to fix addressbook print preview secure css access error. Upstream
#      bug #451143. Downstream bug #914.
patch -p1 -N -R < $SCRIPT_DIR/451143_fix_ab_print_css.patch

# 150. Changes to msgViewPickerOverlay.js to update view picker tollbar item
patch -p0 -N -R < $SCRIPT_DIR/viewpicker_changes.patch

# 140. Patch to fix anomaly in viewing tasks in calendar month view.
patch -p0 -N -R < $SCRIPT_DIR/monthView_tasksInView.patch

# 130. Patch to make sure that itip invitations get added to calendar.
patch -p0 -N -R < $SCRIPT_DIR/itip_adding_event.patch

# 120. Patch to fix errors while migration from Sp 0.4 calendars to 0.7 (Bug 642)
patch -p0 -N -R < $SCRIPT_DIR/642_calendar_migration_fix.patch

# 110. Patch to get rid of security error in displaying imip invitation (Bug 779)
patch -p0 -N -R < $SCRIPT_DIR/imip_event_style.patch

# 100. Patch to enable only fcc without recepients in compose dialog
patch -p0 -N -R < $SCRIPT_DIR/allow_only_fcc.patch

# 90. Patch for defering the findSession part in google calendar code
patch -p0 -N -R < $SCRIPT_DIR/gdata_provider_defer_findsession.patch

# 80. Patch for getting blogs working with current mailnews code.
patch -p0 -N -R < $SCRIPT_DIR/mailnews_local_blog_change.patch

# 70. Patch for nsMsgDBView.cpp & .h to add support for custom date formats.
patch -p0 -N -R < $SCRIPT_DIR/custom-dates.patch

# 65. Patch to fix descending sort order for many message fields.
#     Upstream bug 449949. Downstream bug 977.
patch -p1 -N -R < $SCRIPT_DIR/449949_fix_descending_sort.patch

# 60. Patch to integrate glib event loop into Windows event loop
patch -p0 -N -R < $SCRIPT_DIR/windows_glib_event_loop.patch

# 50. Patch configure.ac for Spicebird specific options and checks
patch -p0 -N -R < $SCRIPT_DIR/configure.patch

# 40. Modify docshell, script security manager, mailnews content policy to
#     allow full content in iframes within same window as messagepane
patch -p0 -N -R < $SCRIPT_DIR/security_relax_for_non_messagepanes_docshells.patch

# 30. Modify nsMessengerBootstrap.cpp to open collab when 
#     the '-mail' command line switch is passed.
patch -p0 -N -R < $SCRIPT_DIR/messenger-bootstrap-collab.patch

# 20. Generalizes the hardcoded Lightning/Sunbird thing
patch -p0 -N -R < $SCRIPT_DIR/generalize_gdata_provider_module.patch

# 10. Let addons add a custom column to addressbook list view
patch -p0 -N -R < $SCRIPT_DIR/addrbook-custom-column.patch

