/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-sound-process.h,v 1.1 2000/01/07 08:44:41 rich Exp $
 */

#ifndef __xracer_sound_process_h__
#define __xracer_sound_process_h__

/* Sound status buffer shared between parent and child processes. */
struct xrSoundStatus
{
};

#define XR_SOUND_COMMAND_CODE_QUIT   0

/* Format of a single command buffer. */
struct xrSoundCommandBuffer
{
  int code;
};

#define XR_SOUND_NR_COMMANDS 16	/* Must be a power of 2. */

/* Format of sound shared memory. */
struct xrSoundSharedMemory
{
  struct xrSoundStatus status;

  int insert_position, remove_position;
  struct xrSoundCommandBuffer command[XR_SOUND_NR_COMMANDS];
};

/* This is the entry point for the sound process in the child. */
extern void xrSoundProcessRun (void *);

#endif /* __xracer_sound_process_h__ */
