/*
   ub_coptic2beta.h - tables for Coptic Unicode to Beta Code conversion.

   Author: Paul Hardy, unifoundry <at> unifoundry.com

   Copyright (C) 2018, 2019, 2020 Paul Hardy

   LICENSE:

      This program is free software: you can redistribute it and/or modify
      it under the terms of the GNU General Public License as published by
      the Free Software Foundation, either version 2 of the License, or
      (at your option) any later version.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.
      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
   uni03xx_coptic_betacode holds Unicode to Coptic Beta Code mappings
   for the Unicode range U+0300..U+03FF.
*/
char *uni03xx_coptic_betacode [256] = {
   /* U+0300 */  "\\",        /* Jinma Coptic accent */
   /* U+0301 */  "{\\u0301}",
   /* U+0302 */  "{\\u0302}",
   /* U+0303 */  "{\\u0303}",
   /* U+0304 */  "{\\u0304}",
   /* U+0305 */  "{\\u0305}",
   /* U+0306 */  "{\\u0306}",
   /* U+0307 */  "{\\u0307}",
   /* U+0308 */  "{\\u0308}",
   /* U+0309 */  "{\\u0309}",
   /* U+030A */  "{\\u030A}",
   /* U+030B */  "{\\u030B}",
   /* U+030C */  "{\\u030C}",
   /* U+030D */  "{\\u030D}",
   /* U+030E */  "{\\u030E}",
   /* U+030F */  "{\\u030F}",
   /* U+0310 */  "{\\u0310}",
   /* U+0311 */  "{\\u0311}",
   /* U+0312 */  "{\\u0312}",
   /* U+0313 */  "{\\u0313}",
   /* U+0314 */  "{\\u0314}",
   /* U+0315 */  "{\\u0315}",
   /* U+0316 */  "{\\u0316}",
   /* U+0317 */  "{\\u0317}",
   /* U+0318 */  "{\\u0318}",
   /* U+0319 */  "{\\u0319}",
   /* U+031A */  "{\\u031A}",
   /* U+031B */  "{\\u031B}",
   /* U+031C */  "{\\u031C}",
   /* U+031D */  "{\\u031D}",
   /* U+031E */  "{\\u031E}",
   /* U+031F */  "{\\u031F}",
   /* U+0320 */  "{\\u0320}",
   /* U+0321 */  "{\\u0321}",
   /* U+0322 */  "{\\u0322}",
   /* U+0323 */  "{\\u0323}",
   /* U+0324 */  "{\\u0324}",
   /* U+0325 */  "{\\u0325}",
   /* U+0326 */  "{\\u0326}",
   /* U+0327 */  "{\\u0327}",
   /* U+0328 */  "{\\u0328}",
   /* U+0329 */  "{\\u0329}",
   /* U+032A */  "{\\u032A}",
   /* U+032B */  "{\\u032B}",
   /* U+032C */  "{\\u032C}",
   /* U+032D */  "{\\u032D}",
   /* U+032E */  "{\\u032E}",
   /* U+032F */  "{\\u032F}",
   /* U+0330 */  "{\\u0330}",
   /* U+0331 */  "{\\u0331}",
   /* U+0332 */  "{\\u0332}",
   /* U+0333 */  "{\\u0333}",
   /* U+0334 */  "{\\u0334}",
   /* U+0335 */  "{\\u0335}",
   /* U+0336 */  "{\\u0336}",
   /* U+0337 */  "{\\u0337}",
   /* U+0338 */  "{\\u0338}",
   /* U+0339 */  "{\\u0339}",
   /* U+033A */  "{\\u033A}",
   /* U+033B */  "{\\u033B}",
   /* U+033C */  "{\\u033C}",
   /* U+033D */  "{\\u033D}",
   /* U+033E */  "{\\u033E}",
   /* U+033F */  "{\\u033F}",
   /* U+0340 */  "{\\u0340}",
   /* U+0341 */  "{\\u0341}",
   /* U+0342 */  "{\\u0342}",
   /* U+0343 */  "{\\u0343}",
   /* U+0344 */  "{\\u0344}",
   /* U+0345 */  "{\\u0345}",
   /* U+0346 */  "{\\u0346}",
   /* U+0347 */  "{\\u0347}",
   /* U+0348 */  "{\\u0348}",
   /* U+0349 */  "{\\u0349}",
   /* U+034A */  "{\\u034A}",
   /* U+034B */  "{\\u034B}",
   /* U+034C */  "{\\u034C}",
   /* U+034D */  "{\\u034D}",
   /* U+034E */  "{\\u034E}",
   /* U+034F */  "{\\u034F}",
   /* U+0350 */  "{\\u0350}",
   /* U+0351 */  "{\\u0351}",
   /* U+0352 */  "{\\u0352}",
   /* U+0353 */  "{\\u0353}",
   /* U+0354 */  "{\\u0354}",
   /* U+0355 */  "{\\u0355}",
   /* U+0356 */  "{\\u0356}",
   /* U+0357 */  "{\\u0357}",
   /* U+0358 */  "{\\u0358}",
   /* U+0359 */  "{\\u0359}",
   /* U+035A */  "{\\u035A}",
   /* U+035B */  "{\\u035B}",
   /* U+035C */  "{\\u035C}",
   /* U+035D */  "{\\u035D}",
   /* U+035E */  "{\\u035E}",
   /* U+035F */  "{\\u035F}",
   /* U+0360 */  "{\\u0360}",
   /* U+0361 */  "{\\u0361}",
   /* U+0362 */  "{\\u0362}",
   /* U+0363 */  "{\\u0363}",
   /* U+0364 */  "{\\u0364}",
   /* U+0365 */  "{\\u0365}",
   /* U+0366 */  "{\\u0366}",
   /* U+0367 */  "{\\u0367}",
   /* U+0368 */  "{\\u0368}",
   /* U+0369 */  "{\\u0369}",
   /* U+036A */  "{\\u036A}",
   /* U+036B */  "{\\u036B}",
   /* U+036C */  "{\\u036C}",
   /* U+036D */  "{\\u036D}",
   /* U+036E */  "{\\u036E}",
   /* U+036F */  "{\\u036F}",
   /* U+0370 */  "{\\u0370}",
   /* U+0371 */  "{\\u0371}",
   /* U+0372 */  "{\\u0372}",
   /* U+0373 */  "{\\u0373}",
   /* U+0374 */  "{\\u0374}",
   /* U+0375 */  "{\\u0375}",
   /* U+0376 */  "{\\u0376}",
   /* U+0377 */  "{\\u0377}",
   /* U+0378 */  "{\\u0378}",
   /* U+0379 */  "{\\u0379}",
   /* U+037A */  "{\\u037A}",
   /* U+037B */  "{\\u037B}",
   /* U+037C */  "{\\u037C}",
   /* U+037D */  "{\\u037D}",
   /* U+037E */  "{\\u037E}",
   /* U+037F */  "{\\u037F}",
   /* U+0380 */  "{\\u0380}",
   /* U+0381 */  "{\\u0381}",
   /* U+0382 */  "{\\u0382}",
   /* U+0383 */  "{\\u0383}",
   /* U+0384 */  "{\\u0384}",
   /* U+0385 */  "{\\u0385}",
   /* U+0386 */  "{\\u0386}",
   /* U+0387 */  "{\\u0387}",
   /* U+0388 */  "{\\u0388}",
   /* U+0389 */  "{\\u0389}",
   /* U+038A */  "{\\u038A}",
   /* U+038B */  "{\\u038B}",
   /* U+038C */  "{\\u038C}",
   /* U+038D */  "{\\u038D}",
   /* U+038E */  "{\\u038E}",
   /* U+038F */  "{\\u038F}",
   /* U+0390 */  "{\\u0390}",
   /* U+0391 */  "{\\u0391}",
   /* U+0392 */  "{\\u0392}",
   /* U+0393 */  "{\\u0393}",
   /* U+0394 */  "{\\u0394}",
   /* U+0395 */  "{\\u0395}",
   /* U+0396 */  "{\\u0396}",
   /* U+0397 */  "{\\u0397}",
   /* U+0398 */  "{\\u0398}",
   /* U+0399 */  "{\\u0399}",
   /* U+039A */  "{\\u039A}",
   /* U+039B */  "{\\u039B}",
   /* U+039C */  "{\\u039C}",
   /* U+039D */  "{\\u039D}",
   /* U+039E */  "{\\u039E}",
   /* U+039F */  "{\\u039F}",
   /* U+03A0 */  "{\\u03A0}",
   /* U+03A1 */  "{\\u03A1}",
   /* U+03A2 */  "{\\u03A2}",
   /* U+03A3 */  "{\\u03A3}",
   /* U+03A4 */  "{\\u03A4}",
   /* U+03A5 */  "{\\u03A5}",
   /* U+03A6 */  "{\\u03A6}",
   /* U+03A7 */  "{\\u03A7}",
   /* U+03A8 */  "{\\u03A8}",
   /* U+03A9 */  "{\\u03A9}",
   /* U+03AA */  "{\\u03AA}",
   /* U+03AB */  "{\\u03AB}",
   /* U+03AC */  "{\\u03AC}",
   /* U+03AD */  "{\\u03AD}",
   /* U+03AE */  "{\\u03AE}",
   /* U+03AF */  "{\\u03AF}",
   /* U+03B0 */  "{\\u03B0}",
   /* U+03B1 */  "{\\u03B1}",
   /* U+03B2 */  "{\\u03B2}",
   /* U+03B3 */  "{\\u03B3}",
   /* U+03B4 */  "{\\u03B4}",
   /* U+03B5 */  "{\\u03B5}",
   /* U+03B6 */  "{\\u03B6}",
   /* U+03B7 */  "{\\u03B7}",
   /* U+03B8 */  "{\\u03B8}",
   /* U+03B9 */  "{\\u03B9}",
   /* U+03BA */  "{\\u03BA}",
   /* U+03BB */  "{\\u03BB}",
   /* U+03BC */  "{\\u03BC}",
   /* U+03BD */  "{\\u03BD}",
   /* U+03BE */  "{\\u03BE}",
   /* U+03BF */  "{\\u03BF}",
   /* U+03C0 */  "{\\u03C0}",
   /* U+03C1 */  "{\\u03C1}",
   /* U+03C2 */  "{\\u03C2}",
   /* U+03C3 */  "{\\u03C3}",
   /* U+03C4 */  "{\\u03C4}",
   /* U+03C5 */  "{\\u03C5}",
   /* U+03C6 */  "{\\u03C6}",
   /* U+03C7 */  "{\\u03C7}",
   /* U+03C8 */  "{\\u03C8}",
   /* U+03C9 */  "{\\u03C9}",
   /* U+03CA */  "{\\u03CA}",
   /* U+03CB */  "{\\u03CB}",
   /* U+03CC */  "{\\u03CC}",
   /* U+03CD */  "{\\u03CD}",
   /* U+03CE */  "{\\u03CE}",
   /* U+03CF */  "{\\u03CF}",
   /* U+03D0 */  "{\\u03D0}",
   /* U+03D1 */  "{\\u03D1}",
   /* U+03D2 */  "{\\u03D2}",
   /* U+03D3 */  "{\\u03D3}",
   /* U+03D4 */  "{\\u03D4}",
   /* U+03D5 */  "{\\u03D5}",
   /* U+03D6 */  "{\\u03D6}",
   /* U+03D7 */  "{\\u03D7}",
   /* U+03D8 */  "{\\u03D8}",
   /* U+03D9 */  "{\\u03D9}",
   /* U+03DA */  "{\\u03DA}",
   /* U+03DB */  "{\\u03DB}",
   /* U+03DC */  "{\\u03DC}",
   /* U+03DD */  "{\\u03DD}",
   /* U+03DE */  "{\\u03DE}",
   /* U+03DF */  "{\\u03DF}",
   /* U+03E0 */  "{\\u03E0}",
   /* U+03E1 */  "{\\u03E1}",
   /* U+03E2 */  "*s",
   /* U+03E3 */  "s",
   /* U+03E4 */  "*f",
   /* U+03E5 */  "f",
   /* U+03E6 */  "*k",
   /* U+03E7 */  "k",
   /* U+03E8 */  "*h",
   /* U+03E9 */  "h",
   /* U+03EA */  "*j",
   /* U+03EB */  "j",
   /* U+03EC */  "*g",
   /* U+03ED */  "g",
   /* U+03EE */  "*t",
   /* U+03EF */  "t",
   /* U+03F0 */  "{\\u03F0}",
   /* U+03F1 */  "{\\u03F1}",
   /* U+03F2 */  "{\\u03F2}",
   /* U+03F3 */  "{\\u03F3}",
   /* U+03F4 */  "{\\u03F4}",
   /* U+03F5 */  "{\\u03F5}",
   /* U+03F6 */  "{\\u03F6}",
   /* U+03F7 */  "{\\u03F7}",
   /* U+03F8 */  "{\\u03F8}",
   /* U+03F9 */  "{\\u03F9}",
   /* U+03FA */  "{\\u03FA}",
   /* U+03FB */  "{\\u03FB}",
   /* U+03FC */  "{\\u03FC}",
   /* U+03FD */  "{\\u03FD}",
   /* U+03FE */  "{\\u03FE}",
   /* U+03FF */  "{\\u03FF}"
};


/*
   uni2Cxx_coptic_betacode holds Unicode to Coptic Beta Code mappings
   for the Unicode range U+2C00..U+2CFF.
*/
char *uni2Cxx_coptic_betacode [256] = {
   /* U+2C80 */  "*A",
   /* U+2C81 */  "A",
   /* U+2C82 */  "*B",
   /* U+2C83 */  "B",
   /* U+2C84 */  "*G",
   /* U+2C85 */  "G",
   /* U+2C86 */  "*D",
   /* U+2C87 */  "D",
   /* U+2C88 */  "*E",
   /* U+2C89 */  "E",
   /* U+2C8A */  "*V",
   /* U+2C8B */  "V",
   /* U+2C8C */  "*Z",
   /* U+2C8D */  "Z",
   /* U+2C8E */  "*H",
   /* U+2C8F */  "H",
   /* U+2C90 */  "*Q",
   /* U+2C91 */  "Q",
   /* U+2C92 */  "*I",
   /* U+2C93 */  "I",
   /* U+2C94 */  "*K",
   /* U+2C95 */  "K",
   /* U+2C96 */  "*L",
   /* U+2C97 */  "L",
   /* U+2C98 */  "*M",
   /* U+2C99 */  "M",
   /* U+2C9A */  "*N",
   /* U+2C9B */  "N",
   /* U+2C9C */  "*C",
   /* U+2C9D */  "C",
   /* U+2C9E */  "*O",
   /* U+2C9F */  "O",
   /* U+2CA0 */  "*P",
   /* U+2CA1 */  "P",
   /* U+2CA2 */  "*R",
   /* U+2CA3 */  "R",
   /* U+2CA4 */  "*S",
   /* U+2CA5 */  "S",
   /* U+2CA6 */  "*T",
   /* U+2CA7 */  "T",
   /* U+2CA8 */  "*U",
   /* U+2CA9 */  "U",
   /* U+2CAA */  "*F",
   /* U+2CAB */  "F",
   /* U+2CAC */  "*X",
   /* U+2CAD */  "X",
   /* U+2CAE */  "*Y",
   /* U+2CAF */  "Y",
   /* U+2CB0 */  "*W",
   /* U+2CB1 */  "W",
   /* U+2CB2 */  "{\\u2CB2}",
   /* U+2CB3 */  "{\\u2CB3}",
   /* U+2CB4 */  "{\\u2CB4}",
   /* U+2CB5 */  "{\\u2CB5}",
   /* U+2CB6 */  "{\\u2CB6}",
   /* U+2CB7 */  "{\\u2CB7}",
   /* U+2CB8 */  "{\\u2CB8}",
   /* U+2CB9 */  "{\\u2CB9}",
   /* U+2CBA */  "{\\u2CBA}",
   /* U+2CBB */  "{\\u2CBB}",
   /* U+2CBC */  "{\\u2CBC}",
   /* U+2CBD */  "{\\u2CBD}",
   /* U+2CBE */  "{\\u2CBE}",
   /* U+2CBF */  "{\\u2CBF}",
   /* U+2CC0 */  "{\\u2CC0}",
   /* U+2CC1 */  "{\\u2CC1}",
   /* U+2CC2 */  "{\\u2CC2}",
   /* U+2CC3 */  "{\\u2CC3}",
   /* U+2CC4 */  "{\\u2CC4}",
   /* U+2CC5 */  "{\\u2CC5}",
   /* U+2CC6 */  "{\\u2CC6}",
   /* U+2CC7 */  "{\\u2CC7}",
   /* U+2CC8 */  "{\\u2CC8}",
   /* U+2CC9 */  "{\\u2CC9}",
   /* U+2CCA */  "{\\u2CCA}",
   /* U+2CCB */  "{\\u2CCB}",
   /* U+2CCC */  "{\\u2CCC}",
   /* U+2CCD */  "{\\u2CCD}",
   /* U+2CCE */  "{\\u2CCE}",
   /* U+2CCF */  "{\\u2CCF}",
   /* U+2CD0 */  "{\\u2CD0}",
   /* U+2CD1 */  "{\\u2CD1}",
   /* U+2CD2 */  "{\\u2CD2}",
   /* U+2CD3 */  "{\\u2CD3}",
   /* U+2CD4 */  "{\\u2CD4}",
   /* U+2CD5 */  "{\\u2CD5}",
   /* U+2CD6 */  "{\\u2CD6}",
   /* U+2CD7 */  "{\\u2CD7}",
   /* U+2CD8 */  "{\\u2CD8}",
   /* U+2CD9 */  "{\\u2CD9}",
   /* U+2CDA */  "{\\u2CDA}",
   /* U+2CDB */  "{\\u2CDB}",
   /* U+2CDC */  "{\\u2CDC}",
   /* U+2CDD */  "{\\u2CDD}",
   /* U+2CDE */  "{\\u2CDE}",
   /* U+2CDF */  "{\\u2CDF}",
   /* U+2CE0 */  "{\\u2CE0}",
   /* U+2CE1 */  "{\\u2CE1}",
   /* U+2CE2 */  "{\\u2CE2}",
   /* U+2CE3 */  "{\\u2CE3}",
   /* U+2CE4 */  "{\\u2CE4}",
   /* U+2CE5 */  "{\\u2CE5}",
   /* U+2CE6 */  "{\\u2CE6}",
   /* U+2CE7 */  "{\\u2CE7}",
   /* U+2CE8 */  "{\\u2CE8}",
   /* U+2CE9 */  "{\\u2CE9}",
   /* U+2CEA */  "{\\u2CEA}",
   /* U+2CEB */  "{\\u2CEB}",
   /* U+2CEC */  "{\\u2CEC}",
   /* U+2CED */  "{\\u2CED}",
   /* U+2CEE */  "{\\u2CEE}",
   /* U+2CEF */  "{\\u2CEF}",
   /* U+2CF0 */  "{\\u2CF0}",
   /* U+2CF1 */  "{\\u2CF1}",
   /* U+2CF2 */  "{\\u2CF2}",
   /* U+2CF3 */  "{\\u2CF3}",
   /* U+2CF4 */  "{\\u2CF4}",
   /* U+2CF5 */  "{\\u2CF5}",
   /* U+2CF6 */  "{\\u2CF6}",
   /* U+2CF7 */  "{\\u2CF7}",
   /* U+2CF8 */  "{\\u2CF8}",
   /* U+2CF9 */  "{\\u2CF9}",
   /* U+2CFA */  "{\\u2CFA}",
   /* U+2CFB */  "{\\u2CFB}",
   /* U+2CFC */  "{\\u2CFC}",
   /* U+2CFD */  "{\\u2CFD}",
   /* U+2CFE */  "{\\u2CFE}",
   /* U+2CFF */  "{\\u2CFF}"
};
