#include <iostream>

#include "CommandlineOptions.hh"

#include "PlacingTriang.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing a placing triangulations of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  Chirotope chiro;
  if (chiro.read_string(std::cin)) {
    MessageStreams::result() << PlacingTriang(chiro) << std::endl;
    return 0;
  }
  else {
    MessageStreams::forced() << "chiro2placingtriang: error while reading chirotope." << std::endl;
    return 1;
  }
}

// eof chiro2placingtriang.cc
