use ui;
use layout;
use core:info;
use core:geometry;

dialog LicenseDialog {
	layout Grid {
		expandCol: 3;
		expandRow: 3;
		normalizeCols;

		// Navigation:
		Label proginfo("Program") { row: 0; col: 0; }
		Label progauthor("By:") { row: 0; col: 1; }

		Label("Components currently used by the system:") { row: 1; col: 0; colspan: 2; }

		ListView licenseList(["Component", "License"]) { row: 2; col: 0; colspan: 2; rowspan: 2; }
		FillBox(250, 200) { row: 3; col: 0; colspan: 2; }

		FillBox(8, 0) { row: 0; col: 2; }

		// License viewer:
		Label lPackage("Package:") { row: 0; col: 3; }
		Label lAuthor("Author:") { row: 1; col: 3; }
		Label("License:") { row: 2; col: 3; }

		ScrollWindow scroll(Label(""), Size(200, 200)) { vertical; row: 3; col: 3; }
	}

	private ProgramInfo info;
	private License[] licenses;

	init(ProgramInfo info) {
		init("About ${info.name}", Size(600, 300)) {
			info = info;
		}

		proginfo.text = if (version = info.version) {
			"${info.name} ${info.version}";
		} else {
			info.name;
		};
		progauthor.text = "By: " + info.author;

		if (license = info.license) {
			licenses << license;
			licenseList.add([info.name, license.title]);
		}

		for (license in core:info:licenses()) {
			if (license !is info.license) {
				addLicense(license);
			}
		}

		// Set callback last.
		licenseList.onSelect = &this.onListSelect;
		licenseList.selection = 0;
	}

	private void addLicense(License license) {
		licenses << license;
		licenseList.add([license.name, license.title]);
	}

	private void onListSelect(Nat id, Bool selected) {
		if (!selected)
			return;

		var l = licenses[id];
		lPackage.text = "Package: " + l.path.toS();
		lAuthor.text = "Author: " + l.author;
		scroll.content = Label(l.body);

		// Update the size/layout if necessary.
		size = max(pos.size(), minSize());
	}
}
