//                                               -*- C++ -*-
/**
 *  @brief The test file of class ResourceMap for standard methods
 *
 *  Copyright 2005-2025 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#include "openturns/OT.hxx"
#include "openturns/OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int, char *[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  // Create a ResourceMap Object
  fullprint << ResourceMap::GetInstance() << std::endl;

  fullprint << "Extract from ResourceMap: Cache-MaxSize -> " << ResourceMap::GetAsUnsignedInteger("Cache-MaxSize") << std::endl;

  // Create string key
  fullprint << "Create key: dummy_key" << std::endl;
  ResourceMap::AddAsString("dummy_key", "A temporary key, to be removed");
  fullprint << ResourceMap::GetInstance() << std::endl;

  // Remove key
  fullprint << "Remove key: dummy_key" << std::endl;
  ResourceMap::RemoveKey("dummy_key");
  fullprint << ResourceMap::GetInstance() << std::endl;


  return ExitCode::Success;
}
