
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HatchGraphShadeStyleAttributes.h
    \\brief Definition of HatchGraphShadeStyle Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "HatchGraphShadeStyleAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

HatchGraphShadeStyleAttributes::HatchGraphShadeStyleAttributes():
	index_(ParameterManager::getInt("graph_shade_hatch_index"))
	
	 
{
} 


HatchGraphShadeStyleAttributes::~HatchGraphShadeStyleAttributes()
{
	
}

    
void HatchGraphShadeStyleAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "graph_shade_hatch_index", index_, params);
	
	
}

void HatchGraphShadeStyleAttributes::copy(const HatchGraphShadeStyleAttributes& other)
{
	index_ = other.index_;
	
} 


bool HatchGraphShadeStyleAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void HatchGraphShadeStyleAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void HatchGraphShadeStyleAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " index = " <<  index_;
	
	out << "]" << "\n";
}

void HatchGraphShadeStyleAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"graph_shade_hatch_index\":";
	niceprint(out,index_);
	
}

static MagicsParameter<int> graph_shade_hatch_index("graph_shade_hatch_index", 0, "");
