/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_k_rational_p.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t26, t28, t29, t30, t31, t32, t33;
  double t34, t35, t42, t43, t47, tzk0;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = 0.1e1 / params->p;
  t26 = M_CBRT6;
  t28 = M_PI * M_PI;
  t29 = POW_1_3(t28);
  t30 = t29 * t29;
  t31 = 0.1e1 / t30;
  t32 = t31 * sigma[0];
  t33 = M_CBRT2;
  t34 = t33 * t33;
  t35 = rho[0] * rho[0];
  t42 = 0.1e1 + params->C2 * t24 * t26 * t32 * t34 / t22 / t35 / 0.24e2;
  t43 = pow(t42, -params->p);
  t47 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t20 * t22 * t43);
  tzk0 = 0.2e1 * t47;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t26, t28, t29, t30, t31, t32, t33;
  double t34, t35, t42, t43, t47, tzk0;

  double t53, t57, t58, t60, t61, t63, t67, tvrho0;
  double t74, t76, t79, tvsigma0;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = 0.1e1 / params->p;
  t26 = M_CBRT6;
  t28 = M_PI * M_PI;
  t29 = POW_1_3(t28);
  t30 = t29 * t29;
  t31 = 0.1e1 / t30;
  t32 = t31 * sigma[0];
  t33 = M_CBRT2;
  t34 = t33 * t33;
  t35 = rho[0] * rho[0];
  t42 = 0.1e1 + params->C2 * t24 * t26 * t32 * t34 / t22 / t35 / 0.24e2;
  t43 = pow(t42, -params->p);
  t47 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t20 * t22 * t43);
  tzk0 = 0.2e1 * t47;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t53 = t35 * rho[0];
  t57 = t7 * t20 / t53 * t43;
  t58 = params->C2 * t26;
  t60 = sigma[0] * t34;
  t61 = 0.1e1 / t42;
  t63 = t58 * t31 * t60 * t61;
  t67 = my_piecewise3(t2, 0, t7 * t20 / t21 * t43 / 0.1e2 + t57 * t63 / 0.6e2);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t47;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t31 * t34;
  t76 = t58 * t74 * t61;
  t79 = my_piecewise3(t2, 0, -t7 * t20 / t35 * t43 * t76 / 0.16e3);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t26, t28, t29, t30, t31, t32, t33;
  double t34, t35, t42, t43, t47, tzk0;

  double t53, t57, t58, t60, t61, t63, t67, tvrho0;
  double t74, t76, t79, tvsigma0;

  double t88, t92, t95, t97, t100, t101, t102, t103;
  double t105, t106, t107, t109, t110, t112, t115, t118;
  double t119, t122, t123, t127, tv2rho20, t132, t134, t137;
  double t140, t149, t153, tv2rhosigma0, t160, t163, t165, t169;
  double tv2sigma20;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = 0.1e1 / params->p;
  t26 = M_CBRT6;
  t28 = M_PI * M_PI;
  t29 = POW_1_3(t28);
  t30 = t29 * t29;
  t31 = 0.1e1 / t30;
  t32 = t31 * sigma[0];
  t33 = M_CBRT2;
  t34 = t33 * t33;
  t35 = rho[0] * rho[0];
  t42 = 0.1e1 + params->C2 * t24 * t26 * t32 * t34 / t22 / t35 / 0.24e2;
  t43 = pow(t42, -params->p);
  t47 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t20 * t22 * t43);
  tzk0 = 0.2e1 * t47;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t53 = t35 * rho[0];
  t57 = t7 * t20 / t53 * t43;
  t58 = params->C2 * t26;
  t60 = sigma[0] * t34;
  t61 = 0.1e1 / t42;
  t63 = t58 * t31 * t60 * t61;
  t67 = my_piecewise3(t2, 0, t7 * t20 / t21 * t43 / 0.1e2 + t57 * t63 / 0.6e2);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t47;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t31 * t34;
  t76 = t58 * t74 * t61;
  t79 = my_piecewise3(t2, 0, -t7 * t20 / t35 * t43 * t76 / 0.16e3);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t88 = t35 * t35;
  t92 = t7 * t20 / t88 * t43;
  t95 = t88 * t35;
  t97 = 0.1e1 / t22 / t95;
  t100 = t7 * t20 * t97 * t43;
  t101 = params->C2 * params->C2;
  t102 = t26 * t26;
  t103 = t101 * t102;
  t105 = 0.1e1 / t29 / t28;
  t106 = t103 * t105;
  t107 = sigma[0] * sigma[0];
  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t106 * t107 * t33 * t110;
  t115 = t7 * t20;
  t118 = t115 * t97 * t43 * t101;
  t119 = t102 * t105;
  t122 = t33 * t110 * t24;
  t123 = t119 * t107 * t122;
  t127 = my_piecewise3(t2, 0, -t7 * t20 / t21 / rho[0] * t43 / 0.3e2 - 0.7e1 / 0.18e3 * t92 * t63 + t100 * t112 / 0.27e3 + t118 * t123 / 0.27e3);
  tv2rho20 = 0.2e1 * rho[0] * t127 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t132 = t88 * rho[0];
  t134 = 0.1e1 / t22 / t132;
  t137 = t7 * t20 * t134 * t43;
  t140 = t106 * sigma[0] * t33 * t110;
  t149 = t119 * t33 * t110 * t24 * sigma[0];
  t153 = my_piecewise3(t2, 0, t57 * t76 / 0.8e2 - t137 * t140 / 0.72e3 - t115 * t134 * t43 * t101 * t149 / 0.72e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t153 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t160 = t7 * t20 / t22 / t88 * t43;
  t163 = t103 * t105 * t33 * t110;
  t165 = t106 * t122;
  t169 = my_piecewise3(t2, 0, t160 * t163 / 0.192e4 + t160 * t165 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t169;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t26, t28, t29, t30, t31, t32, t33;
  double t34, t35, t42, t43, t47, tzk0;

  double t53, t57, t58, t60, t61, t63, t67, tvrho0;
  double t74, t76, t79, tvsigma0;

  double t88, t92, t95, t97, t100, t101, t102, t103;
  double t105, t106, t107, t109, t110, t112, t115, t118;
  double t119, t122, t123, t127, tv2rho20, t132, t134, t137;
  double t140, t149, t153, tv2rhosigma0, t160, t163, t165, t169;
  double tv2sigma20;

  double t181, t184, t186, t189, t194, t197, t200, t201;
  double t202, t206, t207, t208, t209, t211, t212, t213;
  double t217, t220, t221, t223, t227, tv3rho30, t241, t242;
  double t243, t247, t250, t252, t256, tv3rho2sigma0, t262, t264;
  double t266, t269, t271, t277, t281, tv3rhosigma20, t284, t286;
  double t288, t293, t294, t297, t301, tv3sigma30;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = 0.1e1 / params->p;
  t26 = M_CBRT6;
  t28 = M_PI * M_PI;
  t29 = POW_1_3(t28);
  t30 = t29 * t29;
  t31 = 0.1e1 / t30;
  t32 = t31 * sigma[0];
  t33 = M_CBRT2;
  t34 = t33 * t33;
  t35 = rho[0] * rho[0];
  t42 = 0.1e1 + params->C2 * t24 * t26 * t32 * t34 / t22 / t35 / 0.24e2;
  t43 = pow(t42, -params->p);
  t47 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t20 * t22 * t43);
  tzk0 = 0.2e1 * t47;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t53 = t35 * rho[0];
  t57 = t7 * t20 / t53 * t43;
  t58 = params->C2 * t26;
  t60 = sigma[0] * t34;
  t61 = 0.1e1 / t42;
  t63 = t58 * t31 * t60 * t61;
  t67 = my_piecewise3(t2, 0, t7 * t20 / t21 * t43 / 0.1e2 + t57 * t63 / 0.6e2);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t47;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t31 * t34;
  t76 = t58 * t74 * t61;
  t79 = my_piecewise3(t2, 0, -t7 * t20 / t35 * t43 * t76 / 0.16e3);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t88 = t35 * t35;
  t92 = t7 * t20 / t88 * t43;
  t95 = t88 * t35;
  t97 = 0.1e1 / t22 / t95;
  t100 = t7 * t20 * t97 * t43;
  t101 = params->C2 * params->C2;
  t102 = t26 * t26;
  t103 = t101 * t102;
  t105 = 0.1e1 / t29 / t28;
  t106 = t103 * t105;
  t107 = sigma[0] * sigma[0];
  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t106 * t107 * t33 * t110;
  t115 = t7 * t20;
  t118 = t115 * t97 * t43 * t101;
  t119 = t102 * t105;
  t122 = t33 * t110 * t24;
  t123 = t119 * t107 * t122;
  t127 = my_piecewise3(t2, 0, -t7 * t20 / t21 / rho[0] * t43 / 0.3e2 - 0.7e1 / 0.18e3 * t92 * t63 + t100 * t112 / 0.27e3 + t118 * t123 / 0.27e3);
  tv2rho20 = 0.2e1 * rho[0] * t127 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t132 = t88 * rho[0];
  t134 = 0.1e1 / t22 / t132;
  t137 = t7 * t20 * t134 * t43;
  t140 = t106 * sigma[0] * t33 * t110;
  t149 = t119 * t33 * t110 * t24 * sigma[0];
  t153 = my_piecewise3(t2, 0, t57 * t76 / 0.8e2 - t137 * t140 / 0.72e3 - t115 * t134 * t43 * t101 * t149 / 0.72e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t153 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t160 = t7 * t20 / t22 / t88 * t43;
  t163 = t103 * t105 * t33 * t110;
  t165 = t106 * t122;
  t169 = my_piecewise3(t2, 0, t160 * t163 / 0.192e4 + t160 * t165 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t169;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t181 = t7 * t20 / t132 * t43;
  t184 = t88 * t53;
  t186 = 0.1e1 / t22 / t184;
  t189 = t7 * t20 * t186 * t43;
  t194 = t115 * t186 * t43 * t101;
  t197 = t5 * t5;
  t200 = t4 / t197 / t28;
  t201 = t88 * t88;
  t202 = t201 * t35;
  t206 = t200 * t20 / t21 / t202;
  t207 = t101 * params->C2;
  t208 = t43 * t207;
  t209 = t107 * sigma[0];
  t211 = 0.1e1 / t109 / t42;
  t212 = t209 * t211;
  t213 = t208 * t212;
  t217 = t208 * t212 * t24;
  t220 = params->p * params->p;
  t221 = 0.1e1 / t220;
  t223 = t208 * t212 * t221;
  t227 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 / t21 / t35 * t43 + 0.41e2 / 0.27e3 * t181 * t63 - t189 * t112 / 0.3e2 - t194 * t123 / 0.3e2 + 0.2e1 / 0.405e3 * t206 * t213 + 0.2e1 / 0.135e3 * t206 * t217 + 0.4e1 / 0.405e3 * t206 * t223);
  tv3rho30 = 0.2e1 * rho[0] * t227 + 0.6e1 * t127;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t241 = t200 * t20 / t21 / t201 / rho[0];
  t242 = t107 * t211;
  t243 = t208 * t242;
  t247 = t208 * t242 * t24;
  t250 = t211 * t221;
  t252 = t208 * t250 * t107;
  t256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e2 * t92 * t76 + 0.23e2 / 0.216e4 * t100 * t140 + 0.23e2 / 0.216e4 * t118 * t149 - t241 * t243 / 0.54e3 - t241 * t247 / 0.18e3 - t241 * t252 / 0.27e3);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t256 + 0.4e1 * t153;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t262 = 0.1e1 / t21 / t201;
  t264 = t200 * t20 * t262;
  t266 = t208 * sigma[0] * t211;
  t269 = t211 * t24;
  t271 = t208 * t269 * sigma[0];
  t277 = t208 * t250 * sigma[0];
  t281 = my_piecewise3(t2, 0, -0.7e1 / 0.288e4 * t137 * t163 + t264 * t266 / 0.144e4 + t264 * t271 / 0.48e3 - 0.7e1 / 0.288e4 * t137 * t165 + t264 * t277 / 0.72e3);
  tv3rhosigma20 = 0.2e1 * rho[0] * t281 + 0.2e1 * t169;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t284 = t200 * t20;
  t286 = 0.1e1 / t21 / t184;
  t288 = t207 * t211;
  t293 = t200 * t20 * t286;
  t294 = t208 * t269;
  t297 = t208 * t250;
  t301 = my_piecewise3(t2, 0, -t284 * t286 * t43 * t288 / 0.384e4 - t293 * t294 / 0.128e4 - t293 * t297 / 0.192e4);
  tv3sigma30 = 0.2e1 * rho[0] * t301;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t11;
  double t12, t14, t15, t17, t18, t20, t21, t22;
  double t24, t26, t28, t29, t30, t31, t32, t33;
  double t34, t35, t42, t43, t47, tzk0;

  double t53, t57, t58, t60, t61, t63, t67, tvrho0;
  double t74, t76, t79, tvsigma0;

  double t88, t92, t95, t97, t100, t101, t102, t103;
  double t105, t106, t107, t109, t110, t112, t115, t118;
  double t119, t122, t123, t127, tv2rho20, t132, t134, t137;
  double t140, t149, t153, tv2rhosigma0, t160, t163, t165, t169;
  double tv2sigma20;

  double t181, t184, t186, t189, t194, t197, t200, t201;
  double t202, t206, t207, t208, t209, t211, t212, t213;
  double t217, t220, t221, t223, t227, tv3rho30, t241, t242;
  double t243, t247, t250, t252, t256, tv3rho2sigma0, t262, t264;
  double t266, t269, t271, t277, t281, tv3rhosigma20, t284, t286;
  double t288, t293, t294, t297, t301, tv3sigma30;

  double t317, t328, t332, t340, t344, t345, t346, t347;
  double t349, t350, t357, t358, t361, t370, t375, t376;
  double tv4rho40, t393, t404, t405, t414, t420, tv4rho3sigma0, t431;
  double t442, t448, t462, tv4rho2sigma20, t469, t479, t482, t499;
  double tv4rhosigma30, t505, t510, t524, tv4sigma40;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t15 = t14 * t14;
  t17 = POW_1_3(t12);
  t18 = t17 * t17;
  t20 = my_piecewise3(t12 <= p->zeta_threshold, t15 * p->zeta_threshold, t18 * t12);
  t21 = POW_1_3(rho[0]);
  t22 = t21 * t21;
  t24 = 0.1e1 / params->p;
  t26 = M_CBRT6;
  t28 = M_PI * M_PI;
  t29 = POW_1_3(t28);
  t30 = t29 * t29;
  t31 = 0.1e1 / t30;
  t32 = t31 * sigma[0];
  t33 = M_CBRT2;
  t34 = t33 * t33;
  t35 = rho[0] * rho[0];
  t42 = 0.1e1 + params->C2 * t24 * t26 * t32 * t34 / t22 / t35 / 0.24e2;
  t43 = pow(t42, -params->p);
  t47 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t20 * t22 * t43);
  tzk0 = 0.2e1 * t47;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t53 = t35 * rho[0];
  t57 = t7 * t20 / t53 * t43;
  t58 = params->C2 * t26;
  t60 = sigma[0] * t34;
  t61 = 0.1e1 / t42;
  t63 = t58 * t31 * t60 * t61;
  t67 = my_piecewise3(t2, 0, t7 * t20 / t21 * t43 / 0.1e2 + t57 * t63 / 0.6e2);
  tvrho0 = 0.2e1 * rho[0] * t67 + 0.2e1 * t47;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t74 = t31 * t34;
  t76 = t58 * t74 * t61;
  t79 = my_piecewise3(t2, 0, -t7 * t20 / t35 * t43 * t76 / 0.16e3);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t88 = t35 * t35;
  t92 = t7 * t20 / t88 * t43;
  t95 = t88 * t35;
  t97 = 0.1e1 / t22 / t95;
  t100 = t7 * t20 * t97 * t43;
  t101 = params->C2 * params->C2;
  t102 = t26 * t26;
  t103 = t101 * t102;
  t105 = 0.1e1 / t29 / t28;
  t106 = t103 * t105;
  t107 = sigma[0] * sigma[0];
  t109 = t42 * t42;
  t110 = 0.1e1 / t109;
  t112 = t106 * t107 * t33 * t110;
  t115 = t7 * t20;
  t118 = t115 * t97 * t43 * t101;
  t119 = t102 * t105;
  t122 = t33 * t110 * t24;
  t123 = t119 * t107 * t122;
  t127 = my_piecewise3(t2, 0, -t7 * t20 / t21 / rho[0] * t43 / 0.3e2 - 0.7e1 / 0.18e3 * t92 * t63 + t100 * t112 / 0.27e3 + t118 * t123 / 0.27e3);
  tv2rho20 = 0.2e1 * rho[0] * t127 + 0.4e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t132 = t88 * rho[0];
  t134 = 0.1e1 / t22 / t132;
  t137 = t7 * t20 * t134 * t43;
  t140 = t106 * sigma[0] * t33 * t110;
  t149 = t119 * t33 * t110 * t24 * sigma[0];
  t153 = my_piecewise3(t2, 0, t57 * t76 / 0.8e2 - t137 * t140 / 0.72e3 - t115 * t134 * t43 * t101 * t149 / 0.72e3);
  tv2rhosigma0 = 0.2e1 * rho[0] * t153 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t160 = t7 * t20 / t22 / t88 * t43;
  t163 = t103 * t105 * t33 * t110;
  t165 = t106 * t122;
  t169 = my_piecewise3(t2, 0, t160 * t163 / 0.192e4 + t160 * t165 / 0.192e4);
  tv2sigma20 = 0.2e1 * rho[0] * t169;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t181 = t7 * t20 / t132 * t43;
  t184 = t88 * t53;
  t186 = 0.1e1 / t22 / t184;
  t189 = t7 * t20 * t186 * t43;
  t194 = t115 * t186 * t43 * t101;
  t197 = t5 * t5;
  t200 = t4 / t197 / t28;
  t201 = t88 * t88;
  t202 = t201 * t35;
  t206 = t200 * t20 / t21 / t202;
  t207 = t101 * params->C2;
  t208 = t43 * t207;
  t209 = t107 * sigma[0];
  t211 = 0.1e1 / t109 / t42;
  t212 = t209 * t211;
  t213 = t208 * t212;
  t217 = t208 * t212 * t24;
  t220 = params->p * params->p;
  t221 = 0.1e1 / t220;
  t223 = t208 * t212 * t221;
  t227 = my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 / t21 / t35 * t43 + 0.41e2 / 0.27e3 * t181 * t63 - t189 * t112 / 0.3e2 - t194 * t123 / 0.3e2 + 0.2e1 / 0.405e3 * t206 * t213 + 0.2e1 / 0.135e3 * t206 * t217 + 0.4e1 / 0.405e3 * t206 * t223);
  tv3rho30 = 0.2e1 * rho[0] * t227 + 0.6e1 * t127;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t241 = t200 * t20 / t21 / t201 / rho[0];
  t242 = t107 * t211;
  t243 = t208 * t242;
  t247 = t208 * t242 * t24;
  t250 = t211 * t221;
  t252 = t208 * t250 * t107;
  t256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e2 * t92 * t76 + 0.23e2 / 0.216e4 * t100 * t140 + 0.23e2 / 0.216e4 * t118 * t149 - t241 * t243 / 0.54e3 - t241 * t247 / 0.18e3 - t241 * t252 / 0.27e3);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t256 + 0.4e1 * t153;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t262 = 0.1e1 / t21 / t201;
  t264 = t200 * t20 * t262;
  t266 = t208 * sigma[0] * t211;
  t269 = t211 * t24;
  t271 = t208 * t269 * sigma[0];
  t277 = t208 * t250 * sigma[0];
  t281 = my_piecewise3(t2, 0, -0.7e1 / 0.288e4 * t137 * t163 + t264 * t266 / 0.144e4 + t264 * t271 / 0.48e3 - 0.7e1 / 0.288e4 * t137 * t165 + t264 * t277 / 0.72e3);
  tv3rhosigma20 = 0.2e1 * rho[0] * t281 + 0.2e1 * t169;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t284 = t200 * t20;
  t286 = 0.1e1 / t21 / t184;
  t288 = t207 * t211;
  t293 = t200 * t20 * t286;
  t294 = t208 * t269;
  t297 = t208 * t250;
  t301 = my_piecewise3(t2, 0, -t284 * t286 * t43 * t288 / 0.384e4 - t293 * t294 / 0.128e4 - t293 * t297 / 0.192e4);
  tv3sigma30 = 0.2e1 * rho[0] * t301;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t317 = 0.1e1 / t22 / t201;
  t328 = t201 * t53;
  t332 = t200 * t20 / t21 / t328;
  t340 = 0.1e1 / t201 / t95;
  t344 = t101 * t101;
  t345 = t344 * t26;
  t346 = t345 * t31;
  t347 = t107 * t107;
  t349 = t109 * t109;
  t350 = 0.1e1 / t349;
  t357 = t284 * t340 * t43 * t344;
  t358 = t347 * t350;
  t361 = t26 * t31 * t34;
  t370 = 0.1e1 / t220 / params->p;
  t375 = -0.14e2 / 0.135e3 * t7 * t20 / t21 / t53 * t43 - 0.611e3 / 0.81e3 * t7 * t20 / t95 * t43 * t63 + 0.703e3 / 0.243e4 * t7 * t20 * t317 * t43 * t112 + 0.703e3 / 0.243e4 * t115 * t317 * t43 * t101 * t123 - 0.116e3 / 0.1215e4 * t332 * t213 - 0.116e3 / 0.405e3 * t332 * t217 - 0.232e3 / 0.1215e4 * t332 * t223 + 0.2e1 / 0.3645e4 * t200 * t20 * t340 * t43 * t346 * t347 * t34 * t350 + 0.4e1 / 0.1215e4 * t357 * t358 * t24 * t361 + 0.22e2 / 0.3645e4 * t357 * t358 * t221 * t361 + 0.4e1 / 0.1215e4 * t357 * t358 * t370 * t361;
  t376 = my_piecewise3(t2, 0, t375);
  tv4rho40 = 0.2e1 * rho[0] * t376 + 0.8e1 * t227;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t393 = 0.1e1 / t201 / t132;
  t404 = t284 * t393 * t43 * t344;
  t405 = t209 * t350;
  t414 = t350 * t370;
  t420 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t181 * t76 - 0.257e3 / 0.324e4 * t189 * t140 - 0.257e3 / 0.324e4 * t194 * t149 + 0.17e2 / 0.54e3 * t206 * t243 + 0.17e2 / 0.18e3 * t206 * t247 + 0.17e2 / 0.27e3 * t206 * t252 - t200 * t20 * t393 * t43 * t346 * t209 * t34 * t350 / 0.486e4 - t404 * t405 * t24 * t361 / 0.81e3 - 0.11e2 / 0.486e4 * t404 * t405 * t221 * t361 - t404 * t414 * t209 * t361 / 0.81e3);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t420 + 0.6e1 * t256;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t431 = 0.1e1 / t201 / t88;
  t442 = t284 * t431 * t43 * t344;
  t448 = t350 * t221;
  t462 = my_piecewise3(t2, 0, 0.119e3 / 0.864e4 * t100 * t163 - 0.13e2 / 0.144e4 * t241 * t266 - 0.13e2 / 0.48e3 * t241 * t271 + t200 * t20 * t431 * t43 * t346 * t107 * t34 * t350 / 0.1296e5 + t442 * t107 * t350 * t24 * t361 / 0.216e4 + 0.11e2 / 0.1296e5 * t442 * t448 * t107 * t361 + 0.119e3 / 0.864e4 * t100 * t165 - 0.13e2 / 0.72e3 * t241 * t277 + t442 * t414 * t107 * t361 / 0.216e4);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t462 + 0.4e1 * t281;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t469 = 0.1e1 / t328;
  t479 = t284 * t469 * t43 * t344;
  t482 = t32 * t34;
  t499 = my_piecewise3(t2, 0, 0.11e2 / 0.576e4 * t284 * t262 * t43 * t288 - t200 * t20 * t469 * t43 * t346 * t60 * t350 / 0.3456e5 - t479 * t350 * t24 * t26 * t482 / 0.576e4 + 0.11e2 / 0.192e4 * t264 * t294 - 0.11e2 / 0.3456e5 * t479 * t448 * t26 * t482 + 0.11e2 / 0.288e4 * t264 * t297 - t479 * t414 * t26 * t482 / 0.576e4);
  tv4rhosigma30 = 0.2e1 * rho[0] * t499 + 0.2e1 * t301;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t505 = t200 * t20 / t202 * t43;
  t510 = t344 * t350;
  t524 = my_piecewise3(t2, 0, t505 * t345 * t74 * t350 / 0.9216e5 + t505 * t510 * t24 * t361 / 0.1536e5 + 0.11e2 / 0.9216e5 * t505 * t510 * t221 * t361 + t505 * t510 * t370 * t361 / 0.1536e5);
  tv4sigma40 = 0.2e1 * rho[0] * t524;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t38, t39, t41;
  double t42, t43, t45, t49, t50, t51, t52, t54;
  double t55, t56, t58, t59, t60, t61, t62, t64;
  double t65, t67, t68, t69, t71, t75, t76, t77;
  double t78, t80, tzk0;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = 0.1e1 / params->p;
  t34 = M_CBRT6;
  t35 = params->C2 * t32 * t34;
  t36 = M_PI * M_PI;
  t37 = POW_1_3(t36);
  t38 = t37 * t37;
  t39 = 0.1e1 / t38;
  t41 = rho[0] * rho[0];
  t42 = POW_1_3(rho[0]);
  t43 = t42 * t42;
  t45 = 0.1e1 / t43 / t41;
  t49 = 0.1e1 + t35 * t39 * sigma[0] * t45 / 0.24e2;
  t50 = pow(t49, -params->p);
  t51 = t31 * t50;
  t52 = t6 * t51;
  t54 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t52);
  t55 = rho[1] <= p->dens_threshold;
  t56 = -t17;
  t58 = my_piecewise5(t15, t12, t11, t16, t56 * t8);
  t59 = 0.1e1 + t58;
  t60 = t59 <= p->zeta_threshold;
  t61 = POW_1_3(t59);
  t62 = t61 * t61;
  t64 = my_piecewise3(t60, t24, t62 * t59);
  t65 = t64 * t30;
  t67 = rho[1] * rho[1];
  t68 = POW_1_3(rho[1]);
  t69 = t68 * t68;
  t71 = 0.1e1 / t69 / t67;
  t75 = 0.1e1 + t35 * t39 * sigma[2] * t71 / 0.24e2;
  t76 = pow(t75, -params->p);
  t77 = t65 * t76;
  t78 = t6 * t77;
  t80 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t78);
  tzk0 = t54 + t80;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t38, t39, t41;
  double t42, t43, t45, t49, t50, t51, t52, t54;
  double t55, t56, t58, t59, t60, t61, t62, t64;
  double t65, t67, t68, t69, t71, t75, t76, t77;
  double t78, t80, tzk0;

  double t81, t82, t83, t85, t88, t89, t90, t91;
  double t93, t94, t95, t96, t97, t98, t99, t100;
  double t102, t104, t106, t110, t111, t113, t116, t117;
  double t118, t119, t121, t122, t123, t124, t126, tvrho0;
  double t130, t133, t134, t135, t136, t139, t141, t144;
  double t145, t146, t147, t149, t151, t153, t155, t159;
  double tvrho1, t164, t167, tvsigma0, tvsigma1, t170, t173, tvsigma2;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = 0.1e1 / params->p;
  t34 = M_CBRT6;
  t35 = params->C2 * t32 * t34;
  t36 = M_PI * M_PI;
  t37 = POW_1_3(t36);
  t38 = t37 * t37;
  t39 = 0.1e1 / t38;
  t41 = rho[0] * rho[0];
  t42 = POW_1_3(rho[0]);
  t43 = t42 * t42;
  t45 = 0.1e1 / t43 / t41;
  t49 = 0.1e1 + t35 * t39 * sigma[0] * t45 / 0.24e2;
  t50 = pow(t49, -params->p);
  t51 = t31 * t50;
  t52 = t6 * t51;
  t54 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t52);
  t55 = rho[1] <= p->dens_threshold;
  t56 = -t17;
  t58 = my_piecewise5(t15, t12, t11, t16, t56 * t8);
  t59 = 0.1e1 + t58;
  t60 = t59 <= p->zeta_threshold;
  t61 = POW_1_3(t59);
  t62 = t61 * t61;
  t64 = my_piecewise3(t60, t24, t62 * t59);
  t65 = t64 * t30;
  t67 = rho[1] * rho[1];
  t68 = POW_1_3(rho[1]);
  t69 = t68 * t68;
  t71 = 0.1e1 / t69 / t67;
  t75 = 0.1e1 + t35 * t39 * sigma[2] * t71 / 0.24e2;
  t76 = pow(t75, -params->p);
  t77 = t65 * t76;
  t78 = t6 * t77;
  t80 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t78);
  tzk0 = t54 + t80;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t7 * t7;
  t82 = 0.1e1 / t81;
  t83 = t17 * t82;
  t85 = my_piecewise5(t11, 0, t15, 0, t8 - t83);
  t88 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t85);
  t89 = t88 * t30;
  t90 = t89 * t50;
  t91 = t6 * t90;
  t93 = 0.1e1 / t29;
  t94 = t28 * t93;
  t95 = t94 * t50;
  t96 = t6 * t95;
  t97 = t96 / 0.1e2;
  t98 = params->C2 * t34;
  t99 = t98 * t39;
  t100 = t41 * rho[0];
  t102 = 0.1e1 / t43 / t100;
  t104 = 0.1e1 / t49;
  t106 = t99 * sigma[0] * t102 * t104;
  t110 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t91 + t97 + t52 * t106 / 0.6e2);
  t111 = t56 * t82;
  t113 = my_piecewise5(t15, 0, t11, 0, -t8 - t111);
  t116 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t113);
  t117 = t116 * t30;
  t118 = t117 * t76;
  t119 = t6 * t118;
  t121 = t64 * t93;
  t122 = t121 * t76;
  t123 = t6 * t122;
  t124 = t123 / 0.1e2;
  t126 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t119 + t124);
  tvrho0 = t54 + t80 + t7 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t11, 0, t15, 0, -t8 - t83);
  t133 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t130);
  t134 = t133 * t30;
  t135 = t134 * t50;
  t136 = t6 * t135;
  t139 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t136 + t97);
  t141 = my_piecewise5(t15, 0, t11, 0, t8 - t111);
  t144 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t141);
  t145 = t144 * t30;
  t146 = t145 * t76;
  t147 = t6 * t146;
  t149 = t67 * rho[1];
  t151 = 0.1e1 / t69 / t149;
  t153 = 0.1e1 / t75;
  t155 = t99 * sigma[2] * t151 * t153;
  t159 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t147 + t124 + t78 * t155 / 0.6e2);
  tvrho1 = t54 + t80 + t7 * (t139 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t164 = t98 * t39 * t45 * t104;
  t167 = my_piecewise3(t1, 0, -t52 * t164 / 0.16e3);
  tvsigma0 = t7 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t98 * t39 * t71 * t153;
  t173 = my_piecewise3(t55, 0, -t78 * t170 / 0.16e3);
  tvsigma2 = t7 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t38, t39, t41;
  double t42, t43, t45, t49, t50, t51, t52, t54;
  double t55, t56, t58, t59, t60, t61, t62, t64;
  double t65, t67, t68, t69, t71, t75, t76, t77;
  double t78, t80, tzk0;

  double t81, t82, t83, t85, t88, t89, t90, t91;
  double t93, t94, t95, t96, t97, t98, t99, t100;
  double t102, t104, t106, t110, t111, t113, t116, t117;
  double t118, t119, t121, t122, t123, t124, t126, tvrho0;
  double t130, t133, t134, t135, t136, t139, t141, t144;
  double t145, t146, t147, t149, t151, t153, t155, t159;
  double tvrho1, t164, t167, tvsigma0, tvsigma1, t170, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t192;
  double t196, t201, t204, t205, t206, t208, t209, t210;
  double t212, t213, t214, t215, t218, t220, t221, t223;
  double t227, t230, t233, t234, t235, t236, t237, t238;
  double t240, t241, t245, t246, t247, t250, t253, t257;
  double t260, t264, t268, t269, t271, tv2rho20, t274, t278;
  double t282, t285, t289, t296, t297, t301, t305, t308;
  double t312, t317, t320, tv2rho21, t325, t330, t334, t337;
  double t341, t342, t347, t351, t354, t360, t361, t364;
  double t366, t367, t369, t373, t376, t379, t380, t381;
  double t382, t383, t385, t386, t390, tv2rho22, t396, t397;
  double t399, t402, t407, t412, t413, t417, tv2rhosigma0, tv2rhosigma1;
  double t422, t424, tv2rhosigma2, t429, tv2rhosigma3, tv2rhosigma4, t433, t435;
  double t438, t443, t448, t449, t453, tv2rhosigma5, t455, t457;
  double t460, t464, t468, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24;
  double t469, t471, t474, t478, t482, tv2sigma25;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = 0.1e1 / params->p;
  t34 = M_CBRT6;
  t35 = params->C2 * t32 * t34;
  t36 = M_PI * M_PI;
  t37 = POW_1_3(t36);
  t38 = t37 * t37;
  t39 = 0.1e1 / t38;
  t41 = rho[0] * rho[0];
  t42 = POW_1_3(rho[0]);
  t43 = t42 * t42;
  t45 = 0.1e1 / t43 / t41;
  t49 = 0.1e1 + t35 * t39 * sigma[0] * t45 / 0.24e2;
  t50 = pow(t49, -params->p);
  t51 = t31 * t50;
  t52 = t6 * t51;
  t54 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t52);
  t55 = rho[1] <= p->dens_threshold;
  t56 = -t17;
  t58 = my_piecewise5(t15, t12, t11, t16, t56 * t8);
  t59 = 0.1e1 + t58;
  t60 = t59 <= p->zeta_threshold;
  t61 = POW_1_3(t59);
  t62 = t61 * t61;
  t64 = my_piecewise3(t60, t24, t62 * t59);
  t65 = t64 * t30;
  t67 = rho[1] * rho[1];
  t68 = POW_1_3(rho[1]);
  t69 = t68 * t68;
  t71 = 0.1e1 / t69 / t67;
  t75 = 0.1e1 + t35 * t39 * sigma[2] * t71 / 0.24e2;
  t76 = pow(t75, -params->p);
  t77 = t65 * t76;
  t78 = t6 * t77;
  t80 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t78);
  tzk0 = t54 + t80;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t7 * t7;
  t82 = 0.1e1 / t81;
  t83 = t17 * t82;
  t85 = my_piecewise5(t11, 0, t15, 0, t8 - t83);
  t88 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t85);
  t89 = t88 * t30;
  t90 = t89 * t50;
  t91 = t6 * t90;
  t93 = 0.1e1 / t29;
  t94 = t28 * t93;
  t95 = t94 * t50;
  t96 = t6 * t95;
  t97 = t96 / 0.1e2;
  t98 = params->C2 * t34;
  t99 = t98 * t39;
  t100 = t41 * rho[0];
  t102 = 0.1e1 / t43 / t100;
  t104 = 0.1e1 / t49;
  t106 = t99 * sigma[0] * t102 * t104;
  t110 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t91 + t97 + t52 * t106 / 0.6e2);
  t111 = t56 * t82;
  t113 = my_piecewise5(t15, 0, t11, 0, -t8 - t111);
  t116 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t113);
  t117 = t116 * t30;
  t118 = t117 * t76;
  t119 = t6 * t118;
  t121 = t64 * t93;
  t122 = t121 * t76;
  t123 = t6 * t122;
  t124 = t123 / 0.1e2;
  t126 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t119 + t124);
  tvrho0 = t54 + t80 + t7 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t11, 0, t15, 0, -t8 - t83);
  t133 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t130);
  t134 = t133 * t30;
  t135 = t134 * t50;
  t136 = t6 * t135;
  t139 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t136 + t97);
  t141 = my_piecewise5(t15, 0, t11, 0, t8 - t111);
  t144 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t141);
  t145 = t144 * t30;
  t146 = t145 * t76;
  t147 = t6 * t146;
  t149 = t67 * rho[1];
  t151 = 0.1e1 / t69 / t149;
  t153 = 0.1e1 / t75;
  t155 = t99 * sigma[2] * t151 * t153;
  t159 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t147 + t124 + t78 * t155 / 0.6e2);
  tvrho1 = t54 + t80 + t7 * (t139 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t164 = t98 * t39 * t45 * t104;
  t167 = my_piecewise3(t1, 0, -t52 * t164 / 0.16e3);
  tvsigma0 = t7 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t98 * t39 * t71 * t153;
  t173 = my_piecewise3(t55, 0, -t78 * t170 / 0.16e3);
  tvsigma2 = t7 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t25;
  t177 = t85 * t85;
  t180 = t81 * t7;
  t181 = 0.1e1 / t180;
  t182 = t17 * t181;
  t185 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t82 + 0.2e1 * t182);
  t189 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t177 + 0.5e1 / 0.3e1 * t26 * t185);
  t192 = t6 * t189 * t30 * t50;
  t196 = t6 * t88 * t93 * t50;
  t201 = 0.1e1 / t29 / t7;
  t204 = t6 * t28 * t201 * t50;
  t205 = t204 / 0.3e2;
  t206 = t96 * t106;
  t208 = params->C2 * params->C2;
  t209 = t34 * t34;
  t210 = t208 * t209;
  t212 = 0.1e1 / t37 / t36;
  t213 = t210 * t212;
  t214 = sigma[0] * sigma[0];
  t215 = t41 * t41;
  t218 = 0.1e1 / t42 / t215 / t100;
  t220 = t49 * t49;
  t221 = 0.1e1 / t220;
  t223 = t213 * t214 * t218 * t221;
  t227 = 0.1e1 / t43 / t215;
  t230 = t99 * sigma[0] * t227 * t104;
  t233 = t6 * t28;
  t234 = t30 * t50;
  t235 = t234 * t208;
  t236 = t233 * t235;
  t237 = t209 * t212;
  t238 = t237 * t214;
  t240 = t218 * t221 * t32;
  t241 = t238 * t240;
  t245 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t192 + t196 / 0.5e1 + t91 * t106 / 0.3e2 - t205 + t206 / 0.45e2 + t52 * t223 / 0.54e3 - 0.11e2 / 0.18e3 * t52 * t230 + t236 * t241 / 0.54e3);
  t246 = 0.1e1 / t61;
  t247 = t113 * t113;
  t250 = t56 * t181;
  t253 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t82 + 0.2e1 * t250);
  t257 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t247 + 0.5e1 / 0.3e1 * t62 * t253);
  t260 = t6 * t257 * t30 * t76;
  t264 = t6 * t116 * t93 * t76;
  t268 = t6 * t64 * t201 * t76;
  t269 = t268 / 0.3e2;
  t271 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t260 + t264 / 0.5e1 - t269);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t7 * (t245 + t271);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t274 = t176 * t130;
  t278 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t182);
  t282 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t274 * t85 + 0.5e1 / 0.3e1 * t26 * t278);
  t285 = t6 * t282 * t30 * t50;
  t289 = t6 * t133 * t93 * t50;
  t296 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t285 + t289 / 0.1e2 + t136 * t106 / 0.6e2 + t196 / 0.1e2 - t205 + t206 / 0.9e2);
  t297 = t246 * t141;
  t301 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t250);
  t305 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t297 * t113 + 0.5e1 / 0.3e1 * t62 * t301);
  t308 = t6 * t305 * t30 * t76;
  t312 = t6 * t144 * t93 * t76;
  t317 = t123 * t155;
  t320 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t308 + t312 / 0.1e2 + t264 / 0.1e2 - t269 + t119 * t155 / 0.6e2 + t317 / 0.9e2);
  tv2rho21 = t110 + t126 + t139 + t159 + t7 * (t296 + t320);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t325 = t130 * t130;
  t330 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t82 + 0.2e1 * t182);
  t334 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t325 + 0.5e1 / 0.3e1 * t26 * t330);
  t337 = t6 * t334 * t30 * t50;
  t341 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t337 + t289 / 0.5e1 - t205);
  t342 = t141 * t141;
  t347 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t82 + 0.2e1 * t250);
  t351 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t342 + 0.5e1 / 0.3e1 * t62 * t347);
  t354 = t6 * t351 * t30 * t76;
  t360 = sigma[2] * sigma[2];
  t361 = t67 * t67;
  t364 = 0.1e1 / t68 / t361 / t149;
  t366 = t75 * t75;
  t367 = 0.1e1 / t366;
  t369 = t213 * t360 * t364 * t367;
  t373 = 0.1e1 / t69 / t361;
  t376 = t99 * sigma[2] * t373 * t153;
  t379 = t6 * t64;
  t380 = t30 * t76;
  t381 = t380 * t208;
  t382 = t379 * t381;
  t383 = t237 * t360;
  t385 = t364 * t367 * t32;
  t386 = t383 * t385;
  t390 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t354 + t312 / 0.5e1 + t147 * t155 / 0.3e2 - t269 + t317 / 0.45e2 + t78 * t369 / 0.54e3 - 0.11e2 / 0.18e3 * t78 * t376 + t382 * t386 / 0.54e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t159 + t7 * (t341 + t390);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t396 = t96 * t164 / 0.24e3;
  t397 = t215 * t41;
  t399 = 0.1e1 / t42 / t397;
  t402 = t213 * sigma[0] * t399 * t221;
  t407 = t98 * t39 * t102 * t104;
  t412 = t221 * t32 * sigma[0];
  t413 = t237 * t399 * t412;
  t417 = my_piecewise3(t1, 0, -t91 * t164 / 0.16e3 - t396 - t52 * t402 / 0.144e4 + t52 * t407 / 0.6e2 - t236 * t413 / 0.144e4);
  tv2rhosigma0 = t7 * t417 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t422 = t123 * t170 / 0.24e3;
  t424 = my_piecewise3(t55, 0, -t119 * t170 / 0.16e3 - t422);
  tv2rhosigma2 = t7 * t424 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t429 = my_piecewise3(t1, 0, -t136 * t164 / 0.16e3 - t396);
  tv2rhosigma3 = t7 * t429 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t433 = t361 * t67;
  t435 = 0.1e1 / t68 / t433;
  t438 = t213 * sigma[2] * t435 * t367;
  t443 = t98 * t39 * t151 * t153;
  t448 = t367 * t32 * sigma[2];
  t449 = t237 * t435 * t448;
  t453 = my_piecewise3(t55, 0, -t147 * t170 / 0.16e3 - t422 - t78 * t438 / 0.144e4 + t78 * t443 / 0.6e2 - t382 * t449 / 0.144e4);
  tv2rhosigma5 = t7 * t453 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t455 = t215 * rho[0];
  t457 = 0.1e1 / t42 / t455;
  t460 = t210 * t212 * t457 * t221;
  t464 = t213 * t457 * t221 * t32;
  t468 = my_piecewise3(t1, 0, t52 * t460 / 0.384e4 + t52 * t464 / 0.384e4);
  tv2sigma20 = t7 * t468;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t469 = t361 * rho[1];
  t471 = 0.1e1 / t68 / t469;
  t474 = t210 * t212 * t471 * t367;
  t478 = t213 * t471 * t367 * t32;
  t482 = my_piecewise3(t55, 0, t78 * t474 / 0.384e4 + t78 * t478 / 0.384e4);
  tv2sigma25 = t7 * t482;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t38, t39, t41;
  double t42, t43, t45, t49, t50, t51, t52, t54;
  double t55, t56, t58, t59, t60, t61, t62, t64;
  double t65, t67, t68, t69, t71, t75, t76, t77;
  double t78, t80, tzk0;

  double t81, t82, t83, t85, t88, t89, t90, t91;
  double t93, t94, t95, t96, t97, t98, t99, t100;
  double t102, t104, t106, t110, t111, t113, t116, t117;
  double t118, t119, t121, t122, t123, t124, t126, tvrho0;
  double t130, t133, t134, t135, t136, t139, t141, t144;
  double t145, t146, t147, t149, t151, t153, t155, t159;
  double tvrho1, t164, t167, tvsigma0, tvsigma1, t170, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t192;
  double t196, t201, t204, t205, t206, t208, t209, t210;
  double t212, t213, t214, t215, t218, t220, t221, t223;
  double t227, t230, t233, t234, t235, t236, t237, t238;
  double t240, t241, t245, t246, t247, t250, t253, t257;
  double t260, t264, t268, t269, t271, tv2rho20, t274, t278;
  double t282, t285, t289, t296, t297, t301, t305, t308;
  double t312, t317, t320, tv2rho21, t325, t330, t334, t337;
  double t341, t342, t347, t351, t354, t360, t361, t364;
  double t366, t367, t369, t373, t376, t379, t380, t381;
  double t382, t383, t385, t386, t390, tv2rho22, t396, t397;
  double t399, t402, t407, t412, t413, t417, tv2rhosigma0, tv2rhosigma1;
  double t422, t424, tv2rhosigma2, t429, tv2rhosigma3, tv2rhosigma4, t433, t435;
  double t438, t443, t448, t449, t453, tv2rhosigma5, t455, t457;
  double t460, t464, t468, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24;
  double t469, t471, t474, t478, t482, tv2sigma25;

  double t486, t487, t488, t490, t492, t495, t499, t502;
  double t507, t512, t513, t516, t519, t520, t523, t526;
  double t527, t528, t531, t535, t538, t540, t544, t548;
  double t552, t556, t559, t562, t563, t564, t567, t568;
  double t569, t570, t571, t572, t573, t575, t576, t577;
  double t578, t581, t582, t584, t587, t588, t591, t594;
  double t595, t597, t598, t601, t604, t607, t611, t614;
  double t618, t622, t626, t627, t629, tv3rho30, t632, t633;
  double t634, t637, t642, t643, t645, t649, t652, t656;
  double t657, t662, t665, t670, t671, t681, t682, t683;
  double t686, t691, t693, t697, t700, t704, t705, t708;
  double t715, t716, t719, tv3rho31, t722, t727, t731, t735;
  double t738, t742, t750, t751, t756, t760, t764, t767;
  double t771, t776, t782, t786, t788, t789, t793, t794;
  double t795, t797, t798, tv3rho32, t803, t810, t814, t817;
  double t822, t824, t826, t829, t834, t838, t841, t846;
  double t847, t854, t861, t865, t868, t876, t877, t878;
  double t879, t880, t882, t883, t884, t885, t889, t892;
  double t893, t896, t899, t900, tv3rho33, t906, t910, t915;
  double t919, t922, t929, t930, t932, t936, t937, t938;
  double t941, t944, t945, t946, t947, t952, t955, t956;
  double tv3rho2sigma0, tv3rho2sigma1, t961, t964, t966, tv3rho2sigma2, t970, t983;
  double tv3rho2sigma3, tv3rho2sigma4, t987, t992, t996, t1000, t1003, tv3rho2sigma5;
  double t1010, tv3rho2sigma6, tv3rho2sigma7, t1016, t1020, t1028, t1039, t1040;
  double t1041, t1044, t1047, t1048, t1049, t1050, t1055, t1058;
  double t1059, tv3rho2sigma8, t1064, t1065, t1066, t1069, t1074, t1077;
  double t1079, t1080, t1086, t1089, t1092, t1093, t1097, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1102, t1106, t1108, tv3rhosigma25;
  double t1115, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1119, t1120;
  double t1123, t1128, t1131, t1133, t1134, t1141, t1144, t1145;
  double t1149, tv3rhosigma211, t1152, t1153, t1157, t1161, t1165, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t1167, t1168, t1172, t1176, t1180, tv3sigma39;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = 0.1e1 / params->p;
  t34 = M_CBRT6;
  t35 = params->C2 * t32 * t34;
  t36 = M_PI * M_PI;
  t37 = POW_1_3(t36);
  t38 = t37 * t37;
  t39 = 0.1e1 / t38;
  t41 = rho[0] * rho[0];
  t42 = POW_1_3(rho[0]);
  t43 = t42 * t42;
  t45 = 0.1e1 / t43 / t41;
  t49 = 0.1e1 + t35 * t39 * sigma[0] * t45 / 0.24e2;
  t50 = pow(t49, -params->p);
  t51 = t31 * t50;
  t52 = t6 * t51;
  t54 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t52);
  t55 = rho[1] <= p->dens_threshold;
  t56 = -t17;
  t58 = my_piecewise5(t15, t12, t11, t16, t56 * t8);
  t59 = 0.1e1 + t58;
  t60 = t59 <= p->zeta_threshold;
  t61 = POW_1_3(t59);
  t62 = t61 * t61;
  t64 = my_piecewise3(t60, t24, t62 * t59);
  t65 = t64 * t30;
  t67 = rho[1] * rho[1];
  t68 = POW_1_3(rho[1]);
  t69 = t68 * t68;
  t71 = 0.1e1 / t69 / t67;
  t75 = 0.1e1 + t35 * t39 * sigma[2] * t71 / 0.24e2;
  t76 = pow(t75, -params->p);
  t77 = t65 * t76;
  t78 = t6 * t77;
  t80 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t78);
  tzk0 = t54 + t80;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t7 * t7;
  t82 = 0.1e1 / t81;
  t83 = t17 * t82;
  t85 = my_piecewise5(t11, 0, t15, 0, t8 - t83);
  t88 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t85);
  t89 = t88 * t30;
  t90 = t89 * t50;
  t91 = t6 * t90;
  t93 = 0.1e1 / t29;
  t94 = t28 * t93;
  t95 = t94 * t50;
  t96 = t6 * t95;
  t97 = t96 / 0.1e2;
  t98 = params->C2 * t34;
  t99 = t98 * t39;
  t100 = t41 * rho[0];
  t102 = 0.1e1 / t43 / t100;
  t104 = 0.1e1 / t49;
  t106 = t99 * sigma[0] * t102 * t104;
  t110 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t91 + t97 + t52 * t106 / 0.6e2);
  t111 = t56 * t82;
  t113 = my_piecewise5(t15, 0, t11, 0, -t8 - t111);
  t116 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t113);
  t117 = t116 * t30;
  t118 = t117 * t76;
  t119 = t6 * t118;
  t121 = t64 * t93;
  t122 = t121 * t76;
  t123 = t6 * t122;
  t124 = t123 / 0.1e2;
  t126 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t119 + t124);
  tvrho0 = t54 + t80 + t7 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t11, 0, t15, 0, -t8 - t83);
  t133 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t130);
  t134 = t133 * t30;
  t135 = t134 * t50;
  t136 = t6 * t135;
  t139 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t136 + t97);
  t141 = my_piecewise5(t15, 0, t11, 0, t8 - t111);
  t144 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t141);
  t145 = t144 * t30;
  t146 = t145 * t76;
  t147 = t6 * t146;
  t149 = t67 * rho[1];
  t151 = 0.1e1 / t69 / t149;
  t153 = 0.1e1 / t75;
  t155 = t99 * sigma[2] * t151 * t153;
  t159 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t147 + t124 + t78 * t155 / 0.6e2);
  tvrho1 = t54 + t80 + t7 * (t139 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t164 = t98 * t39 * t45 * t104;
  t167 = my_piecewise3(t1, 0, -t52 * t164 / 0.16e3);
  tvsigma0 = t7 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t98 * t39 * t71 * t153;
  t173 = my_piecewise3(t55, 0, -t78 * t170 / 0.16e3);
  tvsigma2 = t7 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t25;
  t177 = t85 * t85;
  t180 = t81 * t7;
  t181 = 0.1e1 / t180;
  t182 = t17 * t181;
  t185 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t82 + 0.2e1 * t182);
  t189 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t177 + 0.5e1 / 0.3e1 * t26 * t185);
  t192 = t6 * t189 * t30 * t50;
  t196 = t6 * t88 * t93 * t50;
  t201 = 0.1e1 / t29 / t7;
  t204 = t6 * t28 * t201 * t50;
  t205 = t204 / 0.3e2;
  t206 = t96 * t106;
  t208 = params->C2 * params->C2;
  t209 = t34 * t34;
  t210 = t208 * t209;
  t212 = 0.1e1 / t37 / t36;
  t213 = t210 * t212;
  t214 = sigma[0] * sigma[0];
  t215 = t41 * t41;
  t218 = 0.1e1 / t42 / t215 / t100;
  t220 = t49 * t49;
  t221 = 0.1e1 / t220;
  t223 = t213 * t214 * t218 * t221;
  t227 = 0.1e1 / t43 / t215;
  t230 = t99 * sigma[0] * t227 * t104;
  t233 = t6 * t28;
  t234 = t30 * t50;
  t235 = t234 * t208;
  t236 = t233 * t235;
  t237 = t209 * t212;
  t238 = t237 * t214;
  t240 = t218 * t221 * t32;
  t241 = t238 * t240;
  t245 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t192 + t196 / 0.5e1 + t91 * t106 / 0.3e2 - t205 + t206 / 0.45e2 + t52 * t223 / 0.54e3 - 0.11e2 / 0.18e3 * t52 * t230 + t236 * t241 / 0.54e3);
  t246 = 0.1e1 / t61;
  t247 = t113 * t113;
  t250 = t56 * t181;
  t253 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t82 + 0.2e1 * t250);
  t257 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t247 + 0.5e1 / 0.3e1 * t62 * t253);
  t260 = t6 * t257 * t30 * t76;
  t264 = t6 * t116 * t93 * t76;
  t268 = t6 * t64 * t201 * t76;
  t269 = t268 / 0.3e2;
  t271 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t260 + t264 / 0.5e1 - t269);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t7 * (t245 + t271);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t274 = t176 * t130;
  t278 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t182);
  t282 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t274 * t85 + 0.5e1 / 0.3e1 * t26 * t278);
  t285 = t6 * t282 * t30 * t50;
  t289 = t6 * t133 * t93 * t50;
  t296 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t285 + t289 / 0.1e2 + t136 * t106 / 0.6e2 + t196 / 0.1e2 - t205 + t206 / 0.9e2);
  t297 = t246 * t141;
  t301 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t250);
  t305 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t297 * t113 + 0.5e1 / 0.3e1 * t62 * t301);
  t308 = t6 * t305 * t30 * t76;
  t312 = t6 * t144 * t93 * t76;
  t317 = t123 * t155;
  t320 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t308 + t312 / 0.1e2 + t264 / 0.1e2 - t269 + t119 * t155 / 0.6e2 + t317 / 0.9e2);
  tv2rho21 = t110 + t126 + t139 + t159 + t7 * (t296 + t320);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t325 = t130 * t130;
  t330 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t82 + 0.2e1 * t182);
  t334 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t325 + 0.5e1 / 0.3e1 * t26 * t330);
  t337 = t6 * t334 * t30 * t50;
  t341 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t337 + t289 / 0.5e1 - t205);
  t342 = t141 * t141;
  t347 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t82 + 0.2e1 * t250);
  t351 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t342 + 0.5e1 / 0.3e1 * t62 * t347);
  t354 = t6 * t351 * t30 * t76;
  t360 = sigma[2] * sigma[2];
  t361 = t67 * t67;
  t364 = 0.1e1 / t68 / t361 / t149;
  t366 = t75 * t75;
  t367 = 0.1e1 / t366;
  t369 = t213 * t360 * t364 * t367;
  t373 = 0.1e1 / t69 / t361;
  t376 = t99 * sigma[2] * t373 * t153;
  t379 = t6 * t64;
  t380 = t30 * t76;
  t381 = t380 * t208;
  t382 = t379 * t381;
  t383 = t237 * t360;
  t385 = t364 * t367 * t32;
  t386 = t383 * t385;
  t390 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t354 + t312 / 0.5e1 + t147 * t155 / 0.3e2 - t269 + t317 / 0.45e2 + t78 * t369 / 0.54e3 - 0.11e2 / 0.18e3 * t78 * t376 + t382 * t386 / 0.54e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t159 + t7 * (t341 + t390);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t396 = t96 * t164 / 0.24e3;
  t397 = t215 * t41;
  t399 = 0.1e1 / t42 / t397;
  t402 = t213 * sigma[0] * t399 * t221;
  t407 = t98 * t39 * t102 * t104;
  t412 = t221 * t32 * sigma[0];
  t413 = t237 * t399 * t412;
  t417 = my_piecewise3(t1, 0, -t91 * t164 / 0.16e3 - t396 - t52 * t402 / 0.144e4 + t52 * t407 / 0.6e2 - t236 * t413 / 0.144e4);
  tv2rhosigma0 = t7 * t417 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t422 = t123 * t170 / 0.24e3;
  t424 = my_piecewise3(t55, 0, -t119 * t170 / 0.16e3 - t422);
  tv2rhosigma2 = t7 * t424 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t429 = my_piecewise3(t1, 0, -t136 * t164 / 0.16e3 - t396);
  tv2rhosigma3 = t7 * t429 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t433 = t361 * t67;
  t435 = 0.1e1 / t68 / t433;
  t438 = t213 * sigma[2] * t435 * t367;
  t443 = t98 * t39 * t151 * t153;
  t448 = t367 * t32 * sigma[2];
  t449 = t237 * t435 * t448;
  t453 = my_piecewise3(t55, 0, -t147 * t170 / 0.16e3 - t422 - t78 * t438 / 0.144e4 + t78 * t443 / 0.6e2 - t382 * t449 / 0.144e4);
  tv2rhosigma5 = t7 * t453 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t455 = t215 * rho[0];
  t457 = 0.1e1 / t42 / t455;
  t460 = t210 * t212 * t457 * t221;
  t464 = t213 * t457 * t221 * t32;
  t468 = my_piecewise3(t1, 0, t52 * t460 / 0.384e4 + t52 * t464 / 0.384e4);
  tv2sigma20 = t7 * t468;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t469 = t361 * rho[1];
  t471 = 0.1e1 / t68 / t469;
  t474 = t210 * t212 * t471 * t367;
  t478 = t213 * t471 * t367 * t32;
  t482 = my_piecewise3(t55, 0, t78 * t474 / 0.384e4 + t78 * t478 / 0.384e4);
  tv2sigma25 = t7 * t482;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t486 = t93 * t50 * t208;
  t487 = t233 * t486;
  t488 = t487 * t241;
  t490 = t215 * t215;
  t492 = 0.1e1 / t42 / t490;
  t495 = t213 * t214 * t492 * t221;
  t499 = 0.1e1 / t43 / t455;
  t502 = t99 * sigma[0] * t499 * t104;
  t507 = t238 * t492 * t221 * t32;
  t512 = t6 * t88;
  t513 = t512 * t235;
  t516 = t96 * t230;
  t519 = 0.1e1 / t25 / t20;
  t520 = t177 * t85;
  t523 = t176 * t85;
  t526 = t81 * t81;
  t527 = 0.1e1 / t526;
  t528 = t17 * t527;
  t531 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t181 - 0.6e1 * t528);
  t535 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t519 * t520 + 0.1e2 / 0.3e1 * t523 * t185 + 0.5e1 / 0.3e1 * t26 * t531);
  t538 = t6 * t535 * t30 * t50;
  t540 = t96 * t223;
  t544 = t196 * t106;
  t548 = t204 * t106;
  t552 = t6 * t189 * t93 * t50;
  t556 = t6 * t88 * t201 * t50;
  t559 = 0.1e1 / t29 / t81;
  t562 = t6 * t28 * t559 * t50;
  t563 = 0.2e1 / 0.45e2 * t562;
  t564 = t4 * t4;
  t567 = t3 / t564 / t36;
  t568 = t567 * t51;
  t569 = t208 * params->C2;
  t570 = t214 * sigma[0];
  t571 = t569 * t570;
  t572 = t490 * t100;
  t573 = 0.1e1 / t572;
  t575 = 0.1e1 / t220 / t49;
  t576 = t573 * t575;
  t577 = t576 * t32;
  t578 = t571 * t577;
  t581 = params->p * params->p;
  t582 = 0.1e1 / t581;
  t584 = t571 * t576 * t582;
  t587 = t567 * t31;
  t588 = t50 * t569;
  t591 = t588 * t570 * t573 * t575;
  t594 = t488 / 0.27e3 - 0.11e2 / 0.54e3 * t52 * t495 + 0.77e2 / 0.27e3 * t52 * t502 - 0.11e2 / 0.54e3 * t236 * t507 - 0.11e2 / 0.6e2 * t91 * t230 + t513 * t241 / 0.18e3 - 0.11e2 / 0.9e2 * t516 + 0.3e1 / 0.2e2 * t538 + t540 / 0.27e3 + t192 * t106 / 0.2e2 + t544 / 0.15e2 + t91 * t223 / 0.18e3 - t548 / 0.9e2 + 0.3e1 / 0.1e2 * t552 - t556 / 0.1e2 + t563 + t568 * t578 / 0.27e3 + t568 * t584 / 0.405e3 + t587 * t591 / 0.81e3;
  t595 = my_piecewise3(t1, 0, t594);
  t597 = 0.1e1 / t61 / t59;
  t598 = t247 * t113;
  t601 = t246 * t113;
  t604 = t56 * t527;
  t607 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t181 - 0.6e1 * t604);
  t611 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t597 * t598 + 0.1e2 / 0.3e1 * t601 * t253 + 0.5e1 / 0.3e1 * t62 * t607);
  t614 = t6 * t611 * t30 * t76;
  t618 = t6 * t257 * t93 * t76;
  t622 = t6 * t116 * t201 * t76;
  t626 = t6 * t64 * t559 * t76;
  t627 = 0.2e1 / 0.45e2 * t626;
  t629 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t614 + 0.3e1 / 0.1e2 * t618 - t622 / 0.1e2 + t627);
  tv3rho30 = 0.3e1 * t245 + 0.3e1 * t271 + t7 * (t595 + t629);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t632 = 0.2e1 * t296;
  t633 = 0.2e1 * t320;
  t634 = t519 * t130;
  t637 = t176 * t278;
  t642 = 0.2e1 * t181;
  t643 = 0.6e1 * t528;
  t645 = my_piecewise5(t11, 0, t15, 0, t642 - t643);
  t649 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t634 * t177 + 0.2e2 / 0.9e1 * t637 * t85 + 0.1e2 / 0.9e1 * t274 * t185 + 0.5e1 / 0.3e1 * t26 * t645);
  t652 = t6 * t649 * t30 * t50;
  t656 = t6 * t282 * t93 * t50;
  t657 = t656 / 0.5e1;
  t662 = t6 * t133 * t201 * t50;
  t665 = t289 * t106 / 0.45e2;
  t670 = t6 * t133;
  t671 = t670 * t235;
  t681 = 0.3e1 / 0.2e2 * t652 + t657 + t285 * t106 / 0.3e2 - t662 / 0.3e2 + t665 + t136 * t223 / 0.54e3 - 0.11e2 / 0.18e3 * t136 * t230 + t671 * t241 / 0.54e3 + t552 / 0.1e2 - t556 / 0.15e2 + t544 / 0.45e2 + t563 - t548 / 0.135e3 + t540 / 0.81e3 - 0.11e2 / 0.27e3 * t516 + t488 / 0.81e3;
  t682 = my_piecewise3(t1, 0, t681);
  t683 = t597 * t141;
  t686 = t246 * t301;
  t691 = 0.6e1 * t604;
  t693 = my_piecewise5(t15, 0, t11, 0, -t642 - t691);
  t697 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t683 * t247 + 0.2e2 / 0.9e1 * t686 * t113 + 0.1e2 / 0.9e1 * t297 * t253 + 0.5e1 / 0.3e1 * t62 * t693);
  t700 = t6 * t697 * t30 * t76;
  t704 = t6 * t305 * t93 * t76;
  t705 = t704 / 0.5e1;
  t708 = t6 * t144 * t201 * t76;
  t715 = t264 * t155 / 0.45e2;
  t716 = t268 * t155;
  t719 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t700 + t705 - t708 / 0.3e2 + t618 / 0.1e2 - t622 / 0.15e2 + t627 + t260 * t155 / 0.6e2 + t715 - t716 / 0.27e3);
  tv3rho31 = t245 + t271 + t632 + t633 + t7 * (t682 + t719);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t722 = t519 * t325;
  t727 = t176 * t330;
  t731 = my_piecewise5(t11, 0, t15, 0, -t642 - t643);
  t735 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t722 * t85 + 0.2e2 / 0.9e1 * t274 * t278 + 0.1e2 / 0.9e1 * t727 * t85 + 0.5e1 / 0.3e1 * t26 * t731);
  t738 = t6 * t735 * t30 * t50;
  t742 = t6 * t334 * t93 * t50;
  t750 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t738 + t742 / 0.1e2 + t337 * t106 / 0.6e2 + t657 - t662 / 0.15e2 + t665 - t556 / 0.3e2 + t563 - t548 / 0.27e3);
  t751 = t597 * t342;
  t756 = t246 * t347;
  t760 = my_piecewise5(t15, 0, t11, 0, t642 - t691);
  t764 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t751 * t113 + 0.2e2 / 0.9e1 * t297 * t301 + 0.1e2 / 0.9e1 * t756 * t113 + 0.5e1 / 0.3e1 * t62 * t760);
  t767 = t6 * t764 * t30 * t76;
  t771 = t6 * t351 * t93 * t76;
  t776 = t312 * t155;
  t782 = t123 * t369;
  t786 = t123 * t376;
  t788 = t6 * t116;
  t789 = t788 * t381;
  t793 = t93 * t76 * t208;
  t794 = t379 * t793;
  t795 = t794 * t386;
  t797 = 0.3e1 / 0.2e2 * t767 + t771 / 0.1e2 + t705 - t708 / 0.15e2 + t308 * t155 / 0.3e2 + t776 / 0.45e2 - t622 / 0.3e2 + t627 + t715 - t716 / 0.135e3 + t119 * t369 / 0.54e3 + t782 / 0.81e3 - 0.11e2 / 0.18e3 * t119 * t376 - 0.11e2 / 0.27e3 * t786 + t789 * t386 / 0.54e3 + t795 / 0.81e3;
  t798 = my_piecewise3(t55, 0, t797);
  tv3rho32 = t632 + t633 + t341 + t390 + t7 * (t750 + t798);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t803 = t325 * t130;
  t810 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t181 - 0.6e1 * t528);
  t814 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t519 * t803 + 0.1e2 / 0.3e1 * t274 * t330 + 0.5e1 / 0.3e1 * t26 * t810);
  t817 = t6 * t814 * t30 * t50;
  t822 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t817 + 0.3e1 / 0.1e2 * t742 - t662 / 0.1e2 + t563);
  t824 = t361 * t361;
  t826 = 0.1e1 / t68 / t824;
  t829 = t383 * t826 * t367 * t32;
  t834 = t213 * t360 * t826 * t367;
  t838 = 0.1e1 / t69 / t469;
  t841 = t99 * sigma[2] * t838 * t153;
  t846 = t6 * t144;
  t847 = t846 * t381;
  t854 = t342 * t141;
  t861 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t181 - 0.6e1 * t604);
  t865 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t597 * t854 + 0.1e2 / 0.3e1 * t297 * t347 + 0.5e1 / 0.3e1 * t62 * t861);
  t868 = t6 * t865 * t30 * t76;
  t876 = t567 * t77;
  t877 = t360 * sigma[2];
  t878 = t569 * t877;
  t879 = t824 * t149;
  t880 = 0.1e1 / t879;
  t882 = 0.1e1 / t366 / t75;
  t883 = t880 * t882;
  t884 = t883 * t32;
  t885 = t878 * t884;
  t889 = t878 * t883 * t582;
  t892 = t567 * t65;
  t893 = t76 * t569;
  t896 = t893 * t877 * t880 * t882;
  t899 = t795 / 0.27e3 - 0.11e2 / 0.54e3 * t382 * t829 - 0.11e2 / 0.54e3 * t78 * t834 + 0.77e2 / 0.27e3 * t78 * t841 - 0.11e2 / 0.6e2 * t147 * t376 + t847 * t386 / 0.18e3 + t782 / 0.27e3 - 0.11e2 / 0.9e2 * t786 - t716 / 0.9e2 + t776 / 0.15e2 + 0.3e1 / 0.2e2 * t868 + t147 * t369 / 0.18e3 + t354 * t155 / 0.2e2 + 0.3e1 / 0.1e2 * t771 + t627 - t708 / 0.1e2 + t876 * t885 / 0.27e3 + t876 * t889 / 0.405e3 + t892 * t896 / 0.81e3;
  t900 = my_piecewise3(t55, 0, t899);
  tv3rho33 = 0.3e1 * t341 + 0.3e1 * t390 + t7 * (t822 + t900);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t906 = t213 * sigma[0] * t218 * t221;
  t910 = t237 * t218 * t412;
  t915 = t487 * t413;
  t919 = t98 * t39 * t227 * t104;
  t922 = t196 * t164;
  t929 = t204 * t164 / 0.72e3;
  t930 = t96 * t407;
  t932 = t96 * t402;
  t936 = t569 * t214;
  t937 = t490 * t41;
  t938 = 0.1e1 / t937;
  t941 = t936 * t938 * t575 * t32;
  t944 = t569 * t938;
  t945 = t575 * t582;
  t946 = t945 * t214;
  t947 = t944 * t946;
  t952 = t588 * t214 * t938 * t575;
  t955 = t52 * t906 / 0.16e3 + t236 * t910 / 0.16e3 - t513 * t413 / 0.72e3 - t915 / 0.108e4 - 0.11e2 / 0.18e3 * t52 * t919 - t922 / 0.12e3 + t91 * t407 / 0.3e2 - t91 * t402 / 0.72e3 + t929 + t930 / 0.45e2 - t932 / 0.108e4 - t192 * t164 / 0.16e3 - t568 * t941 / 0.72e3 - t568 * t947 / 0.108e4 - t587 * t952 / 0.216e4;
  t956 = my_piecewise3(t1, 0, t955);
  tv3rho2sigma0 = t7 * t956 + 0.2e1 * t417;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t961 = t264 * t170;
  t964 = t268 * t170 / 0.72e3;
  t966 = my_piecewise3(t55, 0, -t260 * t170 / 0.16e3 - t961 / 0.12e3 + t964);
  tv3rho2sigma2 = t7 * t966 + 0.2e1 * t424;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t970 = t289 * t164;
  t983 = my_piecewise3(t1, 0, -t285 * t164 / 0.16e3 - t970 / 0.24e3 - t136 * t402 / 0.144e4 + t136 * t407 / 0.6e2 - t671 * t413 / 0.144e4 - t922 / 0.24e3 + t929 - t932 / 0.216e4 + t930 / 0.9e2 - t915 / 0.216e4);
  tv3rho2sigma3 = t7 * t983 + t417 + t429;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t987 = t312 * t170;
  t992 = t123 * t438;
  t996 = t123 * t443;
  t1000 = t794 * t449;
  t1003 = my_piecewise3(t55, 0, -t308 * t170 / 0.16e3 - t987 / 0.24e3 - t961 / 0.24e3 + t964 - t119 * t438 / 0.144e4 - t992 / 0.216e4 + t119 * t443 / 0.6e2 + t996 / 0.9e2 - t789 * t449 / 0.144e4 - t1000 / 0.216e4);
  tv3rho2sigma5 = t7 * t1003 + t424 + t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1010 = my_piecewise3(t1, 0, -t337 * t164 / 0.16e3 - t970 / 0.12e3 + t929);
  tv3rho2sigma6 = t7 * t1010 + 0.2e1 * t429;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1016 = t213 * sigma[2] * t364 * t367;
  t1020 = t237 * t364 * t448;
  t1028 = t98 * t39 * t373 * t153;
  t1039 = t569 * t360;
  t1040 = t824 * t67;
  t1041 = 0.1e1 / t1040;
  t1044 = t1039 * t1041 * t882 * t32;
  t1047 = t569 * t1041;
  t1048 = t882 * t582;
  t1049 = t1048 * t360;
  t1050 = t1047 * t1049;
  t1055 = t893 * t360 * t1041 * t882;
  t1058 = -t1000 / 0.108e4 + t78 * t1016 / 0.16e3 + t382 * t1020 / 0.16e3 - t847 * t449 / 0.72e3 - t992 / 0.108e4 - 0.11e2 / 0.18e3 * t78 * t1028 + t147 * t443 / 0.3e2 - t147 * t438 / 0.72e3 + t996 / 0.45e2 - t987 / 0.12e3 + t964 - t354 * t170 / 0.16e3 - t876 * t1044 / 0.72e3 - t876 * t1050 / 0.108e4 - t892 * t1055 / 0.216e4;
  t1059 = my_piecewise3(t55, 0, t1058);
  tv3rho2sigma8 = t7 * t1059 + 0.2e1 * t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1064 = t96 * t460 / 0.576e4;
  t1065 = t490 * rho[0];
  t1066 = 0.1e1 / t1065;
  t1069 = t588 * sigma[0] * t1066 * t575;
  t1074 = t210 * t212 * t399 * t221;
  t1077 = t569 * t1066;
  t1079 = t575 * t32 * sigma[0];
  t1080 = t1077 * t1079;
  t1086 = t96 * t464 / 0.576e4;
  t1089 = t213 * t399 * t221 * t32;
  t1092 = t945 * sigma[0];
  t1093 = t1077 * t1092;
  t1097 = my_piecewise3(t1, 0, t91 * t460 / 0.384e4 + t1064 + t587 * t1069 / 0.576e4 - t52 * t1074 / 0.72e3 + t568 * t1080 / 0.192e4 + t91 * t464 / 0.384e4 + t1086 - t52 * t1089 / 0.72e3 + t568 * t1093 / 0.288e4);
  tv3rhosigma20 = t7 * t1097 + t468;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1102 = t123 * t474 / 0.576e4;
  t1106 = t123 * t478 / 0.576e4;
  t1108 = my_piecewise3(t55, 0, t119 * t474 / 0.384e4 + t1102 + t119 * t478 / 0.384e4 + t1106);
  tv3rhosigma25 = t7 * t1108 + t482;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1115 = my_piecewise3(t1, 0, t136 * t460 / 0.384e4 + t1064 + t136 * t464 / 0.384e4 + t1086);
  tv3rhosigma26 = t7 * t1115 + t468;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1119 = t824 * rho[1];
  t1120 = 0.1e1 / t1119;
  t1123 = t893 * sigma[2] * t1120 * t882;
  t1128 = t210 * t212 * t435 * t367;
  t1131 = t569 * t1120;
  t1133 = t882 * t32 * sigma[2];
  t1134 = t1131 * t1133;
  t1141 = t213 * t435 * t367 * t32;
  t1144 = t1048 * sigma[2];
  t1145 = t1131 * t1144;
  t1149 = my_piecewise3(t55, 0, t147 * t474 / 0.384e4 + t1102 + t892 * t1123 / 0.576e4 - t78 * t1128 / 0.72e3 + t876 * t1134 / 0.192e4 + t147 * t478 / 0.384e4 + t1106 - t78 * t1141 / 0.72e3 + t876 * t1145 / 0.288e4);
  tv3rhosigma211 = t7 * t1149 + t482;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1152 = 0.1e1 / t490 * t575;
  t1153 = t588 * t1152;
  t1157 = t588 * t1152 * t32;
  t1161 = t588 * t1152 * t582;
  t1165 = my_piecewise3(t1, 0, -t587 * t1153 / 0.1536e5 - t587 * t1157 / 0.512e4 - t587 * t1161 / 0.768e4);
  tv3sigma30 = t7 * t1165;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1167 = 0.1e1 / t824 * t882;
  t1168 = t893 * t1167;
  t1172 = t893 * t1167 * t32;
  t1176 = t893 * t1167 * t582;
  t1180 = my_piecewise3(t55, 0, -t892 * t1168 / 0.1536e5 - t892 * t1172 / 0.512e4 - t892 * t1176 / 0.768e4);
  tv3sigma39 = t7 * t1180;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t6, t7, t8, t11;
  double t12, t15, t16, t17, t19, t20, t21, t22;
  double t23, t24, t25, t26, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t38, t39, t41;
  double t42, t43, t45, t49, t50, t51, t52, t54;
  double t55, t56, t58, t59, t60, t61, t62, t64;
  double t65, t67, t68, t69, t71, t75, t76, t77;
  double t78, t80, tzk0;

  double t81, t82, t83, t85, t88, t89, t90, t91;
  double t93, t94, t95, t96, t97, t98, t99, t100;
  double t102, t104, t106, t110, t111, t113, t116, t117;
  double t118, t119, t121, t122, t123, t124, t126, tvrho0;
  double t130, t133, t134, t135, t136, t139, t141, t144;
  double t145, t146, t147, t149, t151, t153, t155, t159;
  double tvrho1, t164, t167, tvsigma0, tvsigma1, t170, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t192;
  double t196, t201, t204, t205, t206, t208, t209, t210;
  double t212, t213, t214, t215, t218, t220, t221, t223;
  double t227, t230, t233, t234, t235, t236, t237, t238;
  double t240, t241, t245, t246, t247, t250, t253, t257;
  double t260, t264, t268, t269, t271, tv2rho20, t274, t278;
  double t282, t285, t289, t296, t297, t301, t305, t308;
  double t312, t317, t320, tv2rho21, t325, t330, t334, t337;
  double t341, t342, t347, t351, t354, t360, t361, t364;
  double t366, t367, t369, t373, t376, t379, t380, t381;
  double t382, t383, t385, t386, t390, tv2rho22, t396, t397;
  double t399, t402, t407, t412, t413, t417, tv2rhosigma0, tv2rhosigma1;
  double t422, t424, tv2rhosigma2, t429, tv2rhosigma3, tv2rhosigma4, t433, t435;
  double t438, t443, t448, t449, t453, tv2rhosigma5, t455, t457;
  double t460, t464, t468, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24;
  double t469, t471, t474, t478, t482, tv2sigma25;

  double t486, t487, t488, t490, t492, t495, t499, t502;
  double t507, t512, t513, t516, t519, t520, t523, t526;
  double t527, t528, t531, t535, t538, t540, t544, t548;
  double t552, t556, t559, t562, t563, t564, t567, t568;
  double t569, t570, t571, t572, t573, t575, t576, t577;
  double t578, t581, t582, t584, t587, t588, t591, t594;
  double t595, t597, t598, t601, t604, t607, t611, t614;
  double t618, t622, t626, t627, t629, tv3rho30, t632, t633;
  double t634, t637, t642, t643, t645, t649, t652, t656;
  double t657, t662, t665, t670, t671, t681, t682, t683;
  double t686, t691, t693, t697, t700, t704, t705, t708;
  double t715, t716, t719, tv3rho31, t722, t727, t731, t735;
  double t738, t742, t750, t751, t756, t760, t764, t767;
  double t771, t776, t782, t786, t788, t789, t793, t794;
  double t795, t797, t798, tv3rho32, t803, t810, t814, t817;
  double t822, t824, t826, t829, t834, t838, t841, t846;
  double t847, t854, t861, t865, t868, t876, t877, t878;
  double t879, t880, t882, t883, t884, t885, t889, t892;
  double t893, t896, t899, t900, tv3rho33, t906, t910, t915;
  double t919, t922, t929, t930, t932, t936, t937, t938;
  double t941, t944, t945, t946, t947, t952, t955, t956;
  double tv3rho2sigma0, tv3rho2sigma1, t961, t964, t966, tv3rho2sigma2, t970, t983;
  double tv3rho2sigma3, tv3rho2sigma4, t987, t992, t996, t1000, t1003, tv3rho2sigma5;
  double t1010, tv3rho2sigma6, tv3rho2sigma7, t1016, t1020, t1028, t1039, t1040;
  double t1041, t1044, t1047, t1048, t1049, t1050, t1055, t1058;
  double t1059, tv3rho2sigma8, t1064, t1065, t1066, t1069, t1074, t1077;
  double t1079, t1080, t1086, t1089, t1092, t1093, t1097, tv3rhosigma20;
  double tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1102, t1106, t1108, tv3rhosigma25;
  double t1115, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1119, t1120;
  double t1123, t1128, t1131, t1133, t1134, t1141, t1144, t1145;
  double t1149, tv3rhosigma211, t1152, t1153, t1157, t1161, t1165, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t1167, t1168, t1172, t1176, t1180, tv3sigma39;

  double t1183, t1184, t1190, t1191, t1193, t1197, t1199, t1200;
  double t1201, t1205, t1206, t1207, t1215, t1216, t1218, t1221;
  double t1230, t1233, t1234, t1237, t1239, t1244, t1246, t1252;
  double t1256, t1260, t1263, t1267, t1268, t1270, t1271, t1277;
  double t1283, t1284, t1287, t1291, t1296, t1298, t1300, t1302;
  double t1303, t1305, t1307, t1309, t1316, t1325, t1326, t1334;
  double t1342, t1343, t1345, t1347, t1356, t1361, t1363, t1364;
  double t1366, t1367, t1373, t1378, t1381, t1385, t1392, t1396;
  double t1400, t1405, t1407, tv4rho40, t1413, t1418, t1419, t1422;
  double t1447, t1448, t1450, t1454, t1461, t1465, t1466, t1469;
  double t1473, t1477, t1482, t1483, t1484, t1488, t1501, t1506;
  double t1508, t1525, t1527, t1531, t1538, t1542, t1543, t1546;
  double t1553, t1555, t1556, t1557, t1559, t1560, tv4rho41, t1575;
  double t1588, t1592, t1600, t1609, t1613, t1618, t1626, t1633;
  double t1635, t1650, t1663, t1667, t1672, t1674, t1677, t1680;
  double t1682, t1684, t1686, t1689, t1694, t1698, t1707, t1708;
  double t1710, t1711, t1713, t1715, tv4rho42, t1736, t1740, t1747;
  double t1757, t1758, t1759, t1760, t1762, t1765, t1767, t1768;
  double t1773, t1797, t1801, t1808, t1811, t1813, t1816, t1831;
  double t1833, t1835, t1839, t1840, t1842, t1844, t1849, t1851;
  double tv4rho43, t1856, t1861, t1868, t1872, t1881, t1883, t1884;
  double t1890, t1895, t1896, t1899, t1901, t1902, t1903, t1908;
  double t1914, t1932, t1937, t1944, t1948, t1961, t1991, t2000;
  double t2007, t2009, tv4rho44, t2020, t2022, t2025, t2026, t2032;
  double t2044, t2046, t2052, t2054, t2064, t2066, t2068, t2073;
  double t2075, t2078, t2079, t2086, t2099, t2101, t2105, t2111;
  double t2113, tv4rho3sigma0, tv4rho3sigma1, t2118, t2120, t2123, t2125, tv4rho3sigma2;
  double t2127, t2129, t2135, t2138, t2141, t2152, t2155, t2173;
  double t2175, tv4rho3sigma3, tv4rho3sigma4, t2177, t2181, t2182, t2189, t2190;
  double t2195, t2196, t2201, t2202, t2204, t2205, tv4rho3sigma5, t2209;
  double t2222, t2223, tv4rho3sigma6, tv4rho3sigma7, t2229, t2232, t2246, t2247;
  double t2249, t2251, t2253, t2255, t2258, t2262, t2264, t2271;
  double t2273, tv4rho3sigma8, t2281, tv4rho3sigma9, tv4rho3sigma10, t2291, t2293, t2328;
  double t2348, t2349, t2366, t2368, tv4rho3sigma11, t2373, t2378, t2383;
  double t2385, t2387, t2391, t2398, t2403, t2409, t2410, t2417;
  double t2428, t2430, t2433, t2442, t2446, t2448, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2453, t2456, t2459, t2462, t2464;
  double tv4rho2sigma25, t2468, t2482, t2491, t2492, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28;
  double tv4rho2sigma29, tv4rho2sigma210, t2496, t2501, t2505, t2509, t2513, t2518;
  double t2522, t2524, t2525, tv4rho2sigma211, t2535, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214;
  double tv4rho2sigma215, tv4rho2sigma216, t2541, t2543, t2564, t2586, t2589, t2600;
  double t2602, tv4rho2sigma217, t2607, t2609, t2615, t2619, t2621, t2628;
  double t2640, t2649, t2650, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34;
  double tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2655, t2659, t2663, t2665;
  double tv4rhosigma39, t2674, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2679, t2685, t2689, t2691, t2715;
  double t2716, tv4rhosigma319, t2719, t2726, t2737, tv4sigma40, tv4sigma41, tv4sigma42;
  double tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410;
  double tv4sigma411, tv4sigma412, tv4sigma413, t2739, t2746, t2757, tv4sigma414;

  gga_k_rational_p_params *params;

  assert(p->params != NULL);
  params = (gga_k_rational_p_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = t2 * t2;
  t4 = M_CBRTPI;
  t6 = t3 * t4 * M_PI;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * t22;
  t24 = t23 * p->zeta_threshold;
  t25 = POW_1_3(t20);
  t26 = t25 * t25;
  t28 = my_piecewise3(t21, t24, t26 * t20);
  t29 = POW_1_3(t7);
  t30 = t29 * t29;
  t31 = t28 * t30;
  t32 = 0.1e1 / params->p;
  t34 = M_CBRT6;
  t35 = params->C2 * t32 * t34;
  t36 = M_PI * M_PI;
  t37 = POW_1_3(t36);
  t38 = t37 * t37;
  t39 = 0.1e1 / t38;
  t41 = rho[0] * rho[0];
  t42 = POW_1_3(rho[0]);
  t43 = t42 * t42;
  t45 = 0.1e1 / t43 / t41;
  t49 = 0.1e1 + t35 * t39 * sigma[0] * t45 / 0.24e2;
  t50 = pow(t49, -params->p);
  t51 = t31 * t50;
  t52 = t6 * t51;
  t54 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t52);
  t55 = rho[1] <= p->dens_threshold;
  t56 = -t17;
  t58 = my_piecewise5(t15, t12, t11, t16, t56 * t8);
  t59 = 0.1e1 + t58;
  t60 = t59 <= p->zeta_threshold;
  t61 = POW_1_3(t59);
  t62 = t61 * t61;
  t64 = my_piecewise3(t60, t24, t62 * t59);
  t65 = t64 * t30;
  t67 = rho[1] * rho[1];
  t68 = POW_1_3(rho[1]);
  t69 = t68 * t68;
  t71 = 0.1e1 / t69 / t67;
  t75 = 0.1e1 + t35 * t39 * sigma[2] * t71 / 0.24e2;
  t76 = pow(t75, -params->p);
  t77 = t65 * t76;
  t78 = t6 * t77;
  t80 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t78);
  tzk0 = t54 + t80;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t81 = t7 * t7;
  t82 = 0.1e1 / t81;
  t83 = t17 * t82;
  t85 = my_piecewise5(t11, 0, t15, 0, t8 - t83);
  t88 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t85);
  t89 = t88 * t30;
  t90 = t89 * t50;
  t91 = t6 * t90;
  t93 = 0.1e1 / t29;
  t94 = t28 * t93;
  t95 = t94 * t50;
  t96 = t6 * t95;
  t97 = t96 / 0.1e2;
  t98 = params->C2 * t34;
  t99 = t98 * t39;
  t100 = t41 * rho[0];
  t102 = 0.1e1 / t43 / t100;
  t104 = 0.1e1 / t49;
  t106 = t99 * sigma[0] * t102 * t104;
  t110 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t91 + t97 + t52 * t106 / 0.6e2);
  t111 = t56 * t82;
  t113 = my_piecewise5(t15, 0, t11, 0, -t8 - t111);
  t116 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t113);
  t117 = t116 * t30;
  t118 = t117 * t76;
  t119 = t6 * t118;
  t121 = t64 * t93;
  t122 = t121 * t76;
  t123 = t6 * t122;
  t124 = t123 / 0.1e2;
  t126 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t119 + t124);
  tvrho0 = t54 + t80 + t7 * (t110 + t126);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t130 = my_piecewise5(t11, 0, t15, 0, -t8 - t83);
  t133 = my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t130);
  t134 = t133 * t30;
  t135 = t134 * t50;
  t136 = t6 * t135;
  t139 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t136 + t97);
  t141 = my_piecewise5(t15, 0, t11, 0, t8 - t111);
  t144 = my_piecewise3(t60, 0, 0.5e1 / 0.3e1 * t62 * t141);
  t145 = t144 * t30;
  t146 = t145 * t76;
  t147 = t6 * t146;
  t149 = t67 * rho[1];
  t151 = 0.1e1 / t69 / t149;
  t153 = 0.1e1 / t75;
  t155 = t99 * sigma[2] * t151 * t153;
  t159 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t147 + t124 + t78 * t155 / 0.6e2);
  tvrho1 = t54 + t80 + t7 * (t139 + t159);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t164 = t98 * t39 * t45 * t104;
  t167 = my_piecewise3(t1, 0, -t52 * t164 / 0.16e3);
  tvsigma0 = t7 * t167;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t170 = t98 * t39 * t71 * t153;
  t173 = my_piecewise3(t55, 0, -t78 * t170 / 0.16e3);
  tvsigma2 = t7 * t173;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t25;
  t177 = t85 * t85;
  t180 = t81 * t7;
  t181 = 0.1e1 / t180;
  t182 = t17 * t181;
  t185 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t82 + 0.2e1 * t182);
  t189 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t177 + 0.5e1 / 0.3e1 * t26 * t185);
  t192 = t6 * t189 * t30 * t50;
  t196 = t6 * t88 * t93 * t50;
  t201 = 0.1e1 / t29 / t7;
  t204 = t6 * t28 * t201 * t50;
  t205 = t204 / 0.3e2;
  t206 = t96 * t106;
  t208 = params->C2 * params->C2;
  t209 = t34 * t34;
  t210 = t208 * t209;
  t212 = 0.1e1 / t37 / t36;
  t213 = t210 * t212;
  t214 = sigma[0] * sigma[0];
  t215 = t41 * t41;
  t218 = 0.1e1 / t42 / t215 / t100;
  t220 = t49 * t49;
  t221 = 0.1e1 / t220;
  t223 = t213 * t214 * t218 * t221;
  t227 = 0.1e1 / t43 / t215;
  t230 = t99 * sigma[0] * t227 * t104;
  t233 = t6 * t28;
  t234 = t30 * t50;
  t235 = t234 * t208;
  t236 = t233 * t235;
  t237 = t209 * t212;
  t238 = t237 * t214;
  t240 = t218 * t221 * t32;
  t241 = t238 * t240;
  t245 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t192 + t196 / 0.5e1 + t91 * t106 / 0.3e2 - t205 + t206 / 0.45e2 + t52 * t223 / 0.54e3 - 0.11e2 / 0.18e3 * t52 * t230 + t236 * t241 / 0.54e3);
  t246 = 0.1e1 / t61;
  t247 = t113 * t113;
  t250 = t56 * t181;
  t253 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t82 + 0.2e1 * t250);
  t257 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t247 + 0.5e1 / 0.3e1 * t62 * t253);
  t260 = t6 * t257 * t30 * t76;
  t264 = t6 * t116 * t93 * t76;
  t268 = t6 * t64 * t201 * t76;
  t269 = t268 / 0.3e2;
  t271 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t260 + t264 / 0.5e1 - t269);
  tv2rho20 = 0.2e1 * t110 + 0.2e1 * t126 + t7 * (t245 + t271);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t274 = t176 * t130;
  t278 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t182);
  t282 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t274 * t85 + 0.5e1 / 0.3e1 * t26 * t278);
  t285 = t6 * t282 * t30 * t50;
  t289 = t6 * t133 * t93 * t50;
  t296 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t285 + t289 / 0.1e2 + t136 * t106 / 0.6e2 + t196 / 0.1e2 - t205 + t206 / 0.9e2);
  t297 = t246 * t141;
  t301 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t250);
  t305 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t297 * t113 + 0.5e1 / 0.3e1 * t62 * t301);
  t308 = t6 * t305 * t30 * t76;
  t312 = t6 * t144 * t93 * t76;
  t317 = t123 * t155;
  t320 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t308 + t312 / 0.1e2 + t264 / 0.1e2 - t269 + t119 * t155 / 0.6e2 + t317 / 0.9e2);
  tv2rho21 = t110 + t126 + t139 + t159 + t7 * (t296 + t320);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t325 = t130 * t130;
  t330 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t82 + 0.2e1 * t182);
  t334 = my_piecewise3(t21, 0, 0.1e2 / 0.9e1 * t176 * t325 + 0.5e1 / 0.3e1 * t26 * t330);
  t337 = t6 * t334 * t30 * t50;
  t341 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t337 + t289 / 0.5e1 - t205);
  t342 = t141 * t141;
  t347 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t82 + 0.2e1 * t250);
  t351 = my_piecewise3(t60, 0, 0.1e2 / 0.9e1 * t246 * t342 + 0.5e1 / 0.3e1 * t62 * t347);
  t354 = t6 * t351 * t30 * t76;
  t360 = sigma[2] * sigma[2];
  t361 = t67 * t67;
  t364 = 0.1e1 / t68 / t361 / t149;
  t366 = t75 * t75;
  t367 = 0.1e1 / t366;
  t369 = t213 * t360 * t364 * t367;
  t373 = 0.1e1 / t69 / t361;
  t376 = t99 * sigma[2] * t373 * t153;
  t379 = t6 * t64;
  t380 = t30 * t76;
  t381 = t380 * t208;
  t382 = t379 * t381;
  t383 = t237 * t360;
  t385 = t364 * t367 * t32;
  t386 = t383 * t385;
  t390 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t354 + t312 / 0.5e1 + t147 * t155 / 0.3e2 - t269 + t317 / 0.45e2 + t78 * t369 / 0.54e3 - 0.11e2 / 0.18e3 * t78 * t376 + t382 * t386 / 0.54e3);
  tv2rho22 = 0.2e1 * t139 + 0.2e1 * t159 + t7 * (t341 + t390);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t396 = t96 * t164 / 0.24e3;
  t397 = t215 * t41;
  t399 = 0.1e1 / t42 / t397;
  t402 = t213 * sigma[0] * t399 * t221;
  t407 = t98 * t39 * t102 * t104;
  t412 = t221 * t32 * sigma[0];
  t413 = t237 * t399 * t412;
  t417 = my_piecewise3(t1, 0, -t91 * t164 / 0.16e3 - t396 - t52 * t402 / 0.144e4 + t52 * t407 / 0.6e2 - t236 * t413 / 0.144e4);
  tv2rhosigma0 = t7 * t417 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t422 = t123 * t170 / 0.24e3;
  t424 = my_piecewise3(t55, 0, -t119 * t170 / 0.16e3 - t422);
  tv2rhosigma2 = t7 * t424 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t429 = my_piecewise3(t1, 0, -t136 * t164 / 0.16e3 - t396);
  tv2rhosigma3 = t7 * t429 + t167;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t433 = t361 * t67;
  t435 = 0.1e1 / t68 / t433;
  t438 = t213 * sigma[2] * t435 * t367;
  t443 = t98 * t39 * t151 * t153;
  t448 = t367 * t32 * sigma[2];
  t449 = t237 * t435 * t448;
  t453 = my_piecewise3(t55, 0, -t147 * t170 / 0.16e3 - t422 - t78 * t438 / 0.144e4 + t78 * t443 / 0.6e2 - t382 * t449 / 0.144e4);
  tv2rhosigma5 = t7 * t453 + t173;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t455 = t215 * rho[0];
  t457 = 0.1e1 / t42 / t455;
  t460 = t210 * t212 * t457 * t221;
  t464 = t213 * t457 * t221 * t32;
  t468 = my_piecewise3(t1, 0, t52 * t460 / 0.384e4 + t52 * t464 / 0.384e4);
  tv2sigma20 = t7 * t468;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t469 = t361 * rho[1];
  t471 = 0.1e1 / t68 / t469;
  t474 = t210 * t212 * t471 * t367;
  t478 = t213 * t471 * t367 * t32;
  t482 = my_piecewise3(t55, 0, t78 * t474 / 0.384e4 + t78 * t478 / 0.384e4);
  tv2sigma25 = t7 * t482;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t486 = t93 * t50 * t208;
  t487 = t233 * t486;
  t488 = t487 * t241;
  t490 = t215 * t215;
  t492 = 0.1e1 / t42 / t490;
  t495 = t213 * t214 * t492 * t221;
  t499 = 0.1e1 / t43 / t455;
  t502 = t99 * sigma[0] * t499 * t104;
  t507 = t238 * t492 * t221 * t32;
  t512 = t6 * t88;
  t513 = t512 * t235;
  t516 = t96 * t230;
  t519 = 0.1e1 / t25 / t20;
  t520 = t177 * t85;
  t523 = t176 * t85;
  t526 = t81 * t81;
  t527 = 0.1e1 / t526;
  t528 = t17 * t527;
  t531 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t181 - 0.6e1 * t528);
  t535 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t519 * t520 + 0.1e2 / 0.3e1 * t523 * t185 + 0.5e1 / 0.3e1 * t26 * t531);
  t538 = t6 * t535 * t30 * t50;
  t540 = t96 * t223;
  t544 = t196 * t106;
  t548 = t204 * t106;
  t552 = t6 * t189 * t93 * t50;
  t556 = t6 * t88 * t201 * t50;
  t559 = 0.1e1 / t29 / t81;
  t562 = t6 * t28 * t559 * t50;
  t563 = 0.2e1 / 0.45e2 * t562;
  t564 = t4 * t4;
  t567 = t3 / t564 / t36;
  t568 = t567 * t51;
  t569 = t208 * params->C2;
  t570 = t214 * sigma[0];
  t571 = t569 * t570;
  t572 = t490 * t100;
  t573 = 0.1e1 / t572;
  t575 = 0.1e1 / t220 / t49;
  t576 = t573 * t575;
  t577 = t576 * t32;
  t578 = t571 * t577;
  t581 = params->p * params->p;
  t582 = 0.1e1 / t581;
  t584 = t571 * t576 * t582;
  t587 = t567 * t31;
  t588 = t50 * t569;
  t591 = t588 * t570 * t573 * t575;
  t594 = t488 / 0.27e3 - 0.11e2 / 0.54e3 * t52 * t495 + 0.77e2 / 0.27e3 * t52 * t502 - 0.11e2 / 0.54e3 * t236 * t507 - 0.11e2 / 0.6e2 * t91 * t230 + t513 * t241 / 0.18e3 - 0.11e2 / 0.9e2 * t516 + 0.3e1 / 0.2e2 * t538 + t540 / 0.27e3 + t192 * t106 / 0.2e2 + t544 / 0.15e2 + t91 * t223 / 0.18e3 - t548 / 0.9e2 + 0.3e1 / 0.1e2 * t552 - t556 / 0.1e2 + t563 + t568 * t578 / 0.27e3 + t568 * t584 / 0.405e3 + t587 * t591 / 0.81e3;
  t595 = my_piecewise3(t1, 0, t594);
  t597 = 0.1e1 / t61 / t59;
  t598 = t247 * t113;
  t601 = t246 * t113;
  t604 = t56 * t527;
  t607 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t181 - 0.6e1 * t604);
  t611 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t597 * t598 + 0.1e2 / 0.3e1 * t601 * t253 + 0.5e1 / 0.3e1 * t62 * t607);
  t614 = t6 * t611 * t30 * t76;
  t618 = t6 * t257 * t93 * t76;
  t622 = t6 * t116 * t201 * t76;
  t626 = t6 * t64 * t559 * t76;
  t627 = 0.2e1 / 0.45e2 * t626;
  t629 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t614 + 0.3e1 / 0.1e2 * t618 - t622 / 0.1e2 + t627);
  tv3rho30 = 0.3e1 * t245 + 0.3e1 * t271 + t7 * (t595 + t629);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t632 = 0.2e1 * t296;
  t633 = 0.2e1 * t320;
  t634 = t519 * t130;
  t637 = t176 * t278;
  t642 = 0.2e1 * t181;
  t643 = 0.6e1 * t528;
  t645 = my_piecewise5(t11, 0, t15, 0, t642 - t643);
  t649 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t634 * t177 + 0.2e2 / 0.9e1 * t637 * t85 + 0.1e2 / 0.9e1 * t274 * t185 + 0.5e1 / 0.3e1 * t26 * t645);
  t652 = t6 * t649 * t30 * t50;
  t656 = t6 * t282 * t93 * t50;
  t657 = t656 / 0.5e1;
  t662 = t6 * t133 * t201 * t50;
  t665 = t289 * t106 / 0.45e2;
  t670 = t6 * t133;
  t671 = t670 * t235;
  t681 = 0.3e1 / 0.2e2 * t652 + t657 + t285 * t106 / 0.3e2 - t662 / 0.3e2 + t665 + t136 * t223 / 0.54e3 - 0.11e2 / 0.18e3 * t136 * t230 + t671 * t241 / 0.54e3 + t552 / 0.1e2 - t556 / 0.15e2 + t544 / 0.45e2 + t563 - t548 / 0.135e3 + t540 / 0.81e3 - 0.11e2 / 0.27e3 * t516 + t488 / 0.81e3;
  t682 = my_piecewise3(t1, 0, t681);
  t683 = t597 * t141;
  t686 = t246 * t301;
  t691 = 0.6e1 * t604;
  t693 = my_piecewise5(t15, 0, t11, 0, -t642 - t691);
  t697 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t683 * t247 + 0.2e2 / 0.9e1 * t686 * t113 + 0.1e2 / 0.9e1 * t297 * t253 + 0.5e1 / 0.3e1 * t62 * t693);
  t700 = t6 * t697 * t30 * t76;
  t704 = t6 * t305 * t93 * t76;
  t705 = t704 / 0.5e1;
  t708 = t6 * t144 * t201 * t76;
  t715 = t264 * t155 / 0.45e2;
  t716 = t268 * t155;
  t719 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t700 + t705 - t708 / 0.3e2 + t618 / 0.1e2 - t622 / 0.15e2 + t627 + t260 * t155 / 0.6e2 + t715 - t716 / 0.27e3);
  tv3rho31 = t245 + t271 + t632 + t633 + t7 * (t682 + t719);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t722 = t519 * t325;
  t727 = t176 * t330;
  t731 = my_piecewise5(t11, 0, t15, 0, -t642 - t643);
  t735 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t722 * t85 + 0.2e2 / 0.9e1 * t274 * t278 + 0.1e2 / 0.9e1 * t727 * t85 + 0.5e1 / 0.3e1 * t26 * t731);
  t738 = t6 * t735 * t30 * t50;
  t742 = t6 * t334 * t93 * t50;
  t750 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t738 + t742 / 0.1e2 + t337 * t106 / 0.6e2 + t657 - t662 / 0.15e2 + t665 - t556 / 0.3e2 + t563 - t548 / 0.27e3);
  t751 = t597 * t342;
  t756 = t246 * t347;
  t760 = my_piecewise5(t15, 0, t11, 0, t642 - t691);
  t764 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t751 * t113 + 0.2e2 / 0.9e1 * t297 * t301 + 0.1e2 / 0.9e1 * t756 * t113 + 0.5e1 / 0.3e1 * t62 * t760);
  t767 = t6 * t764 * t30 * t76;
  t771 = t6 * t351 * t93 * t76;
  t776 = t312 * t155;
  t782 = t123 * t369;
  t786 = t123 * t376;
  t788 = t6 * t116;
  t789 = t788 * t381;
  t793 = t93 * t76 * t208;
  t794 = t379 * t793;
  t795 = t794 * t386;
  t797 = 0.3e1 / 0.2e2 * t767 + t771 / 0.1e2 + t705 - t708 / 0.15e2 + t308 * t155 / 0.3e2 + t776 / 0.45e2 - t622 / 0.3e2 + t627 + t715 - t716 / 0.135e3 + t119 * t369 / 0.54e3 + t782 / 0.81e3 - 0.11e2 / 0.18e3 * t119 * t376 - 0.11e2 / 0.27e3 * t786 + t789 * t386 / 0.54e3 + t795 / 0.81e3;
  t798 = my_piecewise3(t55, 0, t797);
  tv3rho32 = t632 + t633 + t341 + t390 + t7 * (t750 + t798);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t803 = t325 * t130;
  t810 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t181 - 0.6e1 * t528);
  t814 = my_piecewise3(t21, 0, -0.1e2 / 0.27e2 * t519 * t803 + 0.1e2 / 0.3e1 * t274 * t330 + 0.5e1 / 0.3e1 * t26 * t810);
  t817 = t6 * t814 * t30 * t50;
  t822 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t817 + 0.3e1 / 0.1e2 * t742 - t662 / 0.1e2 + t563);
  t824 = t361 * t361;
  t826 = 0.1e1 / t68 / t824;
  t829 = t383 * t826 * t367 * t32;
  t834 = t213 * t360 * t826 * t367;
  t838 = 0.1e1 / t69 / t469;
  t841 = t99 * sigma[2] * t838 * t153;
  t846 = t6 * t144;
  t847 = t846 * t381;
  t854 = t342 * t141;
  t861 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t181 - 0.6e1 * t604);
  t865 = my_piecewise3(t60, 0, -0.1e2 / 0.27e2 * t597 * t854 + 0.1e2 / 0.3e1 * t297 * t347 + 0.5e1 / 0.3e1 * t62 * t861);
  t868 = t6 * t865 * t30 * t76;
  t876 = t567 * t77;
  t877 = t360 * sigma[2];
  t878 = t569 * t877;
  t879 = t824 * t149;
  t880 = 0.1e1 / t879;
  t882 = 0.1e1 / t366 / t75;
  t883 = t880 * t882;
  t884 = t883 * t32;
  t885 = t878 * t884;
  t889 = t878 * t883 * t582;
  t892 = t567 * t65;
  t893 = t76 * t569;
  t896 = t893 * t877 * t880 * t882;
  t899 = t795 / 0.27e3 - 0.11e2 / 0.54e3 * t382 * t829 - 0.11e2 / 0.54e3 * t78 * t834 + 0.77e2 / 0.27e3 * t78 * t841 - 0.11e2 / 0.6e2 * t147 * t376 + t847 * t386 / 0.18e3 + t782 / 0.27e3 - 0.11e2 / 0.9e2 * t786 - t716 / 0.9e2 + t776 / 0.15e2 + 0.3e1 / 0.2e2 * t868 + t147 * t369 / 0.18e3 + t354 * t155 / 0.2e2 + 0.3e1 / 0.1e2 * t771 + t627 - t708 / 0.1e2 + t876 * t885 / 0.27e3 + t876 * t889 / 0.405e3 + t892 * t896 / 0.81e3;
  t900 = my_piecewise3(t55, 0, t899);
  tv3rho33 = 0.3e1 * t341 + 0.3e1 * t390 + t7 * (t822 + t900);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t906 = t213 * sigma[0] * t218 * t221;
  t910 = t237 * t218 * t412;
  t915 = t487 * t413;
  t919 = t98 * t39 * t227 * t104;
  t922 = t196 * t164;
  t929 = t204 * t164 / 0.72e3;
  t930 = t96 * t407;
  t932 = t96 * t402;
  t936 = t569 * t214;
  t937 = t490 * t41;
  t938 = 0.1e1 / t937;
  t941 = t936 * t938 * t575 * t32;
  t944 = t569 * t938;
  t945 = t575 * t582;
  t946 = t945 * t214;
  t947 = t944 * t946;
  t952 = t588 * t214 * t938 * t575;
  t955 = t52 * t906 / 0.16e3 + t236 * t910 / 0.16e3 - t513 * t413 / 0.72e3 - t915 / 0.108e4 - 0.11e2 / 0.18e3 * t52 * t919 - t922 / 0.12e3 + t91 * t407 / 0.3e2 - t91 * t402 / 0.72e3 + t929 + t930 / 0.45e2 - t932 / 0.108e4 - t192 * t164 / 0.16e3 - t568 * t941 / 0.72e3 - t568 * t947 / 0.108e4 - t587 * t952 / 0.216e4;
  t956 = my_piecewise3(t1, 0, t955);
  tv3rho2sigma0 = t7 * t956 + 0.2e1 * t417;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t961 = t264 * t170;
  t964 = t268 * t170 / 0.72e3;
  t966 = my_piecewise3(t55, 0, -t260 * t170 / 0.16e3 - t961 / 0.12e3 + t964);
  tv3rho2sigma2 = t7 * t966 + 0.2e1 * t424;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t970 = t289 * t164;
  t983 = my_piecewise3(t1, 0, -t285 * t164 / 0.16e3 - t970 / 0.24e3 - t136 * t402 / 0.144e4 + t136 * t407 / 0.6e2 - t671 * t413 / 0.144e4 - t922 / 0.24e3 + t929 - t932 / 0.216e4 + t930 / 0.9e2 - t915 / 0.216e4);
  tv3rho2sigma3 = t7 * t983 + t417 + t429;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t987 = t312 * t170;
  t992 = t123 * t438;
  t996 = t123 * t443;
  t1000 = t794 * t449;
  t1003 = my_piecewise3(t55, 0, -t308 * t170 / 0.16e3 - t987 / 0.24e3 - t961 / 0.24e3 + t964 - t119 * t438 / 0.144e4 - t992 / 0.216e4 + t119 * t443 / 0.6e2 + t996 / 0.9e2 - t789 * t449 / 0.144e4 - t1000 / 0.216e4);
  tv3rho2sigma5 = t7 * t1003 + t424 + t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1010 = my_piecewise3(t1, 0, -t337 * t164 / 0.16e3 - t970 / 0.12e3 + t929);
  tv3rho2sigma6 = t7 * t1010 + 0.2e1 * t429;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1016 = t213 * sigma[2] * t364 * t367;
  t1020 = t237 * t364 * t448;
  t1028 = t98 * t39 * t373 * t153;
  t1039 = t569 * t360;
  t1040 = t824 * t67;
  t1041 = 0.1e1 / t1040;
  t1044 = t1039 * t1041 * t882 * t32;
  t1047 = t569 * t1041;
  t1048 = t882 * t582;
  t1049 = t1048 * t360;
  t1050 = t1047 * t1049;
  t1055 = t893 * t360 * t1041 * t882;
  t1058 = -t1000 / 0.108e4 + t78 * t1016 / 0.16e3 + t382 * t1020 / 0.16e3 - t847 * t449 / 0.72e3 - t992 / 0.108e4 - 0.11e2 / 0.18e3 * t78 * t1028 + t147 * t443 / 0.3e2 - t147 * t438 / 0.72e3 + t996 / 0.45e2 - t987 / 0.12e3 + t964 - t354 * t170 / 0.16e3 - t876 * t1044 / 0.72e3 - t876 * t1050 / 0.108e4 - t892 * t1055 / 0.216e4;
  t1059 = my_piecewise3(t55, 0, t1058);
  tv3rho2sigma8 = t7 * t1059 + 0.2e1 * t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1064 = t96 * t460 / 0.576e4;
  t1065 = t490 * rho[0];
  t1066 = 0.1e1 / t1065;
  t1069 = t588 * sigma[0] * t1066 * t575;
  t1074 = t210 * t212 * t399 * t221;
  t1077 = t569 * t1066;
  t1079 = t575 * t32 * sigma[0];
  t1080 = t1077 * t1079;
  t1086 = t96 * t464 / 0.576e4;
  t1089 = t213 * t399 * t221 * t32;
  t1092 = t945 * sigma[0];
  t1093 = t1077 * t1092;
  t1097 = my_piecewise3(t1, 0, t91 * t460 / 0.384e4 + t1064 + t587 * t1069 / 0.576e4 - t52 * t1074 / 0.72e3 + t568 * t1080 / 0.192e4 + t91 * t464 / 0.384e4 + t1086 - t52 * t1089 / 0.72e3 + t568 * t1093 / 0.288e4);
  tv3rhosigma20 = t7 * t1097 + t468;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1102 = t123 * t474 / 0.576e4;
  t1106 = t123 * t478 / 0.576e4;
  t1108 = my_piecewise3(t55, 0, t119 * t474 / 0.384e4 + t1102 + t119 * t478 / 0.384e4 + t1106);
  tv3rhosigma25 = t7 * t1108 + t482;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1115 = my_piecewise3(t1, 0, t136 * t460 / 0.384e4 + t1064 + t136 * t464 / 0.384e4 + t1086);
  tv3rhosigma26 = t7 * t1115 + t468;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1119 = t824 * rho[1];
  t1120 = 0.1e1 / t1119;
  t1123 = t893 * sigma[2] * t1120 * t882;
  t1128 = t210 * t212 * t435 * t367;
  t1131 = t569 * t1120;
  t1133 = t882 * t32 * sigma[2];
  t1134 = t1131 * t1133;
  t1141 = t213 * t435 * t367 * t32;
  t1144 = t1048 * sigma[2];
  t1145 = t1131 * t1144;
  t1149 = my_piecewise3(t55, 0, t147 * t474 / 0.384e4 + t1102 + t892 * t1123 / 0.576e4 - t78 * t1128 / 0.72e3 + t876 * t1134 / 0.192e4 + t147 * t478 / 0.384e4 + t1106 - t78 * t1141 / 0.72e3 + t876 * t1145 / 0.288e4);
  tv3rhosigma211 = t7 * t1149 + t482;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1152 = 0.1e1 / t490 * t575;
  t1153 = t588 * t1152;
  t1157 = t588 * t1152 * t32;
  t1161 = t588 * t1152 * t582;
  t1165 = my_piecewise3(t1, 0, -t587 * t1153 / 0.1536e5 - t587 * t1157 / 0.512e4 - t587 * t1161 / 0.768e4);
  tv3sigma30 = t7 * t1165;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1167 = 0.1e1 / t824 * t882;
  t1168 = t893 * t1167;
  t1172 = t893 * t1167 * t32;
  t1176 = t893 * t1167 * t582;
  t1180 = my_piecewise3(t55, 0, -t892 * t1168 / 0.1536e5 - t892 * t1172 / 0.512e4 - t892 * t1176 / 0.768e4);
  tv3sigma39 = t7 * t1180;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1183 = t490 * t215;
  t1184 = 0.1e1 / t1183;
  t1190 = t567 * t94;
  t1191 = t1190 * t591;
  t1193 = t567 * t89;
  t1197 = t208 * t208;
  t1199 = t567 * t28 * t234 * t1197;
  t1200 = t34 * t39;
  t1201 = t214 * t214;
  t1205 = 0.1e1 / t43 / t490 / t397;
  t1206 = t220 * t220;
  t1207 = 0.1e1 / t1206;
  t1215 = t233 * t201 * t50 * t208;
  t1216 = t1215 * t241;
  t1218 = t487 * t507;
  t1221 = 0.1e1 / t42 / t1065;
  t1230 = t6 * t189 * t235;
  t1233 = t512 * t486;
  t1234 = t1233 * t241;
  t1237 = t1201 * t1205 * t1207;
  t1239 = t582 * t34 * t39;
  t1244 = 0.1e1 / t581 / params->p;
  t1246 = t1244 * t34 * t39;
  t1252 = t6 * t535 * t93 * t50;
  t1256 = t6 * t189 * t201 * t50;
  t1260 = t6 * t88 * t559 * t50;
  t1263 = 0.1e1 / t29 / t180;
  t1267 = 0.14e2 / 0.135e3 * t6 * t28 * t1263 * t50;
  t1268 = t20 * t20;
  t1270 = 0.1e1 / t25 / t1268;
  t1271 = t177 * t177;
  t1277 = t185 * t185;
  t1283 = 0.1e1 / t526 / t7;
  t1284 = t17 * t1283;
  t1287 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t527 + 0.24e2 * t1284);
  t1291 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1270 * t1271 - 0.2e2 / 0.9e1 * t519 * t177 * t185 + 0.1e2 / 0.3e1 * t176 * t1277 + 0.4e2 / 0.9e1 * t523 * t531 + 0.5e1 / 0.3e1 * t26 * t1287);
  t1296 = t562 * t106;
  t1298 = t552 * t106;
  t1300 = t556 * t106;
  t1302 = -0.11e2 / 0.405e3 * t587 * t588 * t570 * t1184 * t575 + 0.4e1 / 0.1215e4 * t1191 + 0.2e1 / 0.405e3 * t1193 * t591 + t1199 * t1200 * t1201 * t1205 * t1207 * t32 / 0.1215e4 - t1216 / 0.405e3 - 0.22e2 / 0.405e3 * t1218 + 0.979e3 / 0.486e4 * t236 * t238 * t1221 * t221 * t32 - 0.11e2 / 0.135e3 * t513 * t507 + t1230 * t241 / 0.9e2 + 0.2e1 / 0.135e3 * t1234 + 0.11e2 / 0.729e4 * t1199 * t1237 * t1239 + t1199 * t1237 * t1246 / 0.1215e4 + 0.2e1 / 0.5e1 * t1252 - t1256 / 0.5e1 + 0.8e1 / 0.45e2 * t1260 - t1267 + 0.3e1 / 0.2e2 * t6 * t1291 * t30 * t50 + 0.8e1 / 0.405e3 * t1296 + 0.2e1 / 0.15e2 * t1298 - 0.2e1 / 0.45e2 * t1300;
  t1303 = t204 * t230;
  t1305 = t204 * t223;
  t1307 = t196 * t230;
  t1309 = t96 * t495;
  t1316 = t96 * t502;
  t1325 = t1197 * t34;
  t1326 = t1325 * t39;
  t1334 = t196 * t223;
  t1342 = t567 * t95;
  t1343 = t1342 * t578;
  t1345 = t1342 * t584;
  t1347 = t1184 * t575;
  t1356 = t567 * t90;
  t1361 = 0.11e2 / 0.135e3 * t1303 - t1305 / 0.405e3 - 0.22e2 / 0.45e2 * t1307 - 0.22e2 / 0.405e3 * t1309 + 0.979e3 / 0.486e4 * t52 * t213 * t214 * t1221 * t221 + 0.308e3 / 0.405e3 * t1316 - 0.1309e4 / 0.81e3 * t52 * t99 * sigma[0] / t43 / t397 * t104 + t568 * t1326 * t1237 / 0.729e4 - 0.11e2 / 0.3e2 * t192 * t230 + t538 * t106 / 0.15e2 + 0.2e1 / 0.135e3 * t1334 + t192 * t223 / 0.9e2 - 0.11e2 / 0.135e3 * t91 * t495 + 0.154e3 / 0.135e3 * t91 * t502 + 0.4e1 / 0.405e3 * t1343 + 0.8e1 / 0.1215e4 * t1345 - 0.11e2 / 0.135e3 * t568 * t571 * t1347 * t32 - 0.22e2 / 0.405e3 * t568 * t571 * t1347 * t582 + 0.2e1 / 0.135e3 * t1356 * t578 + 0.4e1 / 0.405e3 * t1356 * t584;
  t1363 = my_piecewise3(t1, 0, t1302 + t1361);
  t1364 = t59 * t59;
  t1366 = 0.1e1 / t61 / t1364;
  t1367 = t247 * t247;
  t1373 = t253 * t253;
  t1378 = t56 * t1283;
  t1381 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t527 + 0.24e2 * t1378);
  t1385 = my_piecewise3(t60, 0, 0.4e2 / 0.81e2 * t1366 * t1367 - 0.2e2 / 0.9e1 * t597 * t247 * t253 + 0.1e2 / 0.3e1 * t246 * t1373 + 0.4e2 / 0.9e1 * t601 * t607 + 0.5e1 / 0.3e1 * t62 * t1381);
  t1392 = t6 * t611 * t93 * t76;
  t1396 = t6 * t257 * t201 * t76;
  t1400 = t6 * t116 * t559 * t76;
  t1405 = 0.14e2 / 0.135e3 * t6 * t64 * t1263 * t76;
  t1407 = my_piecewise3(t55, 0, 0.3e1 / 0.2e2 * t6 * t1385 * t30 * t76 + 0.2e1 / 0.5e1 * t1392 - t1396 / 0.5e1 + 0.8e1 / 0.45e2 * t1400 - t1405);
  tv4rho40 = 0.4e1 * t595 + 0.4e1 * t629 + t7 * (t1363 + t1407);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1413 = t567 * t134;
  t1418 = t670 * t486;
  t1419 = t1418 * t241;
  t1422 = t6 * t282 * t235;
  t1447 = 0.12e2 * t527;
  t1448 = 0.24e2 * t1284;
  t1450 = my_piecewise5(t11, 0, t15, 0, -t1447 + t1448);
  t1454 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1270 * t130 * t520 - 0.1e2 / 0.9e1 * t519 * t278 * t177 - 0.1e2 / 0.9e1 * t634 * t85 * t185 + 0.1e2 / 0.3e1 * t176 * t645 * t85 + 0.1e2 / 0.3e1 * t637 * t185 + 0.1e2 / 0.9e1 * t274 * t531 + 0.5e1 / 0.3e1 * t26 * t1450);
  t1461 = t6 * t649 * t93 * t50;
  t1465 = t6 * t282 * t201 * t50;
  t1466 = t1465 / 0.1e2;
  t1469 = t6 * t133 * t559 * t50;
  t1473 = t289 * t230;
  t1477 = t1191 / 0.1215e4 + t1413 * t591 / 0.81e3 - 0.11e2 / 0.54e3 * t671 * t507 + t1419 / 0.27e3 + t1422 * t241 / 0.18e3 - t1216 / 0.81e3 - 0.11e2 / 0.81e3 * t1218 + t1234 / 0.27e3 + t1252 / 0.1e2 - t1256 / 0.1e2 + 0.2e1 / 0.15e2 * t1260 - t1267 + 0.3e1 / 0.2e2 * t6 * t1454 * t30 * t50 + 0.3e1 / 0.1e2 * t1461 - t1466 + 0.2e1 / 0.45e2 * t1469 + 0.77e2 / 0.27e3 * t136 * t502 - 0.11e2 / 0.9e2 * t1473 - 0.11e2 / 0.54e3 * t136 * t495;
  t1482 = t662 * t106;
  t1483 = t1482 / 0.9e2;
  t1484 = t289 * t223;
  t1488 = t656 * t106;
  t1501 = t567 * t135;
  t1506 = -0.11e2 / 0.6e2 * t285 * t230 + t285 * t223 / 0.18e3 - t1483 + t1484 / 0.27e3 + t652 * t106 / 0.2e2 + t1488 / 0.15e2 + 0.2e1 / 0.135e3 * t1296 + t1298 / 0.3e2 - t1300 / 0.45e2 + 0.11e2 / 0.27e3 * t1303 - t1305 / 0.81e3 - 0.11e2 / 0.9e2 * t1307 - 0.11e2 / 0.81e3 * t1309 + 0.77e2 / 0.405e3 * t1316 + t1334 / 0.27e3 + t1343 / 0.405e3 + 0.2e1 / 0.1215e4 * t1345 + t1501 * t578 / 0.27e3 + t1501 * t584 / 0.405e3;
  t1508 = my_piecewise3(t1, 0, t1477 + t1506);
  t1525 = 0.24e2 * t1378;
  t1527 = my_piecewise5(t15, 0, t11, 0, t1447 + t1525);
  t1531 = my_piecewise3(t60, 0, 0.4e2 / 0.81e2 * t1366 * t141 * t598 - 0.1e2 / 0.9e1 * t597 * t301 * t247 - 0.1e2 / 0.9e1 * t683 * t113 * t253 + 0.1e2 / 0.3e1 * t246 * t693 * t113 + 0.1e2 / 0.3e1 * t686 * t253 + 0.1e2 / 0.9e1 * t297 * t607 + 0.5e1 / 0.3e1 * t62 * t1527);
  t1538 = t6 * t697 * t93 * t76;
  t1542 = t6 * t305 * t201 * t76;
  t1543 = t1542 / 0.1e2;
  t1546 = t6 * t144 * t559 * t76;
  t1553 = t618 * t155;
  t1555 = t622 * t155;
  t1556 = t1555 / 0.9e2;
  t1557 = t626 * t155;
  t1559 = 0.3e1 / 0.2e2 * t6 * t1531 * t30 * t76 + 0.3e1 / 0.1e2 * t1538 - t1543 + 0.2e1 / 0.45e2 * t1546 + t1392 / 0.1e2 - t1396 / 0.1e2 + 0.2e1 / 0.15e2 * t1400 - t1405 + t614 * t155 / 0.6e2 + t1553 / 0.3e2 - t1556 + 0.2e1 / 0.405e3 * t1557;
  t1560 = my_piecewise3(t55, 0, t1559);
  tv4rho41 = t595 + t629 + 0.3e1 * t682 + 0.3e1 * t719 + t7 * (t1508 + t1560);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1575 = t278 * t278;
  t1588 = my_piecewise5(t11, 0, t15, 0, t1448);
  t1592 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1270 * t325 * t177 - 0.4e2 / 0.27e2 * t634 * t85 * t278 - 0.1e2 / 0.27e2 * t722 * t185 + 0.2e2 / 0.9e1 * t176 * t1575 + 0.2e2 / 0.9e1 * t274 * t645 - 0.1e2 / 0.27e2 * t519 * t330 * t177 + 0.2e2 / 0.9e1 * t176 * t731 * t85 + 0.1e2 / 0.9e1 * t727 * t185 + 0.5e1 / 0.3e1 * t26 * t1588);
  t1600 = t6 * t334 * t235;
  t1609 = t6 * t735 * t93 * t50;
  t1613 = t6 * t334 * t201 * t50;
  t1618 = 0.3e1 / 0.2e2 * t6 * t1592 * t30 * t50 - 0.11e2 / 0.18e3 * t337 * t230 + t1600 * t241 / 0.54e3 - 0.11e2 / 0.135e3 * t1473 + t1419 / 0.405e3 + 0.4e1 / 0.405e3 * t1296 - t1300 / 0.135e3 + t1609 / 0.5e1 - t1613 / 0.3e2 + t1461 / 0.5e1 - 0.2e1 / 0.15e2 * t1465 + 0.4e1 / 0.45e2 * t1469;
  t1626 = t742 * t106;
  t1633 = -t1256 / 0.3e2 + 0.4e1 / 0.45e2 * t1260 - t1267 - t1216 / 0.243e4 + 0.11e2 / 0.81e3 * t1303 - t1305 / 0.243e4 + t738 * t106 / 0.3e2 + t1626 / 0.45e2 + t337 * t223 / 0.54e3 - 0.2e1 / 0.135e3 * t1482 + t1484 / 0.405e3 + 0.2e1 / 0.45e2 * t1488;
  t1635 = my_piecewise3(t1, 0, t1618 + t1633);
  t1650 = t301 * t301;
  t1663 = my_piecewise5(t15, 0, t11, 0, t1525);
  t1667 = my_piecewise3(t60, 0, 0.4e2 / 0.81e2 * t1366 * t342 * t247 - 0.4e2 / 0.27e2 * t683 * t113 * t301 - 0.1e2 / 0.27e2 * t751 * t253 + 0.2e2 / 0.9e1 * t246 * t1650 + 0.2e2 / 0.9e1 * t297 * t693 - 0.1e2 / 0.27e2 * t597 * t347 * t247 + 0.2e2 / 0.9e1 * t246 * t760 * t113 + 0.1e2 / 0.9e1 * t756 * t253 + 0.5e1 / 0.3e1 * t62 * t1663);
  t1672 = t264 * t376;
  t1674 = t268 * t376;
  t1677 = t6 * t257 * t381;
  t1680 = t264 * t369;
  t1682 = t268 * t369;
  t1684 = t704 * t155;
  t1686 = t708 * t155;
  t1689 = t700 * t155 / 0.3e2 + t260 * t369 / 0.54e3 - 0.11e2 / 0.18e3 * t260 * t376 + 0.3e1 / 0.2e2 * t6 * t1667 * t30 * t76 - 0.11e2 / 0.135e3 * t1672 + 0.11e2 / 0.81e3 * t1674 + t1677 * t386 / 0.54e3 + t1680 / 0.405e3 - t1682 / 0.243e4 + 0.2e1 / 0.45e2 * t1684 - t1686 / 0.135e3 - 0.2e1 / 0.135e3 * t1555;
  t1694 = t6 * t764 * t93 * t76;
  t1698 = t6 * t351 * t201 * t76;
  t1707 = t379 * t201 * t76 * t208;
  t1708 = t1707 * t386;
  t1710 = t788 * t793;
  t1711 = t1710 * t386;
  t1713 = 0.4e1 / 0.405e3 * t1557 + t1553 / 0.45e2 + t1694 / 0.5e1 - t1698 / 0.3e2 + t1538 / 0.5e1 - 0.2e1 / 0.15e2 * t1542 + 0.4e1 / 0.45e2 * t1546 - t1396 / 0.3e2 + 0.4e1 / 0.45e2 * t1400 - t1405 - t1708 / 0.243e4 + t1711 / 0.405e3;
  t1715 = my_piecewise3(t55, 0, t1689 + t1713);
  tv4rho42 = 0.2e1 * t682 + 0.2e1 * t719 + 0.2e1 * t750 + 0.2e1 * t798 + t7 * (t1635 + t1715);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1736 = my_piecewise5(t11, 0, t15, 0, t1447 + t1448);
  t1740 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1270 * t803 * t85 - 0.1e2 / 0.9e1 * t722 * t278 - 0.1e2 / 0.9e1 * t634 * t330 * t85 + 0.1e2 / 0.3e1 * t637 * t330 + 0.1e2 / 0.3e1 * t274 * t731 + 0.1e2 / 0.9e1 * t176 * t810 * t85 + 0.5e1 / 0.3e1 * t26 * t1736);
  t1747 = t6 * t814 * t93 * t50;
  t1757 = 0.3e1 / 0.2e2 * t6 * t1740 * t30 * t50 + t1747 / 0.1e2 + t817 * t106 / 0.6e2 + 0.3e1 / 0.1e2 * t1609 - t1613 / 0.1e2 + t1626 / 0.3e2 - t1466 + 0.2e1 / 0.15e2 * t1469 - t1483 + 0.2e1 / 0.45e2 * t1260 - t1267 + 0.2e1 / 0.405e3 * t1296;
  t1758 = my_piecewise3(t1, 0, t1757);
  t1759 = t567 * t121;
  t1760 = t1759 * t896;
  t1762 = t567 * t117;
  t1765 = t794 * t829;
  t1767 = t846 * t793;
  t1768 = t1767 * t386;
  t1773 = t6 * t305 * t381;
  t1797 = my_piecewise5(t15, 0, t11, 0, -t1447 + t1525);
  t1801 = my_piecewise3(t60, 0, 0.4e2 / 0.81e2 * t1366 * t854 * t113 - 0.1e2 / 0.9e1 * t751 * t301 - 0.1e2 / 0.9e1 * t683 * t347 * t113 + 0.1e2 / 0.3e1 * t686 * t347 + 0.1e2 / 0.3e1 * t297 * t760 + 0.1e2 / 0.9e1 * t246 * t861 * t113 + 0.5e1 / 0.3e1 * t62 * t1797);
  t1808 = t6 * t865 * t93 * t76;
  t1811 = t123 * t834;
  t1813 = t123 * t841;
  t1816 = t1760 / 0.1215e4 + t1762 * t896 / 0.81e3 - 0.11e2 / 0.81e3 * t1765 + t1768 / 0.27e3 - t1708 / 0.81e3 + t1711 / 0.27e3 + t1773 * t386 / 0.18e3 - 0.11e2 / 0.54e3 * t789 * t829 - t1543 + 0.2e1 / 0.15e2 * t1546 + 0.3e1 / 0.1e2 * t1694 - t1698 / 0.1e2 + 0.3e1 / 0.2e2 * t6 * t1801 * t30 * t76 + t1808 / 0.1e2 + 0.2e1 / 0.45e2 * t1400 - t1405 - 0.11e2 / 0.81e3 * t1811 + 0.77e2 / 0.405e3 * t1813 + 0.11e2 / 0.27e3 * t1674;
  t1831 = t771 * t155;
  t1833 = t312 * t376;
  t1835 = t312 * t369;
  t1839 = t567 * t122;
  t1840 = t1839 * t885;
  t1842 = t1839 * t889;
  t1844 = t567 * t118;
  t1849 = t1680 / 0.27e3 - t1682 / 0.81e3 + t1684 / 0.15e2 - t1686 / 0.45e2 + t767 * t155 / 0.2e2 - 0.11e2 / 0.54e3 * t119 * t834 + 0.77e2 / 0.27e3 * t119 * t841 - 0.11e2 / 0.6e2 * t308 * t376 + t308 * t369 / 0.18e3 + t1831 / 0.3e2 - 0.11e2 / 0.9e2 * t1833 + t1835 / 0.27e3 - t1556 + 0.2e1 / 0.135e3 * t1557 - 0.11e2 / 0.9e2 * t1672 + t1840 / 0.405e3 + 0.2e1 / 0.1215e4 * t1842 + t1844 * t885 / 0.27e3 + t1844 * t889 / 0.405e3;
  t1851 = my_piecewise3(t55, 0, t1816 + t1849);
  tv4rho43 = 0.3e1 * t750 + 0.3e1 * t798 + t822 + t900 + t7 * (t1758 + t1851);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1856 = t325 * t325;
  t1861 = t330 * t330;
  t1868 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t527 + 0.24e2 * t1284);
  t1872 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t1270 * t1856 - 0.2e2 / 0.9e1 * t722 * t330 + 0.1e2 / 0.3e1 * t176 * t1861 + 0.4e2 / 0.9e1 * t274 * t810 + 0.5e1 / 0.3e1 * t26 * t1868);
  t1881 = my_piecewise3(t1, 0, 0.3e1 / 0.2e2 * t6 * t1872 * t30 * t50 + 0.2e1 / 0.5e1 * t1747 - t1613 / 0.5e1 + 0.8e1 / 0.45e2 * t1469 - t1267);
  t1883 = t824 * t361;
  t1884 = 0.1e1 / t1883;
  t1890 = t567 * t145;
  t1895 = t567 * t64 * t380 * t1197;
  t1896 = t360 * t360;
  t1899 = 0.1e1 / t69 / t824 / t433;
  t1901 = t366 * t366;
  t1902 = 0.1e1 / t1901;
  t1903 = t1896 * t1899 * t1902;
  t1908 = t6 * t351 * t381;
  t1914 = 0.1e1 / t68 / t1119;
  t1932 = t342 * t342;
  t1937 = t347 * t347;
  t1944 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t527 + 0.24e2 * t1378);
  t1948 = my_piecewise3(t60, 0, 0.4e2 / 0.81e2 * t1366 * t1932 - 0.2e2 / 0.9e1 * t751 * t347 + 0.1e2 / 0.3e1 * t246 * t1937 + 0.4e2 / 0.9e1 * t297 * t861 + 0.5e1 / 0.3e1 * t62 * t1944);
  t1961 = 0.4e1 / 0.1215e4 * t1760 - 0.11e2 / 0.405e3 * t892 * t893 * t877 * t1884 * t882 + 0.2e1 / 0.405e3 * t1890 * t896 + t1895 * t1903 * t1246 / 0.1215e4 + t1908 * t386 / 0.9e2 - 0.11e2 / 0.135e3 * t847 * t829 + 0.979e3 / 0.486e4 * t382 * t383 * t1914 * t367 * t32 - 0.22e2 / 0.405e3 * t1765 + 0.2e1 / 0.135e3 * t1768 + t1895 * t1200 * t1896 * t1899 * t1902 * t32 / 0.1215e4 + 0.11e2 / 0.729e4 * t1895 * t1903 * t1239 - t1708 / 0.405e3 + 0.3e1 / 0.2e2 * t6 * t1948 * t30 * t76 + 0.8e1 / 0.45e2 * t1546 - t1698 / 0.5e1 + 0.2e1 / 0.5e1 * t1808 - t1405 - 0.22e2 / 0.405e3 * t1811 + 0.308e3 / 0.405e3 * t1813 + t876 * t1326 * t1903 / 0.729e4;
  t1991 = t1884 * t882;
  t2000 = t567 * t146;
  t2007 = t868 * t155 / 0.15e2 + t354 * t369 / 0.9e2 - 0.11e2 / 0.135e3 * t147 * t834 + 0.154e3 / 0.135e3 * t147 * t841 - 0.11e2 / 0.3e2 * t354 * t376 + 0.979e3 / 0.486e4 * t78 * t213 * t360 * t1914 * t367 - 0.1309e4 / 0.81e3 * t78 * t99 * sigma[2] / t69 / t433 * t153 + 0.11e2 / 0.135e3 * t1674 - t1682 / 0.405e3 - 0.2e1 / 0.45e2 * t1686 + 0.2e1 / 0.15e2 * t1831 - 0.22e2 / 0.45e2 * t1833 + 0.2e1 / 0.135e3 * t1835 + 0.8e1 / 0.405e3 * t1557 - 0.11e2 / 0.135e3 * t876 * t878 * t1991 * t32 - 0.22e2 / 0.405e3 * t876 * t878 * t1991 * t582 + 0.2e1 / 0.135e3 * t2000 * t885 + 0.4e1 / 0.405e3 * t2000 * t889 + 0.4e1 / 0.405e3 * t1840 + 0.8e1 / 0.1215e4 * t1842;
  t2009 = my_piecewise3(t55, 0, t1961 + t2007);
  tv4rho44 = 0.4e1 * t822 + 0.4e1 * t900 + t7 * (t1881 + t2009);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2020 = t1190 * t952;
  t2022 = t1200 * t570;
  t2025 = 0.1e1 / t43 / t490 / t455;
  t2026 = t2025 * t1207;
  t2032 = t570 * t2025 * t1207;
  t2044 = t1215 * t413;
  t2046 = t487 * t910;
  t2052 = t1233 * t413;
  t2054 = t96 * t906;
  t2064 = t204 * t402;
  t2066 = t196 * t402;
  t2068 = 0.19e2 / 0.216e4 * t587 * t588 * t214 * t573 * t575 - t1193 * t952 / 0.72e3 - t2020 / 0.108e4 - t1199 * t2022 * t2026 * t32 / 0.324e4 - 0.11e2 / 0.1944e5 * t1199 * t2032 * t1239 - t1199 * t2026 * t1244 * t2022 / 0.324e4 + 0.3e1 / 0.16e3 * t513 * t910 - t1230 * t413 / 0.48e3 + t2044 / 0.216e4 + t2046 / 0.8e2 - 0.341e3 / 0.648e4 * t236 * t237 * t492 * t412 - t2052 / 0.36e3 + t2054 / 0.8e2 - 0.341e3 / 0.648e4 * t52 * t213 * sigma[0] * t492 * t221 - t568 * t1326 * t2032 / 0.1944e5 + t2064 / 0.216e4 - t2066 / 0.36e3;
  t2073 = t204 * t407;
  t2075 = t196 * t407;
  t2078 = t562 * t164 / 0.54e3;
  t2079 = t96 * t919;
  t2086 = t556 * t164;
  t2099 = t1342 * t941;
  t2101 = t1342 * t947;
  t2105 = t552 * t164;
  t2111 = -t192 * t402 / 0.48e3 + 0.3e1 / 0.16e3 * t91 * t906 - t2073 / 0.9e2 + t2075 / 0.15e2 - t2078 - 0.11e2 / 0.9e2 * t2079 + 0.77e2 / 0.27e3 * t52 * t98 * t39 * t499 * t104 + t2086 / 0.24e3 + 0.19e2 / 0.72e3 * t568 * t936 * t577 + 0.19e2 / 0.108e4 * t568 * t569 * t573 * t946 - t1356 * t941 / 0.24e3 - t1356 * t947 / 0.36e3 - t2099 / 0.36e3 - t2101 / 0.54e3 - 0.11e2 / 0.6e2 * t91 * t919 - t2105 / 0.8e2 + t192 * t407 / 0.2e2 - t538 * t164 / 0.16e3;
  t2113 = my_piecewise3(t1, 0, t2068 + t2111);
  tv4rho3sigma0 = t7 * t2113 + 0.3e1 * t956;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t2118 = t618 * t170;
  t2120 = t622 * t170;
  t2123 = t626 * t170 / 0.54e3;
  t2125 = my_piecewise3(t55, 0, -t614 * t170 / 0.16e3 - t2118 / 0.8e2 + t2120 / 0.24e3 - t2123);
  tv4rho3sigma2 = t7 * t2125 + 0.3e1 * t966;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2127 = 0.2e1 * t983;
  t2129 = t289 * t402 / 0.108e4;
  t2135 = t656 * t164 / 0.12e3;
  t2138 = t662 * t164;
  t2141 = t289 * t407 / 0.45e2;
  t2152 = t1418 * t413 / 0.108e4;
  t2155 = -t2129 + t136 * t906 / 0.16e3 - 0.11e2 / 0.18e3 * t136 * t919 - t2135 + t285 * t407 / 0.3e2 + t2138 / 0.72e3 + t2141 - t652 * t164 / 0.16e3 - t1501 * t941 / 0.72e3 - t1501 * t947 / 0.108e4 - t1413 * t952 / 0.216e4 - t2020 / 0.324e4 - t2152 + t2044 / 0.324e4 + t2046 / 0.24e3;
  t2173 = -t2052 / 0.108e4 + t671 * t910 / 0.16e3 - t1422 * t413 / 0.72e3 + t2054 / 0.24e3 - t285 * t402 / 0.72e3 + t2064 / 0.324e4 - t2066 / 0.108e4 - t2073 / 0.135e3 + t2075 / 0.45e2 - t2078 - 0.11e2 / 0.27e3 * t2079 + t2086 / 0.36e3 - t2099 / 0.108e4 - t2101 / 0.162e4 - t2105 / 0.24e3;
  t2175 = my_piecewise3(t1, 0, t2155 + t2173);
  tv4rho3sigma3 = t7 * t2175 + t2127 + t956;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2177 = 0.2e1 * t1003;
  t2181 = t704 * t170 / 0.12e3;
  t2182 = t708 * t170;
  t2189 = t264 * t438 / 0.108e4;
  t2190 = t268 * t438;
  t2195 = t264 * t443 / 0.45e2;
  t2196 = t268 * t443;
  t2201 = t1710 * t449 / 0.108e4;
  t2202 = t1707 * t449;
  t2204 = -t700 * t170 / 0.16e3 - t2181 + t2182 / 0.72e3 - t2118 / 0.24e3 + t2120 / 0.36e3 - t2123 - t260 * t438 / 0.144e4 - t2189 + t2190 / 0.648e4 + t260 * t443 / 0.6e2 + t2195 - t2196 / 0.27e3 - t1677 * t449 / 0.144e4 - t2201 + t2202 / 0.648e4;
  t2205 = my_piecewise3(t55, 0, t2204);
  tv4rho3sigma5 = t7 * t2205 + t2177 + t966;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2209 = t742 * t164;
  t2222 = -t738 * t164 / 0.16e3 - t2209 / 0.24e3 - t337 * t402 / 0.144e4 + t337 * t407 / 0.6e2 - t1600 * t413 / 0.144e4 - t2135 + t2138 / 0.36e3 - t2129 + t2141 - t2152 + t2086 / 0.72e3 - t2078 + t2064 / 0.648e4 - t2073 / 0.27e3 + t2044 / 0.648e4;
  t2223 = my_piecewise3(t1, 0, t2222);
  tv4rho3sigma6 = t7 * t2223 + t1010 + t2127;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2229 = t123 * t1016;
  t2232 = t312 * t438;
  t2246 = -t308 * t438 / 0.72e3 + t119 * t1016 / 0.16e3 + t2229 / 0.24e3 - t2189 + t2190 / 0.324e4 - t2232 / 0.108e4 - 0.11e2 / 0.18e3 * t119 * t1028 + t308 * t443 / 0.3e2 - t767 * t170 / 0.16e3 - t1844 * t1044 / 0.72e3 - t1844 * t1050 / 0.108e4 - t2181 + t2182 / 0.36e3 + t2195 - t2196 / 0.135e3;
  t2247 = t1839 * t1050;
  t2249 = t312 * t443;
  t2251 = t771 * t170;
  t2253 = t1839 * t1044;
  t2255 = t123 * t1028;
  t2258 = t1759 * t1055;
  t2262 = t794 * t1020;
  t2264 = t1767 * t449;
  t2271 = -t2247 / 0.162e4 + t2249 / 0.45e2 - t2251 / 0.24e3 - t2253 / 0.108e4 - 0.11e2 / 0.27e3 * t2255 + t2120 / 0.72e3 - t2123 - t2258 / 0.324e4 - t1762 * t1055 / 0.216e4 + t2262 / 0.24e3 - t2264 / 0.108e4 - t2201 + t2202 / 0.324e4 + t789 * t1020 / 0.16e3 - t1773 * t449 / 0.72e3;
  t2273 = my_piecewise3(t55, 0, t2246 + t2271);
  tv4rho3sigma8 = t7 * t2273 + t1059 + t2177;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2281 = my_piecewise3(t1, 0, -t817 * t164 / 0.16e3 - t2209 / 0.8e2 + t2138 / 0.24e3 - t2078);
  tv4rho3sigma9 = t7 * t2281 + 0.3e1 * t1010;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2291 = 0.1e1 / t69 / t824 / t469;
  t2293 = t877 * t2291 * t1902;
  t2328 = -0.341e3 / 0.648e4 * t78 * t213 * sigma[2] * t826 * t367 - t876 * t1326 * t2293 / 0.1944e5 - t354 * t438 / 0.48e3 + 0.3e1 / 0.16e3 * t147 * t1016 + t2229 / 0.8e2 + t2190 / 0.216e4 - t2232 / 0.36e3 - 0.11e2 / 0.6e2 * t147 * t1028 + t354 * t443 / 0.2e2 - t868 * t170 / 0.16e3 + 0.19e2 / 0.72e3 * t876 * t1039 * t884 + 0.19e2 / 0.108e4 * t876 * t569 * t880 * t1049 - t2000 * t1044 / 0.24e3 - t2000 * t1050 / 0.36e3 + 0.77e2 / 0.27e3 * t78 * t98 * t39 * t838 * t153 + t2182 / 0.24e3 - t2196 / 0.9e2;
  t2348 = t1200 * t877;
  t2349 = t2291 * t1902;
  t2366 = -t2247 / 0.54e3 + t2249 / 0.15e2 - t2251 / 0.8e2 - t2253 / 0.36e3 - 0.11e2 / 0.9e2 * t2255 - t2123 - t2258 / 0.108e4 + 0.19e2 / 0.216e4 * t892 * t893 * t360 * t880 * t882 - t1890 * t1055 / 0.72e3 - 0.341e3 / 0.648e4 * t382 * t237 * t826 * t448 + t2262 / 0.8e2 - t2264 / 0.36e3 - t1895 * t2348 * t2349 * t32 / 0.324e4 - 0.11e2 / 0.1944e5 * t1895 * t2293 * t1239 - t1895 * t2349 * t1244 * t2348 / 0.324e4 + 0.3e1 / 0.16e3 * t847 * t1020 - t1908 * t449 / 0.48e3 + t2202 / 0.216e4;
  t2368 = my_piecewise3(t55, 0, t2328 + t2366);
  tv4rho3sigma11 = t7 * t2368 + 0.3e1 * t1059;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2373 = t96 * t1089;
  t2378 = t196 * t464;
  t2383 = t204 * t464 / 0.1728e5;
  t2385 = 0.1e1 / t43 / t1183;
  t2387 = t214 * t2385 * t1207;
  t2391 = t1342 * t1080;
  t2398 = t1342 * t1093;
  t2403 = t192 * t464 / 0.384e4 - t2373 / 0.54e3 + 0.19e2 / 0.216e4 * t52 * t213 * t240 + t2378 / 0.288e4 - t91 * t1089 / 0.36e3 - t2383 + t568 * t1326 * t2387 / 0.5184e5 + t2391 / 0.144e4 - 0.43e2 / 0.576e4 * t568 * t944 * t1079 + t1356 * t1093 / 0.144e4 + t2398 / 0.216e4 - 0.43e2 / 0.864e4 * t568 * t944 * t1092;
  t2409 = t204 * t460 / 0.1728e5;
  t2410 = t96 * t1074;
  t2417 = t196 * t460;
  t2428 = t1190 * t1069;
  t2430 = t2385 * t1207;
  t2433 = t214 * t34 * t39;
  t2442 = t32 * t34 * t39;
  t2446 = t192 * t460 / 0.384e4 + t1356 * t1080 / 0.96e3 - t2409 - t2410 / 0.54e3 + 0.19e2 / 0.216e4 * t52 * t210 * t212 * t218 * t221 + t2417 / 0.288e4 - t91 * t1074 / 0.36e3 - 0.43e2 / 0.1728e5 * t587 * t588 * sigma[0] * t938 * t575 + t1193 * t1069 / 0.288e4 + t2428 / 0.432e4 + t1199 * t2430 * t1244 * t2433 / 0.864e4 + 0.11e2 / 0.5184e5 * t1199 * t2430 * t582 * t2433 + t1199 * t2387 * t2442 / 0.864e4;
  t2448 = my_piecewise3(t1, 0, t2403 + t2446);
  tv4rho2sigma20 = t7 * t2448 + 0.2e1 * t1097;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2453 = t264 * t474;
  t2456 = t268 * t474 / 0.1728e5;
  t2459 = t264 * t478;
  t2462 = t268 * t478 / 0.1728e5;
  t2464 = my_piecewise3(t55, 0, t260 * t474 / 0.384e4 + t2453 / 0.288e4 - t2456 + t260 * t478 / 0.384e4 + t2459 / 0.288e4 - t2462);
  tv4rho2sigma25 = t7 * t2464 + 0.2e1 * t1108;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2468 = t289 * t460;
  t2482 = t289 * t464;
  t2491 = t285 * t460 / 0.384e4 + t2468 / 0.576e4 + t1413 * t1069 / 0.576e4 - t136 * t1074 / 0.72e3 + t1501 * t1080 / 0.192e4 + t2417 / 0.576e4 - t2409 + t2428 / 0.864e4 - t2410 / 0.108e4 + t2391 / 0.288e4 + t285 * t464 / 0.384e4 + t2482 / 0.576e4 - t136 * t1089 / 0.72e3 + t1501 * t1093 / 0.288e4 + t2378 / 0.576e4 - t2383 - t2373 / 0.108e4 + t2398 / 0.432e4;
  t2492 = my_piecewise3(t1, 0, t2491);
  tv4rho2sigma26 = t7 * t2492 + t1097 + t1115;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2496 = t312 * t474;
  t2501 = t1759 * t1123;
  t2505 = t123 * t1128;
  t2509 = t1839 * t1134;
  t2513 = t312 * t478;
  t2518 = t123 * t1141;
  t2522 = t1839 * t1145;
  t2524 = t308 * t474 / 0.384e4 + t2496 / 0.576e4 + t2453 / 0.576e4 - t2456 + t1762 * t1123 / 0.576e4 + t2501 / 0.864e4 - t119 * t1128 / 0.72e3 - t2505 / 0.108e4 + t1844 * t1134 / 0.192e4 + t2509 / 0.288e4 + t308 * t478 / 0.384e4 + t2513 / 0.576e4 + t2459 / 0.576e4 - t2462 - t119 * t1141 / 0.72e3 - t2518 / 0.108e4 + t1844 * t1145 / 0.288e4 + t2522 / 0.432e4;
  t2525 = my_piecewise3(t55, 0, t2524);
  tv4rho2sigma211 = t7 * t2525 + t1108 + t1149;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2535 = my_piecewise3(t1, 0, t337 * t460 / 0.384e4 + t2468 / 0.288e4 - t2409 + t337 * t464 / 0.384e4 + t2482 / 0.288e4 - t2383);
  tv4rho2sigma212 = t7 * t2535 + 0.2e1 * t1115;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2541 = 0.1e1 / t69 / t1883;
  t2543 = t360 * t2541 * t1902;
  t2564 = t354 * t478 / 0.384e4 + t876 * t1326 * t2543 / 0.5184e5 + 0.19e2 / 0.216e4 * t78 * t213 * t385 - t147 * t1141 / 0.36e3 + t2513 / 0.288e4 - t2518 / 0.54e3 - t2462 - t2505 / 0.54e3 + t2509 / 0.144e4 + t2522 / 0.216e4 + 0.19e2 / 0.216e4 * t78 * t210 * t212 * t364 * t367 - t147 * t1128 / 0.36e3;
  t2586 = t2541 * t1902;
  t2589 = t360 * t34 * t39;
  t2600 = t2000 * t1145 / 0.144e4 - 0.43e2 / 0.864e4 * t876 * t1047 * t1144 + t354 * t474 / 0.384e4 + t2000 * t1134 / 0.96e3 - 0.43e2 / 0.576e4 * t876 * t1047 * t1133 - t2456 + t2496 / 0.288e4 + t2501 / 0.432e4 - 0.43e2 / 0.1728e5 * t892 * t893 * sigma[2] * t1041 * t882 + t1890 * t1123 / 0.288e4 + t1895 * t2586 * t1244 * t2589 / 0.864e4 + t1895 * t2543 * t2442 / 0.864e4 + 0.11e2 / 0.5184e5 * t1895 * t2586 * t582 * t2589;
  t2602 = my_piecewise3(t55, 0, t2564 + t2600);
  tv4rho2sigma217 = t7 * t2602 + 0.2e1 * t1149;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2607 = t1190 * t1153 / 0.2304e5;
  t2609 = 0.1e1 / t43 / t572;
  t2615 = t1066 * t575;
  t2619 = t2609 * t1207;
  t2621 = t1200 * sigma[0];
  t2628 = t1190 * t1157 / 0.768e4;
  t2640 = t1190 * t1161 / 0.1152e5;
  t2649 = -t1193 * t1153 / 0.1536e5 - t2607 - t568 * t1326 * sigma[0] * t2609 * t1207 / 0.13824e6 + t587 * t588 * t2615 / 0.192e4 - t1199 * t2619 * t32 * t2621 / 0.2304e5 - t1193 * t1157 / 0.512e4 - t2628 + t587 * t588 * t2615 * t32 / 0.64e3 - 0.11e2 / 0.13824e6 * t1199 * t2619 * t582 * t2621 - t1193 * t1161 / 0.768e4 - t2640 + t587 * t588 * t2615 * t582 / 0.96e3 - t1199 * t2619 * t1244 * t2621 / 0.2304e5;
  t2650 = my_piecewise3(t1, 0, t2649);
  tv4rhosigma30 = t7 * t2650 + t1165;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2655 = t1759 * t1168 / 0.2304e5;
  t2659 = t1759 * t1172 / 0.768e4;
  t2663 = t1759 * t1176 / 0.1152e5;
  t2665 = my_piecewise3(t55, 0, -t1762 * t1168 / 0.1536e5 - t2655 - t1762 * t1172 / 0.512e4 - t2659 - t1762 * t1176 / 0.768e4 - t2663);
  tv4rhosigma39 = t7 * t2665 + t1180;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2674 = my_piecewise3(t1, 0, -t1413 * t1153 / 0.1536e5 - t2607 - t1413 * t1157 / 0.512e4 - t2628 - t1413 * t1161 / 0.768e4 - t2640);
  tv4rhosigma310 = t7 * t2674 + t1165;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2679 = 0.1e1 / t69 / t879;
  t2685 = t1120 * t882;
  t2689 = t2679 * t1902;
  t2691 = t1200 * sigma[2];
  t2715 = -t1890 * t1168 / 0.1536e5 - t2655 - t876 * t1326 * sigma[2] * t2679 * t1902 / 0.13824e6 + t892 * t893 * t2685 / 0.192e4 - t1895 * t2689 * t32 * t2691 / 0.2304e5 - t1890 * t1172 / 0.512e4 - t2659 + t892 * t893 * t2685 * t32 / 0.64e3 - 0.11e2 / 0.13824e6 * t1895 * t2689 * t582 * t2691 - t1890 * t1176 / 0.768e4 - t2663 + t892 * t893 * t2685 * t582 / 0.96e3 - t1895 * t2689 * t1244 * t2691 / 0.2304e5;
  t2716 = my_piecewise3(t55, 0, t2715);
  tv4rhosigma319 = t7 * t2716 + t1180;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2719 = 0.1e1 / t43 / t937;
  t2726 = t1197 * t2719 * t1207;
  t2737 = my_piecewise3(t1, 0, t568 * t1325 * t39 * t2719 * t1207 / 0.36864e6 + t568 * t2726 * t2442 / 0.6144e5 + 0.11e2 / 0.36864e6 * t568 * t2726 * t1239 + t568 * t2726 * t1246 / 0.6144e5);
  tv4sigma40 = t7 * t2737;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2739 = 0.1e1 / t69 / t1040;
  t2746 = t1197 * t2739 * t1902;
  t2757 = my_piecewise3(t55, 0, t876 * t1325 * t39 * t2739 * t1902 / 0.36864e6 + t876 * t2746 * t2442 / 0.6144e5 + 0.11e2 / 0.36864e6 * t876 * t2746 * t1239 + t876 * t2746 * t1246 / 0.6144e5);
  tv4sigma414 = t7 * t2757;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

