//start of PreLzsDecoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLzsDecoder.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;

/**
 * -lzs- 𓀗p PreLzssDecoderB
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLzsDecoder.java,v $
 * Revision 1.1  2002/12/06 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     -lzs-  MaxMatch  17 łׂ 16 ƂȂĂ̂CB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PreLzsDecoder implements PreLzssDecoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 2048;

    /** őv */
    private static final int MaxMatch       = 17;

    /** ŏv */
    private static final int Threshold      = 2;


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  bit length
    //------------------------------------------------------------------
    //  private static final int OffsetBits
    //  private static final int LengthBits
    //------------------------------------------------------------------
    /** vʒũrbg */
    private static final int OffsetBits = Bits.len( PreLzsDecoder.DictionarySize - 1 );

    /** ṽrbg */
    private static final int LengthBits = Bits.len( PreLzsDecoder.MaxMatch - PreLzsDecoder.Threshold );


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private BitInputStream in
    //------------------------------------------------------------------
    /**
     * -lzs- `̈kf[^ BitInputStream
     */
    private BitInputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //  private int matchOffset
    //  private int matchLength
    //------------------------------------------------------------------
    /** 
     * ݏʒuB
     * LzssInputStream̓Ԃ擾łȂ߂ɑ݂B
     * LzssInputStream̓NXƂď΁Aposition͕KvB
     */
    private int position;

    /** łVLzssR[ḧvʒu */
    private int matchOffset;

    /**
     * łVLzssR[ḧv
     * LzssInputStream̓Ԃ擾łȂ߂ɑ݂B
     * LzssInputStream̓NXƂď΁AmatchLength͕KvB
     */
    private int matchLength;


    //------------------------------------------------------------------
    //  member values
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private int markPosition
    //  private int markMatchOffset
    //  private int markMatchLength
    //------------------------------------------------------------------
    /** matchPositioñobNAbvp */
    private int markPosition;

    /** matchPositioñobNAbvp */
    private int markMatchOffset;

    /** matchLength̃obNAbvp */
    private int markMatchLength;


    //------------------------------------------------------------------
    //  constructers
    //------------------------------------------------------------------
    //  public PreLzsDecoder( InputStream in )
    //------------------------------------------------------------------
    /**
     * -lzs- 𓀗p PreLzssDecoder \zB
     * 
     * @param in -lzs- `̈kf[^̓Xg[
     */
    public PreLzsDecoder( InputStream in ){
        if( in != null ){
            if( in instanceof BitInputStream ){
                this.in = (BitInputStream)in;
            }else{
                this.in = new BitInputStream( in );
            }
            this.position    = 0;
            this.matchOffset = 0;
            this.matchLength = 0;
        }else{
            throw new NullPointerException( "in" );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lzs- ňkꂽ
     * 1byte  LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^́A
     *         kꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int readCode() throws IOException {
        try{
            if( this.in.readBoolean() ){
                this.position++;
                return this.in.readBits( 8 );
            }else{
                this.matchOffset = this.in.readBits( this.OffsetBits );
                this.matchLength = this.in.readBits( this.LengthBits );
                return this.matchLength | 0x100;
            }
        }catch( BitDataBrokenException exception ){
            if( exception.getCause() instanceof EOFException )
                throw (EOFException)exception.getCause();
            else
                throw exception;
        }
    }

    /**
     * -lzs- ňkꂽkR[ĥ
     * vʒuǂݍށB<br>
     * 
     * @return -lzs- ňkꂽkR[ĥvʒu
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int readOffset() throws IOException {
        int offset = ( this.position - this.matchOffset - 1
                     - PreLzsDecoder.MaxMatch )
                   & ( PreLzsDecoder.DictionarySize - 1 );

        this.position += this.matchLength + PreLzsDecoder.Threshold;
        return offset;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark / reset 
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢAreadLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\
     * 鎖ɒӂ邱ƁB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){
        this.in.mark( ( readLimit * 9 + 7 ) / 8 + 1 );
        this.markPosition    = this.position;
        this.markMatchOffset = this.matchOffset;
        this.markMatchLength = this.matchLength;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     * &emsp;&emsp; (1) mark()  reset() 悤ƂꍇB<br>
     * &emsp;&emsp; (2) ڑꂽ̓Xg[ markSupported()
     *                  false ԂꍇB<br>
     * &emsp;&emsp; (3) ڑꂽ̓Xg[
     *                  o̓G[ꍇB<br>
     * &emsp;&emsp; ̉ꂩB
     */
    public void reset() throws IOException {
        //mark()Ȃ reset()悤ƂꍇA
        //ڑꂽ InputStream  mark/resetT|[gȂꍇ
        //BitInputStream  reset()ɂ IOExceptionB
        this.in.reset();                                                        //throws IOException

        this.position    = this.markPosition;
        this.matchOffset = this.markMatchOffset;
        this.matchLength = this.markMatchLength;
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * InputStream  available() ƈႢA
     * ̍ŒoCg͕ۏ؂B<br>
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        return Math.max( this.in.availableBits() / 9 - 2, 0 );
    }

    /**
     * ̏o͂ƃXg[
     * ڑĂXg[A
     * gpĂ\[XB
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();

        this.in = null;
    }

    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PreLzssDecoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lzs-` LZSS̃TCY𓾂B
     * 
     * @return -lzs-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PreLzsDecoder.DictionarySize;
    }

    /**
     * -lzs-` LZSS̍Œv𓾂B
     * 
     * @return -lzs-` LZSS̍Œv
     */
    public int getMaxMatch(){
        return PreLzsDecoder.MaxMatch;
    }

    /**
     * -lzs-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lzs-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PreLzsDecoder.Threshold;
    }

}
//end of PreLzsDecoder.java
