## API Report File for "@lumino/datastore"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { IIterable } from '@lumino/algorithm';
import { IIterator } from '@lumino/algorithm';
import { IMessageHandler } from '@lumino/messaging';
import { ISignal } from '@lumino/signaling';
import { IterableOrArrayLike } from '@lumino/algorithm';
import { Message } from '@lumino/messaging';
import { ReadonlyJSONValue } from '@lumino/coreutils';

// @public
export type AnyField = Field<ReadonlyJSONValue, ReadonlyJSONValue, ReadonlyJSONValue, ReadonlyJSONValue, ReadonlyJSONValue>;

// @public
export class Datastore implements IDisposable, IIterable<Table<Schema>>, IMessageHandler {
    readonly adapter: IServerAdapter | null;
    beginTransaction(): string;
    readonly changed: ISignal<Datastore, Datastore.IChangedArgs>;
    static create(options: Datastore.IOptions): Datastore;
    dispose(): void;
    endTransaction(): void;
    get<S extends Schema>(schema: S): Table<S>;
    readonly id: number;
    readonly inTransaction: boolean;
    readonly isDisposed: boolean;
    iter(): IIterator<Table<Schema>>;
    processMessage(msg: Message): void;
    redo(transactionId: string): Promise<void>;
    toString(): string;
    undo(transactionId: string): Promise<void>;
    readonly version: number;
}

// @public
export namespace Datastore {
    export type Change = {
        readonly [schemaId: string]: Table.Change<Schema>;
    };
    // Warning: (ae-forgotten-export) The symbol "Private" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    export type Context = Readonly<Private.MutableContext>;
    export type DataLocation = {
        datastore: Datastore;
    };
    export type FieldLocation<S extends Schema, F extends keyof S['fields']> = RecordLocation<S> & {
        field: F;
    };
    export function getField<S extends Schema, F extends keyof S['fields']>(datastore: Datastore, loc: FieldLocation<S, F>): S['fields'][F]['ValueType'];
    export function getRecord<S extends Schema>(datastore: Datastore, loc: RecordLocation<S>): Record.Value<S> | undefined;
    export function getTable<S extends Schema>(datastore: Datastore, loc: TableLocation<S>): Table<S>;
    export interface IChangedArgs {
        readonly change: Change;
        readonly storeId: number;
        readonly transactionId: string;
        readonly type: TransactionType;
    }
    export interface IOptions {
        adapter?: IServerAdapter;
        id: number;
        restoreState?: string;
        schemas: ReadonlyArray<Schema>;
        transactionIdFactory?: TransactionIdFactory;
    }
    export function listenField<S extends Schema, F extends keyof S['fields']>(datastore: Datastore, loc: FieldLocation<S, F>, slot: (source: Datastore, args: S['fields'][F]['ChangeType']) => void, thisArg?: any): IDisposable;
    export function listenRecord<S extends Schema>(datastore: Datastore, loc: RecordLocation<S>, slot: (source: Datastore, args: Record.Change<S>) => void, thisArg?: any): IDisposable;
    export function listenTable<S extends Schema>(datastore: Datastore, loc: TableLocation<S>, slot: (source: Datastore, args: Table.Change<S>) => void, thisArg?: any): IDisposable;
    // @internal (undocumented)
    export type MutableChange = {
        [schemaId: string]: Table.MutableChange<Schema>;
    };
    // @internal (undocumented)
    export type MutablePatch = {
        [schemaId: string]: Table.MutablePatch<Schema>;
    };
    export type Patch = {
        readonly [schemaId: string]: Table.Patch<Schema>;
    };
    export type RecordLocation<S extends Schema> = TableLocation<S> & {
        record: string;
    };
    export type TableLocation<S extends Schema> = {
        schema: S;
    };
    export type Transaction = {
        readonly id: string;
        readonly storeId: number;
        readonly patch: Patch;
        readonly version: number;
    };
    export type TransactionIdFactory = (version: number, storeId: number) => string;
    export type TransactionType = 'transaction' | 'undo' | 'redo';
    export function updateField<S extends Schema, F extends keyof S['fields']>(datastore: Datastore, loc: FieldLocation<S, F>, update: S['fields'][F]['UpdateType']): void;
    export function updateRecord<S extends Schema>(datastore: Datastore, loc: RecordLocation<S>, update: Record.Update<S>): void;
    export function updateTable<S extends Schema>(datastore: Datastore, loc: TableLocation<S>, update: Table.Update<S>): void;
    export function withTransaction(datastore: Datastore, update: (id: string) => void): string;
}

// @public
export abstract class Field<Value extends ReadonlyJSONValue, Update extends ReadonlyJSONValue, Metadata extends ReadonlyJSONValue, Change extends ReadonlyJSONValue, Patch extends ReadonlyJSONValue> {
    constructor(options?: Field.IOptions);
    abstract applyPatch(args: Field.PatchArgs<Value, Patch, Metadata>): Field.PatchResult<Value, Change>;
    abstract applyUpdate(args: Field.UpdateArgs<Value, Update, Metadata>): Field.UpdateResult<Value, Change, Patch>;
    readonly ChangeType: Change;
    abstract createMetadata(): Metadata;
    abstract createValue(): Value;
    readonly description: string;
    abstract mergeChange(first: Change, second: Change): Change;
    abstract mergePatch(first: Patch, second: Patch): Patch;
    readonly MetadataType: Metadata;
    readonly PatchType: Patch;
    abstract readonly type: string;
    abstract unapplyPatch(args: Field.PatchArgs<Value, Patch, Metadata>): Field.PatchResult<Value, Change>;
    readonly UpdateType: Update;
    readonly ValueType: Value;
}

// @public
export namespace Field {
    export interface IOptions {
        description?: string;
    }
    export type PatchArgs<Value, Patch, Metadata> = {
        readonly previous: Value;
        readonly patch: Patch;
        readonly metadata: Metadata;
    };
    export type PatchResult<Value, Change> = {
        readonly value: Value;
        readonly change: Change;
    };
    export type UpdateArgs<Value, Update, Metadata> = {
        readonly previous: Value;
        readonly update: Update;
        readonly metadata: Metadata;
        readonly version: number;
        readonly storeId: number;
    };
    export type UpdateResult<Value, Change, Patch> = {
        readonly value: Value;
        readonly change: Change;
        readonly patch: Patch;
    };
}

// @public
export namespace Fields {
    export function Boolean(options?: Partial<RegisterField.IOptions<boolean>>): RegisterField<boolean>;
    export function List<T extends ReadonlyJSONValue>(options?: ListField.IOptions<T>): ListField<T>;
    export function Map<T extends ReadonlyJSONValue>(options?: MapField.IOptions<T>): MapField<T>;
    export function Number(options?: Partial<RegisterField.IOptions<number>>): RegisterField<number>;
    export function Register<T extends ReadonlyJSONValue>(options: RegisterField.IOptions<T>): RegisterField<T>;
    export function String(options?: Partial<RegisterField.IOptions<string>>): RegisterField<string>;
    export function Text(options?: TextField.IOptions): TextField;
}

// @public
export interface IServerAdapter extends IDisposable {
    broadcast(transaction: Datastore.Transaction): void;
    onRedo: ((transaction: Datastore.Transaction) => void) | null;
    onRemoteTransaction: ((transaction: Datastore.Transaction) => void) | null;
    onUndo: ((transaction: Datastore.Transaction) => void) | null;
    redo(id: string): Promise<void>;
    undo(id: string): Promise<void>;
}

// @public
export class ListField<T extends ReadonlyJSONValue> extends Field<ListField.Value<T>, ListField.Update<T>, ListField.Metadata<T>, ListField.Change<T>, ListField.Patch<T>> {
    constructor(options?: ListField.IOptions<T>);
    applyPatch(args: Field.PatchArgs<ListField.Value<T>, ListField.Patch<T>, ListField.Metadata<T>>): Field.PatchResult<ListField.Value<T>, ListField.Change<T>>;
    applyUpdate(args: Field.UpdateArgs<ListField.Value<T>, ListField.Update<T>, ListField.Metadata<T>>): Field.UpdateResult<ListField.Value<T>, ListField.Change<T>, ListField.Patch<T>>;
    createMetadata(): ListField.Metadata<T>;
    createValue(): ListField.Value<T>;
    mergeChange(first: ListField.Change<T>, second: ListField.Change<T>): ListField.Change<T>;
    mergePatch(first: ListField.Patch<T>, second: ListField.Patch<T>): ListField.Patch<T>;
    readonly type: 'list';
    unapplyPatch(args: Field.PatchArgs<ListField.Value<T>, ListField.Patch<T>, ListField.Metadata<T>>): Field.PatchResult<ListField.Value<T>, ListField.Change<T>>;
}

// @public
export namespace ListField {
    export type Change<T extends ReadonlyJSONValue> = ReadonlyArray<ChangePart<T>>;
    export type ChangePart<T extends ReadonlyJSONValue> = {
        readonly index: number;
        readonly removed: ReadonlyArray<T>;
        readonly inserted: ReadonlyArray<T>;
    };
    export interface IOptions<T extends ReadonlyJSONValue> extends Field.IOptions {
    }
    export type Metadata<T extends ReadonlyJSONValue> = {
        readonly ids: Array<string>;
        readonly cemetery: {
            [id: string]: number;
        };
    };
    export type Patch<T extends ReadonlyJSONValue> = ReadonlyArray<PatchPart<T>>;
    export type PatchPart<T extends ReadonlyJSONValue> = {
        readonly removedIds: ReadonlyArray<string>;
        readonly removedValues: ReadonlyArray<T>;
        readonly insertedIds: ReadonlyArray<string>;
        readonly insertedValues: ReadonlyArray<T>;
    };
    export type Splice<T extends ReadonlyJSONValue> = {
        readonly index: number;
        readonly remove: number;
        readonly values: ReadonlyArray<T>;
    };
    export type Update<T extends ReadonlyJSONValue> = Splice<T> | ReadonlyArray<Splice<T>>;
    export type Value<T extends ReadonlyJSONValue> = ReadonlyArray<T>;
}

// @public
export class MapField<T extends ReadonlyJSONValue> extends Field<MapField.Value<T>, MapField.Update<T>, MapField.Metadata<T>, MapField.Change<T>, MapField.Patch<T>> {
    constructor(options?: MapField.IOptions<T>);
    applyPatch(args: Field.PatchArgs<MapField.Value<T>, MapField.Patch<T>, MapField.Metadata<T>>): Field.PatchResult<MapField.Value<T>, MapField.Change<T>>;
    applyUpdate(args: Field.UpdateArgs<MapField.Value<T>, MapField.Update<T>, MapField.Metadata<T>>): Field.UpdateResult<MapField.Value<T>, MapField.Change<T>, MapField.Patch<T>>;
    createMetadata(): MapField.Metadata<T>;
    createValue(): MapField.Value<T>;
    mergeChange(first: MapField.Change<T>, second: MapField.Change<T>): MapField.Change<T>;
    mergePatch(first: MapField.Patch<T>, second: MapField.Patch<T>): MapField.Patch<T>;
    readonly type: 'map';
    unapplyPatch(args: Field.PatchArgs<MapField.Value<T>, MapField.Patch<T>, MapField.Metadata<T>>): Field.PatchResult<MapField.Value<T>, MapField.Change<T>>;
}

// @public
export namespace MapField {
    export type Change<T extends ReadonlyJSONValue> = {
        readonly previous: {
            readonly [key: string]: T | null;
        };
        readonly current: {
            readonly [key: string]: T | null;
        };
    };
    export interface IOptions<T extends ReadonlyJSONValue> extends Field.IOptions {
    }
    export type Metadata<T extends ReadonlyJSONValue> = {
        readonly ids: {
            [key: string]: Array<string>;
        };
        readonly values: {
            [key: string]: Array<T | null>;
        };
    };
    export type Patch<T extends ReadonlyJSONValue> = {
        readonly id: string;
        readonly values: {
            readonly [key: string]: T | null;
        };
    };
    export type Update<T extends ReadonlyJSONValue> = {
        readonly [key: string]: T | null;
    };
    export type Value<T extends ReadonlyJSONValue> = {
        readonly [key: string]: T;
    };
}

// @public
export type Record<S extends Schema> = Record.Base<S> & Record.Value<S>;

// @public
export namespace Record {
    export type Base<S extends Schema> = {
        readonly $id: string;
        readonly '@@metadata': Metadata<S>;
    };
    export type Change<S extends Schema> = {
        readonly [N in keyof S['fields']]?: S['fields'][N]['ChangeType'];
    };
    // @internal
    export type Metadata<S extends Schema> = {
        readonly [N in keyof S['fields']]: S['fields'][N]['MetadataType'];
    };
    // @internal
    export type MutableChange<S extends Schema> = {
        [N in keyof S['fields']]?: S['fields'][N]['ChangeType'];
    };
    // @internal
    export type MutablePatch<S extends Schema> = {
        [N in keyof S['fields']]?: S['fields'][N]['PatchType'];
    };
    export type Patch<S extends Schema> = {
        readonly [N in keyof S['fields']]?: S['fields'][N]['PatchType'];
    };
    export type Update<S extends Schema> = {
        readonly [N in keyof S['fields']]?: S['fields'][N]['UpdateType'];
    };
    export type Value<S extends Schema> = {
        readonly [N in keyof S['fields']]: S['fields'][N]['ValueType'];
    };
}

// @public
export class RegisterField<T extends ReadonlyJSONValue> extends Field<RegisterField.Value<T>, RegisterField.Update<T>, RegisterField.Metadata<T>, RegisterField.Change<T>, RegisterField.Patch<T>> {
    constructor(options: RegisterField.IOptions<T>);
    applyPatch(args: Field.PatchArgs<RegisterField.Value<T>, RegisterField.Patch<T>, RegisterField.Metadata<T>>): Field.PatchResult<RegisterField.Value<T>, RegisterField.Change<T>>;
    applyUpdate(args: Field.UpdateArgs<RegisterField.Value<T>, RegisterField.Update<T>, RegisterField.Metadata<T>>): Field.UpdateResult<RegisterField.Value<T>, RegisterField.Change<T>, RegisterField.Patch<T>>;
    createMetadata(): RegisterField.Metadata<T>;
    createValue(): RegisterField.Value<T>;
    mergeChange(first: RegisterField.Change<T>, second: RegisterField.Change<T>): RegisterField.Change<T>;
    mergePatch(first: RegisterField.Patch<T>, second: RegisterField.Patch<T>): RegisterField.Patch<T>;
    readonly type: 'register';
    unapplyPatch(args: Field.PatchArgs<RegisterField.Value<T>, RegisterField.Patch<T>, RegisterField.Metadata<T>>): Field.PatchResult<RegisterField.Value<T>, RegisterField.Change<T>>;
    readonly value: T;
}

// @public
export namespace RegisterField {
    export type Change<T extends ReadonlyJSONValue> = {
        readonly previous: T;
        readonly current: T;
    };
    export interface IOptions<T extends ReadonlyJSONValue> extends Field.IOptions {
        value: T;
    }
    export type Metadata<T extends ReadonlyJSONValue> = {
        readonly ids: Array<string>;
        readonly values: Array<T>;
    };
    export type Patch<T extends ReadonlyJSONValue> = {
        readonly id: string;
        readonly value: T;
    };
    export type Update<T extends ReadonlyJSONValue> = T;
    export type Value<T extends ReadonlyJSONValue> = T;
}

// @public
export type Schema = {
    readonly id: string;
    readonly fields: {
        readonly [name: string]: AnyField;
    };
};

// @public
export class Table<S extends Schema> implements IIterable<Record<S>> {
    // @internal
    static create<U extends Schema>(schema: U, context: Datastore.Context): Table<U>;
    get(id: string): Record<S> | undefined;
    has(id: string): boolean;
    readonly isEmpty: boolean;
    iter(): IIterator<Record<S>>;
    // @internal
    static patch<U extends Schema>(table: Table<U>, data: Table.Patch<U>): Table.Change<U>;
    // @internal
    static recreate<U extends Schema>(schema: U, context: Datastore.Context, records: IterableOrArrayLike<Record<U>>): Table<U>;
    readonly schema: S;
    readonly size: number;
    // @internal
    static unpatch<U extends Schema>(table: Table<U>, data: Table.Patch<U>): Table.Change<U>;
    update(data: Table.Update<S>): void;
}

// @public
export namespace Table {
    export type Change<S extends Schema> = {
        readonly [recordId: string]: Record.Change<S>;
    };
    // @internal
    export type MutableChange<S extends Schema> = {
        [recordId: string]: Record.MutableChange<S>;
    };
    // @internal
    export type MutablePatch<S extends Schema> = {
        [recordId: string]: Record.MutablePatch<S>;
    };
    export type Patch<S extends Schema> = {
        readonly [recordId: string]: Record.Patch<S>;
    };
    export type Update<S extends Schema> = {
        readonly [recordId: string]: Record.Update<S>;
    };
}

// @public
export class TextField extends Field<TextField.Value, TextField.Update, TextField.Metadata, TextField.Change, TextField.Patch> {
    constructor(options?: TextField.IOptions);
    applyPatch(args: Field.PatchArgs<TextField.Value, TextField.Patch, TextField.Metadata>): Field.PatchResult<TextField.Value, TextField.Change>;
    applyUpdate(args: Field.UpdateArgs<TextField.Value, TextField.Update, TextField.Metadata>): Field.UpdateResult<TextField.Value, TextField.Change, TextField.Patch>;
    createMetadata(): TextField.Metadata;
    createValue(): TextField.Value;
    mergeChange(first: TextField.Change, second: TextField.Change): TextField.Change;
    mergePatch(first: TextField.Patch, second: TextField.Patch): TextField.Patch;
    readonly type: 'text';
    unapplyPatch(args: Field.PatchArgs<TextField.Value, TextField.Patch, TextField.Metadata>): Field.PatchResult<TextField.Value, TextField.Change>;
}

// @public
export namespace TextField {
    export type Change = ReadonlyArray<ChangePart>;
    export type ChangePart = {
        readonly index: number;
        readonly removed: string;
        readonly inserted: string;
    };
    export interface IOptions extends Field.IOptions {
    }
    export type Metadata = {
        readonly ids: Array<string>;
        readonly cemetery: {
            [id: string]: number;
        };
    };
    export type Patch = ReadonlyArray<PatchPart>;
    export type PatchPart = {
        readonly removedIds: ReadonlyArray<string>;
        readonly removedText: string;
        readonly insertedIds: ReadonlyArray<string>;
        readonly insertedText: string;
    };
    export type Splice = {
        readonly index: number;
        readonly remove: number;
        readonly text: string;
    };
    export type Update = Splice | ReadonlyArray<Splice>;
    export type Value = string;
}

// @public
export function validateSchema(schema: Schema): string[];


// (No @packageDocumentation comment for this package)

```
