; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --check-globals
; RUN: opt -passes=ipsccp -S %s | FileCheck %s

; Test cases to ensure argmemonly/inaccessiblemem_or_argmemonly attributes are
; dropped, if a function argument is replaced by a constant.
;
; PR46717

@g = internal global i32 0

; Here the pointer argument %arg will be replaced by a constant. We need to
; drop argmemonly.
;.
; CHECK: @[[G:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0
;.
define internal void @ptrarg.1(ptr %arg, i32 %val) argmemonly nounwind {
; CHECK: Function Attrs: nounwind memory(readwrite, inaccessiblemem: none)
; CHECK-LABEL: @ptrarg.1(
; CHECK-NEXT:    store i32 10, ptr @g, align 4
; CHECK-NEXT:    ret void
;
  store i32 %val, ptr %arg
  ret void
}

define i32 @caller.1(i32 %n) {
; CHECK-LABEL: @caller.1(
; CHECK-NEXT:    store i32 1, ptr @g, align 4
; CHECK-NEXT:    tail call void @ptrarg.1(ptr @g, i32 10)
; CHECK-NEXT:    [[G_VAL:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    ret i32 [[G_VAL]]
;
  store i32 1, ptr @g
  tail call void @ptrarg.1(ptr @g, i32 10)
  %g.val = load i32, ptr @g
  ret i32 %g.val
}


; Here only the non-pointer argument %val is replaced, no need
; to drop the argmemonly attribute.
define internal void @ptrarg.2(ptr %arg, i32 %val) argmemonly nounwind {
; CHECK: Function Attrs: nounwind memory(argmem: readwrite)
; CHECK-LABEL: @ptrarg.2(
; CHECK-NEXT:    store i32 10, ptr [[ARG:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 %val, ptr %arg
  ret void
}

define void @caller.2(ptr %ptr) {
; CHECK-LABEL: @caller.2(
; CHECK-NEXT:    tail call void @ptrarg.2(ptr [[PTR:%.*]], i32 10)
; CHECK-NEXT:    ret void
;
  tail call void @ptrarg.2(ptr %ptr, i32 10)
  ret void
}


; Here the pointer argument %arg will be replaced by a constant. We need to
; drop inaccessiblemem_or_argmemonly.
define internal void @ptrarg.3(ptr %arg, i32 %val) inaccessiblemem_or_argmemonly nounwind {
; CHECK: Function Attrs: nounwind memory(readwrite)
; CHECK-LABEL: @ptrarg.3(
; CHECK-NEXT:    store i32 10, ptr @g, align 4
; CHECK-NEXT:    ret void
;
  store i32 %val, ptr %arg
  ret void
}

define i32 @caller.3(i32 %n) {
; CHECK-LABEL: @caller.3(
; CHECK-NEXT:    store i32 1, ptr @g, align 4
; CHECK-NEXT:    tail call void @ptrarg.3(ptr @g, i32 10)
; CHECK-NEXT:    [[G_VAL:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    ret i32 [[G_VAL]]
;
  store i32 1, ptr @g
  tail call void @ptrarg.3(ptr @g, i32 10)
  %g.val = load i32, ptr @g
  ret i32 %g.val
}


; Here only the non-pointer argument %val is replaced, no need
; to drop the inaccessiblemem_or_argmemonly attribute.
define internal void @ptrarg.4(ptr %arg, i32 %val) inaccessiblemem_or_argmemonly nounwind {
; CHECK: Function Attrs: nounwind memory(argmem: readwrite, inaccessiblemem: readwrite)
; CHECK-LABEL: @ptrarg.4(
; CHECK-NEXT:    store i32 10, ptr [[ARG:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i32 %val, ptr %arg
  ret void
}

define void @caller.4(ptr %ptr) {
; CHECK-LABEL: @caller.4(
; CHECK-NEXT:    tail call void @ptrarg.4(ptr [[PTR:%.*]], i32 10)
; CHECK-NEXT:    ret void
;
  tail call void @ptrarg.4(ptr %ptr, i32 10)
  ret void
}


; Here the pointer argument %arg will be replaced by a constant. We need to
; drop inaccessiblemem_or_argmemonly.
define internal void @ptrarg.5(ptr %arg, i32 %val) argmemonly inaccessiblemem_or_argmemonly nounwind {
; CHECK: Function Attrs: nounwind memory(readwrite, inaccessiblemem: none)
; CHECK-LABEL: @ptrarg.5(
; CHECK-NEXT:    store i32 10, ptr @g, align 4
; CHECK-NEXT:    ret void
;
  store i32 %val, ptr %arg
  ret void
}

define i32 @caller.5(i32 %n) {
; CHECK-LABEL: @caller.5(
; CHECK-NEXT:    store i32 1, ptr @g, align 4
; CHECK-NEXT:    tail call void @ptrarg.5(ptr @g, i32 10)
; CHECK-NEXT:    [[G_VAL:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    ret i32 [[G_VAL]]
;
  store i32 1, ptr @g
  tail call void @ptrarg.5(ptr @g, i32 10)
  %g.val = load i32, ptr @g
  ret i32 %g.val
}


; Make sure callsite attributes are also dropped when a pointer argument is
; replaced.
define internal void @ptrarg.6.cs.attributes(ptr %arg, i32 %val) {
; CHECK-LABEL: @ptrarg.6.cs.attributes(
; CHECK-NEXT:    unreachable
;
  store i32 %val, ptr %arg
  ret void
}

define i32 @caller.6.cs.attributes(i32 %n) {
; CHECK-LABEL: @caller.6.cs.attributes(
; CHECK-NEXT:    store i32 1, ptr @g, align 4
; CHECK-NEXT:    tail call void @ptrarg.5(ptr @g, i32 10) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    tail call void @ptrarg.5(ptr @g, i32 10) #[[ATTR2:[0-9]+]]
; CHECK-NEXT:    tail call void @ptrarg.5(ptr @g, i32 10) #[[ATTR0]]
; CHECK-NEXT:    tail call void @ptrarg.5(ptr @g, i32 10) #[[ATTR4:[0-9]+]]
; CHECK-NEXT:    [[G_VAL:%.*]] = load i32, ptr @g, align 4
; CHECK-NEXT:    ret i32 [[G_VAL]]
;
  store i32 1, ptr @g
  tail call void @ptrarg.5(ptr @g, i32 10) argmemonly inaccessiblemem_or_argmemonly nounwind
  tail call void @ptrarg.5(ptr @g, i32 10) inaccessiblemem_or_argmemonly nounwind
  tail call void @ptrarg.5(ptr @g, i32 10) argmemonly nounwind
  tail call void @ptrarg.5(ptr @g, i32 10) nounwind
  %g.val = load i32, ptr @g
  ret i32 %g.val
}

;.
; CHECK: attributes #[[ATTR0]] = { nounwind memory(readwrite, inaccessiblemem: none) }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nounwind memory(argmem: readwrite) }
; CHECK: attributes #[[ATTR2]] = { nounwind memory(readwrite) }
; CHECK: attributes #[[ATTR3:[0-9]+]] = { nounwind memory(argmem: readwrite, inaccessiblemem: readwrite) }
; CHECK: attributes #[[ATTR4]] = { nounwind }
;.
