package cdn

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LogAnalyticsClient is the cdn Management Client
type LogAnalyticsClient struct {
	BaseClient
}

// NewLogAnalyticsClient creates an instance of the LogAnalyticsClient client.
func NewLogAnalyticsClient(subscriptionID string) LogAnalyticsClient {
	return NewLogAnalyticsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLogAnalyticsClientWithBaseURI creates an instance of the LogAnalyticsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewLogAnalyticsClientWithBaseURI(baseURI string, subscriptionID string) LogAnalyticsClient {
	return LogAnalyticsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetLogAnalyticsLocations get all available location names for AFD log analytics report.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
func (client LogAnalyticsClient) GetLogAnalyticsLocations(ctx context.Context, resourceGroupName string, profileName string) (result ContinentsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetLogAnalyticsLocations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetLogAnalyticsLocations", err.Error())
	}

	req, err := client.GetLogAnalyticsLocationsPreparer(ctx, resourceGroupName, profileName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsLocations", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetLogAnalyticsLocationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsLocations", resp, "Failure sending request")
		return
	}

	result, err = client.GetLogAnalyticsLocationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsLocations", resp, "Failure responding to request")
		return
	}

	return
}

// GetLogAnalyticsLocationsPreparer prepares the GetLogAnalyticsLocations request.
func (client LogAnalyticsClient) GetLogAnalyticsLocationsPreparer(ctx context.Context, resourceGroupName string, profileName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsLocations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetLogAnalyticsLocationsSender sends the GetLogAnalyticsLocations request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetLogAnalyticsLocationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetLogAnalyticsLocationsResponder handles the response to the GetLogAnalyticsLocations request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetLogAnalyticsLocationsResponder(resp *http.Response) (result ContinentsResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetLogAnalyticsMetrics get log report for AFD profile
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
// granularity -
func (client LogAnalyticsClient) GetLogAnalyticsMetrics(ctx context.Context, resourceGroupName string, profileName string, metrics []LogMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity LogMetricsGranularity, customDomains []string, protocols []string, groupBy []LogMetricsGroupBy, continents []string, countryOrRegions []string) (result MetricsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetLogAnalyticsMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: metrics,
			Constraints: []validation.Constraint{{Target: "metrics", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: customDomains,
			Constraints: []validation.Constraint{{Target: "customDomains", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: protocols,
			Constraints: []validation.Constraint{{Target: "protocols", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetLogAnalyticsMetrics", err.Error())
	}

	req, err := client.GetLogAnalyticsMetricsPreparer(ctx, resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, customDomains, protocols, groupBy, continents, countryOrRegions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetLogAnalyticsMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetLogAnalyticsMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetLogAnalyticsMetricsPreparer prepares the GetLogAnalyticsMetrics request.
func (client LogAnalyticsClient) GetLogAnalyticsMetricsPreparer(ctx context.Context, resourceGroupName string, profileName string, metrics []LogMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity LogMetricsGranularity, customDomains []string, protocols []string, groupBy []LogMetricsGroupBy, continents []string, countryOrRegions []string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"customDomains": customDomains,
		"dateTimeBegin": autorest.Encode("query", dateTimeBegin),
		"dateTimeEnd":   autorest.Encode("query", dateTimeEnd),
		"granularity":   autorest.Encode("query", granularity),
		"metrics":       metrics,
		"protocols":     protocols,
	}
	if groupBy != nil && len(groupBy) > 0 {
		queryParameters["groupBy"] = groupBy
	}
	if continents != nil && len(continents) > 0 {
		queryParameters["continents"] = continents
	}
	if countryOrRegions != nil && len(countryOrRegions) > 0 {
		queryParameters["countryOrRegions"] = countryOrRegions
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetLogAnalyticsMetricsSender sends the GetLogAnalyticsMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetLogAnalyticsMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetLogAnalyticsMetricsResponder handles the response to the GetLogAnalyticsMetrics request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetLogAnalyticsMetricsResponder(resp *http.Response) (result MetricsResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetLogAnalyticsRankings get log analytics ranking report for AFD profile
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
func (client LogAnalyticsClient) GetLogAnalyticsRankings(ctx context.Context, resourceGroupName string, profileName string, rankings []LogRanking, metrics []LogRankingMetric, maxRanking int32, dateTimeBegin date.Time, dateTimeEnd date.Time, customDomains []string) (result RankingsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetLogAnalyticsRankings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: rankings,
			Constraints: []validation.Constraint{{Target: "rankings", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: metrics,
			Constraints: []validation.Constraint{{Target: "metrics", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetLogAnalyticsRankings", err.Error())
	}

	req, err := client.GetLogAnalyticsRankingsPreparer(ctx, resourceGroupName, profileName, rankings, metrics, maxRanking, dateTimeBegin, dateTimeEnd, customDomains)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsRankings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetLogAnalyticsRankingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsRankings", resp, "Failure sending request")
		return
	}

	result, err = client.GetLogAnalyticsRankingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsRankings", resp, "Failure responding to request")
		return
	}

	return
}

// GetLogAnalyticsRankingsPreparer prepares the GetLogAnalyticsRankings request.
func (client LogAnalyticsClient) GetLogAnalyticsRankingsPreparer(ctx context.Context, resourceGroupName string, profileName string, rankings []LogRanking, metrics []LogRankingMetric, maxRanking int32, dateTimeBegin date.Time, dateTimeEnd date.Time, customDomains []string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"dateTimeBegin": autorest.Encode("query", dateTimeBegin),
		"dateTimeEnd":   autorest.Encode("query", dateTimeEnd),
		"maxRanking":    autorest.Encode("query", maxRanking),
		"metrics":       metrics,
		"rankings":      rankings,
	}
	if customDomains != nil && len(customDomains) > 0 {
		queryParameters["customDomains"] = customDomains
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsRankings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetLogAnalyticsRankingsSender sends the GetLogAnalyticsRankings request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetLogAnalyticsRankingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetLogAnalyticsRankingsResponder handles the response to the GetLogAnalyticsRankings request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetLogAnalyticsRankingsResponder(resp *http.Response) (result RankingsResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetLogAnalyticsResources get all endpoints and custom domains available for AFD log report
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
func (client LogAnalyticsClient) GetLogAnalyticsResources(ctx context.Context, resourceGroupName string, profileName string) (result ResourcesResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetLogAnalyticsResources")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetLogAnalyticsResources", err.Error())
	}

	req, err := client.GetLogAnalyticsResourcesPreparer(ctx, resourceGroupName, profileName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsResources", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetLogAnalyticsResourcesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsResources", resp, "Failure sending request")
		return
	}

	result, err = client.GetLogAnalyticsResourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetLogAnalyticsResources", resp, "Failure responding to request")
		return
	}

	return
}

// GetLogAnalyticsResourcesPreparer prepares the GetLogAnalyticsResources request.
func (client LogAnalyticsClient) GetLogAnalyticsResourcesPreparer(ctx context.Context, resourceGroupName string, profileName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getLogAnalyticsResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetLogAnalyticsResourcesSender sends the GetLogAnalyticsResources request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetLogAnalyticsResourcesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetLogAnalyticsResourcesResponder handles the response to the GetLogAnalyticsResources request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetLogAnalyticsResourcesResponder(resp *http.Response) (result ResourcesResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWafLogAnalyticsMetrics get Waf related log analytics report for AFD profile.
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
// granularity -
func (client LogAnalyticsClient) GetWafLogAnalyticsMetrics(ctx context.Context, resourceGroupName string, profileName string, metrics []WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity WafGranularity, actions []WafAction, groupBy []WafRankingGroupBy, ruleTypes []WafRuleType) (result WafMetricsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetWafLogAnalyticsMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: metrics,
			Constraints: []validation.Constraint{{Target: "metrics", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetWafLogAnalyticsMetrics", err.Error())
	}

	req, err := client.GetWafLogAnalyticsMetricsPreparer(ctx, resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, granularity, actions, groupBy, ruleTypes)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWafLogAnalyticsMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetWafLogAnalyticsMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetWafLogAnalyticsMetricsPreparer prepares the GetWafLogAnalyticsMetrics request.
func (client LogAnalyticsClient) GetWafLogAnalyticsMetricsPreparer(ctx context.Context, resourceGroupName string, profileName string, metrics []WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, granularity WafGranularity, actions []WafAction, groupBy []WafRankingGroupBy, ruleTypes []WafRuleType) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"dateTimeBegin": autorest.Encode("query", dateTimeBegin),
		"dateTimeEnd":   autorest.Encode("query", dateTimeEnd),
		"granularity":   autorest.Encode("query", granularity),
		"metrics":       metrics,
	}
	if actions != nil && len(actions) > 0 {
		queryParameters["actions"] = actions
	}
	if groupBy != nil && len(groupBy) > 0 {
		queryParameters["groupBy"] = groupBy
	}
	if ruleTypes != nil && len(ruleTypes) > 0 {
		queryParameters["ruleTypes"] = ruleTypes
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWafLogAnalyticsMetricsSender sends the GetWafLogAnalyticsMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetWafLogAnalyticsMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWafLogAnalyticsMetricsResponder handles the response to the GetWafLogAnalyticsMetrics request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetWafLogAnalyticsMetricsResponder(resp *http.Response) (result WafMetricsResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWafLogAnalyticsRankings get WAF log analytics charts for AFD profile
// Parameters:
// resourceGroupName - name of the Resource group within the Azure subscription.
// profileName - name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique
// within the resource group. which is unique within the resource group.
func (client LogAnalyticsClient) GetWafLogAnalyticsRankings(ctx context.Context, resourceGroupName string, profileName string, metrics []WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, maxRanking int32, rankings []WafRankingType, actions []WafAction, ruleTypes []WafRuleType) (result WafRankingsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogAnalyticsClient.GetWafLogAnalyticsRankings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: metrics,
			Constraints: []validation.Constraint{{Target: "metrics", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: rankings,
			Constraints: []validation.Constraint{{Target: "rankings", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("cdn.LogAnalyticsClient", "GetWafLogAnalyticsRankings", err.Error())
	}

	req, err := client.GetWafLogAnalyticsRankingsPreparer(ctx, resourceGroupName, profileName, metrics, dateTimeBegin, dateTimeEnd, maxRanking, rankings, actions, ruleTypes)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsRankings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWafLogAnalyticsRankingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsRankings", resp, "Failure sending request")
		return
	}

	result, err = client.GetWafLogAnalyticsRankingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.LogAnalyticsClient", "GetWafLogAnalyticsRankings", resp, "Failure responding to request")
		return
	}

	return
}

// GetWafLogAnalyticsRankingsPreparer prepares the GetWafLogAnalyticsRankings request.
func (client LogAnalyticsClient) GetWafLogAnalyticsRankingsPreparer(ctx context.Context, resourceGroupName string, profileName string, metrics []WafMetric, dateTimeBegin date.Time, dateTimeEnd date.Time, maxRanking int32, rankings []WafRankingType, actions []WafAction, ruleTypes []WafRuleType) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"profileName":       autorest.Encode("path", profileName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-06-01"
	queryParameters := map[string]interface{}{
		"api-version":   APIVersion,
		"dateTimeBegin": autorest.Encode("query", dateTimeBegin),
		"dateTimeEnd":   autorest.Encode("query", dateTimeEnd),
		"maxRanking":    autorest.Encode("query", maxRanking),
		"metrics":       metrics,
		"rankings":      rankings,
	}
	if actions != nil && len(actions) > 0 {
		queryParameters["actions"] = actions
	}
	if ruleTypes != nil && len(ruleTypes) > 0 {
		queryParameters["ruleTypes"] = ruleTypes
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getWafLogAnalyticsRankings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetWafLogAnalyticsRankingsSender sends the GetWafLogAnalyticsRankings request. The method will close the
// http.Response Body if it receives an error.
func (client LogAnalyticsClient) GetWafLogAnalyticsRankingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetWafLogAnalyticsRankingsResponder handles the response to the GetWafLogAnalyticsRankings request. The method always
// closes the http.Response Body.
func (client LogAnalyticsClient) GetWafLogAnalyticsRankingsResponder(resp *http.Response) (result WafRankingsResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
