package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleEligibilityScheduleRequestsClient is the client for the RoleEligibilityScheduleRequests methods of the
// Authorization service.
type RoleEligibilityScheduleRequestsClient struct {
	BaseClient
}

// NewRoleEligibilityScheduleRequestsClient creates an instance of the RoleEligibilityScheduleRequestsClient client.
func NewRoleEligibilityScheduleRequestsClient(subscriptionID string) RoleEligibilityScheduleRequestsClient {
	return NewRoleEligibilityScheduleRequestsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleEligibilityScheduleRequestsClientWithBaseURI creates an instance of the RoleEligibilityScheduleRequestsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewRoleEligibilityScheduleRequestsClientWithBaseURI(baseURI string, subscriptionID string) RoleEligibilityScheduleRequestsClient {
	return RoleEligibilityScheduleRequestsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Cancel cancels a pending role eligibility schedule request.
// Parameters:
// scope - the scope of the role eligibility request to cancel.
// roleEligibilityScheduleRequestName - the name of the role eligibility request to cancel.
func (client RoleEligibilityScheduleRequestsClient) Cancel(ctx context.Context, scope string, roleEligibilityScheduleRequestName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.Cancel")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelPreparer(ctx, scope, roleEligibilityScheduleRequestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Cancel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Cancel", resp, "Failure sending request")
		return
	}

	result, err = client.CancelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Cancel", resp, "Failure responding to request")
		return
	}

	return
}

// CancelPreparer prepares the Cancel request.
func (client RoleEligibilityScheduleRequestsClient) CancelPreparer(ctx context.Context, scope string, roleEligibilityScheduleRequestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleRequestName": autorest.Encode("path", roleEligibilityScheduleRequestName),
		"scope":                              scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelSender sends the Cancel request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleRequestsClient) CancelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CancelResponder handles the response to the Cancel request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleRequestsClient) CancelResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Create creates a role eligibility schedule request.
// Parameters:
// scope - the scope of the role eligibility schedule request to create. The scope can be any REST resource
// instance. For example, use '/subscriptions/{subscription-id}/' for a subscription,
// '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
// '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
// for a resource.
// roleEligibilityScheduleRequestName - the name of the role eligibility to create. It can be any valid GUID.
// parameters - parameters for the role eligibility schedule request.
func (client RoleEligibilityScheduleRequestsClient) Create(ctx context.Context, scope string, roleEligibilityScheduleRequestName string, parameters RoleEligibilityScheduleRequest) (result RoleEligibilityScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.RoleEligibilityScheduleRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.RoleEligibilityScheduleRequestProperties.RoleDefinitionID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.RoleEligibilityScheduleRequestProperties.PrincipalID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authorization.RoleEligibilityScheduleRequestsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, scope, roleEligibilityScheduleRequestName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client RoleEligibilityScheduleRequestsClient) CreatePreparer(ctx context.Context, scope string, roleEligibilityScheduleRequestName string, parameters RoleEligibilityScheduleRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleRequestName": autorest.Encode("path", roleEligibilityScheduleRequestName),
		"scope":                              scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleRequestsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleRequestsClient) CreateResponder(resp *http.Response) (result RoleEligibilityScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get the specified role eligibility schedule request.
// Parameters:
// scope - the scope of the role eligibility schedule request.
// roleEligibilityScheduleRequestName - the name (guid) of the role eligibility schedule request to get.
func (client RoleEligibilityScheduleRequestsClient) Get(ctx context.Context, scope string, roleEligibilityScheduleRequestName string) (result RoleEligibilityScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleEligibilityScheduleRequestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleEligibilityScheduleRequestsClient) GetPreparer(ctx context.Context, scope string, roleEligibilityScheduleRequestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleRequestName": autorest.Encode("path", roleEligibilityScheduleRequestName),
		"scope":                              scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleRequestsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleRequestsClient) GetResponder(resp *http.Response) (result RoleEligibilityScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role eligibility schedule requests for a scope.
// Parameters:
// scope - the scope of the role eligibility schedule requests.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role eligibility schedule
// requests at or above the scope. Use $filter=principalId eq {id} to return all role eligibility schedule
// requests at, above or below the scope for the specified principal. Use $filter=asRequestor() to return all
// role eligibility schedule requests requested by the current user. Use $filter=asTarget() to return all role
// eligibility schedule requests created for the current user. Use $filter=asApprover() to return all role
// eligibility schedule requests where the current user is an approver.
func (client RoleEligibilityScheduleRequestsClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleRequestListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.ListForScope")
		defer func() {
			sc := -1
			if result.resrlr.Response.Response != nil {
				sc = result.resrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.resrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.resrlr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.resrlr.hasNextLink() && result.resrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleEligibilityScheduleRequestsClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleRequestsClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleRequestsClient) ListForScopeResponder(resp *http.Response) (result RoleEligibilityScheduleRequestListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleEligibilityScheduleRequestsClient) listForScopeNextResults(ctx context.Context, lastResults RoleEligibilityScheduleRequestListResult) (result RoleEligibilityScheduleRequestListResult, err error) {
	req, err := lastResults.roleEligibilityScheduleRequestListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleEligibilityScheduleRequestsClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleRequestListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}

// Validate validates a new role eligibility schedule request.
// Parameters:
// scope - the scope of the role eligibility request to validate.
// roleEligibilityScheduleRequestName - the name of the role eligibility request to validate.
// parameters - parameters for the role eligibility schedule request.
func (client RoleEligibilityScheduleRequestsClient) Validate(ctx context.Context, scope string, roleEligibilityScheduleRequestName string, parameters RoleEligibilityScheduleRequest) (result RoleEligibilityScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestsClient.Validate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.RoleEligibilityScheduleRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.RoleEligibilityScheduleRequestProperties.RoleDefinitionID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.RoleEligibilityScheduleRequestProperties.PrincipalID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authorization.RoleEligibilityScheduleRequestsClient", "Validate", err.Error())
	}

	req, err := client.ValidatePreparer(ctx, scope, roleEligibilityScheduleRequestName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Validate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Validate", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleRequestsClient", "Validate", resp, "Failure responding to request")
		return
	}

	return
}

// ValidatePreparer prepares the Validate request.
func (client RoleEligibilityScheduleRequestsClient) ValidatePreparer(ctx context.Context, scope string, roleEligibilityScheduleRequestName string, parameters RoleEligibilityScheduleRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleRequestName": autorest.Encode("path", roleEligibilityScheduleRequestName),
		"scope":                              scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/validate", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateSender sends the Validate request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleRequestsClient) ValidateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ValidateResponder handles the response to the Validate request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleRequestsClient) ValidateResponder(resp *http.Response) (result RoleEligibilityScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
