//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package media

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/mediaservices/mgmt/2021-11-01/media"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AacAudioProfile = original.AacAudioProfile

const (
	AacAudioProfileAacLc   AacAudioProfile = original.AacAudioProfileAacLc
	AacAudioProfileHeAacV1 AacAudioProfile = original.AacAudioProfileHeAacV1
	AacAudioProfileHeAacV2 AacAudioProfile = original.AacAudioProfileHeAacV2
)

type AccountEncryptionKeyType = original.AccountEncryptionKeyType

const (
	AccountEncryptionKeyTypeCustomerKey AccountEncryptionKeyType = original.AccountEncryptionKeyTypeCustomerKey
	AccountEncryptionKeyTypeSystemKey   AccountEncryptionKeyType = original.AccountEncryptionKeyTypeSystemKey
)

type ActionType = original.ActionType

const (
	ActionTypeInternal ActionType = original.ActionTypeInternal
)

type AnalysisResolution = original.AnalysisResolution

const (
	AnalysisResolutionSourceResolution   AnalysisResolution = original.AnalysisResolutionSourceResolution
	AnalysisResolutionStandardDefinition AnalysisResolution = original.AnalysisResolutionStandardDefinition
)

type AssetContainerPermission = original.AssetContainerPermission

const (
	AssetContainerPermissionRead            AssetContainerPermission = original.AssetContainerPermissionRead
	AssetContainerPermissionReadWrite       AssetContainerPermission = original.AssetContainerPermissionReadWrite
	AssetContainerPermissionReadWriteDelete AssetContainerPermission = original.AssetContainerPermissionReadWriteDelete
)

type AssetStorageEncryptionFormat = original.AssetStorageEncryptionFormat

const (
	AssetStorageEncryptionFormatMediaStorageClientEncryption AssetStorageEncryptionFormat = original.AssetStorageEncryptionFormatMediaStorageClientEncryption
	AssetStorageEncryptionFormatNone                         AssetStorageEncryptionFormat = original.AssetStorageEncryptionFormatNone
)

type AttributeFilter = original.AttributeFilter

const (
	AttributeFilterAll         AttributeFilter = original.AttributeFilterAll
	AttributeFilterBottom      AttributeFilter = original.AttributeFilterBottom
	AttributeFilterTop         AttributeFilter = original.AttributeFilterTop
	AttributeFilterValueEquals AttributeFilter = original.AttributeFilterValueEquals
)

type AudioAnalysisMode = original.AudioAnalysisMode

const (
	AudioAnalysisModeBasic    AudioAnalysisMode = original.AudioAnalysisModeBasic
	AudioAnalysisModeStandard AudioAnalysisMode = original.AudioAnalysisModeStandard
)

type BlurType = original.BlurType

const (
	BlurTypeBlack BlurType = original.BlurTypeBlack
	BlurTypeBox   BlurType = original.BlurTypeBox
	BlurTypeHigh  BlurType = original.BlurTypeHigh
	BlurTypeLow   BlurType = original.BlurTypeLow
	BlurTypeMed   BlurType = original.BlurTypeMed
)

type ChannelMapping = original.ChannelMapping

const (
	ChannelMappingBackLeft            ChannelMapping = original.ChannelMappingBackLeft
	ChannelMappingBackRight           ChannelMapping = original.ChannelMappingBackRight
	ChannelMappingCenter              ChannelMapping = original.ChannelMappingCenter
	ChannelMappingFrontLeft           ChannelMapping = original.ChannelMappingFrontLeft
	ChannelMappingFrontRight          ChannelMapping = original.ChannelMappingFrontRight
	ChannelMappingLowFrequencyEffects ChannelMapping = original.ChannelMappingLowFrequencyEffects
	ChannelMappingStereoLeft          ChannelMapping = original.ChannelMappingStereoLeft
	ChannelMappingStereoRight         ChannelMapping = original.ChannelMappingStereoRight
)

type Complexity = original.Complexity

const (
	ComplexityBalanced Complexity = original.ComplexityBalanced
	ComplexityQuality  Complexity = original.ComplexityQuality
	ComplexitySpeed    Complexity = original.ComplexitySpeed
)

type ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyType

const (
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeDualExpiry          ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeDualExpiry
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentLimited   ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentLimited
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentUnlimited ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyTypePersistentUnlimited
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUndefined           ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUndefined
	ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUnknown             ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyTypeUnknown
)

type ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentType

const (
	ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload  ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload
	ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming
	ContentKeyPolicyPlayReadyContentTypeUnknown              ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnknown
	ContentKeyPolicyPlayReadyContentTypeUnspecified          ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnspecified
)

type ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseType

const (
	ContentKeyPolicyPlayReadyLicenseTypeNonPersistent ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeNonPersistent
	ContentKeyPolicyPlayReadyLicenseTypePersistent    ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypePersistent
	ContentKeyPolicyPlayReadyLicenseTypeUnknown       ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeUnknown
)

type ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOption

const (
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed                   ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown
)

type ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenType

const (
	ContentKeyPolicyRestrictionTokenTypeJwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeJwt
	ContentKeyPolicyRestrictionTokenTypeSwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeSwt
	ContentKeyPolicyRestrictionTokenTypeUnknown ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeUnknown
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DefaultAction = original.DefaultAction

const (
	DefaultActionAllow DefaultAction = original.DefaultActionAllow
	DefaultActionDeny  DefaultAction = original.DefaultActionDeny
)

type DeinterlaceMode = original.DeinterlaceMode

const (
	DeinterlaceModeAutoPixelAdaptive DeinterlaceMode = original.DeinterlaceModeAutoPixelAdaptive
	DeinterlaceModeOff               DeinterlaceMode = original.DeinterlaceModeOff
)

type DeinterlaceParity = original.DeinterlaceParity

const (
	DeinterlaceParityAuto             DeinterlaceParity = original.DeinterlaceParityAuto
	DeinterlaceParityBottomFieldFirst DeinterlaceParity = original.DeinterlaceParityBottomFieldFirst
	DeinterlaceParityTopFieldFirst    DeinterlaceParity = original.DeinterlaceParityTopFieldFirst
)

type EncoderNamedPreset = original.EncoderNamedPreset

const (
	EncoderNamedPresetAACGoodQualityAudio              EncoderNamedPreset = original.EncoderNamedPresetAACGoodQualityAudio
	EncoderNamedPresetAdaptiveStreaming                EncoderNamedPreset = original.EncoderNamedPresetAdaptiveStreaming
	EncoderNamedPresetContentAwareEncoding             EncoderNamedPreset = original.EncoderNamedPresetContentAwareEncoding
	EncoderNamedPresetContentAwareEncodingExperimental EncoderNamedPreset = original.EncoderNamedPresetContentAwareEncodingExperimental
	EncoderNamedPresetCopyAllBitrateNonInterleaved     EncoderNamedPreset = original.EncoderNamedPresetCopyAllBitrateNonInterleaved
	EncoderNamedPresetH264MultipleBitrate1080p         EncoderNamedPreset = original.EncoderNamedPresetH264MultipleBitrate1080p
	EncoderNamedPresetH264MultipleBitrate720p          EncoderNamedPreset = original.EncoderNamedPresetH264MultipleBitrate720p
	EncoderNamedPresetH264MultipleBitrateSD            EncoderNamedPreset = original.EncoderNamedPresetH264MultipleBitrateSD
	EncoderNamedPresetH264SingleBitrate1080p           EncoderNamedPreset = original.EncoderNamedPresetH264SingleBitrate1080p
	EncoderNamedPresetH264SingleBitrate720p            EncoderNamedPreset = original.EncoderNamedPresetH264SingleBitrate720p
	EncoderNamedPresetH264SingleBitrateSD              EncoderNamedPreset = original.EncoderNamedPresetH264SingleBitrateSD
	EncoderNamedPresetH265AdaptiveStreaming            EncoderNamedPreset = original.EncoderNamedPresetH265AdaptiveStreaming
	EncoderNamedPresetH265ContentAwareEncoding         EncoderNamedPreset = original.EncoderNamedPresetH265ContentAwareEncoding
	EncoderNamedPresetH265SingleBitrate1080p           EncoderNamedPreset = original.EncoderNamedPresetH265SingleBitrate1080p
	EncoderNamedPresetH265SingleBitrate4K              EncoderNamedPreset = original.EncoderNamedPresetH265SingleBitrate4K
	EncoderNamedPresetH265SingleBitrate720p            EncoderNamedPreset = original.EncoderNamedPresetH265SingleBitrate720p
)

type EncryptionScheme = original.EncryptionScheme

const (
	EncryptionSchemeCommonEncryptionCbcs EncryptionScheme = original.EncryptionSchemeCommonEncryptionCbcs
	EncryptionSchemeCommonEncryptionCenc EncryptionScheme = original.EncryptionSchemeCommonEncryptionCenc
	EncryptionSchemeEnvelopeEncryption   EncryptionScheme = original.EncryptionSchemeEnvelopeEncryption
	EncryptionSchemeNoEncryption         EncryptionScheme = original.EncryptionSchemeNoEncryption
)

type EntropyMode = original.EntropyMode

const (
	EntropyModeCabac EntropyMode = original.EntropyModeCabac
	EntropyModeCavlc EntropyMode = original.EntropyModeCavlc
)

type FaceRedactorMode = original.FaceRedactorMode

const (
	FaceRedactorModeAnalyze  FaceRedactorMode = original.FaceRedactorModeAnalyze
	FaceRedactorModeCombined FaceRedactorMode = original.FaceRedactorModeCombined
	FaceRedactorModeRedact   FaceRedactorMode = original.FaceRedactorModeRedact
)

type FilterTrackPropertyCompareOperation = original.FilterTrackPropertyCompareOperation

const (
	FilterTrackPropertyCompareOperationEqual    FilterTrackPropertyCompareOperation = original.FilterTrackPropertyCompareOperationEqual
	FilterTrackPropertyCompareOperationNotEqual FilterTrackPropertyCompareOperation = original.FilterTrackPropertyCompareOperationNotEqual
)

type FilterTrackPropertyType = original.FilterTrackPropertyType

const (
	FilterTrackPropertyTypeBitrate  FilterTrackPropertyType = original.FilterTrackPropertyTypeBitrate
	FilterTrackPropertyTypeFourCC   FilterTrackPropertyType = original.FilterTrackPropertyTypeFourCC
	FilterTrackPropertyTypeLanguage FilterTrackPropertyType = original.FilterTrackPropertyTypeLanguage
	FilterTrackPropertyTypeName     FilterTrackPropertyType = original.FilterTrackPropertyTypeName
	FilterTrackPropertyTypeType     FilterTrackPropertyType = original.FilterTrackPropertyTypeType
	FilterTrackPropertyTypeUnknown  FilterTrackPropertyType = original.FilterTrackPropertyTypeUnknown
)

type H264Complexity = original.H264Complexity

const (
	H264ComplexityBalanced H264Complexity = original.H264ComplexityBalanced
	H264ComplexityQuality  H264Complexity = original.H264ComplexityQuality
	H264ComplexitySpeed    H264Complexity = original.H264ComplexitySpeed
)

type H264RateControlMode = original.H264RateControlMode

const (
	H264RateControlModeABR H264RateControlMode = original.H264RateControlModeABR
	H264RateControlModeCBR H264RateControlMode = original.H264RateControlModeCBR
	H264RateControlModeCRF H264RateControlMode = original.H264RateControlModeCRF
)

type H264VideoProfile = original.H264VideoProfile

const (
	H264VideoProfileAuto     H264VideoProfile = original.H264VideoProfileAuto
	H264VideoProfileBaseline H264VideoProfile = original.H264VideoProfileBaseline
	H264VideoProfileHigh     H264VideoProfile = original.H264VideoProfileHigh
	H264VideoProfileHigh422  H264VideoProfile = original.H264VideoProfileHigh422
	H264VideoProfileHigh444  H264VideoProfile = original.H264VideoProfileHigh444
	H264VideoProfileMain     H264VideoProfile = original.H264VideoProfileMain
)

type H265Complexity = original.H265Complexity

const (
	H265ComplexityBalanced H265Complexity = original.H265ComplexityBalanced
	H265ComplexityQuality  H265Complexity = original.H265ComplexityQuality
	H265ComplexitySpeed    H265Complexity = original.H265ComplexitySpeed
)

type H265VideoProfile = original.H265VideoProfile

const (
	H265VideoProfileAuto   H265VideoProfile = original.H265VideoProfileAuto
	H265VideoProfileMain   H265VideoProfile = original.H265VideoProfileMain
	H265VideoProfileMain10 H265VideoProfile = original.H265VideoProfileMain10
)

type InsightsType = original.InsightsType

const (
	InsightsTypeAllInsights       InsightsType = original.InsightsTypeAllInsights
	InsightsTypeAudioInsightsOnly InsightsType = original.InsightsTypeAudioInsightsOnly
	InsightsTypeVideoInsightsOnly InsightsType = original.InsightsTypeVideoInsightsOnly
)

type InterleaveOutput = original.InterleaveOutput

const (
	InterleaveOutputInterleavedOutput    InterleaveOutput = original.InterleaveOutputInterleavedOutput
	InterleaveOutputNonInterleavedOutput InterleaveOutput = original.InterleaveOutputNonInterleavedOutput
)

type JobErrorCategory = original.JobErrorCategory

const (
	JobErrorCategoryConfiguration JobErrorCategory = original.JobErrorCategoryConfiguration
	JobErrorCategoryContent       JobErrorCategory = original.JobErrorCategoryContent
	JobErrorCategoryDownload      JobErrorCategory = original.JobErrorCategoryDownload
	JobErrorCategoryService       JobErrorCategory = original.JobErrorCategoryService
	JobErrorCategoryUpload        JobErrorCategory = original.JobErrorCategoryUpload
)

type JobErrorCode = original.JobErrorCode

const (
	JobErrorCodeConfigurationUnsupported JobErrorCode = original.JobErrorCodeConfigurationUnsupported
	JobErrorCodeContentMalformed         JobErrorCode = original.JobErrorCodeContentMalformed
	JobErrorCodeContentUnsupported       JobErrorCode = original.JobErrorCodeContentUnsupported
	JobErrorCodeDownloadNotAccessible    JobErrorCode = original.JobErrorCodeDownloadNotAccessible
	JobErrorCodeDownloadTransientError   JobErrorCode = original.JobErrorCodeDownloadTransientError
	JobErrorCodeServiceError             JobErrorCode = original.JobErrorCodeServiceError
	JobErrorCodeServiceTransientError    JobErrorCode = original.JobErrorCodeServiceTransientError
	JobErrorCodeUploadNotAccessible      JobErrorCode = original.JobErrorCodeUploadNotAccessible
	JobErrorCodeUploadTransientError     JobErrorCode = original.JobErrorCodeUploadTransientError
)

type JobRetry = original.JobRetry

const (
	JobRetryDoNotRetry JobRetry = original.JobRetryDoNotRetry
	JobRetryMayRetry   JobRetry = original.JobRetryMayRetry
)

type JobState = original.JobState

const (
	JobStateCanceled   JobState = original.JobStateCanceled
	JobStateCanceling  JobState = original.JobStateCanceling
	JobStateError      JobState = original.JobStateError
	JobStateFinished   JobState = original.JobStateFinished
	JobStateProcessing JobState = original.JobStateProcessing
	JobStateQueued     JobState = original.JobStateQueued
	JobStateScheduled  JobState = original.JobStateScheduled
)

type LiveEventEncodingType = original.LiveEventEncodingType

const (
	LiveEventEncodingTypeNone                LiveEventEncodingType = original.LiveEventEncodingTypeNone
	LiveEventEncodingTypePassthroughBasic    LiveEventEncodingType = original.LiveEventEncodingTypePassthroughBasic
	LiveEventEncodingTypePassthroughStandard LiveEventEncodingType = original.LiveEventEncodingTypePassthroughStandard
	LiveEventEncodingTypePremium1080p        LiveEventEncodingType = original.LiveEventEncodingTypePremium1080p
	LiveEventEncodingTypeStandard            LiveEventEncodingType = original.LiveEventEncodingTypeStandard
)

type LiveEventInputProtocol = original.LiveEventInputProtocol

const (
	LiveEventInputProtocolFragmentedMP4 LiveEventInputProtocol = original.LiveEventInputProtocolFragmentedMP4
	LiveEventInputProtocolRTMP          LiveEventInputProtocol = original.LiveEventInputProtocolRTMP
)

type LiveEventResourceState = original.LiveEventResourceState

const (
	LiveEventResourceStateAllocating LiveEventResourceState = original.LiveEventResourceStateAllocating
	LiveEventResourceStateDeleting   LiveEventResourceState = original.LiveEventResourceStateDeleting
	LiveEventResourceStateRunning    LiveEventResourceState = original.LiveEventResourceStateRunning
	LiveEventResourceStateStandBy    LiveEventResourceState = original.LiveEventResourceStateStandBy
	LiveEventResourceStateStarting   LiveEventResourceState = original.LiveEventResourceStateStarting
	LiveEventResourceStateStopped    LiveEventResourceState = original.LiveEventResourceStateStopped
	LiveEventResourceStateStopping   LiveEventResourceState = original.LiveEventResourceStateStopping
)

type LiveOutputResourceState = original.LiveOutputResourceState

const (
	LiveOutputResourceStateCreating LiveOutputResourceState = original.LiveOutputResourceStateCreating
	LiveOutputResourceStateDeleting LiveOutputResourceState = original.LiveOutputResourceStateDeleting
	LiveOutputResourceStateRunning  LiveOutputResourceState = original.LiveOutputResourceStateRunning
)

type MetricAggregationType = original.MetricAggregationType

const (
	MetricAggregationTypeAverage MetricAggregationType = original.MetricAggregationTypeAverage
	MetricAggregationTypeCount   MetricAggregationType = original.MetricAggregationTypeCount
	MetricAggregationTypeTotal   MetricAggregationType = original.MetricAggregationTypeTotal
)

type MetricUnit = original.MetricUnit

const (
	MetricUnitBytes        MetricUnit = original.MetricUnitBytes
	MetricUnitCount        MetricUnit = original.MetricUnitCount
	MetricUnitMilliseconds MetricUnit = original.MetricUnitMilliseconds
)

type OdataType = original.OdataType

const (
	OdataTypeMicrosoftMediaAudioTrack OdataType = original.OdataTypeMicrosoftMediaAudioTrack
	OdataTypeMicrosoftMediaTextTrack  OdataType = original.OdataTypeMicrosoftMediaTextTrack
	OdataTypeMicrosoftMediaVideoTrack OdataType = original.OdataTypeMicrosoftMediaVideoTrack
	OdataTypeTrackBase                OdataType = original.OdataTypeTrackBase
)

type OdataTypeBasicClipTime = original.OdataTypeBasicClipTime

const (
	OdataTypeBasicClipTimeOdataTypeClipTime                       OdataTypeBasicClipTime = original.OdataTypeBasicClipTimeOdataTypeClipTime
	OdataTypeBasicClipTimeOdataTypeMicrosoftMediaAbsoluteClipTime OdataTypeBasicClipTime = original.OdataTypeBasicClipTimeOdataTypeMicrosoftMediaAbsoluteClipTime
	OdataTypeBasicClipTimeOdataTypeMicrosoftMediaUtcClipTime      OdataTypeBasicClipTime = original.OdataTypeBasicClipTimeOdataTypeMicrosoftMediaUtcClipTime
)

type OdataTypeBasicCodec = original.OdataTypeBasicCodec

const (
	OdataTypeBasicCodecOdataTypeCodec                   OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeCodec
	OdataTypeBasicCodecOdataTypeMicrosoftMediaAacAudio  OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaAacAudio
	OdataTypeBasicCodecOdataTypeMicrosoftMediaAudio     OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaAudio
	OdataTypeBasicCodecOdataTypeMicrosoftMediaCopyAudio OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaCopyAudio
	OdataTypeBasicCodecOdataTypeMicrosoftMediaCopyVideo OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaCopyVideo
	OdataTypeBasicCodecOdataTypeMicrosoftMediaH264Video OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaH264Video
	OdataTypeBasicCodecOdataTypeMicrosoftMediaH265Video OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaH265Video
	OdataTypeBasicCodecOdataTypeMicrosoftMediaImage     OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaImage
	OdataTypeBasicCodecOdataTypeMicrosoftMediaJpgImage  OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaJpgImage
	OdataTypeBasicCodecOdataTypeMicrosoftMediaPngImage  OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaPngImage
	OdataTypeBasicCodecOdataTypeMicrosoftMediaVideo     OdataTypeBasicCodec = original.OdataTypeBasicCodecOdataTypeMicrosoftMediaVideo
)

type OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfiguration

const (
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeContentKeyPolicyConfiguration                        OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeContentKeyPolicyConfiguration
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration   OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration
	OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfigurationOdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration
)

type OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation = original.OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation

const (
	OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeContentKeyPolicyPlayReadyContentKeyLocation                                  OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation = original.OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeContentKeyPolicyPlayReadyContentKeyLocation
	OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader        OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation = original.OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
	OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation = original.OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationOdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
)

type OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestriction

const (
	OdataTypeBasicContentKeyPolicyRestrictionOdataTypeContentKeyPolicyRestriction                      OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestrictionOdataTypeContentKeyPolicyRestriction
	OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction    OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction
	OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction   OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction
	OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestrictionOdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction
)

type OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKey

const (
	OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeContentKeyPolicyRestrictionTokenKey                   OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeContentKeyPolicyRestrictionTokenKey
	OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey             OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey
	OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey       OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey
	OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKeyOdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey
)

type OdataTypeBasicFormat = original.OdataTypeBasicFormat

const (
	OdataTypeBasicFormatOdataTypeFormat                              OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeFormat
	OdataTypeBasicFormatOdataTypeMicrosoftMediaImageFormat           OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaImageFormat
	OdataTypeBasicFormatOdataTypeMicrosoftMediaJpgFormat             OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaJpgFormat
	OdataTypeBasicFormatOdataTypeMicrosoftMediaMp4Format             OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaMp4Format
	OdataTypeBasicFormatOdataTypeMicrosoftMediaMultiBitrateFormat    OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaMultiBitrateFormat
	OdataTypeBasicFormatOdataTypeMicrosoftMediaPngFormat             OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaPngFormat
	OdataTypeBasicFormatOdataTypeMicrosoftMediaTransportStreamFormat OdataTypeBasicFormat = original.OdataTypeBasicFormatOdataTypeMicrosoftMediaTransportStreamFormat
)

type OdataTypeBasicInputDefinition = original.OdataTypeBasicInputDefinition

const (
	OdataTypeBasicInputDefinitionOdataTypeInputDefinition                 OdataTypeBasicInputDefinition = original.OdataTypeBasicInputDefinitionOdataTypeInputDefinition
	OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaFromAllInputFile  OdataTypeBasicInputDefinition = original.OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaFromAllInputFile
	OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaFromEachInputFile OdataTypeBasicInputDefinition = original.OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaFromEachInputFile
	OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaInputFile         OdataTypeBasicInputDefinition = original.OdataTypeBasicInputDefinitionOdataTypeMicrosoftMediaInputFile
)

type OdataTypeBasicJobInput = original.OdataTypeBasicJobInput

const (
	OdataTypeBasicJobInputOdataTypeJobInput                       OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeJobInput
	OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputAsset    OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputAsset
	OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputClip     OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputClip
	OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputHTTP     OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputHTTP
	OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputs        OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputs
	OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputSequence OdataTypeBasicJobInput = original.OdataTypeBasicJobInputOdataTypeMicrosoftMediaJobInputSequence
)

type OdataTypeBasicJobOutput = original.OdataTypeBasicJobOutput

const (
	OdataTypeBasicJobOutputOdataTypeJobOutput                    OdataTypeBasicJobOutput = original.OdataTypeBasicJobOutputOdataTypeJobOutput
	OdataTypeBasicJobOutputOdataTypeMicrosoftMediaJobOutputAsset OdataTypeBasicJobOutput = original.OdataTypeBasicJobOutputOdataTypeMicrosoftMediaJobOutputAsset
)

type OdataTypeBasicOverlay = original.OdataTypeBasicOverlay

const (
	OdataTypeBasicOverlayOdataTypeMicrosoftMediaAudioOverlay OdataTypeBasicOverlay = original.OdataTypeBasicOverlayOdataTypeMicrosoftMediaAudioOverlay
	OdataTypeBasicOverlayOdataTypeMicrosoftMediaVideoOverlay OdataTypeBasicOverlay = original.OdataTypeBasicOverlayOdataTypeMicrosoftMediaVideoOverlay
	OdataTypeBasicOverlayOdataTypeOverlay                    OdataTypeBasicOverlay = original.OdataTypeBasicOverlayOdataTypeOverlay
)

type OdataTypeBasicPreset = original.OdataTypeBasicPreset

const (
	OdataTypeBasicPresetOdataTypeMicrosoftMediaAudioAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypeMicrosoftMediaAudioAnalyzerPreset
	OdataTypeBasicPresetOdataTypeMicrosoftMediaBuiltInStandardEncoderPreset OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypeMicrosoftMediaBuiltInStandardEncoderPreset
	OdataTypeBasicPresetOdataTypeMicrosoftMediaFaceDetectorPreset           OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypeMicrosoftMediaFaceDetectorPreset
	OdataTypeBasicPresetOdataTypeMicrosoftMediaStandardEncoderPreset        OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypeMicrosoftMediaStandardEncoderPreset
	OdataTypeBasicPresetOdataTypeMicrosoftMediaVideoAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypeMicrosoftMediaVideoAnalyzerPreset
	OdataTypeBasicPresetOdataTypePreset                                     OdataTypeBasicPreset = original.OdataTypeBasicPresetOdataTypePreset
)

type OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptor

const (
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaAudioTrackDescriptor        OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaAudioTrackDescriptor
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectAudioTrackByAttribute OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectAudioTrackByAttribute
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectAudioTrackByID        OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectAudioTrackByID
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectVideoTrackByAttribute OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectVideoTrackByAttribute
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectVideoTrackByID        OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaSelectVideoTrackByID
	OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaVideoTrackDescriptor        OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeMicrosoftMediaVideoTrackDescriptor
	OdataTypeBasicTrackDescriptorOdataTypeTrackDescriptor                           OdataTypeBasicTrackDescriptor = original.OdataTypeBasicTrackDescriptorOdataTypeTrackDescriptor
)

type OnErrorType = original.OnErrorType

const (
	OnErrorTypeContinueJob       OnErrorType = original.OnErrorTypeContinueJob
	OnErrorTypeStopProcessingJob OnErrorType = original.OnErrorTypeStopProcessingJob
)

type Priority = original.Priority

const (
	PriorityHigh   Priority = original.PriorityHigh
	PriorityLow    Priority = original.PriorityLow
	PriorityNormal Priority = original.PriorityNormal
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
)

type PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatus

const (
	PrivateEndpointServiceConnectionStatusApproved PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusApproved
	PrivateEndpointServiceConnectionStatusPending  PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusPending
	PrivateEndpointServiceConnectionStatusRejected PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatusRejected
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateFailed     ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateInProgress ProvisioningState = original.ProvisioningStateInProgress
	ProvisioningStateSucceeded  ProvisioningState = original.ProvisioningStateSucceeded
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type Rotation = original.Rotation

const (
	RotationAuto      Rotation = original.RotationAuto
	RotationNone      Rotation = original.RotationNone
	RotationRotate0   Rotation = original.RotationRotate0
	RotationRotate180 Rotation = original.RotationRotate180
	RotationRotate270 Rotation = original.RotationRotate270
	RotationRotate90  Rotation = original.RotationRotate90
)

type StorageAccountType = original.StorageAccountType

const (
	StorageAccountTypePrimary   StorageAccountType = original.StorageAccountTypePrimary
	StorageAccountTypeSecondary StorageAccountType = original.StorageAccountTypeSecondary
)

type StorageAuthentication = original.StorageAuthentication

const (
	StorageAuthenticationManagedIdentity StorageAuthentication = original.StorageAuthenticationManagedIdentity
	StorageAuthenticationSystem          StorageAuthentication = original.StorageAuthenticationSystem
)

type StreamOptionsFlag = original.StreamOptionsFlag

const (
	StreamOptionsFlagDefault      StreamOptionsFlag = original.StreamOptionsFlagDefault
	StreamOptionsFlagLowLatency   StreamOptionsFlag = original.StreamOptionsFlagLowLatency
	StreamOptionsFlagLowLatencyV2 StreamOptionsFlag = original.StreamOptionsFlagLowLatencyV2
)

type StreamingEndpointResourceState = original.StreamingEndpointResourceState

const (
	StreamingEndpointResourceStateDeleting StreamingEndpointResourceState = original.StreamingEndpointResourceStateDeleting
	StreamingEndpointResourceStateRunning  StreamingEndpointResourceState = original.StreamingEndpointResourceStateRunning
	StreamingEndpointResourceStateScaling  StreamingEndpointResourceState = original.StreamingEndpointResourceStateScaling
	StreamingEndpointResourceStateStarting StreamingEndpointResourceState = original.StreamingEndpointResourceStateStarting
	StreamingEndpointResourceStateStopped  StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopped
	StreamingEndpointResourceStateStopping StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopping
)

type StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyType

const (
	StreamingLocatorContentKeyTypeCommonEncryptionCbcs StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCbcs
	StreamingLocatorContentKeyTypeCommonEncryptionCenc StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCenc
	StreamingLocatorContentKeyTypeEnvelopeEncryption   StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeEnvelopeEncryption
)

type StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocol

const (
	StreamingPolicyStreamingProtocolDash            StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDash
	StreamingPolicyStreamingProtocolDownload        StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDownload
	StreamingPolicyStreamingProtocolHls             StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolHls
	StreamingPolicyStreamingProtocolSmoothStreaming StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolSmoothStreaming
)

type StretchMode = original.StretchMode

const (
	StretchModeAutoFit  StretchMode = original.StretchModeAutoFit
	StretchModeAutoSize StretchMode = original.StretchModeAutoSize
	StretchModeNone     StretchMode = original.StretchModeNone
)

type TrackAttribute = original.TrackAttribute

const (
	TrackAttributeBitrate  TrackAttribute = original.TrackAttributeBitrate
	TrackAttributeLanguage TrackAttribute = original.TrackAttributeLanguage
)

type TrackPropertyCompareOperation = original.TrackPropertyCompareOperation

const (
	TrackPropertyCompareOperationEqual   TrackPropertyCompareOperation = original.TrackPropertyCompareOperationEqual
	TrackPropertyCompareOperationUnknown TrackPropertyCompareOperation = original.TrackPropertyCompareOperationUnknown
)

type TrackPropertyType = original.TrackPropertyType

const (
	TrackPropertyTypeFourCC  TrackPropertyType = original.TrackPropertyTypeFourCC
	TrackPropertyTypeUnknown TrackPropertyType = original.TrackPropertyTypeUnknown
)

type VideoSyncMode = original.VideoSyncMode

const (
	VideoSyncModeAuto        VideoSyncMode = original.VideoSyncModeAuto
	VideoSyncModeCfr         VideoSyncMode = original.VideoSyncModeCfr
	VideoSyncModePassthrough VideoSyncMode = original.VideoSyncModePassthrough
	VideoSyncModeVfr         VideoSyncMode = original.VideoSyncModeVfr
)

type Visibility = original.Visibility

const (
	VisibilityHidden  Visibility = original.VisibilityHidden
	VisibilityVisible Visibility = original.VisibilityVisible
)

type AacAudio = original.AacAudio
type AbsoluteClipTime = original.AbsoluteClipTime
type AccessControl = original.AccessControl
type AccountEncryption = original.AccountEncryption
type AccountFilter = original.AccountFilter
type AccountFilterCollection = original.AccountFilterCollection
type AccountFilterCollectionIterator = original.AccountFilterCollectionIterator
type AccountFilterCollectionPage = original.AccountFilterCollectionPage
type AccountFiltersClient = original.AccountFiltersClient
type AkamaiAccessControl = original.AkamaiAccessControl
type AkamaiSignatureHeaderAuthenticationKey = original.AkamaiSignatureHeaderAuthenticationKey
type ArmStreamingEndpointCapacity = original.ArmStreamingEndpointCapacity
type ArmStreamingEndpointCurrentSku = original.ArmStreamingEndpointCurrentSku
type ArmStreamingEndpointSku = original.ArmStreamingEndpointSku
type ArmStreamingEndpointSkuInfo = original.ArmStreamingEndpointSkuInfo
type Asset = original.Asset
type AssetCollection = original.AssetCollection
type AssetCollectionIterator = original.AssetCollectionIterator
type AssetCollectionPage = original.AssetCollectionPage
type AssetContainerSas = original.AssetContainerSas
type AssetFileEncryptionMetadata = original.AssetFileEncryptionMetadata
type AssetFilter = original.AssetFilter
type AssetFilterCollection = original.AssetFilterCollection
type AssetFilterCollectionIterator = original.AssetFilterCollectionIterator
type AssetFilterCollectionPage = original.AssetFilterCollectionPage
type AssetFiltersClient = original.AssetFiltersClient
type AssetProperties = original.AssetProperties
type AssetStreamingLocator = original.AssetStreamingLocator
type AssetTrack = original.AssetTrack
type AssetTrackCollection = original.AssetTrackCollection
type AssetTrackOperationStatus = original.AssetTrackOperationStatus
type AssetTrackProperties = original.AssetTrackProperties
type AssetsClient = original.AssetsClient
type Audio = original.Audio
type AudioAnalyzerPreset = original.AudioAnalyzerPreset
type AudioOverlay = original.AudioOverlay
type AudioTrack = original.AudioTrack
type AudioTrackDescriptor = original.AudioTrackDescriptor
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicAudio = original.BasicAudio
type BasicAudioAnalyzerPreset = original.BasicAudioAnalyzerPreset
type BasicAudioTrackDescriptor = original.BasicAudioTrackDescriptor
type BasicClipTime = original.BasicClipTime
type BasicCodec = original.BasicCodec
type BasicContentKeyPolicyConfiguration = original.BasicContentKeyPolicyConfiguration
type BasicContentKeyPolicyPlayReadyContentKeyLocation = original.BasicContentKeyPolicyPlayReadyContentKeyLocation
type BasicContentKeyPolicyRestriction = original.BasicContentKeyPolicyRestriction
type BasicContentKeyPolicyRestrictionTokenKey = original.BasicContentKeyPolicyRestrictionTokenKey
type BasicFormat = original.BasicFormat
type BasicImage = original.BasicImage
type BasicImageFormat = original.BasicImageFormat
type BasicInputDefinition = original.BasicInputDefinition
type BasicJobInput = original.BasicJobInput
type BasicJobInputClip = original.BasicJobInputClip
type BasicJobOutput = original.BasicJobOutput
type BasicMultiBitrateFormat = original.BasicMultiBitrateFormat
type BasicOverlay = original.BasicOverlay
type BasicPreset = original.BasicPreset
type BasicTrackBase = original.BasicTrackBase
type BasicTrackDescriptor = original.BasicTrackDescriptor
type BasicVideo = original.BasicVideo
type BasicVideoTrackDescriptor = original.BasicVideoTrackDescriptor
type BuiltInStandardEncoderPreset = original.BuiltInStandardEncoderPreset
type CbcsDrmConfiguration = original.CbcsDrmConfiguration
type CencDrmConfiguration = original.CencDrmConfiguration
type CheckNameAvailabilityInput = original.CheckNameAvailabilityInput
type ClipTime = original.ClipTime
type Codec = original.Codec
type CommonEncryptionCbcs = original.CommonEncryptionCbcs
type CommonEncryptionCenc = original.CommonEncryptionCenc
type ContentKeyPoliciesClient = original.ContentKeyPoliciesClient
type ContentKeyPolicy = original.ContentKeyPolicy
type ContentKeyPolicyClearKeyConfiguration = original.ContentKeyPolicyClearKeyConfiguration
type ContentKeyPolicyCollection = original.ContentKeyPolicyCollection
type ContentKeyPolicyCollectionIterator = original.ContentKeyPolicyCollectionIterator
type ContentKeyPolicyCollectionPage = original.ContentKeyPolicyCollectionPage
type ContentKeyPolicyConfiguration = original.ContentKeyPolicyConfiguration
type ContentKeyPolicyFairPlayConfiguration = original.ContentKeyPolicyFairPlayConfiguration
type ContentKeyPolicyFairPlayOfflineRentalConfiguration = original.ContentKeyPolicyFairPlayOfflineRentalConfiguration
type ContentKeyPolicyOpenRestriction = original.ContentKeyPolicyOpenRestriction
type ContentKeyPolicyOption = original.ContentKeyPolicyOption
type ContentKeyPolicyPlayReadyConfiguration = original.ContentKeyPolicyPlayReadyConfiguration
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
type ContentKeyPolicyPlayReadyContentKeyLocation = original.ContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction = original.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
type ContentKeyPolicyPlayReadyLicense = original.ContentKeyPolicyPlayReadyLicense
type ContentKeyPolicyPlayReadyPlayRight = original.ContentKeyPolicyPlayReadyPlayRight
type ContentKeyPolicyProperties = original.ContentKeyPolicyProperties
type ContentKeyPolicyRestriction = original.ContentKeyPolicyRestriction
type ContentKeyPolicyRestrictionTokenKey = original.ContentKeyPolicyRestrictionTokenKey
type ContentKeyPolicyRsaTokenKey = original.ContentKeyPolicyRsaTokenKey
type ContentKeyPolicySymmetricTokenKey = original.ContentKeyPolicySymmetricTokenKey
type ContentKeyPolicyTokenClaim = original.ContentKeyPolicyTokenClaim
type ContentKeyPolicyTokenRestriction = original.ContentKeyPolicyTokenRestriction
type ContentKeyPolicyUnknownConfiguration = original.ContentKeyPolicyUnknownConfiguration
type ContentKeyPolicyUnknownRestriction = original.ContentKeyPolicyUnknownRestriction
type ContentKeyPolicyWidevineConfiguration = original.ContentKeyPolicyWidevineConfiguration
type ContentKeyPolicyX509CertificateTokenKey = original.ContentKeyPolicyX509CertificateTokenKey
type CopyAudio = original.CopyAudio
type CopyVideo = original.CopyVideo
type CrossSiteAccessPolicies = original.CrossSiteAccessPolicies
type DefaultKey = original.DefaultKey
type Deinterlace = original.Deinterlace
type EdgePolicies = original.EdgePolicies
type EdgeUsageDataCollectionPolicy = original.EdgeUsageDataCollectionPolicy
type EdgeUsageDataEventHub = original.EdgeUsageDataEventHub
type EnabledProtocols = original.EnabledProtocols
type EntityNameAvailabilityCheckOutput = original.EntityNameAvailabilityCheckOutput
type EnvelopeEncryption = original.EnvelopeEncryption
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type FaceDetectorPreset = original.FaceDetectorPreset
type FilterProperties = original.FilterProperties
type FilterTrackPropertyCondition = original.FilterTrackPropertyCondition
type FilterTrackSelection = original.FilterTrackSelection
type Filters = original.Filters
type FirstQuality = original.FirstQuality
type Format = original.Format
type FromAllInputFile = original.FromAllInputFile
type FromEachInputFile = original.FromEachInputFile
type H264Layer = original.H264Layer
type H264Video = original.H264Video
type H265Layer = original.H265Layer
type H265Video = original.H265Video
type H265VideoLayer = original.H265VideoLayer
type Hls = original.Hls
type HlsSettings = original.HlsSettings
type IPAccessControl = original.IPAccessControl
type IPRange = original.IPRange
type Image = original.Image
type ImageFormat = original.ImageFormat
type InputDefinition = original.InputDefinition
type InputFile = original.InputFile
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobError = original.JobError
type JobErrorDetail = original.JobErrorDetail
type JobInput = original.JobInput
type JobInputAsset = original.JobInputAsset
type JobInputClip = original.JobInputClip
type JobInputHTTP = original.JobInputHTTP
type JobInputSequence = original.JobInputSequence
type JobInputs = original.JobInputs
type JobOutput = original.JobOutput
type JobOutputAsset = original.JobOutputAsset
type JobProperties = original.JobProperties
type JobsClient = original.JobsClient
type JpgFormat = original.JpgFormat
type JpgImage = original.JpgImage
type JpgLayer = original.JpgLayer
type KeyDelivery = original.KeyDelivery
type KeyVaultProperties = original.KeyVaultProperties
type Layer = original.Layer
type ListContainerSasInput = original.ListContainerSasInput
type ListContentKeysResponse = original.ListContentKeysResponse
type ListEdgePoliciesInput = original.ListEdgePoliciesInput
type ListPathsResponse = original.ListPathsResponse
type ListStreamingLocatorsResponse = original.ListStreamingLocatorsResponse
type LiveEvent = original.LiveEvent
type LiveEventActionInput = original.LiveEventActionInput
type LiveEventEncoding = original.LiveEventEncoding
type LiveEventEndpoint = original.LiveEventEndpoint
type LiveEventInput = original.LiveEventInput
type LiveEventInputAccessControl = original.LiveEventInputAccessControl
type LiveEventInputTrackSelection = original.LiveEventInputTrackSelection
type LiveEventListResult = original.LiveEventListResult
type LiveEventListResultIterator = original.LiveEventListResultIterator
type LiveEventListResultPage = original.LiveEventListResultPage
type LiveEventOutputTranscriptionTrack = original.LiveEventOutputTranscriptionTrack
type LiveEventPreview = original.LiveEventPreview
type LiveEventPreviewAccessControl = original.LiveEventPreviewAccessControl
type LiveEventProperties = original.LiveEventProperties
type LiveEventTranscription = original.LiveEventTranscription
type LiveEventsAllocateFuture = original.LiveEventsAllocateFuture
type LiveEventsClient = original.LiveEventsClient
type LiveEventsCreateFuture = original.LiveEventsCreateFuture
type LiveEventsDeleteFuture = original.LiveEventsDeleteFuture
type LiveEventsResetFuture = original.LiveEventsResetFuture
type LiveEventsStartFuture = original.LiveEventsStartFuture
type LiveEventsStopFuture = original.LiveEventsStopFuture
type LiveEventsUpdateFuture = original.LiveEventsUpdateFuture
type LiveOutput = original.LiveOutput
type LiveOutputListResult = original.LiveOutputListResult
type LiveOutputListResultIterator = original.LiveOutputListResultIterator
type LiveOutputListResultPage = original.LiveOutputListResultPage
type LiveOutputProperties = original.LiveOutputProperties
type LiveOutputsClient = original.LiveOutputsClient
type LiveOutputsCreateFuture = original.LiveOutputsCreateFuture
type LiveOutputsDeleteFuture = original.LiveOutputsDeleteFuture
type LocationsClient = original.LocationsClient
type LogSpecification = original.LogSpecification
type MediaservicesClient = original.MediaservicesClient
type MetricDimension = original.MetricDimension
type MetricSpecification = original.MetricSpecification
type Mp4Format = original.Mp4Format
type MultiBitrateFormat = original.MultiBitrateFormat
type NoEncryption = original.NoEncryption
type Operation = original.Operation
type OperationCollection = original.OperationCollection
type OperationDisplay = original.OperationDisplay
type OperationResultsClient = original.OperationResultsClient
type OperationStatusesClient = original.OperationStatusesClient
type OperationsClient = original.OperationsClient
type OutputFile = original.OutputFile
type Overlay = original.Overlay
type PngFormat = original.PngFormat
type PngImage = original.PngImage
type PngLayer = original.PngLayer
type PresentationTimeRange = original.PresentationTimeRange
type Preset = original.Preset
type PresetConfigurations = original.PresetConfigurations
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type Properties = original.Properties
type ProxyResource = original.ProxyResource
type Rectangle = original.Rectangle
type Resource = original.Resource
type ResourceIdentity = original.ResourceIdentity
type SelectAudioTrackByAttribute = original.SelectAudioTrackByAttribute
type SelectAudioTrackByID = original.SelectAudioTrackByID
type SelectVideoTrackByAttribute = original.SelectVideoTrackByAttribute
type SelectVideoTrackByID = original.SelectVideoTrackByID
type Service = original.Service
type ServiceCollection = original.ServiceCollection
type ServiceCollectionIterator = original.ServiceCollectionIterator
type ServiceCollectionPage = original.ServiceCollectionPage
type ServiceIdentity = original.ServiceIdentity
type ServiceProperties = original.ServiceProperties
type ServiceSpecification = original.ServiceSpecification
type ServiceUpdate = original.ServiceUpdate
type StandardEncoderPreset = original.StandardEncoderPreset
type StorageAccount = original.StorageAccount
type StorageEncryptedAssetDecryptionData = original.StorageEncryptedAssetDecryptionData
type StreamingEndpoint = original.StreamingEndpoint
type StreamingEndpointAccessControl = original.StreamingEndpointAccessControl
type StreamingEndpointListResult = original.StreamingEndpointListResult
type StreamingEndpointListResultIterator = original.StreamingEndpointListResultIterator
type StreamingEndpointListResultPage = original.StreamingEndpointListResultPage
type StreamingEndpointProperties = original.StreamingEndpointProperties
type StreamingEndpointSkuInfoListResult = original.StreamingEndpointSkuInfoListResult
type StreamingEndpointsClient = original.StreamingEndpointsClient
type StreamingEndpointsCreateFuture = original.StreamingEndpointsCreateFuture
type StreamingEndpointsDeleteFuture = original.StreamingEndpointsDeleteFuture
type StreamingEndpointsScaleFuture = original.StreamingEndpointsScaleFuture
type StreamingEndpointsStartFuture = original.StreamingEndpointsStartFuture
type StreamingEndpointsStopFuture = original.StreamingEndpointsStopFuture
type StreamingEndpointsUpdateFuture = original.StreamingEndpointsUpdateFuture
type StreamingEntityScaleUnit = original.StreamingEntityScaleUnit
type StreamingLocator = original.StreamingLocator
type StreamingLocatorCollection = original.StreamingLocatorCollection
type StreamingLocatorCollectionIterator = original.StreamingLocatorCollectionIterator
type StreamingLocatorCollectionPage = original.StreamingLocatorCollectionPage
type StreamingLocatorContentKey = original.StreamingLocatorContentKey
type StreamingLocatorProperties = original.StreamingLocatorProperties
type StreamingLocatorsClient = original.StreamingLocatorsClient
type StreamingPath = original.StreamingPath
type StreamingPoliciesClient = original.StreamingPoliciesClient
type StreamingPolicy = original.StreamingPolicy
type StreamingPolicyCollection = original.StreamingPolicyCollection
type StreamingPolicyCollectionIterator = original.StreamingPolicyCollectionIterator
type StreamingPolicyCollectionPage = original.StreamingPolicyCollectionPage
type StreamingPolicyContentKey = original.StreamingPolicyContentKey
type StreamingPolicyContentKeys = original.StreamingPolicyContentKeys
type StreamingPolicyFairPlayConfiguration = original.StreamingPolicyFairPlayConfiguration
type StreamingPolicyPlayReadyConfiguration = original.StreamingPolicyPlayReadyConfiguration
type StreamingPolicyProperties = original.StreamingPolicyProperties
type StreamingPolicyWidevineConfiguration = original.StreamingPolicyWidevineConfiguration
type SyncStorageKeysInput = original.SyncStorageKeysInput
type SystemData = original.SystemData
type TextTrack = original.TextTrack
type TrackBase = original.TrackBase
type TrackDescriptor = original.TrackDescriptor
type TrackPropertyCondition = original.TrackPropertyCondition
type TrackSelection = original.TrackSelection
type TrackedResource = original.TrackedResource
type TracksClient = original.TracksClient
type TracksCreateOrUpdateFuture = original.TracksCreateOrUpdateFuture
type TracksDeleteFuture = original.TracksDeleteFuture
type TracksUpdateFuture = original.TracksUpdateFuture
type TracksUpdateTrackDataFuture = original.TracksUpdateTrackDataFuture
type Transform = original.Transform
type TransformCollection = original.TransformCollection
type TransformCollectionIterator = original.TransformCollectionIterator
type TransformCollectionPage = original.TransformCollectionPage
type TransformOutput = original.TransformOutput
type TransformProperties = original.TransformProperties
type TransformsClient = original.TransformsClient
type TransportStreamFormat = original.TransportStreamFormat
type UserAssignedManagedIdentity = original.UserAssignedManagedIdentity
type UtcClipTime = original.UtcClipTime
type Video = original.Video
type VideoAnalyzerPreset = original.VideoAnalyzerPreset
type VideoLayer = original.VideoLayer
type VideoOverlay = original.VideoOverlay
type VideoTrack = original.VideoTrack
type VideoTrackDescriptor = original.VideoTrackDescriptor

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountFilterCollectionIterator(page AccountFilterCollectionPage) AccountFilterCollectionIterator {
	return original.NewAccountFilterCollectionIterator(page)
}
func NewAccountFilterCollectionPage(cur AccountFilterCollection, getNextPage func(context.Context, AccountFilterCollection) (AccountFilterCollection, error)) AccountFilterCollectionPage {
	return original.NewAccountFilterCollectionPage(cur, getNextPage)
}
func NewAccountFiltersClient(subscriptionID string) AccountFiltersClient {
	return original.NewAccountFiltersClient(subscriptionID)
}
func NewAccountFiltersClientWithBaseURI(baseURI string, subscriptionID string) AccountFiltersClient {
	return original.NewAccountFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssetCollectionIterator(page AssetCollectionPage) AssetCollectionIterator {
	return original.NewAssetCollectionIterator(page)
}
func NewAssetCollectionPage(cur AssetCollection, getNextPage func(context.Context, AssetCollection) (AssetCollection, error)) AssetCollectionPage {
	return original.NewAssetCollectionPage(cur, getNextPage)
}
func NewAssetFilterCollectionIterator(page AssetFilterCollectionPage) AssetFilterCollectionIterator {
	return original.NewAssetFilterCollectionIterator(page)
}
func NewAssetFilterCollectionPage(cur AssetFilterCollection, getNextPage func(context.Context, AssetFilterCollection) (AssetFilterCollection, error)) AssetFilterCollectionPage {
	return original.NewAssetFilterCollectionPage(cur, getNextPage)
}
func NewAssetFiltersClient(subscriptionID string) AssetFiltersClient {
	return original.NewAssetFiltersClient(subscriptionID)
}
func NewAssetFiltersClientWithBaseURI(baseURI string, subscriptionID string) AssetFiltersClient {
	return original.NewAssetFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssetsClient(subscriptionID string) AssetsClient {
	return original.NewAssetsClient(subscriptionID)
}
func NewAssetsClientWithBaseURI(baseURI string, subscriptionID string) AssetsClient {
	return original.NewAssetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentKeyPoliciesClient(subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClient(subscriptionID)
}
func NewContentKeyPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentKeyPolicyCollectionIterator(page ContentKeyPolicyCollectionPage) ContentKeyPolicyCollectionIterator {
	return original.NewContentKeyPolicyCollectionIterator(page)
}
func NewContentKeyPolicyCollectionPage(cur ContentKeyPolicyCollection, getNextPage func(context.Context, ContentKeyPolicyCollection) (ContentKeyPolicyCollection, error)) ContentKeyPolicyCollectionPage {
	return original.NewContentKeyPolicyCollectionPage(cur, getNextPage)
}
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return original.NewJobCollectionIterator(page)
}
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return original.NewJobCollectionPage(cur, getNextPage)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveEventListResultIterator(page LiveEventListResultPage) LiveEventListResultIterator {
	return original.NewLiveEventListResultIterator(page)
}
func NewLiveEventListResultPage(cur LiveEventListResult, getNextPage func(context.Context, LiveEventListResult) (LiveEventListResult, error)) LiveEventListResultPage {
	return original.NewLiveEventListResultPage(cur, getNextPage)
}
func NewLiveEventsClient(subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClient(subscriptionID)
}
func NewLiveEventsClientWithBaseURI(baseURI string, subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveOutputListResultIterator(page LiveOutputListResultPage) LiveOutputListResultIterator {
	return original.NewLiveOutputListResultIterator(page)
}
func NewLiveOutputListResultPage(cur LiveOutputListResult, getNextPage func(context.Context, LiveOutputListResult) (LiveOutputListResult, error)) LiveOutputListResultPage {
	return original.NewLiveOutputListResultPage(cur, getNextPage)
}
func NewLiveOutputsClient(subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClient(subscriptionID)
}
func NewLiveOutputsClientWithBaseURI(baseURI string, subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMediaservicesClient(subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClient(subscriptionID)
}
func NewMediaservicesClientWithBaseURI(baseURI string, subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationResultsClient(subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClient(subscriptionID)
}
func NewOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) OperationResultsClient {
	return original.NewOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationStatusesClient(subscriptionID string) OperationStatusesClient {
	return original.NewOperationStatusesClient(subscriptionID)
}
func NewOperationStatusesClientWithBaseURI(baseURI string, subscriptionID string) OperationStatusesClient {
	return original.NewOperationStatusesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceCollectionIterator(page ServiceCollectionPage) ServiceCollectionIterator {
	return original.NewServiceCollectionIterator(page)
}
func NewServiceCollectionPage(cur ServiceCollection, getNextPage func(context.Context, ServiceCollection) (ServiceCollection, error)) ServiceCollectionPage {
	return original.NewServiceCollectionPage(cur, getNextPage)
}
func NewStreamingEndpointListResultIterator(page StreamingEndpointListResultPage) StreamingEndpointListResultIterator {
	return original.NewStreamingEndpointListResultIterator(page)
}
func NewStreamingEndpointListResultPage(cur StreamingEndpointListResult, getNextPage func(context.Context, StreamingEndpointListResult) (StreamingEndpointListResult, error)) StreamingEndpointListResultPage {
	return original.NewStreamingEndpointListResultPage(cur, getNextPage)
}
func NewStreamingEndpointsClient(subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClient(subscriptionID)
}
func NewStreamingEndpointsClientWithBaseURI(baseURI string, subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingLocatorCollectionIterator(page StreamingLocatorCollectionPage) StreamingLocatorCollectionIterator {
	return original.NewStreamingLocatorCollectionIterator(page)
}
func NewStreamingLocatorCollectionPage(cur StreamingLocatorCollection, getNextPage func(context.Context, StreamingLocatorCollection) (StreamingLocatorCollection, error)) StreamingLocatorCollectionPage {
	return original.NewStreamingLocatorCollectionPage(cur, getNextPage)
}
func NewStreamingLocatorsClient(subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClient(subscriptionID)
}
func NewStreamingLocatorsClientWithBaseURI(baseURI string, subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingPoliciesClient(subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClient(subscriptionID)
}
func NewStreamingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingPolicyCollectionIterator(page StreamingPolicyCollectionPage) StreamingPolicyCollectionIterator {
	return original.NewStreamingPolicyCollectionIterator(page)
}
func NewStreamingPolicyCollectionPage(cur StreamingPolicyCollection, getNextPage func(context.Context, StreamingPolicyCollection) (StreamingPolicyCollection, error)) StreamingPolicyCollectionPage {
	return original.NewStreamingPolicyCollectionPage(cur, getNextPage)
}
func NewTracksClient(subscriptionID string) TracksClient {
	return original.NewTracksClient(subscriptionID)
}
func NewTracksClientWithBaseURI(baseURI string, subscriptionID string) TracksClient {
	return original.NewTracksClientWithBaseURI(baseURI, subscriptionID)
}
func NewTransformCollectionIterator(page TransformCollectionPage) TransformCollectionIterator {
	return original.NewTransformCollectionIterator(page)
}
func NewTransformCollectionPage(cur TransformCollection, getNextPage func(context.Context, TransformCollection) (TransformCollection, error)) TransformCollectionPage {
	return original.NewTransformCollectionPage(cur, getNextPage)
}
func NewTransformsClient(subscriptionID string) TransformsClient {
	return original.NewTransformsClient(subscriptionID)
}
func NewTransformsClientWithBaseURI(baseURI string, subscriptionID string) TransformsClient {
	return original.NewTransformsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAacAudioProfileValues() []AacAudioProfile {
	return original.PossibleAacAudioProfileValues()
}
func PossibleAccountEncryptionKeyTypeValues() []AccountEncryptionKeyType {
	return original.PossibleAccountEncryptionKeyTypeValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAnalysisResolutionValues() []AnalysisResolution {
	return original.PossibleAnalysisResolutionValues()
}
func PossibleAssetContainerPermissionValues() []AssetContainerPermission {
	return original.PossibleAssetContainerPermissionValues()
}
func PossibleAssetStorageEncryptionFormatValues() []AssetStorageEncryptionFormat {
	return original.PossibleAssetStorageEncryptionFormatValues()
}
func PossibleAttributeFilterValues() []AttributeFilter {
	return original.PossibleAttributeFilterValues()
}
func PossibleAudioAnalysisModeValues() []AudioAnalysisMode {
	return original.PossibleAudioAnalysisModeValues()
}
func PossibleBlurTypeValues() []BlurType {
	return original.PossibleBlurTypeValues()
}
func PossibleChannelMappingValues() []ChannelMapping {
	return original.PossibleChannelMappingValues()
}
func PossibleComplexityValues() []Complexity {
	return original.PossibleComplexityValues()
}
func PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues() []ContentKeyPolicyFairPlayRentalAndLeaseKeyType {
	return original.PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues()
}
func PossibleContentKeyPolicyPlayReadyContentTypeValues() []ContentKeyPolicyPlayReadyContentType {
	return original.PossibleContentKeyPolicyPlayReadyContentTypeValues()
}
func PossibleContentKeyPolicyPlayReadyLicenseTypeValues() []ContentKeyPolicyPlayReadyLicenseType {
	return original.PossibleContentKeyPolicyPlayReadyLicenseTypeValues()
}
func PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues() []ContentKeyPolicyPlayReadyUnknownOutputPassingOption {
	return original.PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues()
}
func PossibleContentKeyPolicyRestrictionTokenTypeValues() []ContentKeyPolicyRestrictionTokenType {
	return original.PossibleContentKeyPolicyRestrictionTokenTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDefaultActionValues() []DefaultAction {
	return original.PossibleDefaultActionValues()
}
func PossibleDeinterlaceModeValues() []DeinterlaceMode {
	return original.PossibleDeinterlaceModeValues()
}
func PossibleDeinterlaceParityValues() []DeinterlaceParity {
	return original.PossibleDeinterlaceParityValues()
}
func PossibleEncoderNamedPresetValues() []EncoderNamedPreset {
	return original.PossibleEncoderNamedPresetValues()
}
func PossibleEncryptionSchemeValues() []EncryptionScheme {
	return original.PossibleEncryptionSchemeValues()
}
func PossibleEntropyModeValues() []EntropyMode {
	return original.PossibleEntropyModeValues()
}
func PossibleFaceRedactorModeValues() []FaceRedactorMode {
	return original.PossibleFaceRedactorModeValues()
}
func PossibleFilterTrackPropertyCompareOperationValues() []FilterTrackPropertyCompareOperation {
	return original.PossibleFilterTrackPropertyCompareOperationValues()
}
func PossibleFilterTrackPropertyTypeValues() []FilterTrackPropertyType {
	return original.PossibleFilterTrackPropertyTypeValues()
}
func PossibleH264ComplexityValues() []H264Complexity {
	return original.PossibleH264ComplexityValues()
}
func PossibleH264RateControlModeValues() []H264RateControlMode {
	return original.PossibleH264RateControlModeValues()
}
func PossibleH264VideoProfileValues() []H264VideoProfile {
	return original.PossibleH264VideoProfileValues()
}
func PossibleH265ComplexityValues() []H265Complexity {
	return original.PossibleH265ComplexityValues()
}
func PossibleH265VideoProfileValues() []H265VideoProfile {
	return original.PossibleH265VideoProfileValues()
}
func PossibleInsightsTypeValues() []InsightsType {
	return original.PossibleInsightsTypeValues()
}
func PossibleInterleaveOutputValues() []InterleaveOutput {
	return original.PossibleInterleaveOutputValues()
}
func PossibleJobErrorCategoryValues() []JobErrorCategory {
	return original.PossibleJobErrorCategoryValues()
}
func PossibleJobErrorCodeValues() []JobErrorCode {
	return original.PossibleJobErrorCodeValues()
}
func PossibleJobRetryValues() []JobRetry {
	return original.PossibleJobRetryValues()
}
func PossibleJobStateValues() []JobState {
	return original.PossibleJobStateValues()
}
func PossibleLiveEventEncodingTypeValues() []LiveEventEncodingType {
	return original.PossibleLiveEventEncodingTypeValues()
}
func PossibleLiveEventInputProtocolValues() []LiveEventInputProtocol {
	return original.PossibleLiveEventInputProtocolValues()
}
func PossibleLiveEventResourceStateValues() []LiveEventResourceState {
	return original.PossibleLiveEventResourceStateValues()
}
func PossibleLiveOutputResourceStateValues() []LiveOutputResourceState {
	return original.PossibleLiveOutputResourceStateValues()
}
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return original.PossibleMetricAggregationTypeValues()
}
func PossibleMetricUnitValues() []MetricUnit {
	return original.PossibleMetricUnitValues()
}
func PossibleOdataTypeBasicClipTimeValues() []OdataTypeBasicClipTime {
	return original.PossibleOdataTypeBasicClipTimeValues()
}
func PossibleOdataTypeBasicCodecValues() []OdataTypeBasicCodec {
	return original.PossibleOdataTypeBasicCodecValues()
}
func PossibleOdataTypeBasicContentKeyPolicyConfigurationValues() []OdataTypeBasicContentKeyPolicyConfiguration {
	return original.PossibleOdataTypeBasicContentKeyPolicyConfigurationValues()
}
func PossibleOdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationValues() []OdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocation {
	return original.PossibleOdataTypeBasicContentKeyPolicyPlayReadyContentKeyLocationValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues() []OdataTypeBasicContentKeyPolicyRestrictionTokenKey {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionValues() []OdataTypeBasicContentKeyPolicyRestriction {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionValues()
}
func PossibleOdataTypeBasicFormatValues() []OdataTypeBasicFormat {
	return original.PossibleOdataTypeBasicFormatValues()
}
func PossibleOdataTypeBasicInputDefinitionValues() []OdataTypeBasicInputDefinition {
	return original.PossibleOdataTypeBasicInputDefinitionValues()
}
func PossibleOdataTypeBasicJobInputValues() []OdataTypeBasicJobInput {
	return original.PossibleOdataTypeBasicJobInputValues()
}
func PossibleOdataTypeBasicJobOutputValues() []OdataTypeBasicJobOutput {
	return original.PossibleOdataTypeBasicJobOutputValues()
}
func PossibleOdataTypeBasicOverlayValues() []OdataTypeBasicOverlay {
	return original.PossibleOdataTypeBasicOverlayValues()
}
func PossibleOdataTypeBasicPresetValues() []OdataTypeBasicPreset {
	return original.PossibleOdataTypeBasicPresetValues()
}
func PossibleOdataTypeBasicTrackDescriptorValues() []OdataTypeBasicTrackDescriptor {
	return original.PossibleOdataTypeBasicTrackDescriptorValues()
}
func PossibleOdataTypeValues() []OdataType {
	return original.PossibleOdataTypeValues()
}
func PossibleOnErrorTypeValues() []OnErrorType {
	return original.PossibleOnErrorTypeValues()
}
func PossiblePriorityValues() []Priority {
	return original.PossiblePriorityValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return original.PossiblePrivateEndpointServiceConnectionStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleRotationValues() []Rotation {
	return original.PossibleRotationValues()
}
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return original.PossibleStorageAccountTypeValues()
}
func PossibleStorageAuthenticationValues() []StorageAuthentication {
	return original.PossibleStorageAuthenticationValues()
}
func PossibleStreamOptionsFlagValues() []StreamOptionsFlag {
	return original.PossibleStreamOptionsFlagValues()
}
func PossibleStreamingEndpointResourceStateValues() []StreamingEndpointResourceState {
	return original.PossibleStreamingEndpointResourceStateValues()
}
func PossibleStreamingLocatorContentKeyTypeValues() []StreamingLocatorContentKeyType {
	return original.PossibleStreamingLocatorContentKeyTypeValues()
}
func PossibleStreamingPolicyStreamingProtocolValues() []StreamingPolicyStreamingProtocol {
	return original.PossibleStreamingPolicyStreamingProtocolValues()
}
func PossibleStretchModeValues() []StretchMode {
	return original.PossibleStretchModeValues()
}
func PossibleTrackAttributeValues() []TrackAttribute {
	return original.PossibleTrackAttributeValues()
}
func PossibleTrackPropertyCompareOperationValues() []TrackPropertyCompareOperation {
	return original.PossibleTrackPropertyCompareOperationValues()
}
func PossibleTrackPropertyTypeValues() []TrackPropertyType {
	return original.PossibleTrackPropertyTypeValues()
}
func PossibleVideoSyncModeValues() []VideoSyncMode {
	return original.PossibleVideoSyncModeValues()
}
func PossibleVisibilityValues() []Visibility {
	return original.PossibleVisibilityValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
