//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armblockchain_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blockchain/armblockchain"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_Get.json
func ExampleMembersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMembersClient().Get(ctx, "contosemember1", "mygroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Member = armblockchain.Member{
	// 	Name: to.Ptr("contosemember1"),
	// 	Type: to.Ptr("Microsoft.Blockchain/blockchainMembers"),
	// 	ID: to.Ptr("/subscriptions/51766542-3ed7-4a72-a187-0c8ab644ddab/resourceGroups/mygroup/providers/Microsoft.Blockchain/blockchainMembers/contosemember1"),
	// 	Location: to.Ptr("southeastasia"),
	// 	Properties: &armblockchain.MemberProperties{
	// 		Consortium: to.Ptr("ContoseConsortium"),
	// 		ConsortiumManagementAccountAddress: to.Ptr("0xc40d40dedc353885d3e8393735cf799e4d7fe38c"),
	// 		ConsortiumMemberDisplayName: to.Ptr("contosemember1"),
	// 		ConsortiumRole: to.Ptr("ADMIN"),
	// 		DNS: to.Ptr("contosemember1.blockchain.azure.com"),
	// 		ProvisioningState: to.Ptr(armblockchain.BlockchainMemberProvisioningStateSucceeded),
	// 		PublicKey: to.Ptr("1VhPX4PbNGnE9dOEjgTrw92dltBpKxFQjXWNugcwvl0="),
	// 		RootContractAddress: to.Ptr("0x7407947df2f67142340ca7d1a2c120f0dbfd30e1"),
	// 		UserName: to.Ptr("contosemember1"),
	// 		ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
	// 			Capacity: to.Ptr[int32](2),
	// 		},
	// 		Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_Create.json
func ExampleMembersClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMembersClient().BeginCreate(ctx, "contosemember1", "mygroup", &armblockchain.MembersClientBeginCreateOptions{BlockchainMember: &armblockchain.Member{
		Location: to.Ptr("southeastasia"),
		Properties: &armblockchain.MemberProperties{
			Consortium:                          to.Ptr("ContoseConsortium"),
			ConsortiumManagementAccountPassword: to.Ptr("<consortiumManagementAccountPassword>"),
			Password:                            to.Ptr("<password>"),
			ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
				Capacity: to.Ptr[int32](2),
			},
			Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Member = armblockchain.Member{
	// 	Name: to.Ptr("contosemember1"),
	// 	Type: to.Ptr("Microsoft.Blockchain/blockchainMembers"),
	// 	ID: to.Ptr("/subscriptions/51766542-3ed7-4a72-a187-0c8ab644ddab/resourceGroups/mygroup/providers/Microsoft.Blockchain/blockchainMembers/contosemember1"),
	// 	Location: to.Ptr("southeastasia"),
	// 	Properties: &armblockchain.MemberProperties{
	// 		Consortium: to.Ptr("ContoseConsortium"),
	// 		ProvisioningState: to.Ptr(armblockchain.BlockchainMemberProvisioningStateSucceeded),
	// 		UserName: to.Ptr("contosemember1"),
	// 		ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
	// 			Capacity: to.Ptr[int32](2),
	// 		},
	// 		Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_Delete.json
func ExampleMembersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMembersClient().BeginDelete(ctx, "contosemember1", "mygroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_Update.json
func ExampleMembersClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMembersClient().Update(ctx, "ContoseMember1", "mygroup", &armblockchain.MembersClientUpdateOptions{BlockchainMember: &armblockchain.MemberUpdate{
		Properties: &armblockchain.MemberPropertiesUpdate{
			Password:                            to.Ptr("<password>"),
			ConsortiumManagementAccountPassword: to.Ptr("<consortiumManagementAccountPassword>"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Member = armblockchain.Member{
	// 	Name: to.Ptr("ContoseMember1"),
	// 	Type: to.Ptr("Microsoft.Blockchain/blockchainMembers"),
	// 	ID: to.Ptr("/subscriptions/51766542-3ed7-4a72-a187-0c8ab644ddab/resourceGroups/mygroup/providers/Microsoft.Blockchain/blockchainMembers/ContoseMember1"),
	// 	Location: to.Ptr("southeastasia"),
	// 	Properties: &armblockchain.MemberProperties{
	// 		Consortium: to.Ptr("ContoseConsortium"),
	// 		ConsortiumMemberDisplayName: to.Ptr("contosemember1"),
	// 		ConsortiumRole: to.Ptr("ADMIN"),
	// 		ProvisioningState: to.Ptr(armblockchain.BlockchainMemberProvisioningStateSucceeded),
	// 		UserName: to.Ptr("testuser1"),
	// 		ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
	// 			Capacity: to.Ptr[int32](2),
	// 		},
	// 		Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_List.json
func ExampleMembersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMembersClient().NewListPager("mygroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MemberCollection = armblockchain.MemberCollection{
		// 	Value: []*armblockchain.Member{
		// 		{
		// 			Name: to.Ptr("contosemember1"),
		// 			Type: to.Ptr("Microsoft.Blockchain/blockchainMembers"),
		// 			ID: to.Ptr("/subscriptions/51766542-3ed7-4a72-a187-0c8ab644ddab/resourceGroups/mygroup/providers/Microsoft.Blockchain/blockchainMembers/contosemember1"),
		// 			Location: to.Ptr("southeastasia"),
		// 			Properties: &armblockchain.MemberProperties{
		// 				Consortium: to.Ptr("ContoseConsortium"),
		// 				ConsortiumMemberDisplayName: to.Ptr("contosemember1"),
		// 				ConsortiumRole: to.Ptr("ADMIN"),
		// 				DNS: to.Ptr("contosemember1.blockchain.azure.com"),
		// 				ProvisioningState: to.Ptr(armblockchain.BlockchainMemberProvisioningStateSucceeded),
		// 				PublicKey: to.Ptr("1VhPX4PbNGnE9dOEjgTrw92dltBpKxFQjXWNugcwvl0="),
		// 				RootContractAddress: to.Ptr("0x7407947df2f67142340ca7d1a2c120f0dbfd30e1"),
		// 				UserName: to.Ptr("contosemember1"),
		// 				ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
		// 					Capacity: to.Ptr[int32](2),
		// 				},
		// 				Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_ListAll.json
func ExampleMembersClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMembersClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MemberCollection = armblockchain.MemberCollection{
		// 	Value: []*armblockchain.Member{
		// 		{
		// 			Name: to.Ptr("contosemember1"),
		// 			Type: to.Ptr("Microsoft.Blockchain/blockchainMembers"),
		// 			ID: to.Ptr("/subscriptions/51766542-3ed7-4a72-a187-0c8ab644ddab/resourceGroups/mygroup/providers/Microsoft.Blockchain/blockchainMembers/contosemember1"),
		// 			Location: to.Ptr("southeastasia"),
		// 			Properties: &armblockchain.MemberProperties{
		// 				Consortium: to.Ptr("ContoseConsortium"),
		// 				ConsortiumMemberDisplayName: to.Ptr("contosemember1"),
		// 				ConsortiumRole: to.Ptr("ADMIN"),
		// 				DNS: to.Ptr("contosemember1.blockchain.azure.com"),
		// 				ProvisioningState: to.Ptr(armblockchain.BlockchainMemberProvisioningStateSucceeded),
		// 				PublicKey: to.Ptr("1VhPX4PbNGnE9dOEjgTrw92dltBpKxFQjXWNugcwvl0="),
		// 				RootContractAddress: to.Ptr("0x7407947df2f67142340ca7d1a2c120f0dbfd30e1"),
		// 				UserName: to.Ptr("contosemember1"),
		// 				ValidatorNodesSKU: &armblockchain.MemberNodesSKU{
		// 					Capacity: to.Ptr[int32](2),
		// 				},
		// 				Protocol: to.Ptr(armblockchain.BlockchainProtocolQuorum),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_ListConsortiumMembers.json
func ExampleMembersClient_NewListConsortiumMembersPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMembersClient().NewListConsortiumMembersPager("contosemember1", "mygroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConsortiumMemberCollection = armblockchain.ConsortiumMemberCollection{
		// 	Value: []*armblockchain.ConsortiumMember{
		// 		{
		// 			Name: to.Ptr("contosemember1"),
		// 			DateModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-23T22:34:00.330Z"); return t}()),
		// 			DisplayName: to.Ptr("Contose member 1"),
		// 			JoinDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-04-23T22:34:00.330Z"); return t}()),
		// 			Role: to.Ptr("Member"),
		// 			Status: to.Ptr("Ready"),
		// 			SubscriptionID: to.Ptr("51766542-3ed7-4a72-a187-0c8ab644ddab"),
		// 		},
		// 		{
		// 			Name: to.Ptr(""),
		// 			DateModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-06-23T22:34:00.330Z"); return t}()),
		// 			Role: to.Ptr("ADMIN"),
		// 			Status: to.Ptr("Invited"),
		// 			SubscriptionID: to.Ptr("02bf808a-5446-4e54-aea8-39723aaa05e7"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_ListApiKeys.json
func ExampleMembersClient_ListAPIKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMembersClient().ListAPIKeys(ctx, "contosemember1", "mygroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.APIKeyCollection = armblockchain.APIKeyCollection{
	// 	Keys: []*armblockchain.APIKey{
	// 		{
	// 			KeyName: to.Ptr("key1"),
	// 			Value: to.Ptr("-EnIUzu29xj60xPJmstyCURo"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("key2"),
	// 			Value: to.Ptr("I8P-q4u_WDuCZUBYXnJ3yYX7"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/blockchain/resource-manager/Microsoft.Blockchain/preview/2018-06-01-preview/examples/BlockchainMembers_ListRegenerateApiKeys.json
func ExampleMembersClient_ListRegenerateAPIKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblockchain.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMembersClient().ListRegenerateAPIKeys(ctx, "contosemember1", "mygroup", &armblockchain.MembersClientListRegenerateAPIKeysOptions{APIKey: &armblockchain.APIKey{
		KeyName: to.Ptr("key1"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.APIKeyCollection = armblockchain.APIKeyCollection{
	// 	Keys: []*armblockchain.APIKey{
	// 		{
	// 			KeyName: to.Ptr("key1"),
	// 			Value: to.Ptr("-EnIUzu29xj60xPJmstyCURo"),
	// 		},
	// 		{
	// 			KeyName: to.Ptr("key2"),
	// 			Value: to.Ptr("-EHio4yRJLxajDaxRNaoD7cZ"),
	// 	}},
	// }
}
