package peering

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/peering/mgmt/2020-04-01/peering"

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// Active ...
	Active ConnectionState = "Active"
	// Approved ...
	Approved ConnectionState = "Approved"
	// None ...
	None ConnectionState = "None"
	// PendingApproval ...
	PendingApproval ConnectionState = "PendingApproval"
	// ProvisioningCompleted ...
	ProvisioningCompleted ConnectionState = "ProvisioningCompleted"
	// ProvisioningFailed ...
	ProvisioningFailed ConnectionState = "ProvisioningFailed"
	// ProvisioningStarted ...
	ProvisioningStarted ConnectionState = "ProvisioningStarted"
	// Validating ...
	Validating ConnectionState = "Validating"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{Active, Approved, None, PendingApproval, ProvisioningCompleted, ProvisioningFailed, ProvisioningStarted, Validating}
}

// DirectPeeringType enumerates the values for direct peering type.
type DirectPeeringType string

const (
	// Cdn ...
	Cdn DirectPeeringType = "Cdn"
	// Edge ...
	Edge DirectPeeringType = "Edge"
	// Internal ...
	Internal DirectPeeringType = "Internal"
	// Ix ...
	Ix DirectPeeringType = "Ix"
	// IxRs ...
	IxRs DirectPeeringType = "IxRs"
	// Transit ...
	Transit DirectPeeringType = "Transit"
)

// PossibleDirectPeeringTypeValues returns an array of possible values for the DirectPeeringType const type.
func PossibleDirectPeeringTypeValues() []DirectPeeringType {
	return []DirectPeeringType{Cdn, Edge, Internal, Ix, IxRs, Transit}
}

// Family enumerates the values for family.
type Family string

const (
	// Direct ...
	Direct Family = "Direct"
	// Exchange ...
	Exchange Family = "Exchange"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Direct, Exchange}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindDirect ...
	KindDirect Kind = "Direct"
	// KindExchange ...
	KindExchange Kind = "Exchange"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindDirect, KindExchange}
}

// LearnedType enumerates the values for learned type.
type LearnedType string

const (
	// LearnedTypeNone ...
	LearnedTypeNone LearnedType = "None"
	// LearnedTypeViaServiceProvider ...
	LearnedTypeViaServiceProvider LearnedType = "ViaServiceProvider"
	// LearnedTypeViaSession ...
	LearnedTypeViaSession LearnedType = "ViaSession"
)

// PossibleLearnedTypeValues returns an array of possible values for the LearnedType const type.
func PossibleLearnedTypeValues() []LearnedType {
	return []LearnedType{LearnedTypeNone, LearnedTypeViaServiceProvider, LearnedTypeViaSession}
}

// PrefixValidationState enumerates the values for prefix validation state.
type PrefixValidationState string

const (
	// PrefixValidationStateFailed ...
	PrefixValidationStateFailed PrefixValidationState = "Failed"
	// PrefixValidationStateInvalid ...
	PrefixValidationStateInvalid PrefixValidationState = "Invalid"
	// PrefixValidationStateNone ...
	PrefixValidationStateNone PrefixValidationState = "None"
	// PrefixValidationStatePending ...
	PrefixValidationStatePending PrefixValidationState = "Pending"
	// PrefixValidationStateUnknown ...
	PrefixValidationStateUnknown PrefixValidationState = "Unknown"
	// PrefixValidationStateVerified ...
	PrefixValidationStateVerified PrefixValidationState = "Verified"
	// PrefixValidationStateWarning ...
	PrefixValidationStateWarning PrefixValidationState = "Warning"
)

// PossiblePrefixValidationStateValues returns an array of possible values for the PrefixValidationState const type.
func PossiblePrefixValidationStateValues() []PrefixValidationState {
	return []PrefixValidationState{PrefixValidationStateFailed, PrefixValidationStateInvalid, PrefixValidationStateNone, PrefixValidationStatePending, PrefixValidationStateUnknown, PrefixValidationStateVerified, PrefixValidationStateWarning}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Deleting, Failed, Succeeded, Updating}
}

// Role enumerates the values for role.
type Role string

const (
	// RoleEscalation ...
	RoleEscalation Role = "Escalation"
	// RoleNoc ...
	RoleNoc Role = "Noc"
	// RoleOther ...
	RoleOther Role = "Other"
	// RolePolicy ...
	RolePolicy Role = "Policy"
	// RoleService ...
	RoleService Role = "Service"
	// RoleTechnical ...
	RoleTechnical Role = "Technical"
)

// PossibleRoleValues returns an array of possible values for the Role const type.
func PossibleRoleValues() []Role {
	return []Role{RoleEscalation, RoleNoc, RoleOther, RolePolicy, RoleService, RoleTechnical}
}

// SessionAddressProvider enumerates the values for session address provider.
type SessionAddressProvider string

const (
	// Microsoft ...
	Microsoft SessionAddressProvider = "Microsoft"
	// Peer ...
	Peer SessionAddressProvider = "Peer"
)

// PossibleSessionAddressProviderValues returns an array of possible values for the SessionAddressProvider const type.
func PossibleSessionAddressProviderValues() []SessionAddressProvider {
	return []SessionAddressProvider{Microsoft, Peer}
}

// SessionStateV4 enumerates the values for session state v4.
type SessionStateV4 string

const (
	// SessionStateV4Active ...
	SessionStateV4Active SessionStateV4 = "Active"
	// SessionStateV4Connect ...
	SessionStateV4Connect SessionStateV4 = "Connect"
	// SessionStateV4Established ...
	SessionStateV4Established SessionStateV4 = "Established"
	// SessionStateV4Idle ...
	SessionStateV4Idle SessionStateV4 = "Idle"
	// SessionStateV4None ...
	SessionStateV4None SessionStateV4 = "None"
	// SessionStateV4OpenConfirm ...
	SessionStateV4OpenConfirm SessionStateV4 = "OpenConfirm"
	// SessionStateV4OpenReceived ...
	SessionStateV4OpenReceived SessionStateV4 = "OpenReceived"
	// SessionStateV4OpenSent ...
	SessionStateV4OpenSent SessionStateV4 = "OpenSent"
	// SessionStateV4PendingAdd ...
	SessionStateV4PendingAdd SessionStateV4 = "PendingAdd"
	// SessionStateV4PendingRemove ...
	SessionStateV4PendingRemove SessionStateV4 = "PendingRemove"
	// SessionStateV4PendingUpdate ...
	SessionStateV4PendingUpdate SessionStateV4 = "PendingUpdate"
)

// PossibleSessionStateV4Values returns an array of possible values for the SessionStateV4 const type.
func PossibleSessionStateV4Values() []SessionStateV4 {
	return []SessionStateV4{SessionStateV4Active, SessionStateV4Connect, SessionStateV4Established, SessionStateV4Idle, SessionStateV4None, SessionStateV4OpenConfirm, SessionStateV4OpenReceived, SessionStateV4OpenSent, SessionStateV4PendingAdd, SessionStateV4PendingRemove, SessionStateV4PendingUpdate}
}

// SessionStateV6 enumerates the values for session state v6.
type SessionStateV6 string

const (
	// SessionStateV6Active ...
	SessionStateV6Active SessionStateV6 = "Active"
	// SessionStateV6Connect ...
	SessionStateV6Connect SessionStateV6 = "Connect"
	// SessionStateV6Established ...
	SessionStateV6Established SessionStateV6 = "Established"
	// SessionStateV6Idle ...
	SessionStateV6Idle SessionStateV6 = "Idle"
	// SessionStateV6None ...
	SessionStateV6None SessionStateV6 = "None"
	// SessionStateV6OpenConfirm ...
	SessionStateV6OpenConfirm SessionStateV6 = "OpenConfirm"
	// SessionStateV6OpenReceived ...
	SessionStateV6OpenReceived SessionStateV6 = "OpenReceived"
	// SessionStateV6OpenSent ...
	SessionStateV6OpenSent SessionStateV6 = "OpenSent"
	// SessionStateV6PendingAdd ...
	SessionStateV6PendingAdd SessionStateV6 = "PendingAdd"
	// SessionStateV6PendingRemove ...
	SessionStateV6PendingRemove SessionStateV6 = "PendingRemove"
	// SessionStateV6PendingUpdate ...
	SessionStateV6PendingUpdate SessionStateV6 = "PendingUpdate"
)

// PossibleSessionStateV6Values returns an array of possible values for the SessionStateV6 const type.
func PossibleSessionStateV6Values() []SessionStateV6 {
	return []SessionStateV6{SessionStateV6Active, SessionStateV6Connect, SessionStateV6Established, SessionStateV6Idle, SessionStateV6None, SessionStateV6OpenConfirm, SessionStateV6OpenReceived, SessionStateV6OpenSent, SessionStateV6PendingAdd, SessionStateV6PendingRemove, SessionStateV6PendingUpdate}
}

// Size enumerates the values for size.
type Size string

const (
	// Free ...
	Free Size = "Free"
	// Metered ...
	Metered Size = "Metered"
	// Unlimited ...
	Unlimited Size = "Unlimited"
)

// PossibleSizeValues returns an array of possible values for the Size const type.
func PossibleSizeValues() []Size {
	return []Size{Free, Metered, Unlimited}
}

// Tier enumerates the values for tier.
type Tier string

const (
	// Basic ...
	Basic Tier = "Basic"
	// Premium ...
	Premium Tier = "Premium"
)

// PossibleTierValues returns an array of possible values for the Tier const type.
func PossibleTierValues() []Tier {
	return []Tier{Basic, Premium}
}

// ValidationState enumerates the values for validation state.
type ValidationState string

const (
	// ValidationStateApproved ...
	ValidationStateApproved ValidationState = "Approved"
	// ValidationStateFailed ...
	ValidationStateFailed ValidationState = "Failed"
	// ValidationStateNone ...
	ValidationStateNone ValidationState = "None"
	// ValidationStatePending ...
	ValidationStatePending ValidationState = "Pending"
)

// PossibleValidationStateValues returns an array of possible values for the ValidationState const type.
func PossibleValidationStateValues() []ValidationState {
	return []ValidationState{ValidationStateApproved, ValidationStateFailed, ValidationStateNone, ValidationStatePending}
}

// BandwidthOffer the properties that define a peering bandwidth offer.
type BandwidthOffer struct {
	// OfferName - The name of the bandwidth offer.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The value of the bandwidth offer in Mbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// BgpSession the properties that define a BGP session.
type BgpSession struct {
	// SessionPrefixV4 - The IPv4 prefix that contains both ends' IPv4 addresses.
	SessionPrefixV4 *string `json:"sessionPrefixV4,omitempty"`
	// SessionPrefixV6 - The IPv6 prefix that contains both ends' IPv6 addresses.
	SessionPrefixV6 *string `json:"sessionPrefixV6,omitempty"`
	// MicrosoftSessionIPv4Address - The IPv4 session address on Microsoft's end.
	MicrosoftSessionIPv4Address *string `json:"microsoftSessionIPv4Address,omitempty"`
	// MicrosoftSessionIPv6Address - The IPv6 session address on Microsoft's end.
	MicrosoftSessionIPv6Address *string `json:"microsoftSessionIPv6Address,omitempty"`
	// PeerSessionIPv4Address - The IPv4 session address on peer's end.
	PeerSessionIPv4Address *string `json:"peerSessionIPv4Address,omitempty"`
	// PeerSessionIPv6Address - The IPv6 session address on peer's end.
	PeerSessionIPv6Address *string `json:"peerSessionIPv6Address,omitempty"`
	// SessionStateV4 - READ-ONLY; The state of the IPv4 session. Possible values include: 'SessionStateV4None', 'SessionStateV4Idle', 'SessionStateV4Connect', 'SessionStateV4Active', 'SessionStateV4OpenSent', 'SessionStateV4OpenConfirm', 'SessionStateV4OpenReceived', 'SessionStateV4Established', 'SessionStateV4PendingAdd', 'SessionStateV4PendingUpdate', 'SessionStateV4PendingRemove'
	SessionStateV4 SessionStateV4 `json:"sessionStateV4,omitempty"`
	// SessionStateV6 - READ-ONLY; The state of the IPv6 session. Possible values include: 'SessionStateV6None', 'SessionStateV6Idle', 'SessionStateV6Connect', 'SessionStateV6Active', 'SessionStateV6OpenSent', 'SessionStateV6OpenConfirm', 'SessionStateV6OpenReceived', 'SessionStateV6Established', 'SessionStateV6PendingAdd', 'SessionStateV6PendingUpdate', 'SessionStateV6PendingRemove'
	SessionStateV6 SessionStateV6 `json:"sessionStateV6,omitempty"`
	// MaxPrefixesAdvertisedV4 - The maximum number of prefixes advertised over the IPv4 session.
	MaxPrefixesAdvertisedV4 *int32 `json:"maxPrefixesAdvertisedV4,omitempty"`
	// MaxPrefixesAdvertisedV6 - The maximum number of prefixes advertised over the IPv6 session.
	MaxPrefixesAdvertisedV6 *int32 `json:"maxPrefixesAdvertisedV6,omitempty"`
	// Md5AuthenticationKey - The MD5 authentication key of the session.
	Md5AuthenticationKey *string `json:"md5AuthenticationKey,omitempty"`
}

// CheckServiceProviderAvailabilityInput class for CheckServiceProviderAvailabilityInput
type CheckServiceProviderAvailabilityInput struct {
	// PeeringServiceLocation - Gets or sets the peering service location.
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`
	// PeeringServiceProvider - Gets or sets the peering service provider.
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`
}

// ContactDetail the contact detail class.
type ContactDetail struct {
	// Role - The role of the contact. Possible values include: 'RoleNoc', 'RolePolicy', 'RoleTechnical', 'RoleService', 'RoleEscalation', 'RoleOther'
	Role Role `json:"role,omitempty"`
	// Email - The e-mail address of the contact.
	Email *string `json:"email,omitempty"`
	// Phone - The phone number of the contact.
	Phone *string `json:"phone,omitempty"`
}

// DirectConnection the properties that define a direct connection.
type DirectConnection struct {
	// BandwidthInMbps - The bandwidth of the connection.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// ProvisionedBandwidthInMbps - READ-ONLY; The bandwidth that is actually provisioned.
	ProvisionedBandwidthInMbps *int32 `json:"provisionedBandwidthInMbps,omitempty"`
	// SessionAddressProvider - The field indicating if Microsoft provides session ip addresses. Possible values include: 'Microsoft', 'Peer'
	SessionAddressProvider SessionAddressProvider `json:"sessionAddressProvider,omitempty"`
	// UseForPeeringService - The flag that indicates whether or not the connection is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// ConnectionState - READ-ONLY; The state of the connection. Possible values include: 'None', 'PendingApproval', 'Approved', 'ProvisioningStarted', 'ProvisioningFailed', 'ProvisioningCompleted', 'Validating', 'Active'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// BgpSession - The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`
	// ConnectionIdentifier - The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`
	// ErrorMessage - READ-ONLY; The error message related to the connection state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// DirectPeeringFacility the properties that define a direct peering facility.
type DirectPeeringFacility struct {
	// Address - The address of the direct peering facility.
	Address *string `json:"address,omitempty"`
	// DirectPeeringType - The type of the direct peering. Possible values include: 'Edge', 'Transit', 'Cdn', 'Internal', 'Ix', 'IxRs'
	DirectPeeringType DirectPeeringType `json:"directPeeringType,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// PeeringDBFacilityLink - The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// ErrorDetail the error detail that describes why an operation has failed.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse the error response that indicates why an operation has failed.
type ErrorResponse struct {
	// Error - The error detail that describes why an operation has failed.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExchangeConnection the properties that define an exchange connection.
type ExchangeConnection struct {
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// ConnectionState - READ-ONLY; The state of the connection. Possible values include: 'None', 'PendingApproval', 'Approved', 'ProvisioningStarted', 'ProvisioningFailed', 'ProvisioningCompleted', 'Validating', 'Active'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// BgpSession - The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`
	// ConnectionIdentifier - The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`
	// ErrorMessage - READ-ONLY; The error message related to the connection state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ExchangePeeringFacility the properties that define an exchange peering facility.
type ExchangePeeringFacility struct {
	// ExchangeName - The name of the exchange peering facility.
	ExchangeName *string `json:"exchangeName,omitempty"`
	// BandwidthInMbps - The bandwidth of the connection between Microsoft and the exchange peering facility.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// MicrosoftIPv4Address - The IPv4 address of Microsoft at the exchange peering facility.
	MicrosoftIPv4Address *string `json:"microsoftIPv4Address,omitempty"`
	// MicrosoftIPv6Address - The IPv6 address of Microsoft at the exchange peering facility.
	MicrosoftIPv6Address *string `json:"microsoftIPv6Address,omitempty"`
	// FacilityIPv4Prefix - The IPv4 prefixes associated with the exchange peering facility.
	FacilityIPv4Prefix *string `json:"facilityIPv4Prefix,omitempty"`
	// FacilityIPv6Prefix - The IPv6 prefixes associated with the exchange peering facility.
	FacilityIPv6Prefix *string `json:"facilityIPv6Prefix,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// PeeringDBFacilityLink - The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// ListResult the paginated list of peerings.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peerings.
	Value *[]Model `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peerings.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of Model values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Model {
	if !iter.page.NotDone() {
		return Model{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of Model values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Model {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// Location peering location is where connectivity could be established to the Microsoft Cloud Edge.
type Location struct {
	// Kind - The kind of peering that the peering location supports. Possible values include: 'KindDirect', 'KindExchange'
	Kind Kind `json:"kind,omitempty"`
	// LocationProperties - The properties that define a peering location.
	*LocationProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.Kind != "" {
		objectMap["kind"] = l.Kind
	}
	if l.LocationProperties != nil {
		objectMap["properties"] = l.LocationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Location struct.
func (l *Location) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				l.Kind = kind
			}
		case "properties":
			if v != nil {
				var locationProperties LocationProperties
				err = json.Unmarshal(*v, &locationProperties)
				if err != nil {
					return err
				}
				l.LocationProperties = &locationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		}
	}

	return nil
}

// LocationListResult the paginated list of peering locations.
type LocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering locations.
	Value *[]Location `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocationListResultIterator provides access to a complete listing of Location values.
type LocationListResultIterator struct {
	i    int
	page LocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocationListResultIterator) Response() LocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocationListResultIterator) Value() Location {
	if !iter.page.NotDone() {
		return Location{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LocationListResultIterator type.
func NewLocationListResultIterator(page LocationListResultPage) LocationListResultIterator {
	return LocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (llr LocationListResult) IsEmpty() bool {
	return llr.Value == nil || len(*llr.Value) == 0
}

// locationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (llr LocationListResult) locationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if llr.NextLink == nil || len(to.String(llr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(llr.NextLink)))
}

// LocationListResultPage contains a page of Location values.
type LocationListResultPage struct {
	fn  func(context.Context, LocationListResult) (LocationListResult, error)
	llr LocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.llr)
	if err != nil {
		return err
	}
	page.llr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocationListResultPage) NotDone() bool {
	return !page.llr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocationListResultPage) Response() LocationListResult {
	return page.llr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocationListResultPage) Values() []Location {
	if page.llr.IsEmpty() {
		return nil
	}
	return *page.llr.Value
}

// Creates a new instance of the LocationListResultPage type.
func NewLocationListResultPage(getNextPage func(context.Context, LocationListResult) (LocationListResult, error)) LocationListResultPage {
	return LocationListResultPage{fn: getNextPage}
}

// LocationProperties the properties that define a peering location.
type LocationProperties struct {
	// Direct - The properties that define a direct peering location.
	Direct *LocationPropertiesDirect `json:"direct,omitempty"`
	// Exchange - The properties that define an exchange peering location.
	Exchange *LocationPropertiesExchange `json:"exchange,omitempty"`
	// PeeringLocation - The name of the peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// Country - The country in which the peering location exists.
	Country *string `json:"country,omitempty"`
	// AzureRegion - The Azure region associated with the peering location.
	AzureRegion *string `json:"azureRegion,omitempty"`
}

// LocationPropertiesDirect the properties that define a direct peering location.
type LocationPropertiesDirect struct {
	// PeeringFacilities - The list of direct peering facilities at the peering location.
	PeeringFacilities *[]DirectPeeringFacility `json:"peeringFacilities,omitempty"`
	// BandwidthOffers - The list of bandwidth offers available at the peering location.
	BandwidthOffers *[]BandwidthOffer `json:"bandwidthOffers,omitempty"`
}

// LocationPropertiesExchange the properties that define an exchange peering location.
type LocationPropertiesExchange struct {
	// PeeringFacilities - The list of exchange peering facilities at the peering location.
	PeeringFacilities *[]ExchangePeeringFacility `json:"peeringFacilities,omitempty"`
}

// Model peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a
// location.
type Model struct {
	autorest.Response `json:"-"`
	// Sku - The SKU that defines the tier and kind of the peering.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - The kind of the peering. Possible values include: 'KindDirect', 'KindExchange'
	Kind Kind `json:"kind,omitempty"`
	// Properties - The properties that define a peering.
	*Properties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Sku != nil {
		objectMap["sku"] = mVar.Sku
	}
	if mVar.Kind != "" {
		objectMap["kind"] = mVar.Kind
	}
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mVar.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mVar.Kind = kind
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mVar.Properties = &properties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// Operation the peering API operation.
type Operation struct {
	// Name - READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The information related to the operation.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// OperationDisplayInfo the information related to the operation.
type OperationDisplayInfo struct {
	// Provider - READ-ONLY; The name of the resource provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The type of the resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the paginated list of peering API operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering API operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering API operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PeerAsn the essential information related to the peer's ASN.
type PeerAsn struct {
	autorest.Response `json:"-"`
	// PeerAsnProperties - The properties that define a peer's ASN.
	*PeerAsnProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeerAsn.
func (pa PeerAsn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pa.PeerAsnProperties != nil {
		objectMap["properties"] = pa.PeerAsnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PeerAsn struct.
func (pa *PeerAsn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var peerAsnProperties PeerAsnProperties
				err = json.Unmarshal(*v, &peerAsnProperties)
				if err != nil {
					return err
				}
				pa.PeerAsnProperties = &peerAsnProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pa.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pa.Type = &typeVar
			}
		}
	}

	return nil
}

// PeerAsnListResult the paginated list of peer ASNs.
type PeerAsnListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peer ASNs.
	Value *[]PeerAsn `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peer ASNs.
	NextLink *string `json:"nextLink,omitempty"`
}

// PeerAsnListResultIterator provides access to a complete listing of PeerAsn values.
type PeerAsnListResultIterator struct {
	i    int
	page PeerAsnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PeerAsnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerAsnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PeerAsnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PeerAsnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PeerAsnListResultIterator) Response() PeerAsnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PeerAsnListResultIterator) Value() PeerAsn {
	if !iter.page.NotDone() {
		return PeerAsn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PeerAsnListResultIterator type.
func NewPeerAsnListResultIterator(page PeerAsnListResultPage) PeerAsnListResultIterator {
	return PeerAsnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (palr PeerAsnListResult) IsEmpty() bool {
	return palr.Value == nil || len(*palr.Value) == 0
}

// peerAsnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (palr PeerAsnListResult) peerAsnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if palr.NextLink == nil || len(to.String(palr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(palr.NextLink)))
}

// PeerAsnListResultPage contains a page of PeerAsn values.
type PeerAsnListResultPage struct {
	fn   func(context.Context, PeerAsnListResult) (PeerAsnListResult, error)
	palr PeerAsnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PeerAsnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerAsnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.palr)
	if err != nil {
		return err
	}
	page.palr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PeerAsnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PeerAsnListResultPage) NotDone() bool {
	return !page.palr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PeerAsnListResultPage) Response() PeerAsnListResult {
	return page.palr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PeerAsnListResultPage) Values() []PeerAsn {
	if page.palr.IsEmpty() {
		return nil
	}
	return *page.palr.Value
}

// Creates a new instance of the PeerAsnListResultPage type.
func NewPeerAsnListResultPage(getNextPage func(context.Context, PeerAsnListResult) (PeerAsnListResult, error)) PeerAsnListResultPage {
	return PeerAsnListResultPage{fn: getNextPage}
}

// PeerAsnProperties the properties that define a peer's ASN.
type PeerAsnProperties struct {
	// PeerAsn - The Autonomous System Number (ASN) of the peer.
	PeerAsn *int32 `json:"peerAsn,omitempty"`
	// PeerContactDetail - The contact details of the peer.
	PeerContactDetail *[]ContactDetail `json:"peerContactDetail,omitempty"`
	// PeerName - The name of the peer.
	PeerName *string `json:"peerName,omitempty"`
	// ValidationState - The validation state of the ASN associated with the peer. Possible values include: 'ValidationStateNone', 'ValidationStatePending', 'ValidationStateApproved', 'ValidationStateFailed'
	ValidationState ValidationState `json:"validationState,omitempty"`
	// ErrorMessage - READ-ONLY; The error message for the validation state
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// Properties the properties that define connectivity to the Microsoft Cloud Edge.
type Properties struct {
	// Direct - The properties that define a direct peering.
	Direct *PropertiesDirect `json:"direct,omitempty"`
	// Exchange - The properties that define an exchange peering.
	Exchange *PropertiesExchange `json:"exchange,omitempty"`
	// PeeringLocation - The location of the peering.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// PropertiesDirect the properties that define a direct peering.
type PropertiesDirect struct {
	// Connections - The set of connections that constitute a direct peering.
	Connections *[]DirectConnection `json:"connections,omitempty"`
	// UseForPeeringService - READ-ONLY; The flag that indicates whether or not the peering is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty"`
	// PeerAsn - The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`
	// DirectPeeringType - The type of direct peering. Possible values include: 'Edge', 'Transit', 'Cdn', 'Internal', 'Ix', 'IxRs'
	DirectPeeringType DirectPeeringType `json:"directPeeringType,omitempty"`
}

// PropertiesExchange the properties that define an exchange peering.
type PropertiesExchange struct {
	// Connections - The set of connections that constitute an exchange peering.
	Connections *[]ExchangeConnection `json:"connections,omitempty"`
	// PeerAsn - The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`
}

// ReceivedRoute the properties that define a received route.
type ReceivedRoute struct {
	// Prefix - READ-ONLY; The prefix.
	Prefix *string `json:"prefix,omitempty"`
	// NextHop - READ-ONLY; The next hop for the prefix.
	NextHop *string `json:"nextHop,omitempty"`
	// AsPath - READ-ONLY; The AS path for the prefix.
	AsPath *string `json:"asPath,omitempty"`
	// OriginAsValidationState - READ-ONLY; The origin AS change information for the prefix.
	OriginAsValidationState *string `json:"originAsValidationState,omitempty"`
	// RpkiValidationState - READ-ONLY; The RPKI validation state for the prefix and origin AS that's listed in the AS path.
	RpkiValidationState *string `json:"rpkiValidationState,omitempty"`
	// TrustAnchor - READ-ONLY; The authority which holds the Route Origin Authorization record for the prefix, if any.
	TrustAnchor *string `json:"trustAnchor,omitempty"`
	// ReceivedTimestamp - READ-ONLY; The received timestamp associated with the prefix.
	ReceivedTimestamp *string `json:"receivedTimestamp,omitempty"`
}

// ReceivedRouteListResult the paginated list of received routes for the peering.
type ReceivedRouteListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of received routes for the peering.
	Value *[]ReceivedRoute `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of received routes for the peering.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReceivedRouteListResultIterator provides access to a complete listing of ReceivedRoute values.
type ReceivedRouteListResultIterator struct {
	i    int
	page ReceivedRouteListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReceivedRouteListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReceivedRouteListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReceivedRouteListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReceivedRouteListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReceivedRouteListResultIterator) Response() ReceivedRouteListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReceivedRouteListResultIterator) Value() ReceivedRoute {
	if !iter.page.NotDone() {
		return ReceivedRoute{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReceivedRouteListResultIterator type.
func NewReceivedRouteListResultIterator(page ReceivedRouteListResultPage) ReceivedRouteListResultIterator {
	return ReceivedRouteListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rrlr ReceivedRouteListResult) IsEmpty() bool {
	return rrlr.Value == nil || len(*rrlr.Value) == 0
}

// receivedRouteListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rrlr ReceivedRouteListResult) receivedRouteListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rrlr.NextLink == nil || len(to.String(rrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rrlr.NextLink)))
}

// ReceivedRouteListResultPage contains a page of ReceivedRoute values.
type ReceivedRouteListResultPage struct {
	fn   func(context.Context, ReceivedRouteListResult) (ReceivedRouteListResult, error)
	rrlr ReceivedRouteListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReceivedRouteListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReceivedRouteListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rrlr)
	if err != nil {
		return err
	}
	page.rrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReceivedRouteListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReceivedRouteListResultPage) NotDone() bool {
	return !page.rrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReceivedRouteListResultPage) Response() ReceivedRouteListResult {
	return page.rrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReceivedRouteListResultPage) Values() []ReceivedRoute {
	if page.rrlr.IsEmpty() {
		return nil
	}
	return *page.rrlr.Value
}

// Creates a new instance of the ReceivedRouteListResultPage type.
func NewReceivedRouteListResultPage(getNextPage func(context.Context, ReceivedRouteListResult) (ReceivedRouteListResult, error)) ReceivedRouteListResultPage {
	return ReceivedRouteListResultPage{fn: getNextPage}
}

// RegisteredAsn the customer's ASN that is registered by the peering service provider.
type RegisteredAsn struct {
	autorest.Response `json:"-"`
	// RegisteredAsnProperties - The properties that define a registered ASN.
	*RegisteredAsnProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegisteredAsn.
func (ra RegisteredAsn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RegisteredAsnProperties != nil {
		objectMap["properties"] = ra.RegisteredAsnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegisteredAsn struct.
func (ra *RegisteredAsn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registeredAsnProperties RegisteredAsnProperties
				err = json.Unmarshal(*v, &registeredAsnProperties)
				if err != nil {
					return err
				}
				ra.RegisteredAsnProperties = &registeredAsnProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RegisteredAsnListResult the paginated list of peering registered ASNs.
type RegisteredAsnListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering registered ASNs.
	Value *[]RegisteredAsn `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering registered ASNs.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegisteredAsnListResultIterator provides access to a complete listing of RegisteredAsn values.
type RegisteredAsnListResultIterator struct {
	i    int
	page RegisteredAsnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegisteredAsnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegisteredAsnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegisteredAsnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegisteredAsnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegisteredAsnListResultIterator) Response() RegisteredAsnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegisteredAsnListResultIterator) Value() RegisteredAsn {
	if !iter.page.NotDone() {
		return RegisteredAsn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegisteredAsnListResultIterator type.
func NewRegisteredAsnListResultIterator(page RegisteredAsnListResultPage) RegisteredAsnListResultIterator {
	return RegisteredAsnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ralr RegisteredAsnListResult) IsEmpty() bool {
	return ralr.Value == nil || len(*ralr.Value) == 0
}

// registeredAsnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ralr RegisteredAsnListResult) registeredAsnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ralr.NextLink == nil || len(to.String(ralr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ralr.NextLink)))
}

// RegisteredAsnListResultPage contains a page of RegisteredAsn values.
type RegisteredAsnListResultPage struct {
	fn   func(context.Context, RegisteredAsnListResult) (RegisteredAsnListResult, error)
	ralr RegisteredAsnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegisteredAsnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegisteredAsnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ralr)
	if err != nil {
		return err
	}
	page.ralr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegisteredAsnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegisteredAsnListResultPage) NotDone() bool {
	return !page.ralr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegisteredAsnListResultPage) Response() RegisteredAsnListResult {
	return page.ralr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegisteredAsnListResultPage) Values() []RegisteredAsn {
	if page.ralr.IsEmpty() {
		return nil
	}
	return *page.ralr.Value
}

// Creates a new instance of the RegisteredAsnListResultPage type.
func NewRegisteredAsnListResultPage(getNextPage func(context.Context, RegisteredAsnListResult) (RegisteredAsnListResult, error)) RegisteredAsnListResultPage {
	return RegisteredAsnListResultPage{fn: getNextPage}
}

// RegisteredAsnProperties the properties that define a registered ASN.
type RegisteredAsnProperties struct {
	// Asn - The customer's ASN from which traffic originates.
	Asn *int32 `json:"asn,omitempty"`
	// PeeringServicePrefixKey - READ-ONLY; The peering service prefix key that is to be shared with the customer.
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// RegisteredPrefix the customer's prefix that is registered by the peering service provider.
type RegisteredPrefix struct {
	autorest.Response `json:"-"`
	// RegisteredPrefixProperties - The properties that define a registered prefix.
	*RegisteredPrefixProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegisteredPrefix.
func (rp RegisteredPrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RegisteredPrefixProperties != nil {
		objectMap["properties"] = rp.RegisteredPrefixProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegisteredPrefix struct.
func (rp *RegisteredPrefix) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registeredPrefixProperties RegisteredPrefixProperties
				err = json.Unmarshal(*v, &registeredPrefixProperties)
				if err != nil {
					return err
				}
				rp.RegisteredPrefixProperties = &registeredPrefixProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RegisteredPrefixListResult the paginated list of peering registered prefixes.
type RegisteredPrefixListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering registered prefixes.
	Value *[]RegisteredPrefix `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering registered prefixes.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegisteredPrefixListResultIterator provides access to a complete listing of RegisteredPrefix values.
type RegisteredPrefixListResultIterator struct {
	i    int
	page RegisteredPrefixListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegisteredPrefixListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegisteredPrefixListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegisteredPrefixListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegisteredPrefixListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegisteredPrefixListResultIterator) Response() RegisteredPrefixListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegisteredPrefixListResultIterator) Value() RegisteredPrefix {
	if !iter.page.NotDone() {
		return RegisteredPrefix{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegisteredPrefixListResultIterator type.
func NewRegisteredPrefixListResultIterator(page RegisteredPrefixListResultPage) RegisteredPrefixListResultIterator {
	return RegisteredPrefixListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rplr RegisteredPrefixListResult) IsEmpty() bool {
	return rplr.Value == nil || len(*rplr.Value) == 0
}

// registeredPrefixListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rplr RegisteredPrefixListResult) registeredPrefixListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rplr.NextLink == nil || len(to.String(rplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rplr.NextLink)))
}

// RegisteredPrefixListResultPage contains a page of RegisteredPrefix values.
type RegisteredPrefixListResultPage struct {
	fn   func(context.Context, RegisteredPrefixListResult) (RegisteredPrefixListResult, error)
	rplr RegisteredPrefixListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegisteredPrefixListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegisteredPrefixListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rplr)
	if err != nil {
		return err
	}
	page.rplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegisteredPrefixListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegisteredPrefixListResultPage) NotDone() bool {
	return !page.rplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegisteredPrefixListResultPage) Response() RegisteredPrefixListResult {
	return page.rplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegisteredPrefixListResultPage) Values() []RegisteredPrefix {
	if page.rplr.IsEmpty() {
		return nil
	}
	return *page.rplr.Value
}

// Creates a new instance of the RegisteredPrefixListResultPage type.
func NewRegisteredPrefixListResultPage(getNextPage func(context.Context, RegisteredPrefixListResult) (RegisteredPrefixListResult, error)) RegisteredPrefixListResultPage {
	return RegisteredPrefixListResultPage{fn: getNextPage}
}

// RegisteredPrefixProperties the properties that define a registered prefix.
type RegisteredPrefixProperties struct {
	// Prefix - The customer's prefix from which traffic originates.
	Prefix *string `json:"prefix,omitempty"`
	// PrefixValidationState - READ-ONLY; The prefix validation state. Possible values include: 'PrefixValidationStateNone', 'PrefixValidationStateInvalid', 'PrefixValidationStateVerified', 'PrefixValidationStateFailed', 'PrefixValidationStatePending', 'PrefixValidationStateWarning', 'PrefixValidationStateUnknown'
	PrefixValidationState PrefixValidationState `json:"prefixValidationState,omitempty"`
	// PeeringServicePrefixKey - READ-ONLY; The peering service prefix key that is to be shared with the customer.
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty"`
	// ErrorMessage - READ-ONLY; The error message associated with the validation state, if any.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// Resource the ARM resource class.
type Resource struct {
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// ResourceTags the resource tags.
type ResourceTags struct {
	// Tags - Gets or sets the tags, a dictionary of descriptors arm object
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceTags.
func (rt ResourceTags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// Service peering Service
type Service struct {
	autorest.Response `json:"-"`
	// Sku - The SKU that defines the type of the peering service.
	Sku *ServiceSku `json:"sku,omitempty"`
	// ServiceProperties - The properties that define a peering service.
	*ServiceProperties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku ServiceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceCountry the peering service country.
type ServiceCountry struct {
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// ServiceCountryListResult the paginated list of peering service countries.
type ServiceCountryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service countries.
	Value *[]ServiceCountry `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service countries.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceCountryListResultIterator provides access to a complete listing of ServiceCountry values.
type ServiceCountryListResultIterator struct {
	i    int
	page ServiceCountryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceCountryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceCountryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceCountryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceCountryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceCountryListResultIterator) Response() ServiceCountryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceCountryListResultIterator) Value() ServiceCountry {
	if !iter.page.NotDone() {
		return ServiceCountry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceCountryListResultIterator type.
func NewServiceCountryListResultIterator(page ServiceCountryListResultPage) ServiceCountryListResultIterator {
	return ServiceCountryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sclr ServiceCountryListResult) IsEmpty() bool {
	return sclr.Value == nil || len(*sclr.Value) == 0
}

// serviceCountryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sclr ServiceCountryListResult) serviceCountryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sclr.NextLink == nil || len(to.String(sclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sclr.NextLink)))
}

// ServiceCountryListResultPage contains a page of ServiceCountry values.
type ServiceCountryListResultPage struct {
	fn   func(context.Context, ServiceCountryListResult) (ServiceCountryListResult, error)
	sclr ServiceCountryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceCountryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceCountryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sclr)
	if err != nil {
		return err
	}
	page.sclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceCountryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceCountryListResultPage) NotDone() bool {
	return !page.sclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceCountryListResultPage) Response() ServiceCountryListResult {
	return page.sclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceCountryListResultPage) Values() []ServiceCountry {
	if page.sclr.IsEmpty() {
		return nil
	}
	return *page.sclr.Value
}

// Creates a new instance of the ServiceCountryListResultPage type.
func NewServiceCountryListResultPage(getNextPage func(context.Context, ServiceCountryListResult) (ServiceCountryListResult, error)) ServiceCountryListResultPage {
	return ServiceCountryListResultPage{fn: getNextPage}
}

// ServiceListResult the paginated list of peering services.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering services.
	Value *[]Service `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListResultIterator provides access to a complete listing of Service values.
type ServiceListResultIterator struct {
	i    int
	page ServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListResultIterator) Response() ServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListResultIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListResultIterator type.
func NewServiceListResultIterator(page ServiceListResultPage) ServiceListResultIterator {
	return ServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServiceListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// serviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServiceListResult) serviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServiceListResultPage contains a page of Service values.
type ServiceListResultPage struct {
	fn  func(context.Context, ServiceListResult) (ServiceListResult, error)
	slr ServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListResultPage) Response() ServiceListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListResultPage) Values() []Service {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServiceListResultPage type.
func NewServiceListResultPage(getNextPage func(context.Context, ServiceListResult) (ServiceListResult, error)) ServiceListResultPage {
	return ServiceListResultPage{fn: getNextPage}
}

// ServiceLocation the peering service location.
type ServiceLocation struct {
	// ServiceLocationProperties - The properties that define a peering service location.
	*ServiceLocationProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceLocation.
func (sl ServiceLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.ServiceLocationProperties != nil {
		objectMap["properties"] = sl.ServiceLocationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceLocation struct.
func (sl *ServiceLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceLocationProperties ServiceLocationProperties
				err = json.Unmarshal(*v, &serviceLocationProperties)
				if err != nil {
					return err
				}
				sl.ServiceLocationProperties = &serviceLocationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceLocationListResult the paginated list of peering service locations.
type ServiceLocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service locations.
	Value *[]ServiceLocation `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceLocationListResultIterator provides access to a complete listing of ServiceLocation values.
type ServiceLocationListResultIterator struct {
	i    int
	page ServiceLocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceLocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceLocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceLocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceLocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceLocationListResultIterator) Response() ServiceLocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceLocationListResultIterator) Value() ServiceLocation {
	if !iter.page.NotDone() {
		return ServiceLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceLocationListResultIterator type.
func NewServiceLocationListResultIterator(page ServiceLocationListResultPage) ServiceLocationListResultIterator {
	return ServiceLocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr ServiceLocationListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// serviceLocationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr ServiceLocationListResult) serviceLocationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sllr.NextLink == nil || len(to.String(sllr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// ServiceLocationListResultPage contains a page of ServiceLocation values.
type ServiceLocationListResultPage struct {
	fn   func(context.Context, ServiceLocationListResult) (ServiceLocationListResult, error)
	sllr ServiceLocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceLocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceLocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sllr)
	if err != nil {
		return err
	}
	page.sllr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceLocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceLocationListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceLocationListResultPage) Response() ServiceLocationListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceLocationListResultPage) Values() []ServiceLocation {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the ServiceLocationListResultPage type.
func NewServiceLocationListResultPage(getNextPage func(context.Context, ServiceLocationListResult) (ServiceLocationListResult, error)) ServiceLocationListResultPage {
	return ServiceLocationListResultPage{fn: getNextPage}
}

// ServiceLocationProperties the properties that define connectivity to the Peering Service Location.
type ServiceLocationProperties struct {
	// Country - Country of the customer
	Country *string `json:"country,omitempty"`
	// State - State of the customer
	State *string `json:"state,omitempty"`
	// AzureRegion - Azure region for the location
	AzureRegion *string `json:"azureRegion,omitempty"`
}

// ServicePrefix the peering service prefix class.
type ServicePrefix struct {
	autorest.Response `json:"-"`
	// ServicePrefixProperties - Gets or sets the peering prefix properties.
	*ServicePrefixProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrefix.
func (sp ServicePrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ServicePrefixProperties != nil {
		objectMap["properties"] = sp.ServicePrefixProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServicePrefix struct.
func (sp *ServicePrefix) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var servicePrefixProperties ServicePrefixProperties
				err = json.Unmarshal(*v, &servicePrefixProperties)
				if err != nil {
					return err
				}
				sp.ServicePrefixProperties = &servicePrefixProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServicePrefixEvent the details of the event associated with a prefix.
type ServicePrefixEvent struct {
	// EventTimestamp - READ-ONLY; The timestamp of the event associated with a prefix.
	EventTimestamp *date.Time `json:"eventTimestamp,omitempty"`
	// EventType - READ-ONLY; The type of the event associated with a prefix.
	EventType *string `json:"eventType,omitempty"`
	// EventSummary - READ-ONLY; The summary of the event associated with a prefix.
	EventSummary *string `json:"eventSummary,omitempty"`
	// EventLevel - READ-ONLY; The level of the event associated with a prefix.
	EventLevel *string `json:"eventLevel,omitempty"`
	// EventDescription - READ-ONLY; The description of the event associated with a prefix.
	EventDescription *string `json:"eventDescription,omitempty"`
}

// ServicePrefixListResult the paginated list of peering service prefixes.
type ServicePrefixListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service prefixes.
	Value *[]ServicePrefix `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service prefixes.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServicePrefixListResultIterator provides access to a complete listing of ServicePrefix values.
type ServicePrefixListResultIterator struct {
	i    int
	page ServicePrefixListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicePrefixListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrefixListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServicePrefixListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicePrefixListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicePrefixListResultIterator) Response() ServicePrefixListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicePrefixListResultIterator) Value() ServicePrefix {
	if !iter.page.NotDone() {
		return ServicePrefix{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServicePrefixListResultIterator type.
func NewServicePrefixListResultIterator(page ServicePrefixListResultPage) ServicePrefixListResultIterator {
	return ServicePrefixListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServicePrefixListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// servicePrefixListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splr ServicePrefixListResult) servicePrefixListResultPreparer(ctx context.Context) (*http.Request, error) {
	if splr.NextLink == nil || len(to.String(splr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splr.NextLink)))
}

// ServicePrefixListResultPage contains a page of ServicePrefix values.
type ServicePrefixListResultPage struct {
	fn   func(context.Context, ServicePrefixListResult) (ServicePrefixListResult, error)
	splr ServicePrefixListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicePrefixListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrefixListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.splr)
	if err != nil {
		return err
	}
	page.splr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServicePrefixListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicePrefixListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicePrefixListResultPage) Response() ServicePrefixListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicePrefixListResultPage) Values() []ServicePrefix {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the ServicePrefixListResultPage type.
func NewServicePrefixListResultPage(getNextPage func(context.Context, ServicePrefixListResult) (ServicePrefixListResult, error)) ServicePrefixListResultPage {
	return ServicePrefixListResultPage{fn: getNextPage}
}

// ServicePrefixProperties the peering service prefix properties class.
type ServicePrefixProperties struct {
	// Prefix - The prefix from which your traffic originates.
	Prefix *string `json:"prefix,omitempty"`
	// PrefixValidationState - READ-ONLY; The prefix validation state. Possible values include: 'PrefixValidationStateNone', 'PrefixValidationStateInvalid', 'PrefixValidationStateVerified', 'PrefixValidationStateFailed', 'PrefixValidationStatePending', 'PrefixValidationStateWarning', 'PrefixValidationStateUnknown'
	PrefixValidationState PrefixValidationState `json:"prefixValidationState,omitempty"`
	// LearnedType - READ-ONLY; The prefix learned type. Possible values include: 'LearnedTypeNone', 'LearnedTypeViaServiceProvider', 'LearnedTypeViaSession'
	LearnedType LearnedType `json:"learnedType,omitempty"`
	// ErrorMessage - READ-ONLY; The error message for validation state
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - READ-ONLY; The list of events for peering service prefix
	Events *[]ServicePrefixEvent `json:"events,omitempty"`
	// PeeringServicePrefixKey - The peering service prefix key
	PeeringServicePrefixKey *string `json:"peeringServicePrefixKey,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ServiceProperties the properties that define connectivity to the Peering Service.
type ServiceProperties struct {
	// PeeringServiceLocation - The PeeringServiceLocation of the Customer.
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`
	// PeeringServiceProvider - The MAPS Provider Name.
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// ServiceProvider peeringService provider
type ServiceProvider struct {
	// ServiceProviderProperties - The properties that define a peering service provider.
	*ServiceProviderProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProvider.
func (sp ServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ServiceProviderProperties != nil {
		objectMap["properties"] = sp.ServiceProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceProvider struct.
func (sp *ServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProviderProperties ServiceProviderProperties
				err = json.Unmarshal(*v, &serviceProviderProperties)
				if err != nil {
					return err
				}
				sp.ServiceProviderProperties = &serviceProviderProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceProviderListResult the paginated list of peering service providers.
type ServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service providers.
	Value *[]ServiceProvider `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service providers.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceProviderListResultIterator provides access to a complete listing of ServiceProvider values.
type ServiceProviderListResultIterator struct {
	i    int
	page ServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceProviderListResultIterator) Response() ServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceProviderListResultIterator) Value() ServiceProvider {
	if !iter.page.NotDone() {
		return ServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceProviderListResultIterator type.
func NewServiceProviderListResultIterator(page ServiceProviderListResultPage) ServiceProviderListResultIterator {
	return ServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServiceProviderListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// serviceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splr ServiceProviderListResult) serviceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if splr.NextLink == nil || len(to.String(splr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splr.NextLink)))
}

// ServiceProviderListResultPage contains a page of ServiceProvider values.
type ServiceProviderListResultPage struct {
	fn   func(context.Context, ServiceProviderListResult) (ServiceProviderListResult, error)
	splr ServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.splr)
	if err != nil {
		return err
	}
	page.splr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceProviderListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceProviderListResultPage) Response() ServiceProviderListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceProviderListResultPage) Values() []ServiceProvider {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the ServiceProviderListResultPage type.
func NewServiceProviderListResultPage(getNextPage func(context.Context, ServiceProviderListResult) (ServiceProviderListResult, error)) ServiceProviderListResultPage {
	return ServiceProviderListResultPage{fn: getNextPage}
}

// ServiceProviderProperties the properties that define connectivity to the Peering Service Provider.
type ServiceProviderProperties struct {
	// ServiceProviderName - The name of the service provider.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
}

// ServiceSku the SKU that defines the type of the peering service.
type ServiceSku struct {
	// Name - The name of the peering service SKU.
	Name *string `json:"name,omitempty"`
}

// Sku the SKU that defines the tier and kind of the peering.
type Sku struct {
	// Name - The name of the peering SKU.
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the peering SKU. Possible values include: 'Basic', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// Family - The family of the peering SKU. Possible values include: 'Direct', 'Exchange'
	Family Family `json:"family,omitempty"`
	// Size - The size of the peering SKU. Possible values include: 'Free', 'Metered', 'Unlimited'
	Size Size `json:"size,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	// Value - Possible values include: 'Available', 'Unavailable'
	Value *string `json:"value,omitempty"`
}

// SubResource the sub resource.
type SubResource struct {
	// ID - The identifier of the referenced resource.
	ID *string `json:"id,omitempty"`
}
