// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package logger

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func Test_LoggerContext(t *testing.T) {
	ctx := context.Background()
	assert.Nil(t, ContextGetLogger(ctx))
	logger := NewLogger()
	ctx = ContextSetLogger(ctx, logger)
	assert.EqualValues(t, logger, ContextGetLogger(ctx))
}
