// Code generated by smithy-go-codegen DO NOT EDIT.

package lakeformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lakeformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// For a specific governed table, provides a list of Amazon S3 objects that will
// be written during the current transaction and that can be automatically deleted
// if the transaction is canceled. Without this call, no Amazon S3 objects are
// automatically deleted when a transaction cancels.
//
// The Glue ETL library function write_dynamic_frame.from_catalog() includes an
// option to automatically call DeleteObjectsOnCancel before writes. For more
// information, see [Rolling Back Amazon S3 Writes].
//
// [Rolling Back Amazon S3 Writes]: https://docs.aws.amazon.com/lake-formation/latest/dg/transactions-data-operations.html#rolling-back-writes
func (c *Client) DeleteObjectsOnCancel(ctx context.Context, params *DeleteObjectsOnCancelInput, optFns ...func(*Options)) (*DeleteObjectsOnCancelOutput, error) {
	if params == nil {
		params = &DeleteObjectsOnCancelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteObjectsOnCancel", params, optFns, c.addOperationDeleteObjectsOnCancelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteObjectsOnCancelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteObjectsOnCancelInput struct {

	// The database that contains the governed table.
	//
	// This member is required.
	DatabaseName *string

	// A list of VirtualObject structures, which indicates the Amazon S3 objects to be
	// deleted if the transaction cancels.
	//
	// This member is required.
	Objects []types.VirtualObject

	// The name of the governed table.
	//
	// This member is required.
	TableName *string

	// ID of the transaction that the writes occur in.
	//
	// This member is required.
	TransactionId *string

	// The Glue data catalog that contains the governed table. Defaults to the current
	// account ID.
	CatalogId *string

	noSmithyDocumentSerde
}

type DeleteObjectsOnCancelOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteObjectsOnCancelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteObjectsOnCancel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteObjectsOnCancel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteObjectsOnCancel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteObjectsOnCancelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteObjectsOnCancel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteObjectsOnCancel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteObjectsOnCancel",
	}
}
