/* ddcgt_gocontext.h
 *
 * <copyright>
 * Copyright (C) 2014-2016 Sanford Rockowitz <rockowitz@minsoft.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * </endcopyright>
 */

#ifndef DDCGT_CONTEXT_H_
#define DDCGT_CONTEXT_H_

#include <stdbool.h>

#include <glib-2.0/glib-object.h>
// #include <gio/gio.h>

#include "public/ddcutil_types.h"
#include "public/ddcutil_c_api.h"

#include "ddcg_display_identifier.h"
#include "ddcg_display_ref.h"
#include "ddcg_structs.h"
#include "ddcg_types.h"


// Build Information
DdcgDdcutilVersionSpec * ddcg_get_ddcutil_version_spec(void);
gint *                   ddcg_get_ddcutil_version_spec4(void);
const gchar *            ddcg_get_ddcutil_version_string(void);

/**
 * DDCG_BUILD_OPTIONS_ADL3:
 * Built with ADL support.
 */
#define DDCG_BUILD_OPTIONS_ADL3 1


// cannot use DDCA_BUILT_WITH_USB as a value for the define. must be actual number
/**
 * DDCG_BUILT_WITH_USB3: (value 2)
 * Built with USB support.
 */
#define DDCG_BUILT_WITH_USB3 2
const guint8             ddcg_get_build_options(void);

typedef enum {
   DDCG_BUILD_OPTIONS_ADL2     = DDCA_BUILT_WITH_ADL,
   DDCG_BUILD_OPTIONS_USB2     = DDCA_BUILT_WITH_USB,
   DDCG_BUILT_OPTIONS_FAILSIM2 = DDCA_BUILT_WITH_FAILSIM,
} DdcgBuildOptions;

#ifdef TO_SOURCE
GEnumClass * build_flags_class;
GEnumValue * build_flags_value;


build_flags_class = g_type_class_ref(DDCA_Build_Option_Flags);
build_flags_value = g_enum_get_value(build_flags_class, DDCA_BUILD_FLAGS_USB);
#endif


// Status Codes
const gchar * ddcg_rc_name(DdcgStatusCode status_code);
const gchar * ddcg_rc_desc(DdcgStatusCode status_code);


G_BEGIN_DECLS

#ifdef REPLACED_BY_G_DECLARE_FINAL_TYPE
typedef struct _DdcgContext       DdcgContext;
typedef struct _DdcgContextClass  DdcgContextClass;


struct _DdcgContextClass {
   GObjectClass parent_class;
   bool     class_initialized;
};
#endif

#ifdef NO
struct _DdcgContext {
   GObject   parent_instance;
};
#endif


#define DDCG_TYPE_CONTEXT (ddcg_context_get_type())

G_DECLARE_FINAL_TYPE(DdcgContext, ddcg_context, DDCG, CONTEXT, GObject)

// Not needed.  Generated by G_DECLARE_FINAL_TYPE
/*
#define DDCG_CONTEXT(o)           \
   (G_TYPE_CHECK_INSTANCE_CAST ((o), DDCG_TYPE_CONTEXT, DdcgContext))
#define DDCG_CONTEXT_CLASS(k)     \
   (G_TYPE_CHECK_CLASS_CAST((k), DDCG_TYPE_CONTEXT, DdcgContextClass))
#define DDCG_IS_CONTEXT(o)        \
   (G_TYPE_CHECK_INSTANCE_TYPE ((o), DDCG_TYPE_CONTEXT))
#define DDCG_IS_CONTEXT_CLASS(k)  \
   (G_TYPE_CHECK_CLASS_TYPE ((k), DDCG_TYPE_CONTEXT))
#define DDCG_CONTEXT_GET_CLASS(o) \
   (G_TYPE_INSTANCE_GET_CLASS ((o), DDCG_TYPE_CONTEXT, DdcgContextClass))
*/


#define DDCG_CONTEXT_ERROR    (ddcg_context_quark ())
#define DDCG_CONTEXT_TYPE_ERROR  (ddcg_context_get_type ())

DdcgContext * ddcg_context_new(void);



gint32 ddcg_context_get_max_max_tries(
      DdcgContext * ddcg_context);
     //  GError **     error);

gint32
ddcg_context_get_max_tries(
      DdcgContext *  ddcg_context,
      DdcgRetryType retry_type);


void
ddcg_context_set_max_tries(
      DdcgContext *  ddcg_context,
      DdcgRetryType retry_type,
      gint32             max_tries,
      GError **          error);



DdcgDisplayRef *
ddcg_context_create_display_ref(
      DdcgDisplayIdentifier * ddcg_did,
      GError **               error);

#ifdef REF
/**
 * Returns the ddcutil version as a struct of 3 8 bit integers.
 *
 * @return version numbers
 */
DDCA_Ddcutil_Version_Spec ddca_ddcutil_version(void);       // ddcutil version

/**
 * Returns the ddcutil version as a string in the form "major.minor.micro".
 *
 * @return version string.
 */
const char * ddca_ddcutil_version_string();
#endif



G_END_DECLS

#endif /* DDCGT_CONTEXT_H_ */
