<?php

return CRM_Core_CodeGen_SqlData::create('civicrm_payment_processor_type')
  ->addValues([
    [
      'name' => 'PayPal_Standard',
      'title' => ts('PayPal - Website Payments Standard'),
      'description' => NULL,
      'is_active' => 1,
      'is_default' => 0,
      'user_name_label' => ts('Merchant Account Email'),
      'password_label' => NULL,
      'signature_label' => NULL,
      'subject_label' => NULL,
      'class_name' => 'Payment_PayPalImpl',
      'url_site_default' => 'https://www.paypal.com/',
      'url_api_default' => NULL,
      'url_recur_default' => 'https://www.paypal.com/',
      'url_button_default' => NULL,
      'url_site_test_default' => 'https://www.sandbox.paypal.com/',
      'url_api_test_default' => NULL,
      'url_recur_test_default' => 'https://www.sandbox.paypal.com/',
      'url_button_test_default' => NULL,
      'billing_mode' => 4,
      'is_recur' => 1,
    ],
    [
      'name' => 'PayPal',
      'title' => ts('PayPal - Website Payments Pro'),
      'description' => NULL,
      'is_active' => 1,
      'is_default' => 0,
      'user_name_label' => ts('User Name'),
      'password_label' => ts('Password'),
      'signature_label' => ts('Signature'),
      'subject_label' => NULL,
      'class_name' => 'Payment_PayPalImpl',
      'url_site_default' => 'https://www.paypal.com/',
      'url_api_default' => 'https://api-3t.paypal.com/',
      'url_recur_default' => 'https://www.paypal.com/',
      'url_button_default' => 'https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif',
      'url_site_test_default' => 'https://www.sandbox.paypal.com/',
      'url_api_test_default' => 'https://api-3t.sandbox.paypal.com/',
      'url_recur_test_default' => 'https://www.sandbox.paypal.com/',
      'url_button_test_default' => 'https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif',
      'billing_mode' => 3,
      'is_recur' => 1,
    ],
    [
      'name' => 'PayPal_Express',
      'title' => ts('PayPal - Express'),
      'description' => NULL,
      'is_active' => 1,
      'is_default' => 0,
      'user_name_label' => ts('User Name'),
      'password_label' => ts('Password'),
      'signature_label' => ts('Signature'),
      'subject_label' => NULL,
      'class_name' => 'Payment_PayPalImpl',
      'url_site_default' => 'https://www.paypal.com/',
      'url_api_default' => 'https://api-3t.paypal.com/',
      'url_recur_default' => NULL,
      'url_button_default' => 'https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif',
      'url_site_test_default' => 'https://www.sandbox.paypal.com/',
      'url_api_test_default' => 'https://api-3t.sandbox.paypal.com/',
      'url_recur_test_default' => NULL,
      'url_button_test_default' => 'https://www.paypal.com/en_US/i/btn/btn_xpressCheckout.gif',
      'billing_mode' => 2,
      'is_recur' => 1,
    ],
    [
      'name' => 'AuthNet',
      'title' => ts('Authorize.Net'),
      'description' => NULL,
      'is_active' => 1,
      'is_default' => 0,
      'user_name_label' => ts('API Login'),
      'password_label' => ts('Payment Key'),
      'signature_label' => ts('MD5 Hash'),
      'subject_label' => NULL,
      'class_name' => 'Payment_AuthorizeNet',
      'url_site_default' => 'https://secure2.authorize.net/gateway/transact.dll',
      'url_api_default' => NULL,
      'url_recur_default' => 'https://api2.authorize.net/xml/v1/request.api',
      'url_button_default' => NULL,
      'url_site_test_default' => 'https://test.authorize.net/gateway/transact.dll',
      'url_api_test_default' => NULL,
      'url_recur_test_default' => 'https://apitest.authorize.net/xml/v1/request.api',
      'url_button_test_default' => NULL,
      'billing_mode' => 1,
      'is_recur' => 1,
    ],
    [
      'name' => 'PayJunction',
      'title' => ts('PayJunction'),
      'description' => NULL,
      'is_active' => 0,
      'is_default' => 0,
      'user_name_label' => 'User Name',
      'password_label' => 'Password',
      'signature_label' => NULL,
      'subject_label' => NULL,
      'class_name' => 'Payment_PayJunction',
      'url_site_default' => 'https://payjunction.com/quick_link',
      'url_api_default' => NULL,
      'url_recur_default' => NULL,
      'url_button_default' => NULL,
      'url_site_test_default' => 'https://www.payjunctionlabs.com/quick_link',
      'url_api_test_default' => NULL,
      'url_recur_test_default' => NULL,
      'url_button_test_default' => NULL,
      'billing_mode' => 1,
      'is_recur' => 1,
    ],
    [
      'name' => 'Dummy',
      'title' => ts('Dummy Payment Processor'),
      'description' => NULL,
      'is_active' => 1,
      'is_default' => 1,
      'user_name_label' => ts('User Name'),
      'password_label' => NULL,
      'signature_label' => NULL,
      'subject_label' => NULL,
      'class_name' => 'Payment_Dummy',
      'url_site_default' => NULL,
      'url_api_default' => NULL,
      'url_recur_default' => NULL,
      'url_button_default' => NULL,
      'url_site_test_default' => NULL,
      'url_api_test_default' => NULL,
      'url_recur_test_default' => NULL,
      'url_button_test_default' => NULL,
      'billing_mode' => 1,
      'is_recur' => 1,
    ],
    [
      'name' => 'Realex',
      'title' => ts('Realex Payment'),
      'description' => NULL,
      'is_active' => 0,
      'is_default' => 0,
      'user_name_label' => 'Merchant ID',
      'password_label' => 'Password',
      'signature_label' => NULL,
      'subject_label' => 'Account',
      'class_name' => 'Payment_Realex',
      'url_site_default' => 'https://epage.payandshop.com/epage.cgi',
      'url_api_default' => NULL,
      'url_recur_default' => NULL,
      'url_button_default' => NULL,
      'url_site_test_default' => 'https://epage.payandshop.com/epage-remote.cgi',
      'url_api_test_default' => NULL,
      'url_recur_test_default' => NULL,
      'url_button_test_default' => NULL,
      'billing_mode' => 1,
      'is_recur' => 0,
    ],
    [
      'name' => 'FirstData',
      'title' => ts('FirstData (aka linkpoint)'),
      'description' => ts('FirstData (aka linkpoint)'),
      'is_active' => 0,
      'is_default' => 0,
      'user_name_label' => 'Store name',
      'password_label' => 'certificate path',
      'signature_label' => NULL,
      'subject_label' => NULL,
      'class_name' => 'Payment_FirstData',
      'url_site_default' => 'https://secure.linkpt.net',
      'url_api_default' => NULL,
      'url_recur_default' => NULL,
      'url_button_default' => NULL,
      'url_site_test_default' => 'https://staging.linkpt.net',
      'url_api_test_default' => NULL,
      'url_recur_test_default' => NULL,
      'url_button_test_default' => NULL,
      'billing_mode' => 1,
      'is_recur' => 0,
    ],
  ]);
