# CiviCRM 4.7.31

Released March 7, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21244](https://issues.civicrm.org/jira/browse/CRM-21244) Enhancements
  to "FROM email addresses"
  ([11047](https://github.com/civicrm/civicrm-core/pull/11047))**

  A variety of changes have been made to the email addresses available as the
  "From" address for system messages.  The Organization Address and Contact Info
  form no longer has a field for selecting the From email address--this is now
  editable by choosing a default on the From Email Addresses page.

  The PDF letter task now allows selecting the from email address.

  You can also now choose whether to add the logged-in contact's email address
  to the list of from email addresses. If users' addresses are from other
  domains, they can have deliverability problems if the domain uses SPF or
  DMARC.

  Additionally, this refactors and centralizes a lot of the code regarding from
  email addresses.

- **[CRM-21573](https://issues.civicrm.org/jira/browse/CRM-21573) Allow to
  disable sending of email from activity source contact email for receipt
  ([11424](https://github.com/civicrm/civicrm-core/pull/11424))**

  Now activity notifications will not send from the source contact's email
  address if the site is not set to allow emails from the logged-in contact.

- **[CRM-21719](https://issues.civicrm.org/jira/browse/CRM-21719) Require
  Multibyte PHP Extension
  ([11612](https://github.com/civicrm/civicrm-core/pull/11612) and
  [11599](https://github.com/civicrm/civicrm-core/pull/11599))**

  The Multibyte String PHP function support is now a requirement for installing
  CiviCRM.

- **[CRM-21225](https://issues.civicrm.org/jira/browse/CRM-21225) Add a new
  field, Profile Title so that the Profile Name does not serve a dual purpose of
  labelling the Profile and displaying the Title for the Profile fields publicly
  ([11508](https://github.com/civicrm/civicrm-core/pull/11508) and
  [11503](https://github.com/civicrm/civicrm-core/pull/11503))**

  Profiles can now be given a public title to display on frontend forms that is
  distinct from the name for internal purposes.

- **[CRM-21654](https://issues.civicrm.org/jira/browse/CRM-21654) Support custom
  file field on Batch Entry Profile
  ([11520](https://github.com/civicrm/civicrm-core/pull/11520))**

  File fields are no longer suppressed when batch editing data using a profile,
  and if the field currently has a file, the form displays its name.

- **[CRM-21751](https://issues.civicrm.org/jira/browse/CRM-21751) Move SMS
  provider ID to 'Select Recipients' page from 'SMS content'
  ([11656](https://github.com/civicrm/civicrm-core/pull/11656))**

  The field for choosing the SMS provider now appears before the recipient
  selection fields.

- **[CRM-20769](https://issues.civicrm.org/jira/browse/CRM-20769) Allow for
  Button Text on profiles to be overriden in settings
  ([11598](https://github.com/civicrm/civicrm-core/pull/11598)) (completes
  previous work)**

  The profile quick editor now allows setting the cancel and submit button text.

- **[CRM-21540](https://issues.civicrm.org/jira/browse/CRM-21540) Add support
  for auto-complete fields in the batch entry forms
  ([11398](https://github.com/civicrm/civicrm-core/pull/11398))**

  Auto-complete fields in a profile can now be edited when batch editing data.

- **[CRM-21621](https://issues.civicrm.org/jira/browse/CRM-21621) Provide
  ability to delete first website field
  ([11480](https://github.com/civicrm/civicrm-core/pull/11480))**

  A trashcan link now allows all websites to be removed from a contact.

- **[CRM-21750](https://issues.civicrm.org/jira/browse/CRM-21750) Add support
  for addressee_id, email_greeting_id, postal_greeting_id to api Contact.get
  ([11654](https://github.com/civicrm/civicrm-core/pull/11654))**

  Greeting type ids can now be filtered in the Contact API.

- **[CRM-21707](https://issues.civicrm.org/jira/browse/CRM-21707) Handle
  metadata based serialisation in apiv3 basic_create_fallover
  ([11648](https://github.com/civicrm/civicrm-core/pull/11648),
  [11607](https://github.com/civicrm/civicrm-core/pull/11607), and
  [11583](https://github.com/civicrm/civicrm-core/pull/11583))**

  The standard function for Create actions in the API now uses the serialization
  metadata to format multiple values for saving.

- **[CRM-21140](https://issues.civicrm.org/jira/browse/CRM-21140) Agree & (if
  applicable) implement approach to storing extension data for entities / tables
  ([11567](https://github.com/civicrm/civicrm-core/pull/11567)) (preliminary
  work)**

  The API can now be used to create custom data sets for profiles, price sets,
  and payment tokens.  This is envisioned as a way for extension writers to
  store extended data about these entities.

- **[CRM-21674](https://issues.civicrm.org/jira/browse/CRM-21674) Allow
  proximity search to accept lat & long at the BAO/api level & custom search
  form ([11542](https://github.com/civicrm/civicrm-core/pull/11542))**

  Proximity search via the API or custom search now accepts a latitude/longitude
  combination as an alternative to an address to use as the center point.

- **[CRM-21717](https://issues.civicrm.org/jira/browse/CRM-21717) Allow for
  selecting multiple relationship types in advanced search
  ([11595](https://github.com/civicrm/civicrm-core/pull/11595))**

  Advanced Search now allows for searching for contacts with one of multiple
  specified relationship types.

- **[CRM-21634](https://issues.civicrm.org/jira/browse/CRM-21634) Standardise
  component search options for contact fields, add contact type
  ([11492](https://github.com/civicrm/civicrm-core/pull/11492) and
  [11538](https://github.com/civicrm/civicrm-core/pull/11538))**

  Contact fields on the search forms for contributions, pledges, memberships,
  and participants now share a common structure in both appearance and code.

- **[CRM-21020](https://issues.civicrm.org/jira/browse/CRM-21020)
  alterMailContent hook: pass additional contextual details
  ([10815](https://github.com/civicrm/civicrm-core/pull/10815))**

  When a message is sent via a template, additional details about the template
  are provided to functions invoking `hook_civicrm_alterMailContent`.

- **Add API parameter for fix_address
  ([11372](https://github.com/civicrm/civicrm-core/pull/11372))**

  When saving an address using the API, you can now bypass a handful of fixes
  that normally get applied.

- **[CRM-21741](https://issues.civicrm.org/jira/browse/CRM-21741) For in-place
  editing, allow data-params to be passed to CRM.api3
  ([11639](https://github.com/civicrm/civicrm-core/pull/11639))**

  Fields enabled for in-place editing can now specify additional API parameters
  to be sent when saving updates.

### CiviCampaign

- **[CRM-21593](https://issues.civicrm.org/jira/browse/CRM-21593) New order by
  options for WalkList Report
  ([11449](https://github.com/civicrm/civicrm-core/pull/11449))**

  The Walk / Phone List Report now can be sorted by street name, street number,
  and whether the street number is odd or even.

### CiviCase

- **[CRM-21461](https://issues.civicrm.org/jira/browse/CRM-21461) Case Dashlet
  enhancement ([11304](https://github.com/civicrm/civicrm-core/pull/11304))**

  The Case Dashboard, My Cases dashlet, and All Cases dashlet now use DataTables
  to display results.  This allows easy sorting and filtering of results among
  other improvements.

- **[CRM-21498](https://issues.civicrm.org/jira/browse/CRM-21498) Option to
  Change Status of Linked Cases
  ([11350](https://github.com/civicrm/civicrm-core/pull/11350))**

  When changing the status of a case, you now have the option to update the
  status of all linked cases.

- **[CRM-21520](https://issues.civicrm.org/jira/browse/CRM-21520) Add Action on
  Contact Search to Add Contacts to a Case
  ([11371](https://github.com/civicrm/civicrm-core/pull/11371))**

  Contacts selected from search results can now be added in bulk with a selected
  case role to a selected case.

### CiviContribute

- **[EXT-56](https://issues.civicrm.org/jira/browse/EXT-56) - Add
  com.iatspayments.civicrm to tarballs
  ([11052](https://github.com/civicrm/civicrm-core/pull/11052))**

  The iATS payment processor is now included in core CiviCRM.

- **[CRM-21722](https://issues.civicrm.org/jira/browse/CRM-21722) Payment
  processor check configuration - improved message in UI
  ([11604](https://github.com/civicrm/civicrm-core/pull/11604))**

  A payment processor's configuration is now checked as part of the validation
  of the payment processor configuration form.

- **[CRM-21256](https://issues.civicrm.org/jira/browse/CRM-21256) Payment
  processor contribution page performance improvement
  ([11563](https://github.com/civicrm/civicrm-core/pull/11563))**

  The list of available payment processors is now fetched once rather than
  several times per contribution page load.

- **[CRM-21511](https://issues.civicrm.org/jira/browse/CRM-21511) Add recurring
  contribution to membership detail and contribution
  ([11555](https://github.com/civicrm/civicrm-core/pull/11555) and
  [11365](https://github.com/civicrm/civicrm-core/pull/11365))**

  When viewing a contribution or membership with a recurring contribution, there
  is now a link to view the recurring contribution.

- **[CRM-21050](https://issues.civicrm.org/jira/browse/CRM-21050) Use datepicker
  for all date fields used in contribution backoffice form
  ([10841](https://github.com/civicrm/civicrm-core/pull/10841))**

  The receive date, thank you date, receipt date, and cancel/refund date fields
  now use `datepicker` instead of `jcalendar`.

- **[CRM-21343](https://issues.civicrm.org/jira/browse/CRM-21343) Search
  Contributions by Cancel Date and Cancel Reason
  ([11638](https://github.com/civicrm/civicrm-core/pull/11638))**

  Find Contribution and Advanced Search now allow searching for contributions by
  cancellation reason and date.

- **[CRM-21635](https://issues.civicrm.org/jira/browse/CRM-21635) Expose
  contact custom data on contribution summary report
  ([11494](https://github.com/civicrm/civicrm-core/pull/11494))**

  The Contribution Summary Report can now use contact custom fields as filters
  or displayed in columns.

- **[CRM-20614](https://issues.civicrm.org/jira/browse/CRM-20614) Do not
  Download Export file for Financial Batch
  ([10393](https://github.com/civicrm/civicrm-core/pull/10393))**

  A financial batch export can be set using the API or custom extension to not
  automatically download the file.

### CiviMail

- **[CRM-21546](https://issues.civicrm.org/jira/browse/CRM-21546) Implement
  unique opens filter for mailing opened report
  ([11401](https://github.com/civicrm/civicrm-core/pull/11401))**

  A new option on the Mailing Opened Report toggles displaying all open events
  and all recipients who have opened the message.

### CiviMember

- **[CRM-21512](https://issues.civicrm.org/jira/browse/CRM-21512) Remove
  restriction on "update subscription" when linked to membership
  ([11366](https://github.com/civicrm/civicrm-core/pull/11366))**

  Members with autorenewal enabled can now edit the recurring contribution to
  change the amount or number of installments. They will be warned that the
  recurring contribution is linked to a membership.

- **[CRM-21688](https://issues.civicrm.org/jira/browse/CRM-21688) Use
  fontawesome to show membership auto-renew status and and error indicator
  ([11561](https://github.com/civicrm/civicrm-core/pull/11561))**

  Icons for membership autorenewal now use the Font Awesome library, and a new
  icon indicates memberships that were set to autorenew but have a canceled
  recurring contribution.

### Drupal Integration

- **[CRM-21226](https://issues.civicrm.org/jira/browse/CRM-21226) Add view
  filter handler for contact reference custom field
  ([508](https://github.com/civicrm/civicrm-drupal/pull/508))**

  Contact reference custom fields used as views filters can now filter on
  strings in the sort name in addition to the contact ID of the referenced
  contact.

- **[CRM-20822](https://issues.civicrm.org/jira/browse/CRM-20822) Expose tag
  parent id in views
  ([459](https://github.com/civicrm/civicrm-drupal/pull/459))**

  Views can now display, filter, and sort by parent tag ID or name.

- **[CRM-21758](https://issues.civicrm.org/jira/browse/CRM-21758) Add event
  "created_id" to Drupal Views
  ([519](https://github.com/civicrm/civicrm-drupal/pull/519))**

  Views can now display, filter, and sort by the contact who created an event.
  Relationships can be added to the contact.

### WordPress Integration

- **[CRM-16421](https://issues.civicrm.org/jira/browse/CRM-16421) Work to get
  CiviCRM for WordPress in WordPress' official Repository
  ([11576](https://github.com/civicrm/civicrm-core/pull/11576),
  [121](https://github.com/civicrm/civicrm-wordpress/pull/121), and
  [122](https://github.com/civicrm/civicrm-wordpress/pull/122)) (continues
  previous work)**

  Sites about to install CiviCRM can now indicate whether to use the new
  installer library by the presence of a file named `.use-civicrm-setup`.  A new
  tarball will be generated for each version of CiviCRM named
  `civicrm-*-wporg.zip`.  This new tarball will be equivalent to the
  `civicrm-*-wordpress.zip` files except that it uses the new installer and
  displays a series of opt-ins in order to satisfy WordPress.org requirements.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21715](https://issues.civicrm.org/jira/browse/CRM-21715) Activity
  Report: move the SQL creation to a buildQuery function
  ([11584](https://github.com/civicrm/civicrm-core/pull/11584))**

  This resolves a fatal error that would appear when exporting to CSV from the
  Activity Report.

- **[CRM-21334](https://issues.civicrm.org/jira/browse/CRM-21334) Fire hooks on
  contact image deletion
  ([11163](https://github.com/civicrm/civicrm-core/pull/11163))**

  The expected hooks are triggered when deleting a contact image.

- **[CRM-21701](https://issues.civicrm.org/jira/browse/CRM-21701) street
  addresses are not reliably parsed
  ([11579](https://github.com/civicrm/civicrm-core/pull/11579))**

  Street addresses are now parsed whenever they're edited if address parsing is
  enabled.  Previously, this was only done if USPS address standardization was
  enabled.

- **[CRM-21629](https://issues.civicrm.org/jira/browse/CRM-21629) Resource URL
  status check gets false positive when blank user agents are blocked
  ([11488](https://github.com/civicrm/civicrm-core/pull/11488))**

  The system check for verifying resource URLs now sets a user agent header when
  making HTTP requests to the server.

- **[CRM-21591](https://issues.civicrm.org/jira/browse/CRM-21591) PHP 7.1 issue
  Non well form numeric value encountered when viewing the misc settings screen
  ([11505](https://github.com/civicrm/civicrm-core/pull/11505) and
  [11447](https://github.com/civicrm/civicrm-core/pull/11447))**

- **[CRM-21618](https://issues.civicrm.org/jira/browse/CRM-21618) Add missing
  structure in templates
  ([11478](https://github.com/civicrm/civicrm-core/pull/11478) and
  [11457](https://github.com/civicrm/civicrm-core/pull/11457))**

  Several form templates with nonstandard markup have been updated slightly.

- **[CRM-8140](https://issues.civicrm.org/jira/browse/CRM-8140) Not possible to
  select fields for export when using Custom Searches
  ([11458](https://github.com/civicrm/civicrm-core/pull/11458))**

- **[CRM-21616](https://issues.civicrm.org/jira/browse/CRM-21616) sql metadata
  is being lost when calling the report from the api
  ([11476](https://github.com/civicrm/civicrm-core/pull/11476))**

  When retrieving a report via the API, the SQL query is now reliably provided
  if requested.

- **[CRM-21670](https://issues.civicrm.org/jira/browse/CRM-21670) Search of
  active relationships does not appear on Relationship Report
  ([11537](https://github.com/civicrm/civicrm-core/pull/11537))**

  This restores the filter in the Relationship Report for a relationship's
  active period.  The filter had been removed accidentally in a past
  improvement.

- **[CRM-20996](https://issues.civicrm.org/jira/browse/CRM-20996) Copy profile
  from wizard duplicates 'name' in database
  ([11597](https://github.com/civicrm/civicrm-core/pull/11597))**

  This ensures that the profile machine name is unique when copying profiles.  A
  database error would result when copying profiles while editing events or
  contribution pages.

- **[dev/core#2](https://lab.civicrm.org/dev/core/issues/2) Display Inbound
  Email: linefeed suppressed
  ([11661](https://github.com/civicrm/civicrm-core/pull/11661))**

  When viewing an activity, the Details field now displays line breaks that are
  in the original.  This is important in viewing the text of inbound email
  activities.

- **[CRM-21738](https://issues.civicrm.org/jira/browse/CRM-21738) Merges not
  copying viewOnly data (regression but not recent)
  ([11636](https://github.com/civicrm/civicrm-core/pull/11636))**

  View-only custom data was not copying to the merged contact when merging two
  contacts.

- **[CRM-21742](https://issues.civicrm.org/jira/browse/CRM-21742) Use form
  validation rather than Exception handling for proximity seach
  ([11643](https://github.com/civicrm/civicrm-core/pull/11643))**

  Custom searches now support validation, the proximity search is now configured
  to display validation errors rather than a cause a full-blown exception when
  geocoding fails.

- **[CRM-19784](https://issues.civicrm.org/jira/browse/CRM-19784) Yahoo
  Placefinder service appears to have EOL'ed
  ([11540](https://github.com/civicrm/civicrm-core/pull/11540))**

  Support is removed for the now-defunct Yahoo geocoding service.

- **[CRM-21737](https://issues.civicrm.org/jira/browse/CRM-21737) New option
  value validation is too tight for languages
  ([11633](https://github.com/civicrm/civicrm-core/pull/11633))**

  Option values for language now only need to have a unique name rather than a
  unique value.

- **Website api - fix nonstandard BAO delete method
  ([11625](https://github.com/civicrm/civicrm-core/pull/11625))**

  Deleting a website now uses a standard method that invokes all the usual hooks.

- **Use mb_strlen() in ellipsify() to avoid excessive multibyte truncation
  ([11594](https://github.com/civicrm/civicrm-core/pull/11594))**

  This resolves problems truncating text with multibyte characters to a shorter
  length than intended.

- **[CRM-21524](https://issues.civicrm.org/jira/browse/CRM-21524) CiviCRM
  exports (postal) mailing lists including Contacts clearly marked is_deceased
  in the database
  ([11527](https://github.com/civicrm/civicrm-core/pull/11527))**

  This ensures that exports suppress deceased and "do not mail" contacts prior
  to merging rows with the same address.  Previously, contacts sharing an
  address with a deceased contact in the same search result would be merged with
  them in the results.

- **[CRM-21687](https://issues.civicrm.org/jira/browse/CRM-21687) MariaDB 10.2
  and logging: log_civicrm_activity schema syntax error
  ([11580](https://github.com/civicrm/civicrm-core/pull/11580))**

- **[CRM-21651](https://issues.civicrm.org/jira/browse/CRM-21651) Contact :: New
  Email/SMS : loading failed when no contact is found
  ([11506](https://github.com/civicrm/civicrm-core/pull/11506))**

- **[CRM-21669](https://issues.civicrm.org/jira/browse/CRM-21669) Consistent
  wording for "Email - Send now" task
  ([11535](https://github.com/civicrm/civicrm-core/pull/11535))**

- **[CRM-21613](https://issues.civicrm.org/jira/browse/CRM-21613) Search issues
  on 'Manage Tag' page
  ([11510](https://github.com/civicrm/civicrm-core/pull/11510) and
  [11467](https://github.com/civicrm/civicrm-core/pull/11467))**

- **[CRM-21444](https://issues.civicrm.org/jira/browse/CRM-21444) Empty field at
  form "Add rule for..." merge duplicate contacts
  ([11523](https://github.com/civicrm/civicrm-core/pull/11523))**

  The contact type options when creating a dedupe rule would not appear when in
  a language other than English.

- **[CRM-21533](https://issues.civicrm.org/jira/browse/CRM-21533) Outbound
  setting reverts in non-production sites on executing sched job
  ([11393](https://github.com/civicrm/civicrm-core/pull/11393))**

  This resolves a bug where running a scheduled job on a site in development
  mode would re-enable outbound mail.

- **[CRM-17352](https://issues.civicrm.org/jira/browse/CRM-17352) Backbone
  no-conflict ([11504](https://github.com/civicrm/civicrm-core/pull/11504) and
  [198](https://github.com/civicrm/civicrm-packages/pull/198))**

  CiviCRM now uses Backbone.js in `noConflict` mode to prevent conflicts if the
  CMS has its own copy of the library.

- **[CRM-21644](https://issues.civicrm.org/jira/browse/CRM-21644) Preferred
  Communication Method is not set to default for contact
  ([11499](https://github.com/civicrm/civicrm-core/pull/11499))**

  A contact's Preferred Communication Method field now defaults to its current
  value when included in a profile.

- **[CRM-18300](https://issues.civicrm.org/jira/browse/CRM-18300) "Permission
  denied" message re contact on CiviCRM dashboard
  ([11470](https://github.com/civicrm/civicrm-core/pull/11470))**

- **[CRM-21614](https://issues.civicrm.org/jira/browse/CRM-21614) Tag UI doesn't
  appear to respect reserved tags permission
  ([11469](https://github.com/civicrm/civicrm-core/pull/11469))**

  This resolves a problem where a non-privileged user editing a reserved tag
  would appear to be able to make edits, but the edits would not take effect.

- **[CRM-21744](https://issues.civicrm.org/jira/browse/CRM-21744) Fix proximity
  custom search to work with smart groups
  ([11645](https://github.com/civicrm/civicrm-core/pull/11645))**

- **[CRM-21159](https://issues.civicrm.org/jira/browse/CRM-21159) Address fields
  cause DB errors when adding contacts to group from Search Builder
  ([11524](https://github.com/civicrm/civicrm-core/pull/11524) and
  [11422](https://github.com/civicrm/civicrm-core/pull/11422))**

- **[CRM-14834](https://issues.civicrm.org/jira/browse/CRM-14834) Activity
  Export with Relationships incurs fatal error
  ([11526](https://github.com/civicrm/civicrm-core/pull/11526))**

- **[CRM-18048](https://issues.civicrm.org/jira/browse/CRM-18048) Activity
  Report fatal error when including custom field set with long name
  ([11183](https://github.com/civicrm/civicrm-core/pull/11183))**

### CiviCampaign

- **[CRM-21602](https://issues.civicrm.org/jira/browse/CRM-21602) Disable/Enable
  Campaign not working
  ([11466](https://github.com/civicrm/civicrm-core/pull/11466))**

  The loading icon would not stop when working with the listings of campaigns,
  surveys, and petitions.

- **[CRM-21663](https://issues.civicrm.org/jira/browse/CRM-21663) Fix Campaign
  Search and result structure
  ([11528](https://github.com/civicrm/civicrm-core/pull/11528))**

### CiviCase

- **[CRM-21760](https://issues.civicrm.org/jira/browse/CRM-21760) Manager Name
  is missing in 'Find Cases' search list
  ([11665](https://github.com/civicrm/civicrm-core/pull/11665))**

- **[CRM-21730](https://issues.civicrm.org/jira/browse/CRM-21730) postProcess()
  hook don't receive case id after submitting "New Case" form
  ([11618](https://github.com/civicrm/civicrm-core/pull/11618))**

- **[CRM-21704](https://issues.civicrm.org/jira/browse/CRM-21704) Do Not allow a
  case type that is reserved to be deleted or disabled.
  ([11581](https://github.com/civicrm/civicrm-core/pull/11581))**

### CiviContribute

- **[CRM-17647](https://issues.civicrm.org/jira/browse/CRM-17647) Recording
  payment truncates the amount after the comma (whether thousands or decimal
  separator) ([11539](https://github.com/civicrm/civicrm-core/pull/11539),
  [11646](https://github.com/civicrm/civicrm-core/pull/11646),
  [11575](https://github.com/civicrm/civicrm-core/pull/11575),
  [11574](https://github.com/civicrm/civicrm-core/pull/11574),
  [11554](https://github.com/civicrm/civicrm-core/pull/11554),
  [11547](https://github.com/civicrm/civicrm-core/pull/11547), and
  [11541](https://github.com/civicrm/civicrm-core/pull/11541))**

  Monetary amounts are now more consistently cleaned in the form layer.

- **[CRM-21323](https://issues.civicrm.org/jira/browse/CRM-21323) Fix backend
  credit card payment processor selection
  ([11530](https://github.com/civicrm/civicrm-core/pull/11530))**

  This resolves a problem when a backend credit card contribution form fails
  validation: the first payment processor listed would load instead of the one
  selected.

- **[CRM-20625](https://issues.civicrm.org/jira/browse/CRM-20625) Better Payment
  Processor extension error handling
  ([11631](https://github.com/civicrm/civicrm-core/pull/11631))**

  This resolves a problem where CiviCRM would crash attempting to load a payment
  processor provided by a disabled or missing extension.

- **[CRM-21698](https://issues.civicrm.org/jira/browse/CRM-21698) On some
  systems recording a negative contribution results in a $0 contribution
  ([11577](https://github.com/civicrm/civicrm-core/pull/11577))**

- **[dev/core#1](https://lab.civicrm.org/dev/core/issues/1) Allow to search for
  "in progress" contributions
  ([11640](https://github.com/civicrm/civicrm-core/pull/11640))**

  The "in progress" and "overdue" statuses are now available for searching
  contributions.

- **Amount and source could exceed max length of subject column
  ([11593](https://github.com/civicrm/civicrm-core/pull/11593))**

  The activity corresponding to a contribution is given a subject based upon the
  contribution source and amount.  Since the combined string could be longer
  than the activity subject field's maximum length, this truncates it with an
  ellipsis.

- **[CRM-21721](https://issues.civicrm.org/jira/browse/CRM-21721) Notice :
  Division by zero ([11623](https://github.com/civicrm/civicrm-core/pull/11623)
  and [11601](https://github.com/civicrm/civicrm-core/pull/11601))**

  This resolves a PHP notice that would appear when submitting a $0.00
  contribution using a price set.

- **[CRM-21684](https://issues.civicrm.org/jira/browse/CRM-21684) contact
  subtype fields prevent inclusion in profile/receipt email
  ([11559](https://github.com/civicrm/civicrm-core/pull/11559))**

  This resolves a problem where adding a subtype-specific custom field to a
  profile prevents any fields from the profile being included in receipts.

- **[CRM-21647](https://issues.civicrm.org/jira/browse/CRM-21647) Fatal error on
  deleting any contribution record
  ([11500](https://github.com/civicrm/civicrm-core/pull/11500))**

- **[CRM-21580](https://issues.civicrm.org/jira/browse/CRM-21580) exporting
  financial batch fails when label of batch statuses changed
  ([11434](https://github.com/civicrm/civicrm-core/pull/11434))**

- **[CRM-21589](https://issues.civicrm.org/jira/browse/CRM-21589) "Repeat
  Contributions" report ignores sort
  ([11446](https://github.com/civicrm/civicrm-core/pull/11446))**

- **[CRM-20676](https://issues.civicrm.org/jira/browse/CRM-20676) Tax applied
  repeatedly on edits of price set events
  ([11655](https://github.com/civicrm/civicrm-core/pull/11655) and
  [11461](https://github.com/civicrm/civicrm-core/pull/11461)) (completes
  previous work)**

- **[CRM-19752](https://issues.civicrm.org/jira/browse/CRM-19752) Slow query
  created by financial type acls
  ([11621](https://github.com/civicrm/civicrm-core/pull/11621) and
  [9746](https://github.com/civicrm/civicrm-core/pull/9746))**

- **[CRM-21665](https://issues.civicrm.org/jira/browse/CRM-21665) Check Number
  show hide not working
  ([11611](https://github.com/civicrm/civicrm-core/pull/11611))**

- **[CRM-21155](https://issues.civicrm.org/jira/browse/CRM-21155) Hook
  batchItems does not change the csv export
  ([10951](https://github.com/civicrm/civicrm-core/pull/10951))**

- **[CRM-19107](https://issues.civicrm.org/jira/browse/CRM-19107) PayPal Button
  Error ([11474](https://github.com/civicrm/civicrm-core/pull/11474))**

  The PayPal Express button now reliably sends the donor to PayPal rather than
  submitting the contribution form.

- **[CRM-21609](https://issues.civicrm.org/jira/browse/CRM-21609) PayPal Pro IPN
  code no longer respects changed recurring amount
  ([11463](https://github.com/civicrm/civicrm-core/pull/11463))**

- **[CRM-21728](https://issues.civicrm.org/jira/browse/CRM-21728) Intermittant
  fatal on pcp.create api
  ([11606](https://github.com/civicrm/civicrm-core/pull/11606))**

- **[CRM-21664](https://issues.civicrm.org/jira/browse/CRM-21664) Contributions
  creation result in error for certain currencies
  ([11533](https://github.com/civicrm/civicrm-core/pull/11533))**

  Currency validation now uses the `civicrm_currency` table rather than a
  hard-coded list of values.

- **[CRM-21528](https://issues.civicrm.org/jira/browse/CRM-21528) top donor
  report: add2group error
  ([11482](https://github.com/civicrm/civicrm-core/pull/11482))**

- **[CRM-20866](https://issues.civicrm.org/jira/browse/CRM-20866) Soft credit
  appearance inconsistent in contribution search
  ([11433](https://github.com/civicrm/civicrm-core/pull/11433))**

  This resolves problems when changing the option for displaying soft credits
  during a series of contribution searches.

### CiviEvent

- **[CRM-21771](https://issues.civicrm.org/jira/browse/CRM-21771) error when
  viewing event registration with linked contribution
  ([11749](https://github.com/civicrm/civicrm-core/pull/11749))**

- **[CRM-21623](https://issues.civicrm.org/jira/browse/CRM-21623) Smart Group
  Relative Date not saving for some fields in Advance Search.
  ([11486](https://github.com/civicrm/civicrm-core/pull/11486))**

- **[CRM-21743](https://issues.civicrm.org/jira/browse/CRM-21743) Creating an
  event template from existing one does not work
  ([11644](https://github.com/civicrm/civicrm-core/pull/11644))**

  This resolves a problem where using an event template to create a new event
  template would result in creating a new event instead.

- **[CRM-21071](https://issues.civicrm.org/jira/browse/CRM-21071) Event Location
  Tab: Second Email and Phone fields broken
  ([11568](https://github.com/civicrm/civicrm-core/pull/11568))**

### CiviMail

- **[CRM-21759](https://issues.civicrm.org/jira/browse/CRM-21759) mailing
  template selector missing
  ([11676](https://github.com/civicrm/civicrm-core/pull/11676))**

  This restores the field to select a template when composing a CiviMail
  message.  It had gone missing in 4.7.30.

- **[CRM-21683](https://issues.civicrm.org/jira/browse/CRM-21683) Mailing
  summary breaks on mailing names with apostrophes
  ([11557](https://github.com/civicrm/civicrm-core/pull/11557))**

  The mailing name filter in the Mailing Summary Report now uses a standard
  filter, resolving problems with using an apostrophe in the search text.

- **[CRM-21260](https://issues.civicrm.org/jira/browse/CRM-21260) and
  [CRM-21316](https://issues.civicrm.org/jira/browse/CRM-21316) CiviMail compose
  UI very slow to initialize when many mailing groups, past mailings and
  templates ([11142](https://github.com/civicrm/civicrm-core/pull/11142) and
  [11558](https://github.com/civicrm/civicrm-core/pull/11558))**

  The process of building recipient lists for CiviMail has been refactored to be
  simpler and faster.

- **[CRM-21521](https://issues.civicrm.org/jira/browse/CRM-21521) Bounce
  processing exception: no such property 'text'
  ([11390](https://github.com/civicrm/civicrm-core/pull/11390))**

  This correctly handles bounce messages that have nested multipart parts.

- **[CRM-21749](https://issues.civicrm.org/jira/browse/CRM-21749) [obscure
  intra-rc regression] Mailing api no longer respecting
  '_skip_evil_bao_auto_schedule_'
  ([11653](https://github.com/civicrm/civicrm-core/pull/11653))**

### CiviMember

- **[CRM-20707](https://issues.civicrm.org/jira/browse/CRM-20707) membership
  inheritance does not update start/end dates
  ([10485](https://github.com/civicrm/civicrm-core/pull/10485))**

- **[CRM-21554](https://issues.civicrm.org/jira/browse/CRM-21554) Offline Credit
  Card Membership Renewal not showing any error message on failure
  ([11408](https://github.com/civicrm/civicrm-core/pull/11408))**

- **[CRM-21485](https://issues.civicrm.org/jira/browse/CRM-21485) Tax not added
  when renewing membership in backend
  ([11459](https://github.com/civicrm/civicrm-core/pull/11459))**

- **[CRM-21612](https://issues.civicrm.org/jira/browse/CRM-21612) Membership
  Payment not recorded for recurring contribution when status label is changed.
  ([11465](https://github.com/civicrm/civicrm-core/pull/11465))**

- **[CRM-21724](https://issues.civicrm.org/jira/browse/CRM-21724) Receipt for
  membership contribution sending custom fields for wrong membership type
  ([11605](https://github.com/civicrm/civicrm-core/pull/11605))**

- **[CRM-21656](https://issues.civicrm.org/jira/browse/CRM-21656) Backend
  Membership with Priceset applies taxes twice to line_item
  ([11521](https://github.com/civicrm/civicrm-core/pull/11521))**

- **[CRM-19920](https://issues.civicrm.org/jira/browse/CRM-19920)
  Job.process_membership uses too much memory
  ([11564](https://github.com/civicrm/civicrm-core/pull/11564))**

### Backdrop Integration

- **[CRM-21619](https://issues.civicrm.org/jira/browse/CRM-21619) Can't install
CiviCRM on Backdrop using the Module Installer
([44](https://github.com/civicrm/civicrm-backdrop/pull/44))**

### Drupal Integration

- **[CRM-21627](https://issues.civicrm.org/jira/browse/CRM-21627) Can't enable
  multilanguage support in Drupal
  ([11491](https://github.com/civicrm/civicrm-core/pull/11491))**

- **[CRM-21652](https://issues.civicrm.org/jira/browse/CRM-21652) Numerous
  issues with anonymous users registering accounts on Drupal 8 (especially from
  contribution pages)
  ([11509](https://github.com/civicrm/civicrm-core/pull/11509) and
  [11507](https://github.com/civicrm/civicrm-core/pull/11507))**

- **[CRM-21667](https://issues.civicrm.org/jira/browse/CRM-21667) Bad timezone
  hand-off from CMS to CRM
  ([11534](https://github.com/civicrm/civicrm-core/pull/11534))**

- **Backport fix from D7 module.
  ([514](https://github.com/civicrm/civicrm-drupal/pull/514))**

  The Drupal 6 group role sync now uses the improved method developed for Drupal
  7.

- **Update civicrm_handler_field_contact_image.inc
  ([516](https://github.com/civicrm/civicrm-drupal/pull/516))**

  Views containing the contact image field now provide help for setting image
  style.

- **[CRM-17652](https://issues.civicrm.org/jira/browse/CRM-17652) Symfony
  conflict between Civi and Drupal 8
  ([193](https://github.com/civicrm/civicrm-packages/pull/193)) (continues
  previous work)**

  The `civicrm-packages` repository is now contains metadata to be a composer
  library.

- **[CRM-20298](https://issues.civicrm.org/jira/browse/CRM-20298) Drupal Views:
  Custom fields of type Money should use the same filter operators as Integer
  fields ([436](https://github.com/civicrm/civicrm-drupal/pull/436))**

- **[crm-16541](https://issues.civicrm.org/jira/browse/crm-16541) drush
  civicrm-sql-dump fails to dump stored function
  ([520](https://github.com/civicrm/civicrm-drupal/pull/520))**

### Joomla Integration

- **[CRM-20904](https://issues.civicrm.org/jira/browse/CRM-20904) Joomla - Fatal
  Error when schedule job is executed from cron.php
  ([10692](https://github.com/civicrm/civicrm-core/pull/10692))**

## <a name="misc"></a>Miscellany

- **[CRM-21660](https://issues.civicrm.org/jira/browse/CRM-21660) Remove use of
  deprecated function on mapping_type
  ([11525](https://github.com/civicrm/civicrm-core/pull/11525))**

- **[CRM-21671](https://issues.civicrm.org/jira/browse/CRM-21671) Add core tasks
  class ([11536](https://github.com/civicrm/civicrm-core/pull/11536))**

- **[CRM-13123](https://issues.civicrm.org/jira/browse/CRM-13123) Handle
  value-separated fields at the dao level
  ([11472](https://github.com/civicrm/civicrm-core/pull/11472)) (finishes
  previous work)**

  This non-functional change updates serialization metadata for the field
  storing the ways a profile is used.

- **Change geocoder message check.
  ([11664](https://github.com/civicrm/civicrm-core/pull/11664))**

- **Unit test fixes
  ([11659](https://github.com/civicrm/civicrm-core/pull/11659))**

- **Fix unit test to not rely on hacking the DB to have ids for price set…
  ([11652](https://github.com/civicrm/civicrm-core/pull/11652))**

- **Added trait to support Codeception tests
  ([11115](https://github.com/civicrm/civicrm-core/pull/11115))**

- **(NFC) Fix logging test for multilingual on MySQL5.7
  ([11626](https://github.com/civicrm/civicrm-core/pull/11626))**

- **[nfc] Fix intermittantly failing test.
  ([11617](https://github.com/civicrm/civicrm-core/pull/11617))**

- **[CRM-21729](https://issues.civicrm.org/jira/browse/CRM-21729) Exclude
  (non-lintable) vendor test cases from deply
  ([11613](https://github.com/civicrm/civicrm-core/pull/11613))**

- **Minor api clean up.
  ([11569](https://github.com/civicrm/civicrm-core/pull/11569))**

- **Api4 - Update entity directory
  ([11582](https://github.com/civicrm/civicrm-core/pull/11582))**

- **Fix typo (very recent)
  ([11566](https://github.com/civicrm/civicrm-core/pull/11566))**

- **Minor api tidy up.
  ([11543](https://github.com/civicrm/civicrm-core/pull/11543))**

- **Fix mock test data for PaymentProcessor object.
  ([11545](https://github.com/civicrm/civicrm-core/pull/11545))**

- **Edit to contributor listing: Standalone code contributor from now.
  ([11512](https://github.com/civicrm/civicrm-core/pull/11512))**

- **Fix unit test failure
  ([11479](https://github.com/civicrm/civicrm-core/pull/11479))**

- **Reformat DAO files to pass linting and use short array syntax
  ([11418](https://github.com/civicrm/civicrm-core/pull/11418))**

- **Params to assertGreaterThanOrEqual in api_v3_CaseTest were in wrong order
  ([11451](https://github.com/civicrm/civicrm-core/pull/11451))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Tommy Bobo; Agileware - Alok Patel; Australian
Greens - Seamus Lee; Awebon Technologies - Karthikeyan Balasubramanian;
BackOffice Thinking - Hassan Farooq; CiviCoop - Erik Hommel; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Sunil Pawar, Yashodha Chaku; CompuCorp - Camilo
Rodriguez, Michael Devery, Mukesh Ram, Omar Abu Hussein; Coop SymbioTIC -
Mathieu Lutfy; Electronic Frontier Foundation - Mark Burdett; Francesc Bassas i
Bullich; Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit;
Ginkgo Street Labs - Frank Gómez; iXiam - Luciano Spiegel; JazzMan; JMA
Consulting - Monish Deb; Johan Vervloet; John Kingsnorth; Joinery - Allen Shaw;
Joost Fock; Kanzu Code - Carl Andrew Lema; Lighthouse Design and Consulting -
Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; mountev; myDropWizard - David Snopek; Oxfam Germany -
Thomas Schüttler; Pradeep Nayak; Progressive Technology Project - Jamie
McClelland; Samson Alajede; Squiffle Consulting - Aidan Saunders; Systopia -
Björn Endres, Philipp Batroff; Tech To The People - Xavier Dutoit; Third Sector
Design - Michael McAndrew; Timbsoft Technologies - Tunbola Ogunwande; Vedant
Rathore; Wikimedia Foundation - Eileen McNaughton, Elliott Eggleston; yurg

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Andie Hunt, Holly Hanks; Agileware - Agileware Team; Andy
Clarke; Anthony Borrow; Bashar Makhay; Blackfly Solutions - Alan Dixon; Chris
Burgess; Christophe Golle; Circle Interactive - Andrew Walker, Dave Jenkins;
CiviDesk - Nicolas Ganivet; CompuCorp - Chandana Bandara, Guanhuan Chen, Tunbola
Ogunwande; Comunica2 - René Nieuwburg; Custom Websites to Go - Julie Hall; Dave
Greenberg; Dave Rolsky; DevMate - Adam Kwiatkowski; Donald Lobo; Evan Chute;
Fuzion - Gemma Potaka, Peter Davis; Ginkgo Street Labs - Dan O'Brien; Glasgow
Women's Library - Helen MacDonald; GMCVO Databases - Alex Lee, Heather Oliver;
JMA Consulting - Joe Murray; Joseph Lacey; Juan David Hurtado G.; Just Hope -
Phil Morice Brubaker; Klangsoft - David Reedy Jr; Korlon - Stuart Gaston;
Lemniscus - Noah Miller; MC3 - Graham Mitchell; Mick Collopy; Nathan Brettell;
Nubay Services - David Tarrant; Palante Technology Cooperative - Jack Aponte;
Panu Boonpromsook; Piotr Stankowski; Play Australia - Renaee Churches;
Progressive Technology Project - Robyn Perry; Registered Nurses' Association of
Ontario - Thomas Mannell; Richard van Oosterhout; Saurabh Batra; Semper IT -
Karin Gerritsen; Shira Miller; Skvare - Mark Hanna, Peter Petrik; Spry Digital -
Julia Koelsch; Systopia - Fabian Schuttenberg, Martin Peth; Tadpole Collective -
Kevin Cristiano; Team Expansion - Greg Harris; Tobias Lounsbury; Web Access -
Kurund Jalmi; We Move Europe/Caltha - Tomasz Pietrzkowski; Wildsight - Lars
Sanders-Green

## <a name="feedback"></a>Feedback

These release notes are edited by Andie Hunt.  If you'd like to provide
feedback on them, please login to https://chat.civicrm.org/civicrm and contact
`@agh1`.
