/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.ColorSpec;
import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTInstruction;
import com.kreative.rsrc.pict.PixMap;
import com.kreative.rsrc.pict.Point;
import com.kreative.rsrc.pict.Polygon;
import com.kreative.rsrc.pict.RGBColor;
import com.kreative.rsrc.pict.Rect;
import com.kreative.rsrc.pict.Region;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PICTOutputStream
extends DataOutputStream {
    private int version = 1;

    public PICTOutputStream(OutputStream out) {
        super(out);
    }

    public final void writeColorSpec(ColorSpec cs) throws IOException {
        cs.write(this);
    }

    public final void writeColorTable(ColorTable ct) throws IOException {
        ct.write(this);
    }

    public final void writePixMap(PixMap pm, boolean withBaseAddr) throws IOException {
        pm.write(this, withBaseAddr);
    }

    public final void writePoint(Point p) throws IOException {
        p.write(this);
    }

    public final void writePolygon(Polygon p) throws IOException {
        p.write(this);
    }

    public final void writeRect(Rect r) throws IOException {
        r.write(this);
    }

    public final void writeRegion(Region rgn) throws IOException {
        rgn.write(this);
    }

    public final void writeRGBColor(RGBColor c) throws IOException {
        c.write(this);
    }

    public final void writeInstruction(PICTInstruction inst) throws IOException {
        if (inst instanceof PICTInstruction.VersionOp) {
            this.version = ((PICTInstruction.VersionOp)inst).v;
        }
        inst.write(this, this.version);
    }
}

