# Users
A sample of institutions using bcbio-nextgen for solving biological problems. Please [submit](https://github.com/bcbio/bcbio-nextgen/blob/master/docs/contents/users.md) your story if you're using the pipeline in your own research.

* [Harvard School of Public Health](https://bioinformatics.sph.harvard.edu/): We use bcbio-nextgen within the bioinformatics core for variant calling on large population studies related to human health like Breast Cancer and Alzheimer's disease. Increasing scalability of the pipeline has been essential for handling study sizes of more than 1400 whole genomes.

* [Massachusetts General Hospital](https://molbio.mgh.harvard.edu/): The Department of Molecular Biology uses the pipeline to automatically process samples coming off Illumina HiSeq instruments. Automated pipelines perform alignment and sample-specific analysis, with results directly uploaded into a local [Galaxy](https://galaxyproject.org/) instance.

* [Science for Life Laboratory](https://www.scilifelab.se/): The genomics core platform in the Swedish National Genomics Infrastructure ([NGI](https://www.scilifelab.se/platforms/ngi/)) has crunched over 16TBp (terabasepairs) and processed almost 7000+ samples from the beginning of 2013 until the end of July. [UPPMAX](https://www.uppmax.uu.se/projects-and-collaborations/compute-and-storage/), our cluster located in Uppsala runs the pipeline in production since 2010.

* [Institute of Human Genetics, UCSF](https://humangenetics.ucsf.edu/): The Genomics Core Facility utilizes bcbio-nextgen in processing more than 2000 whole genome, exome, RNA-seq, ChIP-seq on various projects. This pipeline tremendously lowers the barrier of getting access to next generation sequencing technology. The community engaged here is also very helpful in providing best practices advices and up-to-date solution to ease scientific discovery.

* [IRCCS "Mario Negri" Institute for Pharmacological Research](https://www.marionegri.it/): The Translational Genomics Unit in the Department of Oncology uses bcbio-nextgen for targeted resequencing (using an Illumina MiSeq) to identify mutations and other variants in tumor samples to investigate their link to tumor progression, patient survival and drug sensitivity and resistance. A [poster from the 2014 European Society of Human Genetics meeting](https://github.com/chapmanb/bcbb/blob/master/posters/beltrame_ESHG_poster_05_2014.reduced.pdf) provides more details on usage in ovarian cancer. A paper on the study of longitudinal ovarian cancer biopsies, which makes extensive use of bcbio-nextgen, [was published in 2015 in Annals of Oncology](https://doi.org/10.1093/annonc/mdv164).

* [The Translational Genomics Research Institute (TGen)](https://www.tgen.org/): Members of the [Huentelman lab](https://www.tgen.org/faculty-profiles/matt-huentelman/) at TGen apply bcbio-nextgen to a wide variety of studies of with a major focus in the neurobiology of aging and neurodegeneration in collaboration with the The Arizona Alzheimer's Consortium ([AAC](http://azalz.org)) and the [McKnight Brain Research Foundation](https://mcknightbrain.org/). We also use bcbio in studies of rare diseases in children through TGen's Center for Rare Childhood Disorders ([C4RCD](https://www.tgen.org/patients/center-for-rare-childhood-disorders/)), and other rare diseases such as Multiple System Atrophy ([MSA](https://www.tgen.org/research-forms/neurological-disorders/multiple-system-atrophy/)). bcbio-nextgen has also been instrumental in projects for TGen's Program for Canine Health & Performance ([PCHP](https://www.tgen.org/patients/canine/)) and numerous RNA-seq projects using rodent models. Our work with bcbio started with a partnership with [Dell](https://www.dell.com) and The Neuroblastoma and Medulloblastoma Translational Research Consortium (NMTRC), and TGen as part of a Phase I clinical trial in these rare childhood cancers.

* [Computer Science and Artificial Intelligence Laboratory (CSAIL), MIT](https://www.csail.mit.edu/): The [Gifford lab](https://cgs.csail.mit.edu/) uses the bcbio-nextgen pipeline to analyze a variety of sequencing datasets for their research in genetics and regulatory genomics (including the SysCode and [Stem Cell to Neuron](http://stemcell.mit.edu/) projects). The pipeline applies collaboratively-developed best practices for analysis as well as computation, which enables the lab to run the pipeline on local clusters and Amazon EC2.

* [Sheffield Bioinformatics Core, The University of Sheffield](https://sbc.shef.ac.uk/): The Sheffield Bioinformatics Core is a relatively new Core facility at The University of Sheffield, and bcbio has been instrumental in setting-up a best-practice Bioinformatics analysis service. We employ bcbio to automate the analyses of RNA-seq, small RNA and ChiP-Seq datasets for researchers at The University of Sheffield and NIHR Biomedical Research Centre. In conjunction with the bcbioRNASeq Bioconductor package, we deliver publication-quality reports to our researchers based on reproducible analyses.
