/* Preferences.m - Preferences window 
   class and support functions for the
   Macintosh OS X SDL port of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/
#import <Cocoa/Cocoa.h>
#import <SDL.h>
#import "Preferences.h"
#import "preferences_c.h"

#define QZ_COMMA		0x2B

extern SDL_Joystick *joystick0, *joystick1;
extern SDL_Joystick *joystick2, *joystick3;
extern int joystick0_nbuttons, joystick1_nbuttons;
extern int joystick2_nbuttons, joystick3_nbuttons;
extern int joystick0_nsticks, joystick0_nhats;
extern int joystick1_nsticks, joystick1_nhats;
extern int joystick2_nsticks, joystick2_nhats;
extern int joystick3_nsticks, joystick3_nhats;

extern void PauseAudio(int pause);
extern int requestPrefsChange;

static char workingDirectory[FILENAME_MAX], osromsDir[FILENAME_MAX], paletteDir[FILENAME_MAX];
static char hardDiskDir1Str[FILENAME_MAX], hardDiskDir2Str[FILENAME_MAX], hardDiskDir3Str[FILENAME_MAX];
static char hardDiskDir4Str[FILENAME_MAX], osARomFileStr[FILENAME_MAX], osBRomFileStr[FILENAME_MAX];
static char xlRomFileStr[FILENAME_MAX], basicRomFileStr[FILENAME_MAX], a5200RomFileStr[FILENAME_MAX];
static char diskImageDirStr[FILENAME_MAX],diskSetDirStr[FILENAME_MAX], cartImageDirStr[FILENAME_MAX], cassImageDirStr[FILENAME_MAX];
static char exeFileDirStr[FILENAME_MAX], savedStateDirStr[FILENAME_MAX];
static char paletteStr[FILENAME_MAX];

void RunPreferences() {
    [[Preferences sharedInstance] showPanel:[Preferences sharedInstance]];
    [[Preferences sharedInstance] releaseCmdKeys:@",":QZ_COMMA];
}

/*------------------------------------------------------------------------------
*  defaultValues - This method sets up the default values for the preferences
*-----------------------------------------------------------------------------*/
static NSDictionary *defaultValues() {
    static NSDictionary *dict = nil;
    
    strcpy(paletteStr, workingDirectory);
    strcat(paletteStr, "/Palettes/Real.act");    
    strcpy(paletteDir, workingDirectory);
    strcat(paletteDir, "/Palettes");    
    strcpy(hardDiskDir1Str, workingDirectory);
    strcat(hardDiskDir1Str, "/HardDrive1");
    strcpy(hardDiskDir2Str, workingDirectory);
    strcat(hardDiskDir2Str, "/HardDrive2");
    strcpy(hardDiskDir3Str, workingDirectory);
    strcat(hardDiskDir3Str, "/HardDrive3");
    strcpy(hardDiskDir4Str, workingDirectory);
    strcat(hardDiskDir4Str, "/HardDrive4");
    strcpy(osromsDir, workingDirectory);
    strcat(osromsDir, "/OSRoms");
    strcpy(osARomFileStr, workingDirectory);
    strcat(osARomFileStr, "/OSRoms/atariosa.rom");
    strcpy(osBRomFileStr, workingDirectory);
    strcat(osBRomFileStr, "/OSRoms/atariosb.rom");
    strcpy(xlRomFileStr, workingDirectory);
    strcat(xlRomFileStr, "/OSRoms/atarixl.rom");
    strcpy(basicRomFileStr, workingDirectory);
    strcat(basicRomFileStr, "/OSRoms/ataribas.rom");
    strcpy(a5200RomFileStr, workingDirectory);
    strcat(a5200RomFileStr, "/OSRoms/a5200.rom");
    strcpy(diskImageDirStr, workingDirectory);
    strcat(diskImageDirStr, "/Disks");
    strcpy(diskSetDirStr, workingDirectory);
    strcat(diskSetDirStr, "/Disks/Sets");
    strcpy(cartImageDirStr, workingDirectory);
    strcat(cartImageDirStr, "/Carts");
    strcpy(cassImageDirStr, workingDirectory);
    strcat(cassImageDirStr, "/Cassettes");
    strcpy(exeFileDirStr, workingDirectory);
    strcat(exeFileDirStr, "/AtariExeFiles");
    strcpy(savedStateDirStr, workingDirectory);
    strcat(savedStateDirStr, "/SavedState");
    
    if (!dict) {
        dict = [[NSDictionary alloc] initWithObjectsAndKeys:
                [NSNumber numberWithBool:NO], FullScreen, 
                [NSNumber numberWithBool:YES], LockFullscreenSize, 
                [NSNumber numberWithBool:NO], DoubleSize, 
                [NSNumber numberWithInt:2], ScaleFactor, 
                [NSNumber numberWithInt:1], WidthMode, 
                [NSNumber numberWithInt:0], TvMode, 
                [NSNumber numberWithInt:1], RefreshRatio, 
                [NSNumber numberWithInt:0], ArtifactingMode, 
                [NSNumber numberWithBool:NO], UseBuiltinPalette, 
                [NSNumber numberWithBool:YES], AdjustPalette,
                [NSNumber numberWithInt:0], BlackLevel, 
                [NSNumber numberWithInt:224], WhiteLevel, 
                [NSNumber numberWithInt:100], Intensity, 
                [NSNumber numberWithInt:40], ColorShift, 
                [NSString stringWithCString:paletteStr], PaletteFile, 
                [NSNumber numberWithBool:NO], ShowFPS, 
                [NSNumber numberWithInt:4], AtariType, 
                [NSNumber numberWithBool:YES], DisableBasic, 
                [NSNumber numberWithBool:YES], EnableSioPatch, 
                [NSNumber numberWithBool:YES], EnableHPatch,
                [NSString stringWithString:@"open %s"],PrintCommand,
                [NSNumber numberWithBool:YES], EnablePPatch,
                [NSNumber numberWithBool:NO], EnableRPatch, 
                [NSNumber numberWithInt:8888], RPatchPort,
                [NSNumber numberWithBool:NO], BootFromCassette, 
                [NSNumber numberWithBool:YES], SpeedLimit, 
                [NSNumber numberWithBool:YES], EnableSound, 
                [NSNumber numberWithBool:YES], EnableHifiSound, 
                [NSNumber numberWithBool:NO], EnableMultijoy, 
                [NSNumber numberWithBool:NO], IgnoreHeaderWriteprotect,
                [NSString stringWithCString:hardDiskDir1Str], HardDiskDir1, 
                [NSString stringWithCString:hardDiskDir2Str], HardDiskDir2, 
                [NSString stringWithCString:hardDiskDir3Str], HardDiskDir3, 
                [NSString stringWithCString:hardDiskDir4Str], HardDiskDir4, 
                [NSNumber numberWithBool:YES], HardDrivesReadOnly, 
                [NSString stringWithString:@"H1:>DOS;>DOS"],HPath,
                [NSString stringWithCString:osARomFileStr], OsARomFile, 
                [NSString stringWithCString:osBRomFileStr], OsBRomFile, 
                [NSString stringWithCString:xlRomFileStr], XlRomFile, 
                [NSString stringWithCString:basicRomFileStr], BasicRomFile, 
                [NSString stringWithCString:a5200RomFileStr], A5200RomFile, 
                [NSString stringWithCString:diskImageDirStr], DiskImageDir, 
                [NSString stringWithCString:diskSetDirStr], DiskSetDir, 
                [NSString stringWithCString:cartImageDirStr], CartImageDir, 
                [NSString stringWithCString:cassImageDirStr], CassImageDir, 
                [NSString stringWithCString:exeFileDirStr], ExeFileDir, 
                [NSString stringWithCString:savedStateDirStr], SavedStateDir, 
                [NSString stringWithString:@""], D1File, 
                [NSString stringWithString:@""], D2File, 
                [NSString stringWithString:@""], D3File, 
                [NSString stringWithString:@""], D4File, 
                [NSString stringWithString:@""], D5File, 
                [NSString stringWithString:@""], D6File, 
                [NSString stringWithString:@""], D7File, 
                [NSString stringWithString:@""], D8File, 
                [NSString stringWithString:@""], CartFile, 
                [NSString stringWithString:@""], ExeFile, 
                [NSString stringWithString:@""], CassFile, 
                [NSNumber numberWithBool:NO], D1FileEnabled, 
                [NSNumber numberWithBool:NO], D2FileEnabled, 
                [NSNumber numberWithBool:NO], D3FileEnabled, 
                [NSNumber numberWithBool:NO], D4FileEnabled, 
                [NSNumber numberWithBool:NO], D5FileEnabled, 
                [NSNumber numberWithBool:NO], D6FileEnabled, 
                [NSNumber numberWithBool:NO], D7FileEnabled, 
                [NSNumber numberWithBool:NO], D8FileEnabled, 
                [NSNumber numberWithBool:NO], CartFileEnabled, 
                [NSNumber numberWithBool:NO], ExeFileEnabled,
                [NSNumber numberWithBool:NO], CassFileEnabled,
                [NSNumber numberWithInt:0], Joystick1Mode, 
                [NSNumber numberWithInt:0], Joystick2Mode, 
                [NSNumber numberWithInt:0], Joystick3Mode, 
                [NSNumber numberWithInt:0], Joystick4Mode, 
                [NSNumber numberWithInt:0], Joystick1Autofire, 
                [NSNumber numberWithInt:0], Joystick2Autofire, 
                [NSNumber numberWithInt:0], Joystick3Autofire, 
                [NSNumber numberWithInt:0], Joystick4Autofire, 
                [NSNumber numberWithInt:0], MouseDevice, 
                [NSNumber numberWithInt:3], MouseSpeed, 
                [NSNumber numberWithInt:0], MouseMinVal, 
                [NSNumber numberWithInt:228], MouseMaxVal, 
                [NSNumber numberWithInt:0], MouseHOffset, 
                [NSNumber numberWithInt:0], MouseVOffset, 
                [NSNumber numberWithInt:10], MouseInertia, 
                [NSString stringWithString:StandardConfigString], GamepadConfigCurrent, 
                [NSString stringWithString:StandardConfigString], Gamepad1ConfigCurrent, 
                [NSString stringWithString:StandardConfigString], Gamepad2ConfigCurrent, 
                [NSString stringWithString:StandardConfigString], Gamepad3ConfigCurrent, 
                [NSString stringWithString:StandardConfigString], Gamepad4ConfigCurrent, 
                [NSMutableArray arrayWithObjects:nil],GamepadConfigArray,
                [NSMutableArray arrayWithObjects:[NSNumber numberWithInt:0], [NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],nil], ButtonAssignment,
                [NSMutableArray arrayWithObjects:[NSNumber numberWithInt:0], [NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],[NSNumber numberWithInt:0],[NSNumber numberWithInt:0],
                    [NSNumber numberWithInt:0],nil], Button5200Assignment,
                [NSNumber numberWithInt:0], Joystick1Type,
                [NSNumber numberWithInt:0], Joystick2Type,
                [NSNumber numberWithInt:0], Joystick3Type,
                [NSNumber numberWithInt:0], Joystick4Type,
                [NSNumber numberWithInt:0], Joystick1Num,
                [NSNumber numberWithInt:0], Joystick2Num,
                [NSNumber numberWithInt:0], Joystick3Num,
                [NSNumber numberWithInt:0], Joystick4Num,
                [NSNumber numberWithInt:0], PaddlesXAxisOnly,
                [NSNumber numberWithInt:22], LeftJoyUp,
                [NSNumber numberWithInt:23], LeftJoyDown,
                [NSNumber numberWithInt:0], LeftJoyLeft,
                [NSNumber numberWithInt:3], LeftJoyRight,
                [NSNumber numberWithInt:16], LeftJoyUpLeft,
                [NSNumber numberWithInt:4], LeftJoyUpRight,
                [NSNumber numberWithInt:25], LeftJoyDownLeft,
                [NSNumber numberWithInt:2], LeftJoyDownRight,
                [NSNumber numberWithInt:40], LeftJoyFire,
                [NSNumber numberWithInt:48], LeftJoyAltFire,
                [NSNumber numberWithInt:70], PadJoyUp,
                [NSNumber numberWithInt:64], PadJoyDown,
                [NSNumber numberWithInt:66], PadJoyLeft,
                [NSNumber numberWithInt:68], PadJoyRight,
                [NSNumber numberWithInt:69], PadJoyUpLeft,
                [NSNumber numberWithInt:71], PadJoyUpRight,
                [NSNumber numberWithInt:63], PadJoyDownLeft,
                [NSNumber numberWithInt:65], PadJoyDownRight,
                [NSNumber numberWithInt:49], PadJoyFire,
                [NSNumber numberWithInt:62], PadJoyAltFire,
		nil];
    }
    return dict;
}

@implementation Preferences

static Preferences *sharedInstance = nil;

+ (Preferences *)sharedInstance {
    return sharedInstance ? sharedInstance : [[self alloc] init];
}

/* The next few factory methods are conveniences, working on the shared instance
*/
+ (id)objectForKey:(id)key {
    return [[[self sharedInstance] preferences] objectForKey:key];
}

+ (void)saveDefaults {
    [[self sharedInstance] saveDefaults];
}

/*------------------------------------------------------------------------------
*  setWorkingDirectory - Sets the working directory to the folder containing the
*     app.
*-----------------------------------------------------------------------------*/
+ (void)setWorkingDirectory:(char *)dir {
    char *c = workingDirectory;

    strncpy ( workingDirectory, dir, sizeof(workingDirectory) );
    
    while (*c != '\0')     /* go to end */
        c++;
    
    while (*c != '/')      /* back up to parent */
        c--;
    c--;
    while (*c != '/')      /* And three more times... */
        c--;
    c--;
    while (*c != '/')      
        c--;
    c--;
    while (*c != '/')      
        c--;
        
    *c = '\0';             /* cut off last part  */
    
    }
    
/*------------------------------------------------------------------------------
*  saveDefaults - Called by the main app class to save the preferences when the
*     program exits.
*-----------------------------------------------------------------------------*/
- (void)saveDefaults {
    NSDictionary *prefs = [self preferences];
    if (![origValues isEqual:prefs]) [Preferences savePreferencesToDefaults:prefs];
}

/*------------------------------------------------------------------------------
*  Constructor
*-----------------------------------------------------------------------------*/
- (id)init {
    if (sharedInstance) {
	[self dealloc];
    } else {
        [super init];
        curValues = [[[self class] preferencesFromDefaults] copyWithZone:[self zone]];
        origValues = [curValues retain];
        [self transferValuesToEmulator];
        commitPrefs();
        [self discardDisplayedValues];
        sharedInstance = self;
    }
    return sharedInstance;
}

/*------------------------------------------------------------------------------
*  Destructor
*-----------------------------------------------------------------------------*/
- (void)dealloc {
}

/*------------------------------------------------------------------------------
* preferences - Method to return pointer to current preferences.
*-----------------------------------------------------------------------------*/
- (NSDictionary *)preferences {
    return curValues;
}

/*------------------------------------------------------------------------------
* showPanel - Method to display the preferences window.
*-----------------------------------------------------------------------------*/
- (void)showPanel:(id)sender {
    NSMutableArray *configArray;
    int i,numberGamepadConfigs;
    int currNumConfigs;
    
    PauseAudio(1);

    if (!prefTabView) {
        if (![NSBundle loadNibNamed:@"Preferences" owner:self])  {
            NSLog(@"Failed to load Preferences.nib");
            NSBeep();
            return;
        }
	[[prefTabView window] setExcludedFromWindowsMenu:YES];
	[[prefTabView window] setMenu:nil];
	[[gamepadButton1 window] setExcludedFromWindowsMenu:YES];
	[[gamepadButton1 window] setMenu:nil];
	[[errorOKButton window] setExcludedFromWindowsMenu:YES];
	[[errorOKButton window] setMenu:nil];
	[[configNameField window] setExcludedFromWindowsMenu:YES];
	[[configNameField window] setMenu:nil];
	[[leftJoyUpPulldown window] setExcludedFromWindowsMenu:YES];
	[[leftJoyUpPulldown window] setMenu:nil];
	[[padJoyUpPulldown window] setExcludedFromWindowsMenu:YES];
	[[padJoyUpPulldown window] setMenu:nil];
        [self updateUI];
        [self miscChanged:self];
        [self gamepadButtonChange:self];
        [[prefTabView window] center];
        [[gamepadButton1 window] center];
        [[errorOKButton window] center];
        [[configNameField window] center];
        [[leftJoyUpPulldown window] center];
        [[padJoyUpPulldown window] center];
        
        /* Get the current gamepad config and values */
        configArray = [curValues objectForKey:GamepadConfigArray];
        numberGamepadConfigs = [configArray count];
        for (i=0;i<numberGamepadConfigs;i++) {
            [gamepadConfigPulldown insertItemWithTitle:[configArray objectAtIndex:i] atIndex: (2+i)];
            }
        for (i=0;i<numberGamepadConfigs;i++) {
            [gamepad1ConfigPulldown insertItemWithTitle:[configArray objectAtIndex:i] atIndex: (1+i)];
            }
        for (i=0;i<numberGamepadConfigs;i++) {
            [gamepad2ConfigPulldown insertItemWithTitle:[configArray objectAtIndex:i] atIndex: (1+i)];
            }
        for (i=0;i<numberGamepadConfigs;i++) {
            [gamepad3ConfigPulldown insertItemWithTitle:[configArray objectAtIndex:i] atIndex: (1+i)];
            }
        for (i=0;i<numberGamepadConfigs;i++) {
            [gamepad4ConfigPulldown insertItemWithTitle:[configArray objectAtIndex:i] atIndex: (1+i)];
            }
        [gamepadConfigPulldown selectItemWithTitle:[curValues objectForKey:GamepadConfigCurrent]];
        [gamepad1ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad1ConfigCurrent]];
        [gamepad2ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad2ConfigCurrent]];
        [gamepad3ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad3ConfigCurrent]];
        [gamepad4ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad4ConfigCurrent]];
        [[gamepadConfigPulldown menu] setAutoenablesItems:NO];
        /* If we have default selected, then turn off Save, Rename, and Delete */
        if ([gamepadConfigPulldown indexOfSelectedItem] == 0) {
            currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
            [[gamepadConfigPulldown itemAtIndex:(3+currNumConfigs)] setEnabled:NO];
            [[gamepadConfigPulldown itemAtIndex:(5+currNumConfigs)] setEnabled:NO];
            [[gamepadConfigPulldown itemAtIndex:(6+currNumConfigs)] setEnabled:NO];
            }

    }
    
    [[joystick1TypePulldown menu] setAutoenablesItems:NO];
    [[joystick1NumPulldown menu] setAutoenablesItems:NO];
    [[joystick1Pulldown menu] setAutoenablesItems:NO];
    [[joystick2TypePulldown menu] setAutoenablesItems:NO];
    [[joystick2Pulldown menu] setAutoenablesItems:NO];
    [[joystick2NumPulldown menu] setAutoenablesItems:NO];
    [[joystick3TypePulldown menu] setAutoenablesItems:NO];
    [[joystick3NumPulldown menu] setAutoenablesItems:NO];
    [[joystick3Pulldown menu] setAutoenablesItems:NO];
    [[joystick4TypePulldown menu] setAutoenablesItems:NO];
    [[joystick4NumPulldown menu] setAutoenablesItems:NO];
    [[joystick4Pulldown menu] setAutoenablesItems:NO];
    
    [NSApp runModalForWindow:[prefTabView window]];
}


/*------------------------------------------------------------------------------
* updateUI - Method to update the display, based on the stored values.
*-----------------------------------------------------------------------------*/
- (void)updateUI {
    int index;

    if (!prefTabView) return;	/* UI hasn't been loaded... */

    [fullScreenMatrix selectCellWithTag:[[displayedValues objectForKey:FullScreen] boolValue] ? 1 : 0];
    [lockFullscreenSizeButton setState:[[displayedValues objectForKey:LockFullscreenSize] boolValue] ? NSOnState : NSOffState];
    [doubleSizeMatrix selectCellWithTag:[[displayedValues objectForKey:DoubleSize] boolValue] ? 1 : 0];
    [scaleFactorMatrix  selectCellWithTag:[[displayedValues objectForKey:ScaleFactor] intValue]];
    [widthModeMatrix  selectCellWithTag:[[displayedValues objectForKey:WidthMode] intValue]];
    [tvModeMatrix  selectCellWithTag:[[displayedValues objectForKey:TvMode] intValue]];
    index = [[displayedValues objectForKey:RefreshRatio] intValue] - 1;
    [refreshRatioPulldown  selectItemAtIndex:index];
    [artifactingPulldown  selectItemAtIndex:[[displayedValues objectForKey:ArtifactingMode] intValue]];
    [blackLevelField setIntValue:[[displayedValues objectForKey:BlackLevel] intValue]];
    [whiteLevelField setIntValue:[[displayedValues objectForKey:WhiteLevel] intValue]];
    [intensityField setIntValue:[[displayedValues objectForKey:Intensity] intValue]];
    [colorShiftField setIntValue:[[displayedValues objectForKey:ColorShift] intValue]];
    [paletteField setStringValue:[displayedValues objectForKey:PaletteFile]];
    [externalPaletteButton setState:[[displayedValues objectForKey:UseBuiltinPalette] boolValue] ? NSOffState : NSOnState];
    [adjustPaletteButton setState:[[displayedValues objectForKey:AdjustPalette] boolValue] ? NSOnState : NSOffState];
    [fpsButton setState:[[displayedValues objectForKey:ShowFPS] boolValue] ? NSOnState : NSOffState];

    [atariTypePulldown  selectItemAtIndex:[[displayedValues objectForKey:AtariType] intValue]];
    [disableBasicButton setState:[[displayedValues objectForKey:DisableBasic] boolValue] ? NSOnState : NSOffState];
    [enableSioPatchButton setState:[[displayedValues objectForKey:EnableSioPatch] boolValue] ? NSOnState : NSOffState];
    [enableHPatchButton setState:[[displayedValues objectForKey:EnableHPatch] boolValue] ? NSOnState : NSOffState];
    [enablePPatchButton setState:[[displayedValues objectForKey:EnablePPatch] boolValue] ? NSOnState : NSOffState];
    [enableRPatchButton setState:[[displayedValues objectForKey:EnableRPatch] boolValue] ? NSOnState : NSOffState];
    [rPatchPortField setStringValue:[displayedValues objectForKey:RPatchPort]];
    [printCommandField setStringValue:[displayedValues objectForKey:PrintCommand]];
    [bootFromCassetteButton setState:[[displayedValues objectForKey:BootFromCassette] boolValue] ? NSOnState : NSOffState];
    [speedLimitButton setState:[[displayedValues objectForKey:SpeedLimit] boolValue] ? NSOnState : NSOffState];
    [enableSoundButton setState:[[displayedValues objectForKey:EnableSound] boolValue] ? NSOnState : NSOffState];
    [enableHifiSoundButton setState:[[displayedValues objectForKey:EnableHifiSound] boolValue] ? NSOnState : NSOffState];
    [enableMultijoyButton setState:[[displayedValues objectForKey:EnableMultijoy] boolValue] ? NSOnState : NSOffState];
    [ignoreHeaderWriteprotectButton setState:[[displayedValues objectForKey:IgnoreHeaderWriteprotect] boolValue] ? NSOnState : NSOffState];

    [hardDiskDir1Field setStringValue:[displayedValues objectForKey:HardDiskDir1]];
    [hardDiskDir2Field setStringValue:[displayedValues objectForKey:HardDiskDir2]];
    [hardDiskDir3Field setStringValue:[displayedValues objectForKey:HardDiskDir3]];
    [hardDiskDir4Field setStringValue:[displayedValues objectForKey:HardDiskDir4]];
    [hardDrivesReadOnlyButton setState:[[displayedValues objectForKey:HardDrivesReadOnly] boolValue] ? NSOnState : NSOffState];
    [hPathField setStringValue:[displayedValues objectForKey:HPath]];

    [osARomFileField setStringValue:[displayedValues objectForKey:OsARomFile]];
    [osBRomFileField setStringValue:[displayedValues objectForKey:OsBRomFile]];
    [xlRomFileField setStringValue:[displayedValues objectForKey:XlRomFile]];
    [basicRomFileField setStringValue:[displayedValues objectForKey:BasicRomFile]];
    [a5200RomFileField setStringValue:[displayedValues objectForKey:A5200RomFile]];

    [diskImageDirField setStringValue:[displayedValues objectForKey:DiskImageDir]];
    [diskSetDirField setStringValue:[displayedValues objectForKey:DiskSetDir]];
    [cartImageDirField setStringValue:[displayedValues objectForKey:CartImageDir]];
    [cassImageDirField setStringValue:[displayedValues objectForKey:CassImageDir]];
    [exeFileDirField setStringValue:[displayedValues objectForKey:ExeFileDir]];
    [savedStateDirField setStringValue:[displayedValues objectForKey:SavedStateDir]];
   
    [d1FileField setStringValue:[displayedValues objectForKey:D1File]];
    [d2FileField setStringValue:[displayedValues objectForKey:D2File]];
    [d3FileField setStringValue:[displayedValues objectForKey:D3File]];
    [d4FileField setStringValue:[displayedValues objectForKey:D4File]];
    [d5FileField setStringValue:[displayedValues objectForKey:D5File]];
    [d6FileField setStringValue:[displayedValues objectForKey:D6File]];
    [d7FileField setStringValue:[displayedValues objectForKey:D7File]];
    [d8FileField setStringValue:[displayedValues objectForKey:D8File]];
    [cartFileField setStringValue:[displayedValues objectForKey:CartFile]];
    [exeFileField setStringValue:[displayedValues objectForKey:ExeFile]];
    [cassFileField setStringValue:[displayedValues objectForKey:CassFile]];
    [d1FileEnabledButton setState:[[displayedValues objectForKey:D1FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d2FileEnabledButton setState:[[displayedValues objectForKey:D2FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d3FileEnabledButton setState:[[displayedValues objectForKey:D3FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d4FileEnabledButton setState:[[displayedValues objectForKey:D4FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d5FileEnabledButton setState:[[displayedValues objectForKey:D5FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d6FileEnabledButton setState:[[displayedValues objectForKey:D6FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d7FileEnabledButton setState:[[displayedValues objectForKey:D7FileEnabled] boolValue] ? NSOnState : NSOffState];
    [d8FileEnabledButton setState:[[displayedValues objectForKey:D8FileEnabled] boolValue] ? NSOnState : NSOffState];
    [cartFileEnabledButton setState:[[displayedValues objectForKey:CartFileEnabled] boolValue] ? NSOnState : NSOffState];
    [exeFileEnabledButton setState:[[displayedValues objectForKey:ExeFileEnabled] boolValue] ? NSOnState : NSOffState];
    [cassFileEnabledButton setState:[[displayedValues objectForKey:CassFileEnabled] boolValue] ? NSOnState : NSOffState];

    [joystick1Pulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick1Mode] intValue]];
    [joystick2Pulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick2Mode] intValue]];
    [joystick3Pulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick3Mode] intValue]];
    [joystick4Pulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick4Mode] intValue]];
    [joy1AutofirePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick1Autofire] intValue]];
    [joy2AutofirePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick2Autofire] intValue]];
    [joy3AutofirePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick3Autofire] intValue]];
    [joy4AutofirePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick4Autofire] intValue]];
    [mouseDevicePulldown  selectItemAtIndex:[[displayedValues objectForKey:MouseDevice] intValue]];
    [mouseSpeedField setIntValue:[[displayedValues objectForKey:MouseSpeed] intValue]];
    [mouseMinValField setIntValue:[[displayedValues objectForKey:MouseMinVal] intValue]];
    [mouseMaxValField setIntValue:[[displayedValues objectForKey:MouseMaxVal] intValue]];
    [mouseHOffsetField setIntValue:[[displayedValues objectForKey:MouseHOffset] intValue]];
    [mouseVOffsetField setIntValue:[[displayedValues objectForKey:MouseVOffset] intValue]];
    [mouseInertiaField setIntValue:[[displayedValues objectForKey:MouseInertia] intValue]];

    [joystick1TypePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick1Type] intValue]];
    [joystick2TypePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick2Type] intValue]];
    [joystick3TypePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick3Type] intValue]];
    [joystick4TypePulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick4Type] intValue]];
    [self updateJoyNumMenus];
    [joystick1NumPulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick1Num] intValue]];
    [joystick2NumPulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick2Num] intValue]];
    [joystick3NumPulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick3Num] intValue]];
    [joystick4NumPulldown  selectItemAtIndex:[[displayedValues objectForKey:Joystick4Num] intValue]];
    [paddlesXAxisOnlyButton setState:[[displayedValues objectForKey:PaddlesXAxisOnly] boolValue] ? NSOnState : NSOffState];

    [gamepad1ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad1ConfigCurrent]];
    [gamepad2ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad2ConfigCurrent]];
    [gamepad3ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad3ConfigCurrent]];
    [gamepad4ConfigPulldown selectItemWithTitle:[curValues objectForKey:Gamepad4ConfigCurrent]];
}

/*------------------------------------------------------------------------------
* updateJoyNumMenus - Method to update the joystick number menus, based on 
*                     joystick type.
*-----------------------------------------------------------------------------*/
- (void)updateJoyNumMenus {
    if (joystick0 == NULL) {
        [joystick1TypePulldown setEnabled:NO];
        [joystick1NumPulldown setEnabled:NO];
        [gamepad1ConfigPulldown setEnabled:NO];
        [gamepad1IdentifyButton setEnabled:NO];
        [[joystick1Pulldown itemAtIndex:3] setEnabled:NO];
        [[joystick2Pulldown itemAtIndex:3] setEnabled:NO];
        [[joystick3Pulldown itemAtIndex:3] setEnabled:NO];
        [[joystick4Pulldown itemAtIndex:3] setEnabled:NO];
    } else {
        [joystick1TypePulldown setEnabled:YES];
        [gamepad1ConfigPulldown setEnabled:YES];
        [gamepad1IdentifyButton setEnabled:YES];
        if (joystick0_nsticks == 0)
            [[joystick1TypePulldown itemAtIndex:0] setEnabled:NO];
        else
            [[joystick1TypePulldown itemAtIndex:0] setEnabled:YES];
        if (joystick0_nhats == 0)
            [[joystick1TypePulldown itemAtIndex:1] setEnabled:NO];
        else
            [[joystick1TypePulldown itemAtIndex:1] setEnabled:YES];
        switch([[displayedValues objectForKey:Joystick1Type] intValue])
        {
            case 0:
                [[joystick1NumPulldown itemAtIndex:0] setTitle:@"Stick 1"];
                [[joystick1NumPulldown itemAtIndex:1] setTitle:@"Stick 2"];
                [joystick1NumPulldown setEnabled:YES];
                if (joystick0_nsticks == 0) {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick0_nsticks == 1) {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 1:
                [[joystick1NumPulldown itemAtIndex:0] setTitle:@"Hat 1"];
                [[joystick1NumPulldown itemAtIndex:1] setTitle:@"Hat 2"];
                [joystick1NumPulldown setEnabled:YES];
                if (joystick0_nhats == 0) {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick0_nhats == 1) {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick1NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick1NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 2:
                [[joystick1NumPulldown itemAtIndex:0] setTitle:@"-----"];
                [[joystick1NumPulldown itemAtIndex:1] setTitle:@"-----"];
                [joystick1NumPulldown setEnabled:NO];
                break;
        }
    }
    if (joystick1 == NULL) {
        [joystick2TypePulldown setEnabled:NO];
        [joystick2NumPulldown setEnabled:NO];
        [gamepad2ConfigPulldown setEnabled:NO];
        [gamepad2IdentifyButton setEnabled:NO];
        [[joystick1Pulldown itemAtIndex:4] setEnabled:NO];
        [[joystick2Pulldown itemAtIndex:4] setEnabled:NO];
        [[joystick3Pulldown itemAtIndex:4] setEnabled:NO];
        [[joystick4Pulldown itemAtIndex:4] setEnabled:NO];
    } else {
        [joystick2TypePulldown setEnabled:YES];
        [gamepad2ConfigPulldown setEnabled:YES];
        [gamepad2IdentifyButton setEnabled:YES];
        if (joystick1_nsticks == 0)
            [[joystick2TypePulldown itemAtIndex:0] setEnabled:NO];
        else
            [[joystick2TypePulldown itemAtIndex:0] setEnabled:YES];
        if (joystick1_nhats == 0)
            [[joystick2TypePulldown itemAtIndex:1] setEnabled:NO];
        else
            [[joystick2TypePulldown itemAtIndex:1] setEnabled:YES];
        switch([[displayedValues objectForKey:Joystick2Type] intValue])
        {
            case 0:
                [[joystick2NumPulldown itemAtIndex:0] setTitle:@"Stick 1"];
                [[joystick2NumPulldown itemAtIndex:1] setTitle:@"Stick 2"];
                [joystick2NumPulldown setEnabled:YES];
                if (joystick1_nsticks == 0) {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick1_nsticks == 1) {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 1:	
                [[joystick2NumPulldown itemAtIndex:0] setTitle:@"Hat 1"];
                [[joystick2NumPulldown itemAtIndex:1] setTitle:@"Hat 2"];
                [joystick2NumPulldown setEnabled:YES];
                if (joystick1_nhats == 0) {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick1_nhats == 1) {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick2NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick2NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 2:
                [[joystick2NumPulldown itemAtIndex:0] setTitle:@"-----"];
                [[joystick2NumPulldown itemAtIndex:1] setTitle:@"-----"];
                [joystick2NumPulldown setEnabled:NO];
                break;
        }
    }
    if (joystick2 == NULL) {
        [joystick3TypePulldown setEnabled:NO];
        [joystick3NumPulldown setEnabled:NO];
        [gamepad3ConfigPulldown setEnabled:NO];
        [gamepad3IdentifyButton setEnabled:NO];
        [[joystick1Pulldown itemAtIndex:5] setEnabled:NO];
        [[joystick2Pulldown itemAtIndex:5] setEnabled:NO];
        [[joystick3Pulldown itemAtIndex:5] setEnabled:NO];
        [[joystick4Pulldown itemAtIndex:5] setEnabled:NO];
    } else {
        [joystick3TypePulldown setEnabled:YES];
        [gamepad3ConfigPulldown setEnabled:YES];
        [gamepad3IdentifyButton setEnabled:YES];
        if (joystick2_nsticks == 0)
            [[joystick3TypePulldown itemAtIndex:0] setEnabled:NO];
        else
            [[joystick3TypePulldown itemAtIndex:0] setEnabled:YES];
        if (joystick2_nhats == 0)
            [[joystick3TypePulldown itemAtIndex:1] setEnabled:NO];
        else
            [[joystick3TypePulldown itemAtIndex:1] setEnabled:YES];
        switch([[displayedValues objectForKey:Joystick3Type] intValue])
        {
            case 0:
                [[joystick3NumPulldown itemAtIndex:0] setTitle:@"Stick 1"];
                [[joystick3NumPulldown itemAtIndex:1] setTitle:@"Stick 2"];
                [joystick3NumPulldown setEnabled:YES];
                if (joystick2_nsticks == 0) {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick2_nsticks == 1) {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 1:
                [[joystick3NumPulldown itemAtIndex:0] setTitle:@"Hat 1"];
                [[joystick3NumPulldown itemAtIndex:1] setTitle:@"Hat 2"];
                [joystick3NumPulldown setEnabled:YES];
                if (joystick2_nhats == 0) {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick2_nhats == 1) {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick3NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick3NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 2:
                [[joystick3NumPulldown itemAtIndex:0] setTitle:@"-----"];
                [[joystick3NumPulldown itemAtIndex:1] setTitle:@"-----"];
                [joystick3NumPulldown setEnabled:NO];
                break;
        }
    }
    if (joystick3 == NULL) {
        [joystick4TypePulldown setEnabled:NO];
        [joystick4NumPulldown setEnabled:NO];
        [gamepad4ConfigPulldown setEnabled:NO];
        [gamepad4IdentifyButton setEnabled:NO];
        [[joystick1Pulldown itemAtIndex:6] setEnabled:NO];
        [[joystick2Pulldown itemAtIndex:6] setEnabled:NO];
        [[joystick3Pulldown itemAtIndex:6] setEnabled:NO];
        [[joystick4Pulldown itemAtIndex:6] setEnabled:NO];
    } else {
        [joystick4TypePulldown setEnabled:YES];
        [gamepad4ConfigPulldown setEnabled:YES];
        [gamepad4IdentifyButton setEnabled:YES];
        if (joystick3_nsticks == 0)
            [[joystick4TypePulldown itemAtIndex:0] setEnabled:NO];
        else
            [[joystick4TypePulldown itemAtIndex:0] setEnabled:YES];
        if (joystick3_nhats == 0)
            [[joystick4TypePulldown itemAtIndex:1] setEnabled:NO];
        else
            [[joystick4TypePulldown itemAtIndex:1] setEnabled:YES];
        switch([[displayedValues objectForKey:Joystick4Type] intValue])
        {
            case 0:
                [[joystick4NumPulldown itemAtIndex:0] setTitle:@"Stick 1"];
                [[joystick4NumPulldown itemAtIndex:1] setTitle:@"Stick 2"];
                [joystick4NumPulldown setEnabled:YES];
                if (joystick3_nsticks == 0) {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick3_nsticks == 1) {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 1:
                [[joystick4NumPulldown itemAtIndex:0] setTitle:@"Hat 1"];
                [[joystick4NumPulldown itemAtIndex:1] setTitle:@"Hat 2"];
                [joystick4NumPulldown setEnabled:YES];
                if (joystick3_nhats == 0) {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:NO];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else if (joystick3_nhats == 1) {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:NO];
                    }
                else {
                    [[joystick4NumPulldown itemAtIndex:0] setEnabled:YES];
                    [[joystick4NumPulldown itemAtIndex:1] setEnabled:YES];
                    }
                break;
            case 2:
                [[joystick4NumPulldown itemAtIndex:0] setTitle:@"-----"];
                [[joystick4NumPulldown itemAtIndex:1] setTitle:@"-----"];
                [joystick4NumPulldown setEnabled:NO];
                break;
        }
    }
}

/*------------------------------------------------------------------------------
* miscChanged - Method to get everything from User Interface when an event 
*        occurs.  Should probably be broke up by tab, since it is so huge.
*-----------------------------------------------------------------------------*/
- (void)miscChanged:(id)sender {
    int anInt;
    int mouseCount = 0;
    int firstMouse = 0;
    
    static NSNumber *yes = nil;
    static NSNumber *no = nil;
    static NSNumber *zero = nil;
    static NSNumber *one = nil;
    static NSNumber *two = nil;
    static NSNumber *three = nil;
    static NSNumber *four = nil;
    static NSNumber *five = nil;
    static NSNumber *six = nil;
    static NSNumber *seven = nil;
    static NSNumber *eight = nil;
    static NSNumber *nine = nil;
    static NSNumber *ten = nil;
    static NSNumber *eleven = nil;
    static NSNumber *twelve = nil;
    static NSNumber *thirteen = nil;
    static NSNumber *fourteen = nil;
   
    if (!yes) {
        yes = [[NSNumber alloc] initWithBool:YES];
        no = [[NSNumber alloc] initWithBool:NO];
        zero = [[NSNumber alloc] initWithInt:0];
        one = [[NSNumber alloc] initWithInt:1];
        two = [[NSNumber alloc] initWithInt:2];
        three = [[NSNumber alloc] initWithInt:3];
        four = [[NSNumber alloc] initWithInt:4];
        five = [[NSNumber alloc] initWithInt:5];
        six = [[NSNumber alloc] initWithInt:6];
        seven = [[NSNumber alloc] initWithInt:7];
        eight = [[NSNumber alloc] initWithInt:8];
        nine = [[NSNumber alloc] initWithInt:9];
        ten = [[NSNumber alloc] initWithInt:10];
        eleven = [[NSNumber alloc] initWithInt:11];
        twelve = [[NSNumber alloc] initWithInt:12];
        thirteen = [[NSNumber alloc] initWithInt:13];
        fourteen = [[NSNumber alloc] initWithInt:14];
    }

    [displayedValues setObject:[[fullScreenMatrix selectedCell] tag] ? yes : no forKey:FullScreen];
    if ([lockFullscreenSizeButton state] == NSOnState)
        [displayedValues setObject:yes forKey:LockFullscreenSize];
    else
        [displayedValues setObject:no forKey:LockFullscreenSize];
    [displayedValues setObject:[[doubleSizeMatrix selectedCell] tag] ? yes : no forKey:DoubleSize];
    switch([[scaleFactorMatrix selectedCell] tag]) {
        case 2:
            [displayedValues setObject:two forKey:ScaleFactor];
            break;
        case 3:
            [displayedValues setObject:three forKey:ScaleFactor];
            break;
        case 4:
            [displayedValues setObject:four forKey:ScaleFactor];
            break;
    }
    switch([[widthModeMatrix selectedCell] tag]) {
        case 0:
            [displayedValues setObject:zero forKey:WidthMode];
            break;
        case 1:
            [displayedValues setObject:one forKey:WidthMode];
            break;
        case 2:
            [displayedValues setObject:two forKey:WidthMode];
            break;
    }
    switch([[tvModeMatrix selectedCell] tag]) {
        case 0:
            [displayedValues setObject:zero forKey:TvMode];
            break;
        case 1:
            [displayedValues setObject:one forKey:TvMode];
            break;
    }
    switch([refreshRatioPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:one forKey:RefreshRatio];
            break;
        case 1:
            [displayedValues setObject:two forKey:RefreshRatio];
            break;
        case 2:
            [displayedValues setObject:three forKey:RefreshRatio];
            break;
        case 3:
            [displayedValues setObject:four forKey:RefreshRatio];
            break;
    }
    switch([artifactingPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:ArtifactingMode];
            break;
        case 1:
            [displayedValues setObject:one forKey:ArtifactingMode];
            break;
        case 2:
            [displayedValues setObject:two forKey:ArtifactingMode];
            break;
        case 3:
            [displayedValues setObject:three forKey:ArtifactingMode];
            break;
        case 4:
            [displayedValues setObject:four forKey:ArtifactingMode];
            break;
    }
    anInt = [whiteLevelField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:WhiteLevel];
    anInt = [blackLevelField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:BlackLevel];
    anInt = [intensityField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:Intensity];
    anInt = [colorShiftField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:ColorShift];
    if ([externalPaletteButton state] == NSOnState) {
        [adjustPaletteButton setEnabled:YES];
        [displayedValues setObject:no forKey:UseBuiltinPalette];
        [colorShiftField setEnabled:NO];
        [paletteField setEnabled:YES];
        [paletteChooseButton setEnabled:YES];
        if ([adjustPaletteButton state] == NSOnState) {
            [displayedValues setObject:yes forKey:AdjustPalette];
            [blackLevelField setEnabled:YES];
            [whiteLevelField setEnabled:YES];
            [intensityField setEnabled:YES];
            }
        else {
            [displayedValues setObject:no forKey:AdjustPalette];
            [blackLevelField setEnabled:NO];
            [whiteLevelField setEnabled:NO];
            [intensityField setEnabled:NO];
            }
        }
    else {
        [displayedValues setObject:yes forKey:UseBuiltinPalette];
        [displayedValues setObject:no forKey:AdjustPalette];
        [blackLevelField setEnabled:YES];
        [whiteLevelField setEnabled:YES];
        [intensityField setEnabled:YES];
        [colorShiftField setEnabled:YES];
        [paletteField setEnabled:NO];
        [paletteChooseButton setEnabled:NO];
        [adjustPaletteButton setEnabled:NO];
        }
    [displayedValues setObject:[paletteField stringValue] forKey:PaletteFile];
    if ([fpsButton state] == NSOnState)
        [displayedValues setObject:yes forKey:ShowFPS];
    else
        [displayedValues setObject:no forKey:ShowFPS];
    
    switch([atariTypePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:AtariType];
            break;
        case 1:
            [displayedValues setObject:one forKey:AtariType];
            break;
        case 2:
            [displayedValues setObject:two forKey:AtariType];
            break;
        case 3:
            [displayedValues setObject:three forKey:AtariType];
            break;
        case 4:
            [displayedValues setObject:four forKey:AtariType];
            break;
        case 5:
            [displayedValues setObject:five forKey:AtariType];
            break;
        case 6:
            [displayedValues setObject:six forKey:AtariType];
            break;
        case 7:
            [displayedValues setObject:seven forKey:AtariType];
            break;
        case 8:
            [displayedValues setObject:eight forKey:AtariType];
            break;
        case 9:
            [displayedValues setObject:nine forKey:AtariType];
            break;
        case 10:
            [displayedValues setObject:ten forKey:AtariType];
            break;
        case 11:
            [displayedValues setObject:eleven forKey:AtariType];
            break;
        case 12:
            [displayedValues setObject:twelve forKey:AtariType];
            break;
        case 13:
            [displayedValues setObject:thirteen forKey:AtariType];
            break;
        case 14:
            [displayedValues setObject:fourteen forKey:AtariType];
            break;
    }    
    if ([disableBasicButton state] == NSOnState)
        [displayedValues setObject:yes forKey:DisableBasic];
    else
        [displayedValues setObject:no forKey:DisableBasic];
    if ([enableSioPatchButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableSioPatch];
    else
        [displayedValues setObject:no forKey:EnableSioPatch];
    if ([enableHPatchButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableHPatch];
    else
        [displayedValues setObject:no forKey:EnableHPatch];
    [displayedValues setObject:[printCommandField stringValue] forKey:PrintCommand];   
    if ([enablePPatchButton state] == NSOnState) {
        [displayedValues setObject:yes forKey:EnablePPatch];
        [printCommandField setEnabled:YES];
        }
    else {
        [displayedValues setObject:no forKey:EnablePPatch];
        [printCommandField setEnabled:NO];
        }
    if ([enableRPatchButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableRPatch];
    else
        [displayedValues setObject:no forKey:EnableRPatch];
    [displayedValues setObject:[rPatchPortField stringValue] forKey:RPatchPort];
    if ([bootFromCassetteButton state] == NSOnState)
        [displayedValues setObject:yes forKey:BootFromCassette];
    else
        [displayedValues setObject:no forKey:BootFromCassette];
    if ([speedLimitButton state] == NSOnState)
        [displayedValues setObject:yes forKey:SpeedLimit];
    else
        [displayedValues setObject:no forKey:SpeedLimit];
    if ([enableSoundButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableSound];
    else
        [displayedValues setObject:no forKey:EnableSound];
    if ([enableHifiSoundButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableHifiSound];
    else
        [displayedValues setObject:no forKey:EnableHifiSound];
    if ([enableMultijoyButton state] == NSOnState)
        [displayedValues setObject:yes forKey:EnableMultijoy];
    else
        [displayedValues setObject:no forKey:EnableMultijoy];
    if ([ignoreHeaderWriteprotectButton state] == NSOnState)
        [displayedValues setObject:yes forKey:IgnoreHeaderWriteprotect];
    else
        [displayedValues setObject:no forKey:IgnoreHeaderWriteprotect];

    [displayedValues setObject:[hardDiskDir1Field stringValue] forKey:HardDiskDir1];
    [displayedValues setObject:[hardDiskDir2Field stringValue] forKey:HardDiskDir2];
    [displayedValues setObject:[hardDiskDir3Field stringValue] forKey:HardDiskDir3];
    [displayedValues setObject:[hardDiskDir4Field stringValue] forKey:HardDiskDir4];
    if ([hardDrivesReadOnlyButton state] == NSOnState)
        [displayedValues setObject:yes forKey:HardDrivesReadOnly];
    else
        [displayedValues setObject:no forKey:HardDrivesReadOnly];
    [displayedValues setObject:[hPathField stringValue] forKey:HPath];

    [displayedValues setObject:[osARomFileField stringValue] forKey:OsARomFile];
    [displayedValues setObject:[osBRomFileField stringValue] forKey:OsBRomFile];
    [displayedValues setObject:[xlRomFileField stringValue] forKey:XlRomFile];
    [displayedValues setObject:[basicRomFileField stringValue] forKey:BasicRomFile];
    [displayedValues setObject:[a5200RomFileField stringValue] forKey:A5200RomFile];

    [displayedValues setObject:[diskImageDirField stringValue] forKey:DiskImageDir];
    [displayedValues setObject:[diskSetDirField stringValue] forKey:DiskSetDir];
    [displayedValues setObject:[cartImageDirField stringValue] forKey:CartImageDir];
    [displayedValues setObject:[cassImageDirField stringValue] forKey:CassImageDir];
    [displayedValues setObject:[exeFileDirField stringValue] forKey:ExeFileDir];
    [displayedValues setObject:[savedStateDirField stringValue] forKey:SavedStateDir];

    [displayedValues setObject:[d1FileField stringValue] forKey:D1File];
    [displayedValues setObject:[d2FileField stringValue] forKey:D2File];
    [displayedValues setObject:[d3FileField stringValue] forKey:D3File];
    [displayedValues setObject:[d4FileField stringValue] forKey:D4File];
    [displayedValues setObject:[d5FileField stringValue] forKey:D5File];
    [displayedValues setObject:[d6FileField stringValue] forKey:D6File];
    [displayedValues setObject:[d7FileField stringValue] forKey:D7File];
    [displayedValues setObject:[d8FileField stringValue] forKey:D8File];
    [displayedValues setObject:[cartFileField stringValue] forKey:CartFile];
    [displayedValues setObject:[exeFileField stringValue] forKey:ExeFile];
    [displayedValues setObject:[cassFileField stringValue] forKey:CassFile];
    if ([d1FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D1FileEnabled];
    else
        [displayedValues setObject:no forKey:D1FileEnabled];
    if ([d2FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D2FileEnabled];
    else
        [displayedValues setObject:no forKey:D2FileEnabled];
    if ([d3FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D3FileEnabled];
    else
        [displayedValues setObject:no forKey:D3FileEnabled];
    if ([d4FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D4FileEnabled];
    else
        [displayedValues setObject:no forKey:D4FileEnabled];
    if ([d5FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D5FileEnabled];
    else
        [displayedValues setObject:no forKey:D5FileEnabled];
    if ([d6FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D6FileEnabled];
    else
        [displayedValues setObject:no forKey:D6FileEnabled];
    if ([d7FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D7FileEnabled];
    else
        [displayedValues setObject:no forKey:D7FileEnabled];
    if ([d8FileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:D8FileEnabled];
    else
        [displayedValues setObject:no forKey:D8FileEnabled];
    if ([cartFileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:CartFileEnabled];
    else
        [displayedValues setObject:no forKey:CartFileEnabled];
    if ([exeFileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:ExeFileEnabled];
    else
        [displayedValues setObject:no forKey:ExeFileEnabled];
    if ([cassFileEnabledButton state] == NSOnState)
        [displayedValues setObject:yes forKey:CassFileEnabled];
    else
        [displayedValues setObject:no forKey:CassFileEnabled];

    switch([joystick1Pulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick1Mode];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick1Mode];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick1Mode];
            break;
        case 3:
            [displayedValues setObject:three forKey:Joystick1Mode];
            break;
        case 4:
            [displayedValues setObject:four forKey:Joystick1Mode];
            break;
        case 5:
            [displayedValues setObject:five forKey:Joystick1Mode];
            break;
        case 6:
            [displayedValues setObject:six forKey:Joystick1Mode];
            break;
        case 7:
            [displayedValues setObject:seven forKey:Joystick1Mode];
            mouseCount++;
            break;
        }
    switch([joystick2Pulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick2Mode];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick2Mode];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick2Mode];
            break;
        case 3:
            [displayedValues setObject:three forKey:Joystick2Mode];
            break;
        case 4:
            [displayedValues setObject:four forKey:Joystick2Mode];
            break;
        case 5:
            [displayedValues setObject:five forKey:Joystick2Mode];
            break;
        case 6:
            [displayedValues setObject:six forKey:Joystick2Mode];
            break;
        case 7:
            [displayedValues setObject:seven forKey:Joystick2Mode];
            mouseCount++;
            break;
        }
    switch([joystick3Pulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick3Mode];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick3Mode];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick3Mode];
            break;
        case 3:
            [displayedValues setObject:three forKey:Joystick3Mode];
            break;
        case 4:
            [displayedValues setObject:four forKey:Joystick3Mode];
            break;
        case 5:
            [displayedValues setObject:five forKey:Joystick3Mode];
            break;
        case 6:
            [displayedValues setObject:six forKey:Joystick3Mode];
            break;
        case 7:
            [displayedValues setObject:seven forKey:Joystick3Mode];
            mouseCount++;
            break;
        }
    switch([joystick4Pulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick4Mode];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick4Mode];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick4Mode];
            break;
        case 3:
            [displayedValues setObject:three forKey:Joystick4Mode];
            break;
        case 4:
            [displayedValues setObject:four forKey:Joystick4Mode];
            break;
        case 5:
            [displayedValues setObject:five forKey:Joystick4Mode];
            break;
        case 6:
            [displayedValues setObject:six forKey:Joystick4Mode];
            break;
        case 7:
            [displayedValues setObject:seven forKey:Joystick4Mode];
            mouseCount++;
            break;
        }
    if (mouseCount >1) {
        if ([joystick1Pulldown indexOfSelectedItem] == 5)
            firstMouse = 1;
        else if ([joystick2Pulldown indexOfSelectedItem] == 5) 
            firstMouse = 2;
        else if ([joystick2Pulldown indexOfSelectedItem] == 5)
            firstMouse = 3;
            
        if (firstMouse == 1) {
            if ([joystick2Pulldown indexOfSelectedItem] == 5) {
                [joystick2Pulldown  selectItemAtIndex:0];
                [displayedValues setObject:zero forKey:Joystick2Mode];
                }
            else if ([joystick3Pulldown indexOfSelectedItem] == 5) {
                [joystick3Pulldown  selectItemAtIndex:0];
                [displayedValues setObject:zero forKey:Joystick3Mode];
                }
            else {
                [joystick4Pulldown  selectItemAtIndex:0];
                [displayedValues setObject:zero forKey:Joystick4Mode];
                }
            }
        else if (firstMouse == 2) {
            if ([joystick3Pulldown indexOfSelectedItem] == 5) {
                [joystick3Pulldown  selectItemAtIndex:0];
                [displayedValues setObject:zero forKey:Joystick3Mode];
                }
            else {
                [joystick4Pulldown  selectItemAtIndex:0];
                [displayedValues setObject:zero forKey:Joystick4Mode];
                }
            }
        else {
            [joystick4Pulldown  selectItemAtIndex:0];
            [displayedValues setObject:zero forKey:Joystick4Mode];
            }
        mouseCount = 1;              
        }
    switch([joy1AutofirePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick1Autofire];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick1Autofire];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick1Autofire];
            break;
        }
    switch([joy2AutofirePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick2Autofire];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick2Autofire];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick2Autofire];
            break;
        }
    switch([joy3AutofirePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick3Autofire];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick3Autofire];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick3Autofire];
            break;
        }
    switch([joy4AutofirePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick4Autofire];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick4Autofire];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick4Autofire];
            break;
        }
    if (mouseCount == 0) {
        [mouseDevicePulldown  selectItemAtIndex:0];
        [mouseDevicePulldown setEnabled:NO];
        [mouseSpeedField setEnabled:NO];
        [mouseMinValField setEnabled:NO];
        [mouseMaxValField setEnabled:NO];
        [mouseHOffsetField setEnabled:NO];
        [mouseVOffsetField setEnabled:NO];
        [mouseInertiaField setEnabled:NO];
        [displayedValues setObject:zero forKey:MouseDevice];
        }
    else {
        [mouseDevicePulldown setEnabled:YES];
        switch([mouseDevicePulldown indexOfSelectedItem]) {
            case 0:
                [displayedValues setObject:zero forKey:MouseDevice];
                [mouseSpeedField setEnabled:NO];
                [mouseMinValField setEnabled:NO];
                [mouseMaxValField setEnabled:NO];
                [mouseHOffsetField setEnabled:NO];
                [mouseVOffsetField setEnabled:NO];
                [mouseInertiaField setEnabled:NO];
                break;
            case 1:
                [displayedValues setObject:one forKey:MouseDevice];
                [mouseSpeedField setEnabled:YES];
                [mouseMinValField setEnabled:YES];
                [mouseMaxValField setEnabled:YES];
                [mouseHOffsetField setEnabled:NO];
                [mouseVOffsetField setEnabled:NO];
                [mouseInertiaField setEnabled:NO];
                break;
            case 2:
                [displayedValues setObject:two forKey:MouseDevice];
                [mouseSpeedField setEnabled:YES];
                [mouseMinValField setEnabled:YES];
            [mouseMaxValField setEnabled:YES];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:NO];
            break;
        case 3:
            [displayedValues setObject:three forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:YES];
            [mouseMaxValField setEnabled:YES];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:NO];
            break;
        case 4:
            [displayedValues setObject:four forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:YES];
            [mouseVOffsetField setEnabled:YES];
            [mouseInertiaField setEnabled:NO];
            break;
        case 5:
            [displayedValues setObject:five forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:YES];
            [mouseVOffsetField setEnabled:YES];
            [mouseInertiaField setEnabled:NO];
            break;
        case 6:
            [displayedValues setObject:six forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:NO];
            break;
        case 7:
            [displayedValues setObject:seven forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:NO];
            break;
        case 8:
            [displayedValues setObject:eight forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:NO];
            break;
        case 9:
            [displayedValues setObject:nine forKey:MouseDevice];
            [mouseSpeedField setEnabled:YES];
            [mouseMinValField setEnabled:NO];
            [mouseMaxValField setEnabled:NO];
            [mouseHOffsetField setEnabled:NO];
            [mouseVOffsetField setEnabled:NO];
            [mouseInertiaField setEnabled:YES];
            break;
        }
        }
    anInt = [mouseSpeedField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseSpeed];
    anInt = [mouseMinValField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseMinVal];
    anInt = [mouseMaxValField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseMaxVal];
    anInt = [mouseHOffsetField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseHOffset];
    anInt = [mouseVOffsetField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseVOffset];
    anInt = [mouseInertiaField intValue];
    [displayedValues setObject:[NSNumber numberWithInt:anInt] forKey:MouseInertia];

    switch([joystick1TypePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick1Type];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick1Type];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick1Type];
            break;
        }
    switch([joystick2TypePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick2Type];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick2Type];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick2Type];
            break;
        }
    switch([joystick3TypePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick3Type];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick3Type];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick3Type];
            break;
        }
    switch([joystick4TypePulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick4Type];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick4Type];
            break;
        case 2:
            [displayedValues setObject:two forKey:Joystick4Type];
            break;
        }

    [self updateJoyNumMenus];

    switch([joystick1NumPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick1Num];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick1Num];
            break;
        }
    switch([joystick2NumPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick2Num];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick2Num];
            break;
        }
    switch([joystick3NumPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick3Num];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick3Num];
            break;
        }
    switch([joystick4NumPulldown indexOfSelectedItem]) {
        case 0:
            [displayedValues setObject:zero forKey:Joystick4Num];
            break;
        case 1:
            [displayedValues setObject:one forKey:Joystick4Num];
            break;
        }
        
    if ([paddlesXAxisOnlyButton state] == NSOnState)
        [displayedValues setObject:yes forKey:PaddlesXAxisOnly];
    else
        [displayedValues setObject:no forKey:PaddlesXAxisOnly];
        
    [displayedValues setObject:[gamepad1ConfigPulldown title] forKey:Gamepad1ConfigCurrent];
    [displayedValues setObject:[gamepad2ConfigPulldown title] forKey:Gamepad2ConfigCurrent];
    [displayedValues setObject:[gamepad3ConfigPulldown title] forKey:Gamepad3ConfigCurrent];
    [displayedValues setObject:[gamepad4ConfigPulldown title] forKey:Gamepad4ConfigCurrent];

}


/*------------------------------------------------------------------------------
* browseFile - Method which allows user to choose a file.
*-----------------------------------------------------------------------------*/
- (NSString *) browseFile {
    NSOpenPanel *openPanel;
    
    openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseDirectories:NO];
    [openPanel setCanChooseFiles:YES];
    
    if ([openPanel runModalForTypes:nil] == NSOKButton)
        return([[openPanel filenames] objectAtIndex:0]);
    else
        return nil;
    }

/*------------------------------------------------------------------------------
* browseFileInDirectory - Method which allows user to choose a file in a 
*     specific directory.
*-----------------------------------------------------------------------------*/
- (NSString *) browseFileInDirectory:(NSString *)directory {
    NSOpenPanel *openPanel;
    
    openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseDirectories:NO];
    [openPanel setCanChooseFiles:YES];
    
    if ([openPanel runModalForDirectory:directory file:nil types:nil] == NSOKButton) 
        return([[openPanel filenames] objectAtIndex:0]);
    else
        return nil;
    }


/*------------------------------------------------------------------------------
* browseDir - Method which allows user to choose a directory.
*-----------------------------------------------------------------------------*/
- (NSString *) browseDir {
    NSOpenPanel *openPanel;
    
    openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseDirectories:YES];
    [openPanel setCanChooseFiles:NO];
    
    if ([openPanel runModalForTypes:nil] == NSOKButton)
        return([[openPanel filenames] objectAtIndex:0]);
    else
        return nil;
    }

/* The following methods allow the user to choose the color Palette file */
- (void)browsePalette:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:paletteDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [paletteField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }

/* The following methods allow the user to choose the Hard Disk Drive 
   directories */
- (void)browseHardDisk1:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [hardDiskDir1Field setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseHardDisk2:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [hardDiskDir2Field setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseHardDisk3:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [hardDiskDir3Field setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseHardDisk4:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [hardDiskDir4Field setStringValue:dirname];
        [self miscChanged:self];
        }
    }

/* The following methods allow the user to choose the ROM files */
   
- (void)browseOsARom:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:osromsDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [osARomFileField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }
    
- (void)browseOsBRom:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:osromsDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [osBRomFileField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }
    
- (void)browseXlRom:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:osromsDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [xlRomFileField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }
    
- (void)browseBasicRom:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:osromsDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [basicRomFileField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }
    
- (void)browse5200Rom:(id)sender {
    NSString *filename, *dir;
    
    dir = [[NSString alloc] initWithCString:osromsDir];
    filename = [self browseFileInDirectory:dir];
    if (filename != nil) {
        [a5200RomFileField setStringValue:filename];
        [self miscChanged:self];
        }
    [dir release];
    }

/* The following methods allow the user to choose the default directories
    for files */
    
- (void)browseDiskDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [diskImageDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseDiskSetDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [diskSetDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseCartDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [cartImageDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseCassDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [cassImageDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseExeDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [exeFileDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

- (void)browseStateDir:(id)sender {
    NSString *dirname;
    
    dirname = [self browseDir];
    if (dirname != nil) {
        [savedStateDirField setStringValue:dirname];
        [self miscChanged:self];
        }
    }

/* The following methods allow the user to choose the files for disks, cartridges
   and cassettes which are inserted at the emulator startup */

- (void)browseD1File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d1FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD2File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d2FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD3File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d3FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD4File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d4FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD5File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d5FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD6File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d6FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD7File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d7FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseD8File:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:DiskImageDir]];
    if (filename != nil) {
        [d8FileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseCartFile:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:CartImageDir]];
    if (filename != nil) {
        [cartFileField setStringValue:filename];
        [self miscChanged:self];
        }
    }
    
- (void)browseExeFile:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:ExeFileDir]];
    if (filename != nil) {
        [exeFileField setStringValue:filename];
        [self miscChanged:self];
        }
    }

- (void)browseCassFile:(id)sender {
    NSString *filename;
    
    filename = [self browseFileInDirectory:[curValues objectForKey:CassImageDir]];
    if (filename != nil) {
        [cassFileField setStringValue:filename];
        [self miscChanged:self];
        }
    }

/**** Commit/revert etc ****/

- (void)commitDisplayedValues {
    if (curValues != displayedValues) {
        [curValues release];
        curValues = [displayedValues copyWithZone:[self zone]];
    }
}

- (void)discardDisplayedValues {
    if (curValues != displayedValues) {
        [displayedValues release];
        displayedValues = [curValues mutableCopyWithZone:[self zone]];
        [self updateUI];
    }
}

/*------------------------------------------------------------------------------
* transferValuesToEmulator - Method which allows preferences to be transfered
*   to the 'C' structure which is a buffer between the emulator code and this
*   Cocoa code.
*-----------------------------------------------------------------------------*/
- (void)transferValuesToEmulator {
    ATARI800MACX_PREF *prefs;
    int i,j;
    NSString *configString = NULL;
    NSString *buttonKey, *button5200Key;
    
    prefs = getPrefStorage();
    prefs->fullScreen = [[curValues objectForKey:FullScreen] intValue]; 
    prefs->lockFullscreenSize = [[curValues objectForKey:LockFullscreenSize] intValue]; 
    prefs->doubleSize = [[curValues objectForKey:DoubleSize] intValue]; 
    prefs->scaleFactor = [[curValues objectForKey:ScaleFactor] intValue]; 
    prefs->widthMode = [[curValues objectForKey:WidthMode] intValue]; 
    prefs->tvMode = [[curValues objectForKey:TvMode] intValue]; 
    prefs->refreshRatio = [[curValues objectForKey:RefreshRatio] intValue]; 
    prefs->artifactingMode = [[curValues objectForKey:ArtifactingMode] intValue]; 
    prefs->useBuiltinPalette = [[curValues objectForKey:UseBuiltinPalette] intValue]; 
    prefs->adjustPalette = [[curValues objectForKey:AdjustPalette] intValue]; 
    prefs->blackLevel = [[curValues objectForKey:BlackLevel] intValue]; 
    prefs->whiteLevel = [[curValues objectForKey:WhiteLevel] intValue]; 
    prefs->intensity = [[curValues objectForKey:Intensity] intValue]; 
    prefs->colorShift = [[curValues objectForKey:ColorShift] intValue]; 
    [[curValues objectForKey:PaletteFile] getCString:prefs->paletteFile]; 
    prefs->showFPS = [[curValues objectForKey:ShowFPS] intValue]; 
    prefs->atariType = [[curValues objectForKey:AtariType] intValue]; 
    prefs->disableBasic = [[curValues objectForKey:DisableBasic] intValue]; 
    prefs->enableSioPatch = [[curValues objectForKey:EnableSioPatch] intValue]; 
    prefs->enableHPatch = [[curValues objectForKey:EnableHPatch] intValue]; 
    prefs->enablePPatch = [[curValues objectForKey:EnablePPatch] intValue]; 
    prefs->enableRPatch = [[curValues objectForKey:EnableRPatch] intValue];
    prefs->rPatchPort = [[curValues objectForKey:RPatchPort] intValue];
    [[curValues objectForKey:PrintCommand] getCString:prefs->printCommand]; 
    prefs->bootFromCassette = [[curValues objectForKey:BootFromCassette] intValue]; 
    prefs->speedLimit = [[curValues objectForKey:SpeedLimit] intValue]; 
    prefs->enableSound = [[curValues objectForKey:EnableSound] intValue]; 
    prefs->enableHifiSound = [[curValues objectForKey:EnableHifiSound] intValue]; 
    prefs->enableMultijoy = [[curValues objectForKey:EnableMultijoy] intValue]; 
    prefs->ignoreHeaderWriteprotect = [[curValues objectForKey:IgnoreHeaderWriteprotect] intValue]; 
    [[curValues objectForKey:HardDiskDir1] getCString:prefs->hardDiskDir[0]]; 
    [[curValues objectForKey:HardDiskDir2] getCString:prefs->hardDiskDir[1]]; 
    [[curValues objectForKey:HardDiskDir2] getCString:prefs->hardDiskDir[2]]; 
    [[curValues objectForKey:HardDiskDir3] getCString:prefs->hardDiskDir[3]]; 
    prefs->hardDrivesReadOnly = [[curValues objectForKey:HardDrivesReadOnly] intValue];
    [[curValues objectForKey:HPath] getCString:prefs->hPath]; 
    [[curValues objectForKey:OsARomFile] getCString:prefs->osARomFile]; 
    [[curValues objectForKey:OsBRomFile] getCString:prefs->osBRomFile]; 
    [[curValues objectForKey:XlRomFile] getCString:prefs->xlRomFile]; 
    [[curValues objectForKey:BasicRomFile] getCString:prefs->basicRomFile]; 
    [[curValues objectForKey:A5200RomFile] getCString:prefs->a5200RomFile]; 
    [[curValues objectForKey:DiskImageDir] getCString:prefs->diskImageDir]; 
    [[curValues objectForKey:DiskSetDir] getCString:prefs->diskSetDir]; 
    [[curValues objectForKey:CartImageDir] getCString:prefs->cartImageDir]; 
    [[curValues objectForKey:CassImageDir] getCString:prefs->cassImageDir]; 
    [[curValues objectForKey:ExeFileDir] getCString:prefs->exeFileDir]; 
    [[curValues objectForKey:SavedStateDir] getCString:prefs->savedStateDir];
    [[curValues objectForKey:D1File] getCString:prefs->dFile[0]];
    [[curValues objectForKey:D2File] getCString:prefs->dFile[1]];
    [[curValues objectForKey:D3File] getCString:prefs->dFile[2]];
    [[curValues objectForKey:D4File] getCString:prefs->dFile[3]];
    [[curValues objectForKey:D5File] getCString:prefs->dFile[4]];
    [[curValues objectForKey:D6File] getCString:prefs->dFile[5]];
    [[curValues objectForKey:D7File] getCString:prefs->dFile[6]];
    [[curValues objectForKey:D8File] getCString:prefs->dFile[7]];
    [[curValues objectForKey:CartFile] getCString:prefs->cartFile];
    [[curValues objectForKey:ExeFile] getCString:prefs->exeFile];
    [[curValues objectForKey:CassFile] getCString:prefs->cassFile];
    prefs->dFileEnabled[0] = [[curValues objectForKey:D1FileEnabled] intValue]; 
    prefs->dFileEnabled[1] = [[curValues objectForKey:D2FileEnabled] intValue]; 
    prefs->dFileEnabled[2] = [[curValues objectForKey:D3FileEnabled] intValue]; 
    prefs->dFileEnabled[3] = [[curValues objectForKey:D4FileEnabled] intValue]; 
    prefs->dFileEnabled[4] = [[curValues objectForKey:D5FileEnabled] intValue]; 
    prefs->dFileEnabled[5] = [[curValues objectForKey:D6FileEnabled] intValue]; 
    prefs->dFileEnabled[6] = [[curValues objectForKey:D7FileEnabled] intValue]; 
    prefs->dFileEnabled[7] = [[curValues objectForKey:D8FileEnabled] intValue]; 
    prefs->cartFileEnabled = [[curValues objectForKey:CartFileEnabled] intValue]; 
    prefs->exeFileEnabled = [[curValues objectForKey:ExeFileEnabled] intValue]; 
    prefs->cassFileEnabled = [[curValues objectForKey:CassFileEnabled] intValue]; 
    prefs->joystickMode[0] = [[curValues objectForKey:Joystick1Mode] intValue]; 
    prefs->joystickMode[1] = [[curValues objectForKey:Joystick2Mode] intValue]; 
    prefs->joystickMode[2] = [[curValues objectForKey:Joystick3Mode] intValue]; 
    prefs->joystickMode[3] = [[curValues objectForKey:Joystick4Mode] intValue]; 
    prefs->joystickAutofire[0] = [[curValues objectForKey:Joystick1Autofire] intValue]; 
    prefs->joystickAutofire[1] = [[curValues objectForKey:Joystick2Autofire] intValue]; 
    prefs->joystickAutofire[2] = [[curValues objectForKey:Joystick3Autofire] intValue]; 
    prefs->joystickAutofire[3] = [[curValues objectForKey:Joystick4Autofire] intValue];
    prefs->mouseDevice = [[curValues objectForKey:MouseDevice] intValue];
    prefs->mouseSpeed = [[curValues objectForKey:MouseSpeed] intValue];
    prefs->mouseMinVal = [[curValues objectForKey:MouseMinVal] intValue];
    prefs->mouseMaxVal = [[curValues objectForKey:MouseMaxVal] intValue];
    prefs->mouseHOffset = [[curValues objectForKey:MouseHOffset] intValue];
    prefs->mouseVOffset = [[curValues objectForKey:MouseVOffset] intValue];
    prefs->mouseInertia = [[curValues objectForKey:MouseInertia] intValue];
    prefs->joystick1Type = [[curValues objectForKey:Joystick1Type] intValue];
    prefs->joystick2Type = [[curValues objectForKey:Joystick2Type] intValue];
    prefs->joystick3Type = [[curValues objectForKey:Joystick3Type] intValue];
    prefs->joystick4Type = [[curValues objectForKey:Joystick4Type] intValue];
    prefs->joystick1Num = [[curValues objectForKey:Joystick1Num] intValue];
    prefs->joystick2Num = [[curValues objectForKey:Joystick2Num] intValue];
    prefs->joystick3Num = [[curValues objectForKey:Joystick3Num] intValue];
    prefs->joystick4Num = [[curValues objectForKey:Joystick4Num] intValue];
    prefs->paddlesXAxisOnly = [[curValues objectForKey:PaddlesXAxisOnly] intValue];

    for (i=0;i<4;i++) {
        switch(i) {
            case 0:
                configString = [curValues objectForKey:Gamepad1ConfigCurrent];
                break;
            case 1:
                configString = [curValues objectForKey:Gamepad2ConfigCurrent];
                break;
            case 2:
                configString = [curValues objectForKey:Gamepad3ConfigCurrent];
                break;
            case 3:
                configString = [curValues objectForKey:Gamepad4ConfigCurrent];
                break;
            }
        
        if ([configString isEqual:StandardConfigString]) {
            for (j=0;j<24;j++) {
                prefs->buttonAssignment[i][j] = 0;
                prefs->button5200Assignment[i][j] = 0;
                }
            }
        else {
            buttonKey = [ButtonAssignmentPrefix stringByAppendingString:configString];
            button5200Key = [Button5200AssignmentPrefix stringByAppendingString:configString];
            
            for (j=0;j<24;j++) {
                prefs->buttonAssignment[i][j] = 
                    [[[[NSUserDefaults standardUserDefaults] objectForKey:buttonKey] objectAtIndex:j] intValue];
                prefs->button5200Assignment[i][j] = 
                    [[[[NSUserDefaults standardUserDefaults] objectForKey:button5200Key] objectAtIndex:j] intValue];
                }
            }
        }
        
    prefs->leftJoyUp = [[curValues objectForKey:LeftJoyUp] intValue];
    prefs->leftJoyDown = [[curValues objectForKey:LeftJoyDown] intValue];
    prefs->leftJoyLeft = [[curValues objectForKey:LeftJoyLeft] intValue];
    prefs->leftJoyRight = [[curValues objectForKey:LeftJoyRight] intValue];
    prefs->leftJoyUpLeft = [[curValues objectForKey:LeftJoyUpLeft] intValue];
    prefs->leftJoyUpRight = [[curValues objectForKey:LeftJoyUpRight] intValue];
    prefs->leftJoyDownLeft = [[curValues objectForKey:LeftJoyDownLeft] intValue];
    prefs->leftJoyDownRight = [[curValues objectForKey:LeftJoyDownRight] intValue];
    prefs->leftJoyFire = [[curValues objectForKey:LeftJoyFire] intValue];
    prefs->leftJoyAltFire = [[curValues objectForKey:LeftJoyAltFire] intValue];
    prefs->padJoyUp = [[curValues objectForKey:PadJoyUp] intValue];
    prefs->padJoyDown = [[curValues objectForKey:PadJoyDown] intValue];
    prefs->padJoyLeft = [[curValues objectForKey:PadJoyLeft] intValue];
    prefs->padJoyRight = [[curValues objectForKey:PadJoyRight] intValue];
    prefs->padJoyUpLeft = [[curValues objectForKey:PadJoyUpLeft] intValue];
    prefs->padJoyUpRight = [[curValues objectForKey:PadJoyUpRight] intValue];
    prefs->padJoyDownLeft = [[curValues objectForKey:PadJoyDownLeft] intValue];
    prefs->padJoyDownRight = [[curValues objectForKey:PadJoyDownRight] intValue];
    prefs->padJoyFire = [[curValues objectForKey:PadJoyFire] intValue];
    prefs->padJoyAltFire = [[curValues objectForKey:PadJoyAltFire] intValue];
    }

/* Handle the OK, cancel, and Revert buttons */

- (void)ok:(id)sender {
    [self miscChanged:self];
    [self gamepadConfigChange:gamepadConfigPulldown];
    [self commitDisplayedValues];
    [NSApp stopModal];
    [[prefTabView window] close];
    [self transferValuesToEmulator];
    requestPrefsChange = 1;
    PauseAudio(0);
}

- (void)revertToDefault:(id)sender {
    NSMutableArray *configArray;
    
    configArray = [[curValues objectForKey:GamepadConfigArray] mutableCopyWithZone:[self zone]];
    curValues = [defaultValues() mutableCopyWithZone:[self zone]];
    [curValues setObject:configArray forKey:GamepadConfigArray];
    
    [self discardDisplayedValues];
    [gamepadConfigPulldown selectItemAtIndex:0];
    [gamepad1ConfigPulldown selectItemAtIndex:0];
    [gamepad2ConfigPulldown selectItemAtIndex:0];
    [gamepad3ConfigPulldown selectItemAtIndex:0];
    [gamepad4ConfigPulldown selectItemAtIndex:0];
    [self gamepadButtonChange:self];
    [NSApp stopModal];
    [[prefTabView window] close];
    [self transferValuesToEmulator];
    requestPrefsChange = 1;
    PauseAudio(0);
}

- (void)revert:(id)sender {
    [self discardDisplayedValues];
    [NSApp stopModal];
    [[prefTabView window] close];
    PauseAudio(0);
}

- (void)gamepadConfigChange:(id)sender {
    int numberOfConfigs, action;
    int nameTaken = FALSE;
    int i,currNumConfigs;
    NSString *buttonKey, *button5200Key;
    
    numberOfConfigs = [[curValues objectForKey:GamepadConfigArray] count];
    action = [sender indexOfSelectedItem];
    if (action == 0) {  /* Default Config */
        if (![[displayedValues objectForKey:GamepadConfigCurrent] isEqual:StandardConfigString]) {
            [displayedValues setObject:StandardConfigString forKey:GamepadConfigCurrent];
            for (i=0;i<24;i++) {
                [[displayedValues objectForKey:ButtonAssignment] replaceObjectAtIndex:i 
                    withObject:[[defaultValues() objectForKey:ButtonAssignment] objectAtIndex:i]];
                [[displayedValues objectForKey:Button5200Assignment] replaceObjectAtIndex:i 
                    withObject:[[defaultValues() objectForKey:Button5200Assignment] objectAtIndex:i]];
                }
            }
        }
    else if (action == (3 + numberOfConfigs)) { /* Save Config */
        buttonKey = [ButtonAssignmentPrefix stringByAppendingString:[displayedValues objectForKey:GamepadConfigCurrent]];
        button5200Key = [Button5200AssignmentPrefix 
                            stringByAppendingString:[displayedValues objectForKey:GamepadConfigCurrent]];
        [[NSUserDefaults standardUserDefaults] 
            setObject:[displayedValues objectForKey:ButtonAssignment] forKey:buttonKey];
        [[NSUserDefaults standardUserDefaults] 
            setObject:[displayedValues objectForKey:Button5200Assignment] forKey:button5200Key];
        }
    else if (action == (4 + numberOfConfigs)) { /* Save As....Config */
        /* Go get the deired configuration name */
        [NSApp runModalForWindow:[configNameField window]];
        /* Findout if the configuration name is in use */
        currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
        for (i=0;i < currNumConfigs ;i++)
            if ([[configNameField stringValue] isEqual:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:i]])
                nameTaken = TRUE;
        if ([[configNameField stringValue] isEqual:StandardConfigString])
            nameTaken = TRUE;
        /* If it is display an error....*/
        if (nameTaken) {
            [NSApp runModalForWindow:[errorOKButton window]];
            }
        /* Otherwise save the current config under that name...*/
        else {
            /* Add the name to the array */
            [[curValues objectForKey:GamepadConfigArray] 
                addObject:[NSString stringWithString:[configNameField stringValue]]];
            /* Set the current config to it */
            [displayedValues setObject:[configNameField stringValue] forKey:GamepadConfigCurrent];
            /* Add the name to the menu...*/
            [gamepadConfigPulldown insertItemWithTitle:[configNameField stringValue] atIndex: (2+currNumConfigs)];
            [gamepad1ConfigPulldown insertItemWithTitle:[configNameField stringValue] atIndex: (1+currNumConfigs)];
            [gamepad2ConfigPulldown insertItemWithTitle:[configNameField stringValue] atIndex: (1+currNumConfigs)];
            [gamepad3ConfigPulldown insertItemWithTitle:[configNameField stringValue] atIndex: (1+currNumConfigs)];
            [gamepad4ConfigPulldown insertItemWithTitle:[configNameField stringValue] atIndex: (1+currNumConfigs)];
            /* And save the config in Defaults ... */
            buttonKey = [ButtonAssignmentPrefix stringByAppendingString:[configNameField stringValue]];
            button5200Key = [Button5200AssignmentPrefix stringByAppendingString:[configNameField stringValue]];
            [[NSUserDefaults standardUserDefaults] 
                setObject:[displayedValues objectForKey:ButtonAssignment] forKey:buttonKey];
            [[NSUserDefaults standardUserDefaults] 
                setObject:[displayedValues objectForKey:Button5200Assignment] forKey:button5200Key];
            }
        }
    else if (action == (5 + numberOfConfigs)) { /* Rename....Config */
        /* Go get the deired configuration name */
        [NSApp runModalForWindow:[configNameField window]];
        /* Findout if the configuration name is in use */
        currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
        for (i=0;i < currNumConfigs ;i++)
            if ([[configNameField stringValue] isEqual:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:i]])
                nameTaken = TRUE;
        if ([[configNameField stringValue] isEqual:StandardConfigString])
            nameTaken = TRUE;
        if ([[configNameField stringValue] isEqual:[curValues objectForKey:GamepadConfigCurrent]])
            nameTaken = FALSE;
        /* If it is display an error....*/
        if (nameTaken) {
            [NSApp runModalForWindow:[errorOKButton window]];
            }
        /* Otherwise rename the current config under that name...*/
        else {
            /* Find the name in the current list */
            currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
            for (i=0;i < currNumConfigs ;i++) 
                if ([[displayedValues objectForKey:GamepadConfigCurrent] 
                    isEqual:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:i]])
                        break;
            /* Take out the old name in the list, and put in the new... */
            [[curValues objectForKey:GamepadConfigArray] removeObjectAtIndex:i];
            [[curValues objectForKey:GamepadConfigArray] 
                insertObject:[NSString stringWithString:[configNameField stringValue]] atIndex:i];
            /* Rename the menu item */
            [[gamepadConfigPulldown itemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]] 
                setTitle:[configNameField stringValue]];
            [[gamepad1ConfigPulldown itemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]] 
                setTitle:[configNameField stringValue]];
            [[gamepad2ConfigPulldown itemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]] 
                setTitle:[configNameField stringValue]];
            [[gamepad3ConfigPulldown itemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]] 
                setTitle:[configNameField stringValue]];
            [[gamepad4ConfigPulldown itemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]] 
                setTitle:[configNameField stringValue]];
            /* Remove the old configs from the defaults....*/
            buttonKey = [ButtonAssignmentPrefix stringByAppendingString:
                [displayedValues objectForKey:GamepadConfigCurrent]];
            button5200Key = [Button5200AssignmentPrefix stringByAppendingString:
                [displayedValues objectForKey:GamepadConfigCurrent]];
            [[NSUserDefaults standardUserDefaults] removeObjectForKey:buttonKey];
            [[NSUserDefaults standardUserDefaults] removeObjectForKey:button5200Key];
            /* ...And add the new ones */
            buttonKey = [ButtonAssignmentPrefix stringByAppendingString:[configNameField stringValue]];
            button5200Key = [Button5200AssignmentPrefix stringByAppendingString:[configNameField stringValue]];
            [[NSUserDefaults standardUserDefaults] 
                setObject:[displayedValues objectForKey:ButtonAssignment] forKey:buttonKey];
            [[NSUserDefaults standardUserDefaults] 
                setObject:[displayedValues objectForKey:Button5200Assignment] forKey:button5200Key];
            /* Set the current config to it */
            [displayedValues setObject:[configNameField stringValue] forKey:GamepadConfigCurrent];
            }
        }
    else if (action == (6 + numberOfConfigs)) { /* Delete Config */
        /* Find the name in the current list */
        currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
        for (i=0;i < currNumConfigs ;i++) {
            if ([[displayedValues objectForKey:GamepadConfigCurrent] 
                    isEqual:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:i]])
               break;
            }
        /* Take it out of the list */
        [[curValues objectForKey:GamepadConfigArray] removeObjectAtIndex:i];
        /* And the Menu */
        [gamepadConfigPulldown removeItemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]];
        [gamepad1ConfigPulldown removeItemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]];
        [gamepad2ConfigPulldown removeItemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]];
        [gamepad3ConfigPulldown removeItemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]];
        [gamepad4ConfigPulldown removeItemWithTitle:[displayedValues objectForKey:GamepadConfigCurrent]];
        /* And the defaults.... */
        buttonKey = [ButtonAssignmentPrefix stringByAppendingString:[displayedValues objectForKey:GamepadConfigCurrent]];
        button5200Key = [Button5200AssignmentPrefix 
                            stringByAppendingString:[displayedValues objectForKey:GamepadConfigCurrent]];
        [[NSUserDefaults standardUserDefaults] removeObjectForKey:buttonKey];
        [[NSUserDefaults standardUserDefaults] removeObjectForKey:button5200Key];

        /* Now set the default to the config before it, if it exists...*/
        /* If there was only one, we are back to Default */
        if (currNumConfigs == 1) {
            [displayedValues setObject:StandardConfigString forKey:GamepadConfigCurrent];
            }
        else {
            /* If it was the first one, select the new first one */
            if (i==0) {
                [displayedValues setObject:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:0] 						forKey:GamepadConfigCurrent];
                }
            /* Otherwise select the one before it */
            else {
                [displayedValues setObject:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:(i-1)] 						forKey:GamepadConfigCurrent];
                }
            /* and load in the button settings for that item ...*/
            buttonKey = [ButtonAssignmentPrefix stringByAppendingString:
                [displayedValues objectForKey:GamepadConfigCurrent]];
            button5200Key = [Button5200AssignmentPrefix stringByAppendingString:
                [displayedValues objectForKey:GamepadConfigCurrent]];
            [displayedValues setObject:[[[NSUserDefaults standardUserDefaults] objectForKey:buttonKey] 
                mutableCopyWithZone:[self zone]] forKey:ButtonAssignment];
            [displayedValues setObject:[[[NSUserDefaults standardUserDefaults] objectForKey:button5200Key]
                mutableCopyWithZone:[self zone]] forKey:Button5200Assignment];
            }
        }
    else {
        /* Set the current config to the selected one */
        [displayedValues setObject:
            [gamepadConfigPulldown itemTitleAtIndex:action] forKey:GamepadConfigCurrent];
        /* And get the button settings from Defaults */
        buttonKey = [ButtonAssignmentPrefix stringByAppendingString:[gamepadConfigPulldown itemTitleAtIndex:action]];
        button5200Key = [Button5200AssignmentPrefix stringByAppendingString:[gamepadConfigPulldown itemTitleAtIndex:action]];
        [displayedValues setObject:[[[NSUserDefaults standardUserDefaults] objectForKey:buttonKey] 
            mutableCopyWithZone:[self zone]] forKey:ButtonAssignment];
        [displayedValues setObject:[[[NSUserDefaults standardUserDefaults] objectForKey:button5200Key]
            mutableCopyWithZone:[self zone]] forKey:Button5200Assignment];
        }
    
    /* Set the menu to the selected configuration */
    if ([[displayedValues objectForKey:GamepadConfigCurrent] isEqual:StandardConfigString])
        [gamepadConfigPulldown selectItemAtIndex:0];
    else {
        /* Find the name in the current list */
        currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
        for (i=0;i < currNumConfigs ;i++) {
            if ([[displayedValues objectForKey:GamepadConfigCurrent] 
                    isEqual:[[curValues objectForKey:GamepadConfigArray] objectAtIndex:i]])
               break;
            }
        [gamepadConfigPulldown selectItemAtIndex:(2+i)];
        }
    
    /* Turn on/off the Save, Delete, and Rename menu items based on if Default is selected... */
    currNumConfigs = [[curValues objectForKey:GamepadConfigArray] count];
    if ([gamepadConfigPulldown indexOfSelectedItem] == 0) {
        [[gamepadConfigPulldown itemAtIndex:(3+currNumConfigs)] setEnabled:NO];
        [[gamepadConfigPulldown itemAtIndex:(5+currNumConfigs)] setEnabled:NO];
        [[gamepadConfigPulldown itemAtIndex:(6+currNumConfigs)] setEnabled:NO];
        }
    else {
        [[gamepadConfigPulldown itemAtIndex:(3+currNumConfigs)] setEnabled:YES];
        [[gamepadConfigPulldown itemAtIndex:(5+currNumConfigs)] setEnabled:YES];
        [[gamepadConfigPulldown itemAtIndex:(6+currNumConfigs)] setEnabled:YES];
        }
    
    /* Tell the other menus to update... */
    [self gamepadButtonChange:self];
    [self miscChanged:self];
    }
    
- (void)configNameOK:(id)sender {
    [NSApp stopModal];
    [[configNameField window] close];
    }
    
- (void)errorOK:(id)sender {
    [NSApp stopModal];
    [[errorOKButton window] close];
    }

- (void)gamepadButtonChange:(id)sender {
    int buttonNum;

    buttonNum = [gamepadButtonPulldown indexOfSelectedItem];
    
    [gamepadAssignmentPulldown selectItemAtIndex:
        [[[displayedValues objectForKey:ButtonAssignment] objectAtIndex:buttonNum] intValue]];
    [gamepad5200AssignmentPulldown  selectItemAtIndex:
        [[[displayedValues objectForKey:Button5200Assignment] objectAtIndex:buttonNum] intValue]];
    }
    
- (void)buttonAssign:(id)sender {
    int buttonNum;
    int index;

    buttonNum = [gamepadButtonPulldown indexOfSelectedItem];
    index = [gamepadAssignmentPulldown indexOfSelectedItem];
    
    [[displayedValues objectForKey:ButtonAssignment] 
        replaceObjectAtIndex:buttonNum withObject:[NSNumber numberWithInt:index]];
    }
    
- (void)button5200Assign:(id)sender {
    int buttonNum;
    int index;

    buttonNum = [gamepadButtonPulldown indexOfSelectedItem];
    index = [gamepad5200AssignmentPulldown indexOfSelectedItem];
    
    [[displayedValues objectForKey:Button5200Assignment] 
        replaceObjectAtIndex:buttonNum withObject:[NSNumber numberWithInt:index]];
    }
    
- (void)identifyGamepad:(id)sender{
    int numButtons, numSticks, numHats;
    SDL_Joystick *joystick;

    padNum = [sender tag];
    if (padNum == 0) {
        joystick = joystick0;
        numButtons = joystick0_nbuttons;
        numSticks = joystick0_nsticks;
        numHats = joystick0_nhats;
        }
    else if (padNum == 1) {
        joystick = joystick1;
        numButtons = joystick1_nbuttons;
        numSticks = joystick1_nsticks;
        numHats = joystick1_nhats;
        }
    else if (padNum == 2) {
        joystick = joystick2;
        numButtons = joystick2_nbuttons;
        numSticks = joystick2_nsticks;
        numHats = joystick2_nhats;
        }
    else {
        joystick = joystick3;
        numButtons = joystick3_nbuttons;
        numSticks = joystick3_nsticks;
        numHats = joystick3_nhats;
        }

    [gamepadButton1 setState:NSOffState];
    [gamepadButton2 setState:NSOffState];
    [gamepadButton3 setState:NSOffState];
    [gamepadButton4 setState:NSOffState];
    [gamepadButton5 setState:NSOffState];
    [gamepadButton6 setState:NSOffState];
    [gamepadButton7 setState:NSOffState];
    [gamepadButton8 setState:NSOffState];
    [gamepadButton9 setState:NSOffState];
    [gamepadButton10 setState:NSOffState];
    [gamepadButton11 setState:NSOffState];
    [gamepadButton12 setState:NSOffState];
    [gamepadButton13 setState:NSOffState];
    [gamepadButton14 setState:NSOffState];
    [gamepadButton15 setState:NSOffState];
    [gamepadButton16 setState:NSOffState];
    [gamepadButton17 setState:NSOffState];
    [gamepadButton18 setState:NSOffState];
    [gamepadButton19 setState:NSOffState];
    [gamepadButton20 setState:NSOffState];
    [gamepadButton21 setState:NSOffState];
    [gamepadButton22 setState:NSOffState];
    [gamepadButton23 setState:NSOffState];
    [gamepadButton24 setState:NSOffState];
    if (joystick == NULL) {
        [gamepadNameField setStringValue:@"No Joystick Connected"];
        [gamepadNumButtonsField setStringValue:@"0"];
        [gamepadNumSticksField setStringValue:@"0"];
        [gamepadNumHatsField setStringValue:@"0"];
        }
    else {
        [gamepadNameField setStringValue:[NSString stringWithCString:SDL_JoystickName(SDL_JoystickIndex(joystick))]];
        [gamepadNumButtonsField setIntValue:numButtons];
        [gamepadNumSticksField setIntValue:numSticks];
        [gamepadNumHatsField setIntValue:numHats];
        }
    
    [NSApp runModalForWindow:[gamepadButton1 window]];
    }
    


- (void)identifyOK:(id)sender {
    [NSApp stopModal];
    [[gamepadButton1 window] close];
    }
    
- (void)identifyTest:(id)sender {
    int numButtons;
    SDL_Joystick *joystick;
    int i;
    int state;

    if (padNum == 0) {
        joystick = joystick0;
        numButtons = joystick0_nbuttons;
        }
    else if (padNum == 1) {
        joystick = joystick1;
        numButtons = joystick1_nbuttons;
        }
    else if (padNum == 2) {
        joystick = joystick2;
        numButtons = joystick2_nbuttons;
        }
    else {
        joystick = joystick3;
        numButtons = joystick3_nbuttons;
        }


    SDL_JoystickUpdate();
    for (i=0;i<numButtons;i++) {
        state = SDL_JoystickGetButton(joystick, i);
        switch(i) {
            case 0:
                if (state)
                    [gamepadButton1 setState:NSOnState];
                else
                    [gamepadButton1 setState:NSOffState];
                break;
            case 1:
                if (state)
                    [gamepadButton2 setState:NSOnState];
                else
                    [gamepadButton2 setState:NSOffState];
                break;
            case 2:
                if (state)
                    [gamepadButton3 setState:NSOnState];
                else
                    [gamepadButton3 setState:NSOffState];
                break;
            case 3:
                if (state)
                    [gamepadButton4 setState:NSOnState];
                else
                    [gamepadButton4 setState:NSOffState];
                break;
            case 4:
                if (state)
                    [gamepadButton5 setState:NSOnState];
                else
                    [gamepadButton5 setState:NSOffState];
                break;
            case 5:
                if (state)
                    [gamepadButton6 setState:NSOnState];
                else
                    [gamepadButton6 setState:NSOffState];
                break;
            case 6:
                if (state)
                    [gamepadButton7 setState:NSOnState];
                else
                    [gamepadButton7 setState:NSOffState];
                break;
            case 7:
                if (state)
                    [gamepadButton8 setState:NSOnState];
                else
                    [gamepadButton8 setState:NSOffState];
                break;
            case 8:
                if (state)
                    [gamepadButton9 setState:NSOnState];
                else
                    [gamepadButton9 setState:NSOffState];
                break;
            case 9:
                if (state)
                    [gamepadButton10 setState:NSOnState];
                else
                    [gamepadButton10 setState:NSOffState];
                break;
            case 10:
                if (state)
                    [gamepadButton11 setState:NSOnState];
                else
                    [gamepadButton11 setState:NSOffState];
                break;
            case 11:
                if (state)
                    [gamepadButton12 setState:NSOnState];
                else
                    [gamepadButton12 setState:NSOffState];
                break;
            case 12:
                if (state)
                    [gamepadButton13 setState:NSOnState];
                else
                    [gamepadButton13 setState:NSOffState];
                break;
            case 13:
                if (state)
                    [gamepadButton14 setState:NSOnState];
                else
                    [gamepadButton14 setState:NSOffState];
                break;
            case 14:
                if (state)
                    [gamepadButton15 setState:NSOnState];
                else
                    [gamepadButton15 setState:NSOffState];
                break;
            case 15:
                if (state)
                    [gamepadButton16 setState:NSOnState];
                else
                    [gamepadButton16 setState:NSOffState];
                break;
            case 16:
                if (state)
                    [gamepadButton17 setState:NSOnState];
                else
                    [gamepadButton17 setState:NSOffState];
                break;
            case 17:
                if (state)
                    [gamepadButton18 setState:NSOnState];
                else
                    [gamepadButton18 setState:NSOffState];
                break;
            case 18:
                if (state)
                    [gamepadButton19 setState:NSOnState];
                else
                    [gamepadButton19 setState:NSOffState];
                break;
            case 19:
                if (state)
                    [gamepadButton20 setState:NSOnState];
                else
                    [gamepadButton20 setState:NSOffState];
                break;
            case 20:
                if (state)
                    [gamepadButton21 setState:NSOnState];
                else
                    [gamepadButton21 setState:NSOffState];
                break;
            case 21:
                if (state)
                    [gamepadButton22 setState:NSOnState];
                else
                    [gamepadButton22 setState:NSOffState];
                break;
            case 22:
                if (state)
                    [gamepadButton23 setState:NSOnState];
                else
                    [gamepadButton23 setState:NSOffState];
                break;
            case 23:
                if (state)
                    [gamepadButton24 setState:NSOnState];
                else
                    [gamepadButton24 setState:NSOffState];
                break;
            }
        }
    }

- (void)leftJoyConfigure:(id)sender
{
    [leftJoyUpPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyUp] intValue]];
    [leftJoyDownPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyDown] intValue]];
    [leftJoyLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyLeft] intValue]];
    [leftJoyRightPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyRight] intValue]];
    [leftJoyUpLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyUpLeft] intValue]];
    [leftJoyUpRightPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyUpRight] intValue]];
    [leftJoyDownLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyDownLeft] intValue]];
    [leftJoyDownRightPulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyDownRight] intValue]];
    [leftJoyFirePulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyFire] intValue]];
    [leftJoyAltFirePulldown selectItemAtIndex:[[displayedValues objectForKey:LeftJoyAltFire] intValue]];
    [NSApp runModalForWindow:[leftJoyUpPulldown window]];
}

- (void)leftJoyOK:(id)sender
{
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyUpPulldown indexOfSelectedItem]]
        forKey:LeftJoyUp]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyDownPulldown indexOfSelectedItem]]
        forKey:LeftJoyDown]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyLeftPulldown indexOfSelectedItem]]
        forKey:LeftJoyLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyRightPulldown indexOfSelectedItem]]
        forKey:LeftJoyRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyUpLeftPulldown indexOfSelectedItem]]
        forKey:LeftJoyUpLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyUpRightPulldown indexOfSelectedItem]]
        forKey:LeftJoyUpRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyDownLeftPulldown indexOfSelectedItem]]
        forKey:LeftJoyDownLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyDownRightPulldown indexOfSelectedItem]]
        forKey:LeftJoyDownRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyFirePulldown indexOfSelectedItem]]
        forKey:LeftJoyFire]; 
    [displayedValues setObject:[NSNumber numberWithInt:[leftJoyAltFirePulldown indexOfSelectedItem]]
        forKey:LeftJoyAltFire]; 
    [NSApp stopModal];
    [[leftJoyUpPulldown window] close];
}

- (void)padJoyConfigure:(id)sender
{
    [padJoyUpPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyUp] intValue]];
    [padJoyDownPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyDown] intValue]];
    [padJoyLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyLeft] intValue]];
    [padJoyRightPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyRight] intValue]];
    [padJoyUpLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyUpLeft] intValue]];
    [padJoyUpRightPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyUpRight] intValue]];
    [padJoyDownLeftPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyDownLeft] intValue]];
    [padJoyDownRightPulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyDownRight] intValue]];
    [padJoyFirePulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyFire] intValue]];
    [padJoyAltFirePulldown selectItemAtIndex:[[displayedValues objectForKey:PadJoyAltFire] intValue]];
    [NSApp runModalForWindow:[padJoyUpPulldown window]];
}

- (void)padJoyOK:(id)sender
{
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyUpPulldown indexOfSelectedItem]]
        forKey:PadJoyUp]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyDownPulldown indexOfSelectedItem]]
        forKey:PadJoyDown]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyLeftPulldown indexOfSelectedItem]]
        forKey:PadJoyLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyRightPulldown indexOfSelectedItem]]
        forKey:PadJoyRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyUpLeftPulldown indexOfSelectedItem]]
        forKey:PadJoyUpLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyUpRightPulldown indexOfSelectedItem]]
        forKey:PadJoyUpRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyDownLeftPulldown indexOfSelectedItem]]
        forKey:PadJoyDownLeft]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyDownRightPulldown indexOfSelectedItem]]
        forKey:PadJoyDownRight]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyFirePulldown indexOfSelectedItem]]
        forKey:PadJoyFire]; 
    [displayedValues setObject:[NSNumber numberWithInt:[padJoyAltFirePulldown indexOfSelectedItem]]
        forKey:PadJoyAltFire]; 
    [NSApp stopModal];
    [[padJoyUpPulldown window] close];
}



/**** Code to deal with defaults ****/
   
#define getBoolDefault(name) \
  {id obj = [defaults objectForKey:name]; \
      [dict setObject:obj ? [NSNumber numberWithBool:[defaults boolForKey:name]] : [defaultValues() objectForKey:name] forKey:name];}

#define getIntDefault(name) \
  {id obj = [defaults objectForKey:name]; \
      [dict setObject:obj ? [NSNumber numberWithInt:[defaults integerForKey:name]] : [defaultValues() objectForKey:name] forKey:name];}

#define getStringDefault(name) \
  {id obj = [defaults objectForKey:name]; \
      [dict setObject:obj ? [NSString stringWithString:[defaults stringForKey:name]] : [defaultValues() objectForKey:name] forKey:name];}
      
#define getArrayDefault(name) \
  {id obj = [defaults objectForKey:name]; \
      [dict setObject:obj ? [NSMutableArray arrayWithArray:[defaults arrayForKey:name]] : [[defaultValues() objectForKey:name] mutableCopyWithZone:[self zone]] forKey:name];}
      
/* Read prefs from system defaults */
+ (NSDictionary *)preferencesFromDefaults {
    unsigned i,count;
    
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSMutableDictionary *dict = [NSMutableDictionary dictionaryWithCapacity:10];
    getBoolDefault(FullScreen);
    getBoolDefault(LockFullscreenSize);
    getBoolDefault(DoubleSize);
    getIntDefault(ScaleFactor);
    getIntDefault(WidthMode);
    getIntDefault(TvMode);
    getIntDefault(RefreshRatio);
    getIntDefault(ArtifactingMode);
    getStringDefault(PaletteFile);
    getBoolDefault(UseBuiltinPalette);
    getIntDefault(BlackLevel);
    getIntDefault(WhiteLevel);
    getIntDefault(Intensity);
    getIntDefault(ColorShift);
    getBoolDefault(AdjustPalette);
    getBoolDefault(ShowFPS);
    getIntDefault(AtariType);
    getBoolDefault(DisableBasic);
    getBoolDefault(EnableSioPatch);
    getBoolDefault(EnableHPatch);
    getBoolDefault(EnablePPatch);
    getBoolDefault(EnableRPatch);
    getIntDefault(RPatchPort);
    getStringDefault(PrintCommand);
    getBoolDefault(BootFromCassette);
    getBoolDefault(SpeedLimit);
    getBoolDefault(EnableSound);
    getBoolDefault(EnableHifiSound);
    getBoolDefault(EnableMultijoy);
    getBoolDefault(IgnoreHeaderWriteprotect);
    getStringDefault(HardDiskDir1);
    getStringDefault(HardDiskDir2);
    getStringDefault(HardDiskDir3);
    getStringDefault(HardDiskDir4);
    getBoolDefault(HardDrivesReadOnly);
    getStringDefault(HPath);
    getStringDefault(OsARomFile);
    getStringDefault(OsBRomFile);
    getStringDefault(XlRomFile);
    getStringDefault(BasicRomFile);
    getStringDefault(A5200RomFile);
    getStringDefault(DiskImageDir);
    getStringDefault(DiskSetDir);
    getStringDefault(CartImageDir);
    getStringDefault(CassImageDir);
    getStringDefault(ExeFileDir);
    getStringDefault(SavedStateDir);
    getStringDefault(D1File);
    getStringDefault(D2File);
    getStringDefault(D3File);
    getStringDefault(D4File);
    getStringDefault(D5File);
    getStringDefault(D6File);
    getStringDefault(D7File);
    getStringDefault(D8File);
    getStringDefault(CartFile);
    getStringDefault(ExeFile);
    getStringDefault(CassFile);
    getBoolDefault(D1FileEnabled);
    getBoolDefault(D2FileEnabled);
    getBoolDefault(D3FileEnabled);
    getBoolDefault(D4FileEnabled);
    getBoolDefault(D5FileEnabled);
    getBoolDefault(D6FileEnabled);
    getBoolDefault(D7FileEnabled);
    getBoolDefault(D8FileEnabled);
    getBoolDefault(CartFileEnabled);
    getBoolDefault(ExeFileEnabled);
    getBoolDefault(CassFileEnabled);
    getIntDefault(Joystick1Mode);
    getIntDefault(Joystick2Mode);
    getIntDefault(Joystick3Mode);
    getIntDefault(Joystick4Mode);
    getIntDefault(Joystick1Autofire);
    getIntDefault(Joystick2Autofire);
    getIntDefault(Joystick3Autofire);
    getIntDefault(Joystick4Autofire);
    getIntDefault(MouseDevice);
    getIntDefault(MouseSpeed);
    getIntDefault(MouseMinVal);
    getIntDefault(MouseMaxVal);
    getIntDefault(MouseHOffset);
    getIntDefault(MouseVOffset);
    getIntDefault(MouseInertia);
    getIntDefault(Joystick1Type);
    getIntDefault(Joystick2Type);
    getIntDefault(Joystick3Type);
    getIntDefault(Joystick4Type);
    getIntDefault(Joystick1Num);
    getIntDefault(Joystick2Num);
    getIntDefault(Joystick3Num);
    getIntDefault(Joystick4Num);
    getArrayDefault(GamepadConfigArray);
    getStringDefault(GamepadConfigCurrent);
    getStringDefault(Gamepad1ConfigCurrent);
    getStringDefault(Gamepad2ConfigCurrent);
    getStringDefault(Gamepad3ConfigCurrent);
    getStringDefault(Gamepad4ConfigCurrent);
    getArrayDefault(ButtonAssignment);
    count = [[dict objectForKey:ButtonAssignment] count];
    if (count < 24) {
        for (i=count; i<24; i++)
            [[dict objectForKey:ButtonAssignment] addObject:[NSNumber numberWithInt:0]];
        }
    getArrayDefault(Button5200Assignment);
    count = [[dict objectForKey:Button5200Assignment] count];
    if (count < 24) {
        for (i=count; i<24; i++)
            [[dict objectForKey:Button5200Assignment] addObject:[NSNumber numberWithInt:0]];
        }
    getIntDefault(PaddlesXAxisOnly);
    getIntDefault(LeftJoyUp);
    getIntDefault(LeftJoyDown);
    getIntDefault(LeftJoyLeft);
    getIntDefault(LeftJoyRight);
    getIntDefault(LeftJoyUpLeft);
    getIntDefault(LeftJoyUpRight);
    getIntDefault(LeftJoyDownLeft);
    getIntDefault(LeftJoyDownRight);
    getIntDefault(LeftJoyFire);
    getIntDefault(LeftJoyAltFire);
    getIntDefault(PadJoyUp);
    getIntDefault(PadJoyDown);
    getIntDefault(PadJoyLeft);
    getIntDefault(PadJoyRight);
    getIntDefault(PadJoyUpLeft);
    getIntDefault(PadJoyUpRight);
    getIntDefault(PadJoyDownLeft);
    getIntDefault(PadJoyDownRight);
    getIntDefault(PadJoyFire);
    getIntDefault(PadJoyAltFire);

    return dict;
}

#define setBoolDefault(name) \
  {if ([[defaultValues() objectForKey:name] isEqual:[dict objectForKey:name]]) [defaults removeObjectForKey:name]; else [defaults setBool:[[dict objectForKey:name] boolValue] forKey:name];}

#define setIntDefault(name) \
  {if ([[defaultValues() objectForKey:name] isEqual:[dict objectForKey:name]]) [defaults removeObjectForKey:name]; else [defaults setInteger:[[dict objectForKey:name] intValue] forKey:name];}

#define setStringDefault(name) \
  {if ([[defaultValues() objectForKey:name] isEqual:[dict objectForKey:name]]) [defaults removeObjectForKey:name]; else [defaults setObject:[dict objectForKey:name] forKey:name];}

#define setArrayDefault(name) \
  {if ([[defaultValues() objectForKey:name] isEqual:[dict objectForKey:name]]) [defaults removeObjectForKey:name]; else [defaults setObject:[dict objectForKey:name] forKey:name];}

/* Save preferences to system defaults */
+ (void)savePreferencesToDefaults:(NSDictionary *)dict {
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    setBoolDefault(FullScreen);
    setBoolDefault(LockFullscreenSize);
    setBoolDefault(DoubleSize);
    setIntDefault(ScaleFactor);
    setIntDefault(WidthMode);
    setIntDefault(TvMode);
    setIntDefault(RefreshRatio);
    setIntDefault(ArtifactingMode);
    setStringDefault(PaletteFile);
    setBoolDefault(UseBuiltinPalette);
    setIntDefault(BlackLevel);
    setIntDefault(WhiteLevel);
    setIntDefault(Intensity);
    setIntDefault(ColorShift);
    setBoolDefault(AdjustPalette);
    setBoolDefault(ShowFPS);
    setIntDefault(AtariType);
    setBoolDefault(DisableBasic);
    setBoolDefault(EnableSioPatch);
    setBoolDefault(EnableHPatch);
    setBoolDefault(EnablePPatch);
    setBoolDefault(EnableRPatch);
    setIntDefault(RPatchPort);
    setStringDefault(PrintCommand);
    setBoolDefault(BootFromCassette);
    setBoolDefault(SpeedLimit);
    setBoolDefault(EnableSound);
    setBoolDefault(EnableHifiSound);
    setBoolDefault(EnableMultijoy);
    setBoolDefault(IgnoreHeaderWriteprotect);
    setStringDefault(HardDiskDir1);
    setStringDefault(HardDiskDir2);
    setStringDefault(HardDiskDir3);
    setStringDefault(HardDiskDir4);
    setBoolDefault(HardDrivesReadOnly);
    setStringDefault(HPath);
    setStringDefault(OsARomFile);
    setStringDefault(OsBRomFile);
    setStringDefault(XlRomFile);
    setStringDefault(BasicRomFile);
    setStringDefault(A5200RomFile);
    setStringDefault(DiskImageDir);
    setStringDefault(DiskSetDir);
    setStringDefault(CartImageDir);
    setStringDefault(CassImageDir);
    setStringDefault(ExeFileDir);
    setStringDefault(SavedStateDir);
    setStringDefault(D1File);
    setStringDefault(D2File);
    setStringDefault(D3File);
    setStringDefault(D4File);
    setStringDefault(D5File);
    setStringDefault(D6File);
    setStringDefault(D7File);
    setStringDefault(D8File);
    setStringDefault(CartFile);
    setStringDefault(ExeFile);
    setStringDefault(CassFile);
    setBoolDefault(D1FileEnabled);
    setBoolDefault(D2FileEnabled);
    setBoolDefault(D3FileEnabled);
    setBoolDefault(D4FileEnabled);
    setBoolDefault(D5FileEnabled);
    setBoolDefault(D6FileEnabled);
    setBoolDefault(D7FileEnabled);
    setBoolDefault(D8FileEnabled);
    setBoolDefault(CartFileEnabled);
    setBoolDefault(ExeFileEnabled);
    setBoolDefault(CassFileEnabled);
    setIntDefault(Joystick1Mode);
    setIntDefault(Joystick2Mode);
    setIntDefault(Joystick3Mode);
    setIntDefault(Joystick4Mode);
    setIntDefault(Joystick1Autofire);
    setIntDefault(Joystick2Autofire);
    setIntDefault(Joystick3Autofire);
    setIntDefault(Joystick4Autofire);
    setIntDefault(MouseDevice);
    setIntDefault(MouseSpeed);
    setIntDefault(MouseMinVal);
    setIntDefault(MouseMaxVal);
    setIntDefault(MouseHOffset);
    setIntDefault(MouseVOffset);
    setIntDefault(MouseInertia);
    setIntDefault(Joystick1Type);
    setIntDefault(Joystick2Type);
    setIntDefault(Joystick3Type);
    setIntDefault(Joystick4Type);
    setIntDefault(Joystick1Num);
    setIntDefault(Joystick2Num);
    setIntDefault(Joystick3Num);
    setIntDefault(Joystick4Num);
    setArrayDefault(GamepadConfigArray);
    setStringDefault(GamepadConfigCurrent);
    setStringDefault(Gamepad1ConfigCurrent);
    setStringDefault(Gamepad2ConfigCurrent);
    setStringDefault(Gamepad3ConfigCurrent);
    setStringDefault(Gamepad4ConfigCurrent);
    setArrayDefault(ButtonAssignment);
    setArrayDefault(Button5200Assignment);
    setIntDefault(PaddlesXAxisOnly);
    setIntDefault(LeftJoyUp);
    setIntDefault(LeftJoyDown);
    setIntDefault(LeftJoyLeft);
    setIntDefault(LeftJoyRight);
    setIntDefault(LeftJoyUpLeft);
    setIntDefault(LeftJoyUpRight);
    setIntDefault(LeftJoyDownLeft);
    setIntDefault(LeftJoyDownRight);
    setIntDefault(LeftJoyFire);
    setIntDefault(LeftJoyAltFire);
    setIntDefault(PadJoyUp);
    setIntDefault(PadJoyDown);
    setIntDefault(PadJoyLeft);
    setIntDefault(PadJoyRight);
    setIntDefault(PadJoyUpLeft);
    setIntDefault(PadJoyUpRight);
    setIntDefault(PadJoyDownLeft);
    setIntDefault(PadJoyDownRight);
    setIntDefault(PadJoyFire);
    setIntDefault(PadJoyAltFire);

    [defaults synchronize];
}

/**** Window delegation ****/

// We do this to catch the case where the user enters a value into one of the text fields but closes the window without hitting enter or tab.

- (void)windowWillClose:(NSNotification *)notification {
    NSWindow *window = [notification object];
    (void)[window makeFirstResponder:window];
}

/*------------------------------------------------------------------------------
*  releaseCmdKeys - This method fixes an issue when modal windows are used with
*     the Mac OSX version of the SDL library.
*     As the SDL normally captures all keystrokes, but we need to type in some 
*     Mac windows, all of the control menu windows run in modal mode.  However, 
*     when this happens, the release of the command key and the shortcut key 
*     are not sent to SDL.  We have to manually cause these events to happen 
*     to keep the SDL library in a sane state, otherwise only everyother shortcut
*     keypress will work.
*-----------------------------------------------------------------------------*/
- (void) releaseCmdKeys:(NSString *)character:(int)keyCode
{
    NSEvent *event1, *event2;
    NSPoint point;
    
    event1 = [NSEvent keyEventWithType:NSKeyUp location:point modifierFlags:0
                    timestamp:nil windowNumber:0 context:nil characters:character
                    charactersIgnoringModifiers:character isARepeat:NO keyCode:keyCode];
    [NSApp postEvent:event1 atStart:NO];
    
    event2 = [NSEvent keyEventWithType:NSFlagsChanged location:point modifierFlags:0
                    timestamp:nil windowNumber:0 context:nil characters:nil
                    charactersIgnoringModifiers:nil isARepeat:NO keyCode:0];
    [NSApp postEvent:event2 atStart:NO];
}


@end
