// Generated by gmmproc 2.85.0 -- DO NOT MODIFY!
#ifndef _GTKMM_TREEPATH_H
#define _GTKMM_TREEPATH_H

#include <gtkmmconfig.h>

#ifndef GTKMM_DISABLE_DEPRECATED


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <https://www.gnu.org/licenses/>.
 */

// This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <gtkmm/treemodel.h>
#include <gdkmm/contentprovider.h>

#ifdef GLIBMM_HAVE_SUN_REVERSE_ITERATOR
#include <cstddef> /* for std::ptrdiff_t */
#endif

 
 // The entire file is deprecated.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GtkTreePath GtkTreePath; }
#endif

namespace Gtk
{

/** A path is essentially a potential node. It is a location on a model that may
 * or may not actually correspond to a node on a specific model.
 *
 * A Path can be converted into either an array of unsigned integers or a string. The string
 * form is a list of numbers separated by a colon. Each number refers to the
 * offset at that level. Thus, the path "0" refers to the root node and the
 * path "2:4" refers to the fifth child of the third node.
 *
 * Typedefed as Gtk::TreeModel::Path.
 * @ingroup TreeView
 * @deprecated 4.10: Use Gio::ListModel instead.
 */
class GTKMM_API TreePath
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = TreePath;
  using BaseObjectType = GtkTreePath;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;

  TreePath();


  TreePath(const TreePath& other);
  TreePath& operator=(const TreePath& other);

  TreePath(TreePath&& other) noexcept;
  TreePath& operator=(TreePath&& other) noexcept;

  ~TreePath() noexcept;

  void swap(TreePath& other) noexcept;

  ///Provides access to the underlying C instance.
  GtkTreePath*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GtkTreePath* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GtkTreePath* gobj_copy() const;

protected:
  GtkTreePath* gobject_;

private:

  
public:
  typedef unsigned int  size_type;
  typedef int           difference_type;

  typedef int           value_type;
  typedef int&          reference;
  typedef const int&    const_reference;

  // Use plain pointers for simplicity.
  typedef int*          iterator;
  typedef const int*    const_iterator;

#ifndef GLIBMM_HAVE_SUN_REVERSE_ITERATOR

  typedef std::reverse_iterator<iterator>       reverse_iterator;
  typedef std::reverse_iterator<const_iterator> const_reverse_iterator;

#else

  typedef std::reverse_iterator<iterator, std::random_access_iterator_tag,
                                int, int&, int*, std::ptrdiff_t> reverse_iterator;

  typedef std::reverse_iterator<const_iterator, std::random_access_iterator_tag,
                                int, const int&, const int*, std::ptrdiff_t> const_reverse_iterator;

#endif /* GLIBMM_HAVE_SUN_REVERSE_ITERATOR */

  
  explicit TreePath(GtkTreePath* gobject, bool make_a_copy = true);
  explicit TreePath(size_type n, value_type value = 0);
  explicit TreePath(const Glib::ustring& path);
  explicit TreePath(const TreeModel::iterator& iter);
  /// @newin{4,14}
  explicit TreePath(const TreeModel::const_iterator& iter);

  template <class In> inline TreePath(In pbegin, In pend);

  void clear();

  // I think it's OK for this assignment to be implicit.  It's very useful.
  TreePath& operator=(const TreeModel::iterator& iter);
  /// @newin{4,14}
  TreePath& operator=(const TreeModel::const_iterator& iter);

  /** Checks that the path is not empty, by calling empty().
   * For instance,
   * @code
   * if(treepath)
   *   do_something()
   * @endcode
   *
   * @newin{3,22}
   */
  explicit operator bool() const;

  template <class In> inline void assign(In pbegin, In pend);
  template <class In>        void append(In pbegin, In pend);

  
  /** Appends a new index to a path.
   * 
   * As a result, the depth of the path is increased.
   * 
   * Deprecated: 4.10
   * 
   * @param index The index.
   */
  void push_back(int index);
  
  /** Prepends a new index to a path.
   * 
   * As a result, the depth of the path is increased.
   * 
   * Deprecated: 4.10
   * 
   * @param index The index.
   */
  void push_front(int index);

  size_type size() const;
  bool empty() const;

  reference       operator[](size_type i);
  const_reference operator[](size_type i) const;

  
  iterator begin();
  iterator end();
  const_iterator begin() const;
  const_iterator end()   const;

  // Note: there is no advantage in not inlining these methods.
  // We can't change them without breaking ABI anyway.
  reverse_iterator       rbegin()       { return reverse_iterator(end());         }
  reverse_iterator       rend()         { return reverse_iterator(begin());       }
  const_reverse_iterator rbegin() const { return const_reverse_iterator(end());   }
  const_reverse_iterator rend()   const { return const_reverse_iterator(begin()); }

  reference       front()       { return *begin();  }
  const_reference front() const { return *begin();  }
  reference       back()        { return *rbegin(); }
  const_reference back()  const { return *rbegin(); }

  
  /** Moves the @a path to point to the next node at the current depth.
   * 
   * Deprecated: 4.10
   */
  void next();
  
  /** Moves the @a path to point to the previous node at the
   * current depth, if it exists.
   * 
   * Deprecated: 4.10
   * 
   * @return <tt>true</tt> if @a path has a previous node, and
   * the move was made.
   */
  bool prev();
  
  /** Moves the @a path to point to its parent node, if it has a parent.
   * 
   * Deprecated: 4.10
   * 
   * @return <tt>true</tt> if @a path has a parent, and the move was made.
   */
  bool up();
  
  /** Moves @a path to point to the first child of the current path.
   * 
   * Deprecated: 4.10
   */
  void down();

  
  /** Returns <tt>true</tt> if @a descendant is a descendant of @a path.
   * 
   * Deprecated: 4.10
   * 
   * @param descendant Another `Gtk::TreePath`.
   * @return <tt>true</tt> if @a descendant is contained inside @a path.
   */
  bool is_ancestor(const TreePath& descendant) const;
  
  /** Returns <tt>true</tt> if @a path is a descendant of @a ancestor.
   * 
   * Deprecated: 4.10
   * 
   * @param ancestor Another `Gtk::TreePath`.
   * @return <tt>true</tt> if @a ancestor contains @a path somewhere below it.
   */
  bool is_descendant(const TreePath& ancestor) const;

  
  /** Generates a string representation of the path.
   * 
   * This string is a “:” separated list of numbers.
   * For example, “4:10:0:3” would be an acceptable
   * return value for this string. If the path has
   * depth 0, <tt>nullptr</tt> is returned.
   * 
   * Deprecated: 4.10
   * 
   * @return The string.
   */
  Glib::ustring to_string() const;


   //replaced by push_back()
   //replaced by push_front()
   //replaced by size()
  

  /** Obtains a Gtk::TreeModel and Gtk::TreeModel::Path from @a value of target type
   * GTK_TYPE_TREE_ROW_DATA.
   *
   * @param value A Glib::ValueBase
   * @param[out] model A Gtk::TreeModel
   * @param[out] path A row in @a model
   * @return <tt>true</tt> if the @a value had target type GTK_TYPE_TREE_ROW_DATA
   *         and is otherwise valid.
   */
  static bool get_row_drag_data(const Glib::ValueBase& value, Glib::RefPtr<const TreeModel>& model, TreePath& path);

  /// See description in the other overload.
  static bool get_row_drag_data(const Glib::ValueBase& value, TreePath& path);

  /** Creates a content provider for dragging the path from @a model.
   *
   * @param model A Gtk::TreeModel.
   * @return A Gdk::ContentProvider.
   */
  Glib::RefPtr<Gdk::ContentProvider> create_row_drag_content(const Glib::RefPtr<const TreeModel>& model) const;

private:
  /// @newin{4,14}
  TreePath(const GtkTreeModel* model, const GtkTreeIter* iter);


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class In>
void TreePath::append(In pbegin, In pend)
{
  // push_back() can't throw -- if it could, this code wouldn't be strongly exception-safe.
  for(; pbegin != pend; ++pbegin)
    this->push_back(*pbegin);
}

template <class In> inline
TreePath::TreePath(In pbegin, In pend)
{
  this->append(pbegin, pend);
}

template <class In> inline
void TreePath::assign(In pbegin, In pend)
{
  TreePath temp (pbegin, pend);
  this->swap(temp);
}

struct TreePathTraits
{
  typedef TreePath            CppType;
  typedef const GtkTreePath*  CType;
  typedef GtkTreePath*        CTypeNonConst;

  static CType to_c_type(const CppType& item)
    { return item.gobj(); }

  static CType to_c_type(CType item)
    { return item; }

  static CppType to_cpp_type(CType item)
    { return CppType(const_cast<CTypeNonConst>(item)); }

  G_GNUC_BEGIN_IGNORE_DEPRECATIONS
  static void release_c_type(CType item)
    { gtk_tree_path_free(const_cast<CTypeNonConst>(item)); }
  G_GNUC_END_IGNORE_DEPRECATIONS
};

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Gtk
{

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator==(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator!=(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator<(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator>(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator<=(const TreePath& lhs, const TreePath& rhs);

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
GTKMM_API
bool operator>=(const TreePath& lhs, const TreePath& rhs);


} // namespace Gtk


namespace Gtk
{

/** @relates Gtk::TreePath
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(TreePath& lhs, TreePath& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Gtk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gtk::TreePath
 */
GTKMM_API
Gtk::TreePath wrap(GtkTreePath* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class GTKMM_API Value<Gtk::TreePath> : public Glib::Value_Boxed<Gtk::TreePath>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif // GTKMM_DISABLE_DEPRECATED


#endif /* _GTKMM_TREEPATH_H */

