/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.text.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantJSONQuery
extends VariantAbstractRPCQuery {
    public static final String JSON_RPC_CONTENT_TYPE = "application/json";
    public static final int NAME_SEPARATOR = 58;
    public static final int VALUE_SEPARATOR = 44;
    public static final int BEGIN_ARRAY = 91;
    public static final int QUOTATION_MARK = 34;
    public static final int BEGIN_OBJECT = 123;
    public static final int END_OBJECT = 125;
    public static final int END_ARRAY = 93;
    public static final int BACKSLASH = 92;
    private SimpleStringReader sr;
    private boolean scanNullValues;
    private static final String SHORT_NAME = "json";
    private static final int STATE_READ_START_OBJECT = 0;
    private static final int STATE_READ_FIELD = 1;
    private static final int STATE_READ_VALUE = 2;
    private static final int STATE_READ_POST_VALUE = 3;

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public VariantJSONQuery() {
        super(37);
    }

    public void setScanNullValues(boolean scan) {
        this.scanNullValues = scan;
    }

    public boolean isScanNullValues() {
        return this.scanNullValues;
    }

    @Override
    public boolean isValidContentType(String contentType) {
        return contentType.startsWith(JSON_RPC_CONTENT_TYPE);
    }

    @Override
    public void parseContent(String content) {
        if (content.isEmpty()) {
            return;
        }
        this.sr = new SimpleStringReader(content);
        this.parseObject();
    }

    @Override
    public String getEscapedValue(String value, boolean toQuote) {
        String result = StringEscapeUtils.escapeJava((String)value);
        return toQuote ? "\"" + result + "\"" : result;
    }

    @Override
    public String getUnescapedValue(String value) {
        return StringEscapeUtils.unescapeJava((String)value);
    }

    private void parseObject() {
        int state = 0;
        boolean objectRead = false;
        boolean done = false;
        String field = null;
        while (!done) {
            switch (state) {
                case 0: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == 123) {
                        objectRead = true;
                        chr = this.sr.skipWhitespaceRead();
                        if (chr == 125) {
                            return;
                        }
                        this.sr.unreadLastCharacter();
                        state = 1;
                        break;
                    }
                    if (chr == 91) {
                        this.sr.unreadLastCharacter();
                        state = 2;
                        break;
                    }
                    throw new IllegalArgumentException("Input is invalid JSON; does not start with '{' or '[', c=" + chr);
                }
                case 1: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == 34) {
                        int beginToken = this.sr.getPosition();
                        this.readEscapedString();
                        int endToken = this.sr.getPosition() - 1;
                        field = this.getToken(beginToken, endToken);
                        chr = this.sr.skipWhitespaceRead();
                        if (chr != 58) {
                            throw new IllegalArgumentException("Expected ':' between string field and value at position " + this.sr.getPosition());
                        }
                        this.sr.skipWhitespaceRead();
                        this.sr.unreadLastCharacter();
                        state = 2;
                        break;
                    }
                    throw new IllegalArgumentException("Expected quote at position " + this.sr.getPosition());
                }
                case 2: {
                    if (field == null) {
                        field = "@items";
                    }
                    this.parseValue(field);
                    state = 3;
                    break;
                }
                case 3: {
                    int chr = this.sr.skipWhitespaceRead();
                    if (chr == -1 && objectRead) {
                        throw new IllegalArgumentException("EOF reached before closing '}'");
                    }
                    if (chr == 125 || chr == -1) {
                        done = true;
                        break;
                    }
                    if (chr == 44) {
                        state = 1;
                        break;
                    }
                    throw new IllegalArgumentException("Object not ended with '}' or ']' at position " + this.sr.getPosition());
                }
            }
        }
    }

    private void parseValue(String fieldName) {
        int chr = this.sr.read();
        if (chr == 34) {
            int beginToken = this.sr.getPosition();
            this.readEscapedString();
            this.addParameter(fieldName, beginToken, this.sr.getPosition() - 1, false, true);
        } else if (Character.isDigit(chr) || chr == 45) {
            this.sr.unreadLastCharacter();
            int beginToken = this.sr.getPosition();
            do {
                if ((chr = this.sr.read()) != -1) continue;
                throw new IllegalArgumentException("Reached EOF while reading number");
            } while (Character.isDigit(chr) || chr == 46 || chr == 101 || chr == 69 || chr == 43 || chr == 45);
            this.sr.unreadLastCharacter();
            this.addParameter(fieldName, beginToken, this.sr.getPosition(), true, false);
        } else if (chr == 123) {
            this.sr.unreadLastCharacter();
            this.parseObject();
        } else if (chr == 91) {
            this.parseArray(fieldName);
        } else if (chr == 93) {
            this.sr.unreadLastCharacter();
        } else if (chr == 116 || chr == 84) {
            this.sr.unreadLastCharacter();
            this.parseToken("true");
        } else if (chr == 102 || chr == 70) {
            this.sr.unreadLastCharacter();
            this.parseToken("false");
        } else if (chr == 110 || chr == 78) {
            this.sr.unreadLastCharacter();
            if (this.scanNullValues) {
                int start = this.sr.getPosition();
                this.addParameter(fieldName, start, start + 4, true, null);
            }
            this.parseToken("null");
        } else {
            if (chr == -1) {
                throw new IllegalArgumentException("EOF reached prematurely");
            }
            throw new IllegalArgumentException("Unknown value type '" + chr + "' for field '" + fieldName + "' at position " + this.sr.getPosition());
        }
    }

    private void parseArray(String fieldName) {
        block1: {
            int chr;
            int idx = 0;
            do {
                this.sr.skipWhitespaceRead();
                this.sr.unreadLastCharacter();
                this.parseValue(fieldName + "[" + idx++ + "]");
                chr = this.sr.skipWhitespaceRead();
                if (chr == 93) break block1;
            } while (chr == 44);
            throw new IllegalArgumentException("Expected ',' or ']' inside array at position " + this.sr.getPosition());
        }
    }

    private void parseToken(String token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            int chr = this.sr.read();
            if (chr == -1) {
                throw new IllegalArgumentException("EOF reached while reading token: " + token);
            }
            chr = Character.toLowerCase((char)chr);
            char loTokenChar = token.charAt(i);
            if (loTokenChar == chr) continue;
            throw new IllegalArgumentException("Expected token: " + token + " at position " + this.sr.getPosition());
        }
    }

    private void readEscapedString() {
        block2: {
            int chr;
            do {
                if ((chr = this.sr.read()) == 92) {
                    chr = this.sr.read();
                    continue;
                }
                if (chr == 34) break block2;
            } while (chr != -1);
            throw new IllegalArgumentException("EOF reached while reading JSON field name");
        }
    }

    protected class SimpleStringReader {
        private static final String WS = " \t\r\n";
        private String str;
        private int length;
        private int next = 0;

        public SimpleStringReader(String s) {
            this.str = s;
            this.length = s.length();
        }

        public int skipWhitespaceRead() {
            int c = this.read();
            while (WS.indexOf(c) != -1) {
                c = this.read();
            }
            return c;
        }

        public int read() {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        public void unreadLastCharacter() {
            --this.next;
        }

        public int getPosition() {
            return this.next;
        }
    }
}

