/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.GzipDecompressingEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.reactive.ReactiveResponseConsumer;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.opensearch.client.Cancellable;
import org.opensearch.client.DeadHostState;
import org.opensearch.client.Node;
import org.opensearch.client.NodeSelector;
import org.opensearch.client.Request;
import org.opensearch.client.RequestLogger;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.ResponseListener;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.StreamingRequest;
import org.opensearch.client.StreamingResponse;
import org.opensearch.client.WarningFailureException;
import org.opensearch.client.WarningsHandler;
import org.opensearch.client.http.HttpUriRequestProducer;
import org.opensearch.client.http.ReactiveHttpUriRequestProducer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class RestClient
implements Closeable {
    private static final Log logger = LogFactory.getLog(RestClient.class);
    private final CloseableHttpAsyncClient client;
    final List<Header> defaultHeaders;
    private final String pathPrefix;
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private final ConcurrentMap<HttpHost, DeadHostState> denylist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final FailureListener failureListener;
    private final NodeSelector nodeSelector;
    private volatile NodeTuple<List<Node>> nodeTuple;
    private final WarningsHandler warningsHandler;
    private final boolean compressionEnabled;
    private final Optional<Boolean> chunkedEnabled;

    RestClient(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled, boolean chunkedEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.chunkedEnabled = Optional.of(chunkedEnabled);
        this.setNodes(nodes);
    }

    RestClient(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.chunkedEnabled = Optional.empty();
        this.setNodes(nodes);
    }

    public static RestClientBuilder builder(String cloudId) {
        int port;
        String decoded;
        String[] decodedParts;
        if (cloudId.contains(":")) {
            if (cloudId.indexOf(":") == cloudId.length() - 1) {
                throw new IllegalStateException("cloudId " + cloudId + " must begin with a human readable identifier followed by a colon");
            }
            cloudId = cloudId.substring(cloudId.indexOf(":") + 1);
        }
        if ((decodedParts = (decoded = new String(Base64.getDecoder().decode(cloudId), StandardCharsets.UTF_8)).split("\\$")).length != 3) {
            throw new IllegalStateException("cloudId " + cloudId + " did not decode to a cluster identifier correctly");
        }
        String[] domainAndMaybePort = decodedParts[0].split(":", 2);
        String domain = domainAndMaybePort[0];
        if (domainAndMaybePort.length == 2) {
            try {
                port = Integer.parseInt(domainAndMaybePort[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("cloudId " + cloudId + " does not contain a valid port number");
            }
        } else {
            port = 443;
        }
        String url = decodedParts[1] + "." + domain;
        return RestClient.builder(new HttpHost("https", url, port));
    }

    public static RestClientBuilder builder(Node ... nodes) {
        return new RestClientBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static RestClientBuilder builder(HttpHost ... hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        List<Node> nodes = Arrays.stream(hosts).map(Node::new).collect(Collectors.toList());
        return new RestClientBuilder(nodes);
    }

    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), (AuthScheme)new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), (AuthCache)authCache);
        this.denylist.clear();
    }

    public List<Node> getNodes() {
        return (List)this.nodeTuple.nodes;
    }

    public boolean isRunning() {
        return this.client.getStatus() == IOReactorStatus.ACTIVE;
    }

    public StreamingResponse<ByteBuffer> streamRequest(StreamingRequest<ByteBuffer> request) throws IOException {
        InternalStreamingRequest internalRequest = new InternalStreamingRequest(request);
        StreamingResponse<ByteBuffer> response = new StreamingResponse<ByteBuffer>(new RequestLine((HttpRequest)internalRequest.httpRequest), this.streamRequest(this.nextNodes(), internalRequest));
        return response;
    }

    public Response performRequest(Request request) throws IOException {
        InternalRequest internalRequest = new InternalRequest(request);
        return this.performRequest(this.nextNodes(), internalRequest, null);
    }

    private Response performRequest(NodeTuple<Iterator<Node>> nodeTuple, InternalRequest request, Exception previousException) throws IOException {
        ClassicHttpResponse httpResponse;
        RequestContext<ClassicHttpResponse> context = request.createContextForNextAttempt((Node)((Iterator)nodeTuple.nodes).next(), nodeTuple.authCache);
        try {
            httpResponse = (ClassicHttpResponse)this.client.execute(context.requestProducer(), context.asyncResponseConsumer(), (HttpContext)context.context(), null).get();
        }
        catch (Exception e) {
            RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node(), e);
            this.onFailure(context.node());
            Exception cause = RestClient.extractAndWrapCause(e);
            RestClient.addSuppressedException(previousException, cause);
            if (((Iterator)nodeTuple.nodes).hasNext()) {
                return this.performRequest(nodeTuple, request, cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
        }
        ResponseOrResponseException responseOrResponseException = this.convertResponse(request, context.node(), httpResponse);
        if (responseOrResponseException.responseException == null) {
            return responseOrResponseException.response;
        }
        RestClient.addSuppressedException(previousException, responseOrResponseException.responseException);
        if (((Iterator)nodeTuple.nodes).hasNext()) {
            return this.performRequest(nodeTuple, request, responseOrResponseException.responseException);
        }
        throw responseOrResponseException.responseException;
    }

    private Publisher<Message<HttpResponse, Publisher<ByteBuffer>>> streamRequest(NodeTuple<Iterator<Node>> nodeTuple, InternalStreamingRequest request) throws IOException {
        return (Publisher)request.cancellable.callIfNotCancelled(() -> {
            Node node = (Node)((Iterator)nodeTuple.nodes).next();
            Mono publisher = Mono.create(emitter -> {
                RequestContext<Void> context = request.createContextForNextAttempt(node, nodeTuple.authCache, (MonoSink<Message<HttpResponse, Publisher<ByteBuffer>>>)emitter);
                Future future = this.client.execute(context.requestProducer(), context.asyncResponseConsumer(), (HttpContext)context.context(), null);
                if (future instanceof org.apache.hc.core5.concurrent.Cancellable) {
                    request.httpRequest.setDependency((org.apache.hc.core5.concurrent.Cancellable)future);
                }
            });
            return publisher.flatMap(message -> {
                try {
                    ResponseOrResponseException responseOrResponseException = this.convertResponse(request, node, (Message<HttpResponse, Publisher<ByteBuffer>>)message);
                    if (responseOrResponseException.responseException == null) {
                        return Mono.just((Object)new Message((MessageHeaders)((HttpResponse)message.getHead()), (Object)Flux.from((Publisher)((Publisher)message.getBody())).flatMapSequential(b -> Flux.fromIterable(RestClient.frame(b)))));
                    }
                    if (((Iterator)nodeTuple.nodes).hasNext()) {
                        return Mono.from(this.streamRequest(nodeTuple, request));
                    }
                    return Mono.error((Throwable)responseOrResponseException.responseException);
                }
                catch (Exception ex) {
                    return Mono.error((Throwable)ex);
                }
            });
        });
    }

    private static Collection<ByteBuffer> frame(ByteBuffer b) {
        byte[] chunk;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int position = b.position();
        while (b.hasRemaining()) {
            if (b.get() != 13 || !b.hasRemaining() || b.position() <= 1 || b.get() != 10) continue;
            chunk = new byte[b.position() - position];
            b.position(position);
            b.get(chunk);
            buffers.add(ByteBuffer.wrap(chunk, 0, chunk.length - 2));
            position = b.position();
        }
        if (buffers.isEmpty()) {
            return Collections.singleton(b);
        }
        if (position != b.position()) {
            chunk = new byte[b.position() - position];
            b.position(position);
            b.get(chunk);
            buffers.add(ByteBuffer.wrap(chunk, 0, chunk.length));
        }
        return buffers;
    }

    private ResponseOrResponseException convertResponse(InternalRequest request, Node node, ClassicHttpResponse httpResponse) throws IOException {
        RequestLogger.logResponse(logger, (HttpUriRequest)request.httpRequest, node.getHost(), httpResponse);
        int statusCode = httpResponse.getCode();
        Optional.ofNullable(httpResponse.getEntity()).map(EntityDetails::getContentEncoding).filter("gzip"::equalsIgnoreCase).map(gzipHeaderValue -> new GzipDecompressingEntity(httpResponse.getEntity())).ifPresent(arg_0 -> ((ClassicHttpResponse)httpResponse).setEntity(arg_0));
        Response response = new Response(new RequestLine((HttpRequest)request.httpRequest), node.getHost(), httpResponse);
        if (RestClient.isSuccessfulResponse(statusCode) || request.ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
            this.onResponse(node);
            if (request.warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (RestClient.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    private ResponseOrResponseException convertResponse(InternalStreamingRequest request, Node node, Message<HttpResponse, Publisher<ByteBuffer>> message) throws IOException {
        BasicClassicHttpResponse httpResponse = new BasicClassicHttpResponse(((HttpResponse)message.getHead()).getCode(), ((HttpResponse)message.getHead()).getReasonPhrase());
        Response response = new Response(new RequestLine((HttpRequest)request.httpRequest), node.getHost(), (ClassicHttpResponse)httpResponse);
        RequestLogger.logResponse(logger, (HttpUriRequest)request.httpRequest, node.getHost(), (ClassicHttpResponse)httpResponse);
        int statusCode = httpResponse.getCode();
        if (RestClient.isSuccessfulResponse(statusCode) || request.ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
            this.onResponse(node);
            if (request.warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (RestClient.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    public Cancellable performRequestAsync(Request request, ResponseListener responseListener) {
        try {
            FailureTrackingResponseListener failureTrackingResponseListener = new FailureTrackingResponseListener(responseListener);
            InternalRequest internalRequest = new InternalRequest(request);
            this.performRequestAsync(this.nextNodes(), internalRequest, failureTrackingResponseListener);
            return internalRequest.cancellable;
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return Cancellable.NO_OP;
        }
    }

    private void performRequestAsync(final NodeTuple<Iterator<Node>> nodeTuple, final InternalRequest request, final FailureTrackingResponseListener listener) {
        request.cancellable.runIfNotCancelled(() -> {
            final RequestContext<ClassicHttpResponse> context = request.createContextForNextAttempt((Node)((Iterator)nodeTuple.nodes).next(), nodeTuple.authCache);
            Future future = this.client.execute(context.requestProducer(), context.asyncResponseConsumer(), (HttpContext)context.context(), (FutureCallback)new FutureCallback<ClassicHttpResponse>(){
                final /* synthetic */ RestClient this$0;
                {
                    this.this$0 = this$0;
                }

                public void completed(ClassicHttpResponse httpResponse) {
                    try {
                        ResponseOrResponseException responseOrResponseException = this.this$0.convertResponse(request, context.node(), httpResponse);
                        if (responseOrResponseException.responseException == null) {
                            listener.onSuccess(responseOrResponseException.response);
                        } else if (((Iterator)nodeTuple.nodes).hasNext()) {
                            listener.trackFailure(responseOrResponseException.responseException);
                            this.this$0.performRequestAsync(nodeTuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(responseOrResponseException.responseException);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void failed(Exception failure) {
                    try {
                        RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node(), failure);
                        this.this$0.onFailure(context.node());
                        if (((Iterator)nodeTuple.nodes).hasNext()) {
                            listener.trackFailure(failure);
                            this.this$0.performRequestAsync(nodeTuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(failure);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void cancelled() {
                    listener.onDefinitiveFailure(Cancellable.newCancellationException());
                }
            });
            if (future instanceof org.apache.hc.core5.concurrent.Cancellable) {
                request.httpRequest.setDependency((org.apache.hc.core5.concurrent.Cancellable)future);
            }
        });
    }

    private NodeTuple<Iterator<Node>> nextNodes() throws IOException {
        NodeTuple<List<Node>> nodeTuple = this.nodeTuple;
        Iterable<Node> hosts = RestClient.selectNodes(nodeTuple, this.denylist, this.lastNodeIndex, this.nodeSelector);
        return new NodeTuple<Iterator<Node>>(hosts.iterator(), nodeTuple.authCache);
    }

    static Iterable<Node> selectNodes(NodeTuple<List<Node>> nodeTuple, Map<HttpHost, DeadHostState> denylist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(Math.max(0, ((List)nodeTuple.nodes).size() - denylist.size()));
        ArrayList<DeadNode> deadNodes = new ArrayList<DeadNode>(denylist.size());
        for (Node node : (List)nodeTuple.nodes) {
            DeadHostState deadness = denylist.get(node.getHost());
            if (deadness == null || deadness.shallBeRetried()) {
                livingNodes.add(node);
                continue;
            }
            deadNodes.add(new DeadNode(node, deadness));
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (!deadNodes.isEmpty()) {
            ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(() -> new DeadNodeIteratorAdapter(selectedDeadNodes.iterator()));
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + nodeSelector + "] rejected all nodes, living " + livingNodes + " and dead " + deadNodes);
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.denylist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug((Object)("removed [" + node + "] from denylist"));
        }
    }

    private void onFailure(Node node) {
        block3: {
            DeadHostState previousDeadHostState;
            do {
                if ((previousDeadHostState = this.denylist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.DEFAULT_TIME_SUPPLIER))) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("added [" + node + "] to denylist"));
                }
                break block3;
            } while (!this.denylist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updated [" + node + "] already in denylist"));
            }
        }
        this.failureListener.onFailure(node);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static boolean isSuccessfulResponse(int statusCode) {
        return statusCode < 300;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static void addSuppressedException(Exception suppressedException, Exception currentException) {
        if (suppressedException != null) {
            currentException.addSuppressed(suppressedException);
        }
    }

    private HttpUriRequestBase createHttpRequest(String method, URI uri, HttpEntity entity) {
        switch (method.toUpperCase(Locale.ROOT)) {
            case "DELETE": {
                return this.addRequestBody((HttpUriRequestBase)new HttpDelete(uri), entity);
            }
            case "GET": {
                return this.addRequestBody((HttpUriRequestBase)new HttpGet(uri), entity);
            }
            case "HEAD": {
                return this.addRequestBody((HttpUriRequestBase)new HttpHead(uri), entity);
            }
            case "OPTIONS": {
                return this.addRequestBody((HttpUriRequestBase)new HttpOptions(uri), entity);
            }
            case "PATCH": {
                return this.addRequestBody((HttpUriRequestBase)new HttpPatch(uri), entity);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                this.addRequestBody((HttpUriRequestBase)httpPost, entity);
                return httpPost;
            }
            case "PUT": {
                return this.addRequestBody((HttpUriRequestBase)new HttpPut(uri), entity);
            }
            case "TRACE": {
                return this.addRequestBody((HttpUriRequestBase)new HttpTrace(uri), entity);
            }
        }
        throw new UnsupportedOperationException("http method not supported: " + method);
    }

    private HttpUriRequestBase addRequestBody(HttpUriRequestBase httpRequest, HttpEntity entity) {
        if (entity != null) {
            if (this.compressionEnabled) {
                entity = this.chunkedEnabled.isPresent() ? new ContentCompressingEntity((HttpEntity)entity, this.chunkedEnabled.get()) : new ContentCompressingEntity((HttpEntity)entity);
            } else if (this.chunkedEnabled.isPresent()) {
                entity = new ContentHttpEntity((HttpEntity)entity, this.chunkedEnabled.get());
            }
            httpRequest.setEntity(entity);
        }
        return httpRequest;
    }

    static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            String fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder(fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return new URI(uriBuilder.build().toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Set<Integer> getIgnoreErrorCodes(String ignoreString, String requestMethod) {
        Set<Integer> ignoreErrorCodes;
        if (ignoreString == null) {
            ignoreErrorCodes = "HEAD".equals(requestMethod) ? Collections.singleton(404) : Collections.emptySet();
        } else {
            String[] ignoresArray = ignoreString.split(",");
            ignoreErrorCodes = new HashSet();
            if ("HEAD".equals(requestMethod)) {
                ignoreErrorCodes.add(404);
            }
            for (String ignoreCode : ignoresArray) {
                try {
                    ignoreErrorCodes.add(Integer.valueOf(ignoreCode));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead", e);
                }
            }
        }
        return ignoreErrorCodes;
    }

    private static Exception extractAndWrapCause(Exception exception) {
        Object e;
        if (exception instanceof InterruptedException) {
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof ConnectTimeoutException) {
            e = new ConnectTimeoutException(exception.getMessage());
            e.initCause((Throwable)exception);
            return e;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectionClosedException) {
            e = new ConnectionClosedException(exception.getMessage());
            e.initCause((Throwable)exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage() + "\nSee https://opensearch.org/docs/latest/clients/java-rest-high-level/ for troubleshooting.");
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }

    static class NodeTuple<T> {
        final T nodes;
        final AuthCache authCache;

        NodeTuple(T nodes, AuthCache authCache) {
            this.nodes = nodes;
            this.authCache = authCache;
        }
    }

    private class InternalRequest {
        private final Request request;
        private final Set<Integer> ignoreErrorCodes;
        private final HttpUriRequestBase httpRequest;
        private final Cancellable cancellable;
        private final WarningsHandler warningsHandler;

        InternalRequest(Request request) {
            this.request = request;
            HashMap<String, String> params = new HashMap<String, String>(request.getParameters());
            String ignoreString = (String)params.remove("ignore");
            this.ignoreErrorCodes = RestClient.getIgnoreErrorCodes(ignoreString, request.getMethod());
            URI uri = RestClient.buildUri(RestClient.this.pathPrefix, request.getEndpoint(), params);
            this.httpRequest = RestClient.this.createHttpRequest(request.getMethod(), uri, request.getEntity());
            this.cancellable = Cancellable.fromRequest((CancellableDependency)this.httpRequest);
            this.setHeaders((HttpRequest)this.httpRequest, request.getOptions().getHeaders());
            this.setRequestConfig(this.httpRequest, request.getOptions().getRequestConfig());
            this.warningsHandler = request.getOptions().getWarningsHandler() == null ? RestClient.this.warningsHandler : request.getOptions().getWarningsHandler();
        }

        private void setHeaders(HttpRequest httpRequest, Collection<Header> requestHeaders) {
            HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
            for (Header requestHeader : requestHeaders) {
                httpRequest.addHeader(requestHeader);
                requestNames.add(requestHeader.getName());
            }
            for (Header defaultHeader : RestClient.this.defaultHeaders) {
                if (requestNames.contains(defaultHeader.getName())) continue;
                httpRequest.addHeader(defaultHeader);
            }
            if (RestClient.this.compressionEnabled) {
                httpRequest.addHeader("Accept-Encoding", (Object)"gzip");
            }
        }

        private void setRequestConfig(HttpUriRequestBase httpRequest, RequestConfig requestConfig) {
            if (requestConfig != null) {
                httpRequest.setConfig(requestConfig);
            }
        }

        RequestContext<ClassicHttpResponse> createContextForNextAttempt(Node node, AuthCache authCache) {
            this.httpRequest.reset();
            return new AsyncRequestContext(this, node, authCache);
        }
    }

    static class FailureTrackingResponseListener {
        private final ResponseListener responseListener;
        private volatile Exception exception;

        FailureTrackingResponseListener(ResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        void onSuccess(Response response) {
            this.responseListener.onSuccess(response);
        }

        void onDefinitiveFailure(Exception exception) {
            this.trackFailure(exception);
            this.responseListener.onFailure(this.exception);
        }

        void trackFailure(Exception exception) {
            RestClient.addSuppressedException(this.exception, exception);
            this.exception = exception;
        }
    }

    private static class ResponseOrResponseException {
        private final Response response;
        private final ResponseException responseException;

        ResponseOrResponseException(Response response) {
            this.response = Objects.requireNonNull(response);
            this.responseException = null;
        }

        ResponseOrResponseException(ResponseException responseException) {
            this.responseException = Objects.requireNonNull(responseException);
            this.response = null;
        }
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    private class InternalStreamingRequest {
        private final StreamingRequest<ByteBuffer> request;
        private final Set<Integer> ignoreErrorCodes;
        private final HttpUriRequestBase httpRequest;
        private final Cancellable cancellable;
        private final WarningsHandler warningsHandler;

        InternalStreamingRequest(StreamingRequest<ByteBuffer> request) {
            this.request = request;
            HashMap<String, String> params = new HashMap<String, String>(request.getParameters());
            String ignoreString = (String)params.remove("ignore");
            this.ignoreErrorCodes = RestClient.getIgnoreErrorCodes(ignoreString, request.getMethod());
            URI uri = RestClient.buildUri(RestClient.this.pathPrefix, request.getEndpoint(), params);
            this.httpRequest = RestClient.this.createHttpRequest(request.getMethod(), uri, null);
            this.cancellable = Cancellable.fromRequest((CancellableDependency)this.httpRequest);
            this.setHeaders((HttpRequest)this.httpRequest, request.getOptions().getHeaders());
            this.setRequestConfig(this.httpRequest, request.getOptions().getRequestConfig());
            this.warningsHandler = request.getOptions().getWarningsHandler() == null ? RestClient.this.warningsHandler : request.getOptions().getWarningsHandler();
        }

        private void setHeaders(HttpRequest httpRequest, Collection<Header> requestHeaders) {
            HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
            for (Header requestHeader : requestHeaders) {
                httpRequest.addHeader(requestHeader);
                requestNames.add(requestHeader.getName());
            }
            for (Header defaultHeader : RestClient.this.defaultHeaders) {
                if (requestNames.contains(defaultHeader.getName())) continue;
                httpRequest.addHeader(defaultHeader);
            }
            if (RestClient.this.compressionEnabled) {
                httpRequest.addHeader("Accept-Encoding", (Object)"gzip");
            }
        }

        private void setRequestConfig(HttpUriRequestBase httpRequest, RequestConfig requestConfig) {
            if (requestConfig != null) {
                httpRequest.setConfig(requestConfig);
            }
        }

        public Publisher<ByteBuffer> getPublisher() {
            return this.request.getBody();
        }

        RequestContext<Void> createContextForNextAttempt(Node node, AuthCache authCache, MonoSink<Message<HttpResponse, Publisher<ByteBuffer>>> emitter) {
            this.httpRequest.reset();
            return new ReactiveRequestContext(this, node, authCache, emitter);
        }
    }

    private static interface RequestContext<T> {
        public Node node();

        public AsyncRequestProducer requestProducer();

        public AsyncResponseConsumer<T> asyncResponseConsumer();

        public HttpClientContext context();
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    public static class ContentCompressingEntity
    extends HttpEntityWrapper {
        private static final String GZIP_CODEC = "gzip";
        private Optional<Boolean> chunkedEnabled;

        public ContentCompressingEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        public String getContentEncoding() {
            return GZIP_CODEC;
        }

        public ContentCompressingEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        public InputStream getContent() throws IOException {
            ByteArrayInputOutputStream out = new ByteArrayInputOutputStream(1024);
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);){
                super.writeTo((OutputStream)gzipOut);
            }
            return out.asInput();
        }

        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }

        public long getContentLength() {
            if (this.chunkedEnabled.isPresent()) {
                if (this.chunkedEnabled.get().booleanValue()) {
                    return -1L;
                }
                long size = 0L;
                byte[] buf = new byte[8192];
                int nread = 0;
                try (InputStream is = this.getContent();){
                    while ((nread = is.read(buf)) > 0) {
                        size += (long)nread;
                    }
                }
                catch (IOException ex) {
                    size = -1L;
                }
                return size;
            }
            return -1L;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            Args.notNull((Object)outStream, (String)"Output stream");
            GZIPOutputStream gzip = new GZIPOutputStream(outStream);
            super.writeTo((OutputStream)gzip);
            gzip.close();
        }
    }

    public static class ContentHttpEntity
    extends HttpEntityWrapper {
        private Optional<Boolean> chunkedEnabled;

        public ContentHttpEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        public ContentHttpEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        ByteArrayInputOutputStream(int size) {
            super(size);
        }

        public InputStream asInput() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }

    private static class AsyncRequestContext
    implements RequestContext<ClassicHttpResponse> {
        private final Node node;
        private final AsyncRequestProducer requestProducer;
        private final AsyncResponseConsumer<ClassicHttpResponse> asyncResponseConsumer;
        private final HttpClientContext context;

        AsyncRequestContext(InternalRequest request, Node node, AuthCache authCache) {
            this.node = node;
            this.requestProducer = HttpUriRequestProducer.create(request.httpRequest, node.getHost());
            this.asyncResponseConsumer = request.request.getOptions().getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer();
            this.context = HttpClientContext.create();
            this.context.setAuthCache((AuthCache)new WrappingAuthCache(this.context, authCache));
        }

        @Override
        public AsyncResponseConsumer<ClassicHttpResponse> asyncResponseConsumer() {
            return this.asyncResponseConsumer;
        }

        @Override
        public HttpClientContext context() {
            return this.context;
        }

        @Override
        public Node node() {
            return this.node;
        }

        @Override
        public AsyncRequestProducer requestProducer() {
            return this.requestProducer;
        }
    }

    private static class ReactiveRequestContext
    implements RequestContext<Void> {
        private final Node node;
        private final AsyncRequestProducer requestProducer;
        private final AsyncResponseConsumer<Void> asyncResponseConsumer;
        private final HttpClientContext context;

        ReactiveRequestContext(InternalStreamingRequest request, Node node, AuthCache authCache, final MonoSink<Message<HttpResponse, Publisher<ByteBuffer>>> emitter) {
            this.node = node;
            this.requestProducer = ReactiveHttpUriRequestProducer.create(request.httpRequest, node.getHost(), request.getPublisher());
            this.asyncResponseConsumer = new ReactiveResponseConsumer((FutureCallback)new FutureCallback<Message<HttpResponse, Publisher<ByteBuffer>>>(){
                final /* synthetic */ ReactiveRequestContext this$0;
                {
                    this.this$0 = this$0;
                }

                public void failed(Exception ex) {
                    emitter.error((Throwable)ex);
                }

                public void completed(Message<HttpResponse, Publisher<ByteBuffer>> result) {
                    if (result == null) {
                        emitter.success();
                    } else {
                        emitter.success(result);
                    }
                }

                public void cancelled() {
                    this.failed(new CancellationException("Future cancelled"));
                }
            });
            this.context = HttpClientContext.create();
            this.context.setAuthCache((AuthCache)new WrappingAuthCache(this.context, authCache));
        }

        @Override
        public AsyncResponseConsumer<Void> asyncResponseConsumer() {
            return this.asyncResponseConsumer;
        }

        @Override
        public HttpClientContext context() {
            return this.context;
        }

        @Override
        public Node node() {
            return this.node;
        }

        @Override
        public AsyncRequestProducer requestProducer() {
            return this.requestProducer;
        }
    }

    private static class WrappingAuthCache
    implements AuthCache {
        private final HttpClientContext context;
        private final AuthCache delegate;
        private final boolean usePersistentCredentials = true;

        public WrappingAuthCache(HttpClientContext context, AuthCache delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public void put(HttpHost host, AuthScheme authScheme) {
            this.delegate.put(host, authScheme);
        }

        public AuthScheme get(HttpHost host) {
            CredentialsProvider credsProvider;
            AuthScheme authScheme = this.delegate.get(host);
            if (authScheme != null && (credsProvider = this.context.getCredentialsProvider()) != null) {
                String schemeName = authScheme.getName();
                AuthScope authScope = new AuthScope(host, null, schemeName);
                Credentials creds = credsProvider.getCredentials(authScope, (HttpContext)this.context);
                if (authScheme instanceof BasicScheme) {
                    ((BasicScheme)authScheme).initPreemptive(creds);
                }
                if (creds == null) {
                    return null;
                }
            }
            return authScheme;
        }

        public void remove(HttpHost host) {
        }

        public void clear() {
            this.delegate.clear();
        }
    }
}

