Dell SonicWALL Scrutinizer is multi-vendor, application traffic analytics, visualization and
reporting tool to measure and troubleshoot real-time network performance. It is used by routers,
firewalls, and other network equipment products.

In version 11.0.1, SonicWall Scrutinizer suffers from a vulnerability that allows a remote
attacker to inject a malicious SQL string into the methodDetail parameter, and then gain
control of execution under the context of SYSTEM on Windows, or Apache on Linux.

Authentication is required to exploit this vulnerability. However, SonicWALL Scrutinizer does
come with a default username and password (admin:admin), which is also somewhat unsafe.

## Vulnerable Application

As reported by the vendor, only version 11.0.1 is vulnerable to the SQL injection attack.

For testing purposes, you may download the vulnerable version of Dell SonicWALL Scrutinizer for Windows from:
[http://software.sonicwall.com/ScrutinizerSW/184-003184-00_Rev_A_sonicwall-oem-Scrutinizer-windows-installer.exe](http://software.sonicwall.com/ScrutinizerSW/184-003184-00_Rev_A_sonicwall-oem-Scrutinizer-windows-installer.exe).

If you prefer the appliance, then you can get it from: [http://software.sonicwall.com/scrutinizerVA/184-003186-00_Rev_A_Dell_SonicWALL_ScrutinizerVA.zip](http://software.sonicwall.com/scrutinizerVA/184-003186-00_Rev_A_Dell_SonicWALL_ScrutinizerVA.zip).

## Verification Steps

For testing purposes, the Windows installer is a bit easier to use. You should be able to complete
it by simply following the instructions on the screen.

The Linux appliance requires more steps. To be able to use this, make sure you have more than 20GB
on disk. And you may need to modify the boot menu to [reset the root password](https://wiki.centos.org/TipsAndTricks/ResetRootPassword) if you cannot get around the scrutinizer login screen.

Using the sonicwall_scrutinizer_methoddetail_sqli module is rather straight-forward. Make sure
you have a valid username and password, and configure the payload for the target. You will most
likely use the module like this:

1. Start msfconsole
2. Do: ```use exploit/multi/http/sonicwall_scrutinizer_methoddetail_sqli ```
3. Do: ```set RHOST [TARGET IP]```
5. Do: ```set PAYLOAD [PAYLOAD NAME]``` (use ```show payloads``` for more info)
6. Do: ```exploit```

## Scenarios

sonicwall_scrutinizer_methoddetail_sqli supports two platforms: Windows and Linux. By default,
it can automatically find the right OS, and configure the exploit and payload generation
accordingly.

**Using the module against Windows platform**

If sonicwall_scrutinizer_methoddetail_sqli is able to exploit SonicWALL Scrutinizer successfully,
on Windows you will be compromising the host as SYSTEM - the highest privilege. However, since
Windows does not allow you to delete the malicious executable that is in use, you will have to
do this manually at some point after you've migrated to a different process. The exploit should
tell you where this binary is like this message:

```
[!] This exploit may require manual cleanup of 'YrfCO.exe' on the target
```

**Using the module against Linux platform**

For Linux platform, sonicwall_scrutinizer_methoddetail_sqli was specifically written against
the Linux appliance provided by Dell, but it should also work against other similar machines.

Unlike Windows, if the module is able to successfully exploit the machine, you won't have the
highest privilege, instead you start off with Apache.

Automatic cleanup is not an issue on Linux. Both the PHP backdoor and the Linux binary
should be automatically removed without problems.

