/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.StreamsGroupMemberDescription;
import org.apache.kafka.clients.admin.StreamsGroupSubtopologyDescription;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class StreamsGroupDescription {
    private final String groupId;
    private final int groupEpoch;
    private final int targetAssignmentEpoch;
    private final int topologyEpoch;
    private final Collection<StreamsGroupSubtopologyDescription> subtopologies;
    private final Collection<StreamsGroupMemberDescription> members;
    private final GroupState groupState;
    private final Node coordinator;
    private final Set<AclOperation> authorizedOperations;

    public StreamsGroupDescription(String groupId, int groupEpoch, int targetAssignmentEpoch, int topologyEpoch, Collection<StreamsGroupSubtopologyDescription> subtopologies, Collection<StreamsGroupMemberDescription> members, GroupState groupState, Node coordinator, Set<AclOperation> authorizedOperations) {
        this.groupId = Objects.requireNonNull(groupId, "groupId must be non-null");
        this.groupEpoch = groupEpoch;
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.topologyEpoch = topologyEpoch;
        this.subtopologies = Objects.requireNonNull(subtopologies, "subtopologies must be non-null");
        this.members = Objects.requireNonNull(members, "members must be non-null");
        this.groupState = Objects.requireNonNull(groupState, "groupState must be non-null");
        this.coordinator = Objects.requireNonNull(coordinator, "coordinator must be non-null");
        this.authorizedOperations = authorizedOperations;
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupEpoch() {
        return this.groupEpoch;
    }

    public int targetAssignmentEpoch() {
        return this.targetAssignmentEpoch;
    }

    public int topologyEpoch() {
        return this.topologyEpoch;
    }

    public Collection<StreamsGroupMemberDescription> members() {
        return this.members;
    }

    public Collection<StreamsGroupSubtopologyDescription> subtopologies() {
        return this.subtopologies;
    }

    public GroupState groupState() {
        return this.groupState;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsGroupDescription that = (StreamsGroupDescription)o;
        return this.groupEpoch == that.groupEpoch && this.targetAssignmentEpoch == that.targetAssignmentEpoch && this.topologyEpoch == that.topologyEpoch && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.subtopologies, that.subtopologies) && Objects.equals(this.members, that.members) && this.groupState == that.groupState && Objects.equals(this.coordinator, that.coordinator) && Objects.equals(this.authorizedOperations, that.authorizedOperations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.groupEpoch, this.targetAssignmentEpoch, this.topologyEpoch, this.subtopologies, this.members, this.groupState, this.coordinator, this.authorizedOperations});
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", groupEpoch=" + this.groupEpoch + ", targetAssignmentEpoch=" + this.targetAssignmentEpoch + ", topologyEpoch=" + this.topologyEpoch + ", subtopologies=" + this.subtopologies.stream().map(StreamsGroupSubtopologyDescription::toString).collect(Collectors.joining(",")) + ", members=" + this.members.stream().map(StreamsGroupMemberDescription::toString).collect(Collectors.joining(",")) + ", groupState=" + String.valueOf((Object)this.groupState) + ", coordinator=" + String.valueOf(this.coordinator) + ", authorizedOperations=" + this.authorizedOperations.stream().map(Enum::toString).collect(Collectors.joining(",")) + ")";
    }
}

