/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapLongBufferR;
import java.nio.LongBuffer;

class HeapLongBuffer
extends LongBuffer {
    HeapLongBuffer(int n, int n2) {
        super(-1, 0, n2, n, new long[n], 0);
    }

    HeapLongBuffer(long[] lArray, int n, int n2) {
        super(-1, n, n + n2, lArray.length, lArray, 0);
    }

    protected HeapLongBuffer(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, lArray, n5);
    }

    @Override
    public LongBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapLongBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public LongBuffer duplicate() {
        return new HeapLongBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new HeapLongBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public long get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public long get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public LongBuffer get(long[] lArray, int n, int n2) {
        HeapLongBuffer.checkBounds(n, n2, lArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(n3), lArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public LongBuffer put(long l) {
        this.hb[this.ix((int)this.nextPutIndex())] = l;
        return this;
    }

    @Override
    public LongBuffer put(int n, long l) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = l;
        return this;
    }

    @Override
    public LongBuffer put(long[] lArray, int n, int n2) {
        HeapLongBuffer.checkBounds(n, n2, lArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferOverflowException();
        }
        System.arraycopy(lArray, n, this.hb, this.ix(n3), n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer instanceof HeapLongBuffer) {
            if (longBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapLongBuffer heapLongBuffer = (HeapLongBuffer)longBuffer;
            int n = this.position();
            int n2 = heapLongBuffer.position();
            int n3 = heapLongBuffer.limit() - n2;
            if (n3 > this.limit() - n) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapLongBuffer.hb, heapLongBuffer.ix(n2), this.hb, this.ix(n), n3);
            heapLongBuffer.position(n2 + n3);
            this.position(n + n3);
        } else if (longBuffer.isDirect()) {
            int n = longBuffer.remaining();
            int n4 = this.position();
            if (n > this.limit() - n4) {
                throw new BufferOverflowException();
            }
            longBuffer.get(this.hb, this.ix(n4), n);
            this.position(n4 + n);
        } else {
            super.put(longBuffer);
        }
        return this;
    }

    @Override
    public LongBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        System.arraycopy(this.hb, this.ix(n), this.hb, this.ix(0), n3);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

