#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 extra
version:              1.7.16
visibility:           public
id:                   extra-1.7.16-HFVkAG9ZjF7KRVgcoT9Nb3
key:                  extra-1.7.16-HFVkAG9ZjF7KRVgcoT9Nb3
license:              BSD-3-Clause
copyright:            Neil Mitchell 2014-2024
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/extra#readme
synopsis:             Extra functions I use.
description:
    A library of extra functions for the standard Haskell libraries. Most functions are simple additions, filling out missing functionality. A few functions are available in later versions of GHC, but this package makes them available back to GHC 7.2.

    The module "Extra" documents all functions provided by this library. Modules such as "Data.List.Extra" provide extra functions over "Data.List" and also reexport "Data.List". Users are recommended to replace "Data.List" imports with "Data.List.Extra" if they need the extra functionality.

category:             Development
abi:                  fb80a40045e294f8c0c1441de3c7225a
exposed:              True
exposed-modules:
    Control.Concurrent.Extra Control.Exception.Extra
    Control.Monad.Extra Data.Either.Extra Data.Foldable.Extra
    Data.IORef.Extra Data.List.Extra Data.List.NonEmpty.Extra
    Data.Monoid.Extra Data.Tuple.Extra Data.Typeable.Extra
    Data.Version.Extra Extra Numeric.Extra System.Directory.Extra
    System.Environment.Extra System.IO.Extra System.Info.Extra
    System.Process.Extra System.Time.Extra Text.Read.Extra

hidden-modules:       Partial
import-dirs:          /usr/lib/ghc-9.4.8/site-local/extra-1.7.16
library-dirs:         /usr/lib/ghc-9.4.8/site-local/extra-1.7.16
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/extra-1.7.16
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-extra
hs-libraries:         HSextra-1.7.16-HFVkAG9ZjF7KRVgcoT9Nb3
depends:
    base-4.17.2.1 clock-0.8.4-Ba1oWJXunJs1C01SeBKsWd directory-1.3.7.1
    filepath-1.4.2.2 process-1.6.18.0 time-1.12.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-extra/html/extra.haddock
haddock-html:         /usr/share/doc/haskell-extra/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

