#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 equivalence
version:              0.4.1
visibility:           public
id:                   equivalence-0.4.1-1X3Y0dwzZr983bgfGjOL7S
key:                  equivalence-0.4.1-1X3Y0dwzZr983bgfGjOL7S
license:              BSD-3-Clause
maintainer:           Andreas Abel
author:               Patrick Bahr
stability:            provisional
homepage:             https://github.com/pa-ba/equivalence
synopsis:
    Maintaining an equivalence relation implemented as union-find using STT.

description:
    This is an implementation of Tarjan'\''s Union-Find algorithm (Robert
    E. Tarjan. "Efficiency of a Good But Not Linear Set Union
    Algorithm", JACM 22(2), 1975) in order to maintain an equivalence
    relation.
    This implementation is a port of the /union-find/ package using the
    ST monad transformer (instead of the IO monad).

category:             Algorithms, Data
abi:                  f06d1eaa49b1dd8cb496d744a0df34c0
exposed:              True
exposed-modules:      Data.Equivalence.Monad Data.Equivalence.STT
import-dirs:          /usr/lib/ghc-9.4.8/site-local/equivalence-0.4.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/equivalence-0.4.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/equivalence-0.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-equivalence
hs-libraries:         HSequivalence-0.4.1-1X3Y0dwzZr983bgfGjOL7S
depends:
    STMonadTrans-0.4.8-GzAVVmCG1Xg7QWo71sRpxv base-4.17.2.1
    containers-0.6.7 mtl-2.2.2 transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ

haddock-interfaces:   /usr/share/doc/haskell-equivalence/html/equivalence.haddock
haddock-html:         /usr/share/doc/haskell-equivalence/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

