#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 curve25519
version:              0.2.8.1
visibility:           public
id:                   curve25519-0.2.8.1-KEf9tMs4qQXJQBi28IYXbh
key:                  curve25519-0.2.8.1-KEf9tMs4qQXJQBi28IYXbh
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@uhsure.com>
author:               Adam Wick <awick@uhsure.com>
homepage:             http://github.com/acw/curve25519
synopsis:
    Fast implementations of the curve25519 elliptic curve primitives.

description:
    Haskell bindings and extensions to the curve25519-donna
    codebase. This module is a pretty straightforward implementation
    of the basic cryptographic routines you'\''d want from a project that
    uses curve25519: key generation, and key agreement. For further
    functionality, you'\''ll want to look elsewhere.

category:             Math
abi:                  524b37678da258f93f24ccad5373d39f
exposed:              True
exposed-modules:
    Crypto.Curve25519 Crypto.Curve25519.Exceptions
    Crypto.Curve25519.Pure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/curve25519-0.2.8.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/curve25519-0.2.8.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/curve25519-0.2.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-curve25519
hs-libraries:         HScurve25519-0.2.8.1-KEf9tMs4qQXJQBi28IYXbh
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    crypto-api-0.13.3-L9US7GS3I02EI9rbQ94kVv

haddock-interfaces:   /usr/share/doc/haskell-curve25519/html/curve25519.haddock
haddock-html:         /usr/share/doc/haskell-curve25519/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

