#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptonite-conduit
version:              0.2.2
visibility:           public
id:                   cryptonite-conduit-0.2.2-D0ncvFcrijHKlD3HfuRX2a
key:                  cryptonite-conduit-0.2.2-D0ncvFcrijHKlD3HfuRX2a
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/haskell-crypto/cryptonite-conduit
synopsis:             cryptonite conduit
description:
    Conduit bridge for cryptonite

    For now only provide a conduit version for hash and hmac, but
    with contribution, this could provide cipher conduits too,
    and probably other things.

category:             Cryptography, Conduit
abi:                  18ac848ce67e991e85c78c548871df87
exposed:              True
exposed-modules:
    Crypto.Cipher.ChaChaPoly1305.Conduit Crypto.Hash.Conduit
    Crypto.MAC.HMAC.Conduit Crypto.PubKey.ECIES.Conduit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptonite-conduit-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptonite-conduit
hs-libraries:         HScryptonite-conduit-0.2.2-D0ncvFcrijHKlD3HfuRX2a
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    conduit-1.3.6.1-KZNeLPeXvjD5EEhRbg4Ht8
    conduit-extra-1.3.8-Gwq2qlVhV3jEWryL83GuOP
    cryptonite-0.30-AgWWRR3TAZE6jEw6rHy8Yx exceptions-0.10.5
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    resourcet-1.2.6-4s6buasN4G4AuwCuvXVHSL transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-cryptonite-conduit/html/cryptonite-conduit.haddock

haddock-html:         /usr/share/doc/haskell-cryptonite-conduit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

