#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptohash-sha1
version:              0.11.101.0
visibility:           public
id:                   cryptohash-sha1-0.11.101.0-Jzjg3pgPRsDJw985tBCSMU
key:                  cryptohash-sha1-0.11.101.0-Jzjg3pgPRsDJw985tBCSMU
license:              BSD-3-Clause
copyright:            Vincent Hanquez, Herbert Valerio Riedel
maintainer:           Herbert Valerio Riedel <hvr@gnu.org>
homepage:             https://github.com/hvr/cryptohash-sha1
synopsis:             Fast, pure and practical SHA-1 implementation
description:
    A practical incremental and one-pass, pure API to the
    <https://en.wikipedia.org/wiki/SHA-1 SHA-1 hash algorithm>
    (including <https://en.wikipedia.org/wiki/HMAC HMAC> support)
    with performance close to the fastest implementations available in other languages.

    The implementation is made in C with a haskell FFI wrapper that hides the C implementation.

    NOTE: This package has been forked off @cryptohash-0.11.7@ because the @cryptohash@ package has been
    deprecated and so this package continues to satisfy the need for a lightweight package
    providing the SHA1 hash algorithm without any dependencies on packages other than
    @base@ and @bytestring@.

    Consequently, this package can be used as a drop-in replacement for @cryptohash@'\''s
    "Crypto.Hash.SHA1" module, though with a clearly smaller footprint.

category:             Data, Cryptography
abi:                  b446e86f74d3f794776b43428501b464
exposed:              True
exposed-modules:      Crypto.Hash.SHA1
hidden-modules:       Crypto.Hash.SHA1.FFI Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptohash-sha1-0.11.101.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptohash-sha1-0.11.101.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptohash-sha1-0.11.101.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-cryptohash-sha1
hs-libraries:         HScryptohash-sha1-0.11.101.0-Jzjg3pgPRsDJw985tBCSMU
depends:              base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:
    /usr/share/doc/haskell-cryptohash-sha1/html/cryptohash-sha1.haddock

haddock-html:         /usr/share/doc/haskell-cryptohash-sha1/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

