#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-G6EHY6Is2qe6VrHgvOjvjZ
key:                  crypto-api-tests-0.3-G6EHY6Is2qe6VrHgvOjvjZ
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  f17fc9bee85668dc2eee210a77eb5a68
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-9.4.8/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/crypto-api-tests-0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-api-tests
hs-libraries:         HScrypto-api-tests-0.3-G6EHY6Is2qe6VrHgvOjvjZ
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    QuickCheck-2.14.3-5M5TotFyqMq9PCRuWSklwe base-4.17.2.1
    bytestring-0.11.5.3 cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    crypto-api-0.13.3-L9US7GS3I02EI9rbQ94kVv directory-1.3.7.1
    filepath-1.4.2.2 test-framework-0.8.2.2-2C9Idcjq6PmEQp5ISc41rQ
    test-framework-hunit-0.3.0.2-898QaCLaTxd3vXhumxfvjV
    test-framework-quickcheck2-0.3.0.6-5TlWOJMtidoJoOhqjjxvG7

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

