#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 concurrent-output
version:              1.10.21
visibility:           public
id:                   concurrent-output-1.10.21-JaXU15KYmDg4duiseGkZXI
key:                  concurrent-output-1.10.21-JaXU15KYmDg4duiseGkZXI
license:              BSD-2-Clause
copyright:            2015-2021 Joey Hess, 2009 Joachim Breitner
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess, Joachim Breitner
stability:            Stable
synopsis:             Ungarble output from several threads or commands
description:
    Lets multiple threads and external processes concurrently output to the
    console, without it getting all garbled up.

    Built on top of that is a way of defining multiple output regions,
    which are automatically laid out on the screen and can be individually
    updated by concurrent threads. Can be used for progress displays etc.

    <<https://joeyh.name/code/concurrent-output/demo2.gif>>

category:             User Interfaces, Concurrency
abi:                  344e698bd21c10b2428bfa4cbd3182f5
exposed:              True
exposed-modules:
    System.Console.Concurrent System.Console.Concurrent.Internal
    System.Console.Regions System.Process.Concurrent

hidden-modules:       Utility.Monad Utility.Exception
import-dirs:          /usr/lib/ghc-9.4.8/site-local/concurrent-output-1.10.21
library-dirs:         /usr/lib/ghc-9.4.8/site-local/concurrent-output-1.10.21
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/concurrent-output-1.10.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-concurrent-output
hs-libraries:         HSconcurrent-output-1.10.21-JaXU15KYmDg4duiseGkZXI
depends:
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1
    async-2.2.5-EP91qAI3cOI8P3d6QWskI6 base-4.17.2.1 directory-1.3.7.1
    exceptions-0.10.5 process-1.6.18.0 stm-2.5.1.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    transformers-0.5.6.2 unix-2.7.3

haddock-interfaces:
    /usr/share/doc/haskell-concurrent-output/html/concurrent-output.haddock

haddock-html:         /usr/share/doc/haskell-concurrent-output/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

