#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 concurrent-extra
version:              0.7.0.12
visibility:           public
id:                   concurrent-extra-0.7.0.12-KQIaBfF1NR97gzxwvYzreo
key:                  concurrent-extra-0.7.0.12-KQIaBfF1NR97gzxwvYzreo
license:              BSD-3-Clause
copyright:            (c) 2010-2012 Bas van Dijk & Roel van Dijk
maintainer:
    Bas van Dijk <v.dijk.bas@gmail.com>
    Roel van Dijk <vandijk.roel@gmail.com>

author:
    Bas van Dijk <v.dijk.bas@gmail.com>
    Roel van Dijk <vandijk.roel@gmail.com>

stability:            experimental
homepage:             https://github.com/basvandijk/concurrent-extra
synopsis:             Extra concurrency primitives
description:
    The @concurrent-extra@ package offers among other things the
    following selection of synchronisation primitives:

    * @Broadcast@: Wake multiple threads by broadcasting a value.

    * @Event@: Wake multiple threads by signalling an event.

    * @Lock@: Enforce exclusive access to a resource. Also known as a
    binary semaphore or mutex. The package additionally provides an
    alternative that works in the @STM@ monad.

    * @RLock@: A lock which can be acquired multiple times by the same
    thread. Also known as a reentrant mutex.

    * @ReadWriteLock@: Multiple-reader, single-writer locks. Used to
    protect shared resources which may be concurrently read, but only
    sequentially written.

    * @ReadWriteVar@: Concurrent read, sequential write variables.

    Please consult the API documentation of the individual modules for
    more detailed information.

    This package was inspired by the concurrency libraries of Java and
    Python.

category:             Concurrency
abi:                  674617bd8819c60763bc624d5c79c92c
exposed:              True
exposed-modules:
    Control.Concurrent.Broadcast Control.Concurrent.Event
    Control.Concurrent.Lock Control.Concurrent.RLock
    Control.Concurrent.ReadWriteLock Control.Concurrent.ReadWriteVar
    Control.Concurrent.STM.Lock

hidden-modules:       Utils
import-dirs:          /usr/lib/ghc-9.4.8/site-local/concurrent-extra-0.7.0.12
library-dirs:         /usr/lib/ghc-9.4.8/site-local/concurrent-extra-0.7.0.12
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/concurrent-extra-0.7.0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-concurrent-extra
hs-libraries:         HSconcurrent-extra-0.7.0.12-KQIaBfF1NR97gzxwvYzreo
depends:
    base-4.17.2.1 stm-2.5.1.0
    unbounded-delays-0.1.1.1-9PQJht8VjI9BW2tiXlJWhX

haddock-interfaces:
    /usr/share/doc/haskell-concurrent-extra/html/concurrent-extra.haddock

haddock-html:         /usr/share/doc/haskell-concurrent-extra/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

