#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-lib
version:              1.8.2
visibility:           public
id:                   clash-lib-1.8.2-KBCpUHzK7k4KoxakNWoM13
key:                  clash-lib-1.8.2-KBCpUHzK7k4KoxakNWoM13
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2023, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  0bb1c829385bf8850bb68116f0b5874c
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Backend.Verilog.Time Clash.Core.DataCon
    Clash.Core.EqSolver Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Data.UniqMap Clash.DataFiles Clash.Debug
    Clash.Driver Clash.Driver.Bool Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Expr Clash.Netlist.Id Clash.Netlist.Id.Common
    Clash.Netlist.Id.Internal Clash.Netlist.Id.SystemVerilog
    Clash.Netlist.Id.VHDL Clash.Netlist.Id.Verilog Clash.Netlist.Types
    Clash.Netlist.Util Clash.Normalize
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Primitives
    Clash.Normalize.Strategy Clash.Normalize.Transformations
    Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty
    Clash.Primitives.Annotations.SynthesisAttributes
    Clash.Primitives.DSL Clash.Primitives.GHC.Int
    Clash.Primitives.GHC.Literal Clash.Primitives.GHC.Word
    Clash.Primitives.Intel.ClockGen Clash.Primitives.Magic
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Primitives.Xilinx.ClockGen Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Eq Clash.Util.Graph
    Clash.Util.Interpolate Clash.Util.Supply Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra
    GHC.BasicTypes.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.SrcLoc.Extra Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.8.2-KBCpUHzK7k4KoxakNWoM13
depends:
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us
    aeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa
    ansi-terminal-1.0.2-HptUcAgyCR58cokR0SMdxn array-0.5.4.0
    async-2.2.5-Tatd1blDDeFXcniqPZgAh
    attoparsec-0.14.4-LYMz7sGPlLCLdIXUlDCVP9
    attoparsec-aeson-2.1.0.0-9CwObhaLT6zJ0edMhKq57 base-4.17.2.1
    base16-bytestring-1.0.2.0-LUU3ms9NsF4GQtyGeO8pva binary-0.8.9.1
    bytestring-0.11.5.3 clash-prelude-1.8.2-Ci6SvhaC7dBESSsP783uPq
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-GlI6J0iALmR3Ajx7WCWQyw
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-BKgPi70fx5AJreCYiKxIIN
    exceptions-0.10.5 extra-1.7.16-1RhoiOXPfr67YmwKq5VFCS
    filepath-1.4.2.2 ghc-9.4.8 ghc-bignum-1.3 ghc-boot-th-9.4.8
    ghc-prim-0.9.1 hashable-1.4.4.0-AFqmlTE0BBaCoTGEV5znl2
    haskell-src-meta-0.8.15-6tdVzK1pPfoCgS9bgybE8f
    hint-0.9.0.8-FhJCcF5Pi0hF78NURmdkbB
    infinite-list-0.1.2-LwYXW99Nc5W1BdVaJYztvO
    lens-5.3.1-JV4NgTTRRUD4MjO8VGr2iB mtl-2.2.2
    ordered-containers-0.2.4-D9abLiJuZ4H8sKIOI63ST
    pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    prettyprinter-1.7.1-5cxpZ3jZU7h3nFjq43pkKP
    prettyprinter-interp-0.2.0.0-JgkskRhWnh0L4n7m3sGWdu
    primitive-0.9.1.0-2rF1KRuV9tjItame9gIzcT
    string-interpolate-0.3.4.0-1Ft7WgihqJ94RGhte5nKwk
    template-haskell-2.19.0.0 temporary-1.3-5ykvKjhsciDABbzBam51Ha
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    transformers-0.5.6.2 trifecta-2.1.4-AbKW9wSHByUElsPtc0SHXQ
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U
    vector-binary-instances-0.2.5.2-I0yM0ITYm1WGwWrsWxnuA6
    yaml-0.11.11.2-37tw4FuYjIR6RRod391CFN

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

