#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-lib
version:              1.8.2
visibility:           public
id:                   clash-lib-1.8.2-FjZ7dYYgAPGraGnoKiFqO
key:                  clash-lib-1.8.2-FjZ7dYYgAPGraGnoKiFqO
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2023, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  88b4bd549a8bf0cd8feb75d1c1be1520
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Backend.Verilog.Time Clash.Core.DataCon
    Clash.Core.EqSolver Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Data.UniqMap Clash.DataFiles Clash.Debug
    Clash.Driver Clash.Driver.Bool Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Expr Clash.Netlist.Id Clash.Netlist.Id.Common
    Clash.Netlist.Id.Internal Clash.Netlist.Id.SystemVerilog
    Clash.Netlist.Id.VHDL Clash.Netlist.Id.Verilog Clash.Netlist.Types
    Clash.Netlist.Util Clash.Normalize
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Primitives
    Clash.Normalize.Strategy Clash.Normalize.Transformations
    Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty
    Clash.Primitives.Annotations.SynthesisAttributes
    Clash.Primitives.DSL Clash.Primitives.GHC.Int
    Clash.Primitives.GHC.Literal Clash.Primitives.GHC.Word
    Clash.Primitives.Intel.ClockGen Clash.Primitives.Magic
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Primitives.Xilinx.ClockGen Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Eq Clash.Util.Graph
    Clash.Util.Interpolate Clash.Util.Supply Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra
    GHC.BasicTypes.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.SrcLoc.Extra Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/clash-lib-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.8.2-FjZ7dYYgAPGraGnoKiFqO
depends:
    aeson-2.1.2.1-BWqAP5DPS0iMNSAJtMWSf
    aeson-pretty-0.8.10-8EXoxIF81CyGdoAzb1CQGS
    ansi-terminal-1.0.2-1WMmnSFsRadEUq8BUHK73i array-0.5.4.0
    async-2.2.5-EKzjtytxFSDGO33P7IPwKj
    attoparsec-0.14.4-7XWZ3nsZOGKJDEorzXp6qF
    attoparsec-aeson-2.1.0.0-FXj7tOmtjxCJauw5Ev0wtT base-4.17.2.1
    base16-bytestring-1.0.2.0-1bEkwAvKVlC52PGjoO72jZ binary-0.8.9.1
    bytestring-0.11.5.3 clash-prelude-1.8.2-B2FxBxVIzSMLxsASSERpm8
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-7HoC5OGxbDV3R4V8a1pbCZ
    data-binary-ieee754-0.4.4-3K4wyZ8KRa1CgKftL8GYsk
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-BKgPi70fx5AJreCYiKxIIN
    exceptions-0.10.5 extra-1.7.16-5rwblNHIKnAJW8xVzxUUh1
    filepath-1.4.2.2 ghc-9.4.8 ghc-bignum-1.3 ghc-boot-th-9.4.8
    ghc-prim-0.9.1 hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    haskell-src-meta-0.8.15-CzK62NI2ZmsETsfwvJ0A0U
    hint-0.9.0.8-5E4aoTol3LkBi0GVsovp6s
    infinite-list-0.1.2-BGgQSzrahN153n6M2rYT0K
    lens-5.3.1-L3T26fDKV8KAh84K9wN8lF mtl-2.2.2
    ordered-containers-0.2.4-2ldaaGaJM1iK3xQFQmOruL
    pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    prettyprinter-1.7.1-GW24MvTJNAcBiqvxAdyJJ2
    prettyprinter-interp-0.2.0.0-AXQuVfveiap7Hk2x1TaiAz
    primitive-0.9.1.0-3qHntBOAe4Y4he61Fs3OAc
    string-interpolate-0.3.4.0-J67nl07U15zX0PvvfHLE9
    template-haskell-2.19.0.0 temporary-1.3-JIXZ1S2ItU295qbRBPUO0q
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2 time-1.12.2
    transformers-0.5.6.2 trifecta-2.1.4-HQMusMy6MWf5Mr7i0qup9K
    unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A
    vector-binary-instances-0.2.5.2-BCEQjhLB32T2czEiuj3PMi
    yaml-0.11.11.2-E2y2ob5lfUes8QJFxXIpl

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

