#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 chimera
version:              0.4.1.0
visibility:           public
id:                   chimera-0.4.1.0-LOcgkpYNJhSD2etHUczcm9
key:                  chimera-0.4.1.0-LOcgkpYNJhSD2etHUczcm9
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  5f830ffb1ef3d29d96bf3404f16e0757
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:
    Data.Chimera.Compat Data.Chimera.FromIntegral Data.Chimera.Internal
    Data.Chimera.Memoize

import-dirs:          /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.4.1.0-LOcgkpYNJhSD2etHUczcm9
depends:
    adjunctions-4.4.3-9WnSW5MCRSaC35eDbBJFCt base-4.17.2.1
    distributive-0.6.2.1-JWrRvxW4M5uLlDVH9ni0Nb
    infinite-list-0.1.2-FfHZP7HMfEq5Tz3gPQZycL mtl-2.2.2
    primitive-0.9.0.0-2SWzXeJZNqNGCC3BQBwQzS transformers-0.5.6.2
    vector-0.13.2.0-DHb3zbtAYMJG5fP738ULIp

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

