#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 blaze-builder
version:              0.4.4.1
visibility:           public
id:                   blaze-builder-0.4.4.1-20XIpZGgNDfHegCCnMhzZO
key:                  blaze-builder-0.4.4.1-20XIpZGgNDfHegCCnMhzZO
license:              BSD-3-Clause
copyright:
    (c) 2010-2014 Simon Meier
    (c) 2010 Jasper Van der Jeugt
    (c) 2013-2015 Leon P Smith

maintainer:           https://github.com/blaze-builder
author:               Jasper Van der Jeugt, Simon Meier, Leon P Smith
stability:            Stable
homepage:             https://github.com/blaze-builder/blaze-builder
synopsis:             Efficient buffered output.
description:
    This library allows to efficiently serialize Haskell values to lazy bytestrings
    with a large average chunk size. The large average chunk size allows to make
    good use of cache prefetching in later processing steps (e.g. compression) and
    reduces the system call overhead when writing the resulting lazy bytestring to a
    file or sending it over the network.

    This library was inspired by the module Data.Binary.Builder provided by the
    binary package. It was originally developed with the specific needs of the
    blaze-html package in mind. Since then it has been restructured to serve as a
    drop-in replacement for Data.Binary.Builder, which it improves upon both in
    speed as well as expressivity.

category:             Data
abi:                  dc9b808be47aeb3c541d54d86bd0d00f
exposed:              True
exposed-modules:
    Blaze.ByteString.Builder Blaze.ByteString.Builder.ByteString
    Blaze.ByteString.Builder.Char.Utf8 Blaze.ByteString.Builder.Char8
    Blaze.ByteString.Builder.Compat.Write Blaze.ByteString.Builder.HTTP
    Blaze.ByteString.Builder.Html.Utf8
    Blaze.ByteString.Builder.Html.Word Blaze.ByteString.Builder.Int
    Blaze.ByteString.Builder.Internal.Write
    Blaze.ByteString.Builder.Word

import-dirs:          /usr/lib/ghc-9.4.8/site-local/blaze-builder-0.4.4.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/blaze-builder-0.4.4.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/blaze-builder-0.4.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-blaze-builder
hs-libraries:         HSblaze-builder-0.4.4.1-20XIpZGgNDfHegCCnMhzZO
depends:              base-4.17.2.1 bytestring-0.11.5.3 text-2.0.2
haddock-interfaces:
    /usr/share/doc/haskell-blaze-builder/html/blaze-builder.haddock

haddock-html:         /usr/share/doc/haskell-blaze-builder/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

