#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bitvec
version:              1.1.5.0
visibility:           public
id:                   bitvec-1.1.5.0-298xCLFLZGyJSa38yDtOnw
key:                  bitvec-1.1.5.0-298xCLFLZGyJSa38yDtOnw
license:              BSD-3-Clause
copyright:            2019-2022 Andrew Lelechenko, 2012-2016 James Cook
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:
    Andrew Lelechenko <andrew.lelechenko@gmail.com>,
    James Cook <mokus@deepbondi.net>

homepage:             https://github.com/Bodigrim/bitvec
synopsis:             Space-efficient bit vectors
description:
    A newtype over '\''Bool'\'' with a better '\''Vector'\'' instance: 8x less memory, up to 3500x faster.

    The <https://hackage.haskell.org/package/vector vector>
    package represents unboxed arrays of '\''Bool'\''s
    spending 1 byte (8 bits) per boolean.
    This library provides a newtype wrapper '\''Bit'\'' and a custom instance
    of an unboxed '\''Vector'\'', which packs bits densely,
    achieving an __8x smaller memory footprint.__
    The performance stays mostly the same;
    the most significant degradation happens for random writes
    (up to 10% slower).
    On the other hand, for certain bulk bit operations
    '\''Vector'\'' '\''Bit'\'' is up to 3500x faster than '\''Vector'\'' '\''Bool'\''.

    === Thread safety

    * "Data.Bit" is faster, but writes and flips are not thread-safe.
    This is because naive updates are not atomic:
    they read the whole word from memory,
    then modify a bit, then write the whole word back.
    Concurrently modifying non-intersecting slices of the same underlying array
    may also lead to unexpected results, since they can share a word in memory.
    * "Data.Bit.ThreadSafe" is slower (usually 10-20%),
    but writes and flips are thread-safe.
    Additionally, concurrently modifying non-intersecting slices of the same underlying array
    works as expected. However, operations that affect multiple elements are not
    guaranteed to be atomic.

    === Similar packages

    * <https://hackage.haskell.org/package/bv bv> and
    <https://hackage.haskell.org/package/bv-little bv-little>
    do not offer mutable vectors.

    * <https://hackage.haskell.org/package/array array>
    is memory-efficient for '\''Bool'\'', but lacks
    a handy '\''Vector'\'' interface and is not thread-safe.

category:             Data, Bit Vectors
abi:                  feded05e2d2bd6ce876565013ac28f5a
exposed:              True
exposed-modules:      Data.Bit Data.Bit.ThreadSafe
hidden-modules:
    Data.Bit.F2Poly Data.Bit.F2PolyTS Data.Bit.Immutable
    Data.Bit.ImmutableTS Data.Bit.Internal Data.Bit.InternalTS
    Data.Bit.Mutable Data.Bit.MutableTS Data.Bit.PdepPext
    Data.Bit.Utils Data.Bit.SIMD

import-dirs:          /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.5.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.5.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bitvec
hs-libraries:         HSbitvec-1.1.5.0-298xCLFLZGyJSa38yDtOnw
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-BeRIw0AUz65FDgv1GzpeGd
    vector-0.13.2.0-24VaMY7coOLw3wI0c1W3K

haddock-interfaces:   /usr/share/doc/haskell-bitvec/html/bitvec.haddock
haddock-html:         /usr/share/doc/haskell-bitvec/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

