#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 base64
version:              1.0
visibility:           public
id:                   base64-1.0-HCd4N4HGSTR3ghB8sAevi7
key:                  base64-1.0-HCd4N4HGSTR3ghB8sAevi7
license:              BSD-3-Clause
copyright:            (c) 2019-2023 Emily Pillmore
maintainer:
    Emily Pillmore <emilypi@cohomolo.gy>
    , Sofia-m-a <https://github.com/sofia-m-a>

author:               Emily Pillmore
homepage:             https://github.com/emilypi/base64
synopsis:             A modern Base64 library
description:
    A performant, featureful RFC 4648 and 7049-compliant Base64 implementation

category:             Data
abi:                  81f1b3b247fdadc70727f15fdfc6b424
exposed:              True
exposed-modules:
    Data.Base64.Types Data.ByteString.Base64 Data.ByteString.Base64.URL
    Data.ByteString.Lazy.Base64 Data.ByteString.Lazy.Base64.URL
    Data.ByteString.Short.Base64 Data.ByteString.Short.Base64.URL
    Data.Text.Encoding.Base64 Data.Text.Encoding.Base64.Error
    Data.Text.Encoding.Base64.URL Data.Text.Lazy.Encoding.Base64
    Data.Text.Lazy.Encoding.Base64.URL Data.Text.Short.Encoding.Base64
    Data.Text.Short.Encoding.Base64.URL

hidden-modules:
    Data.Base64.Types.Internal Data.ByteString.Base64.Internal
    Data.ByteString.Base64.Internal.Head
    Data.ByteString.Base64.Internal.Tables
    Data.ByteString.Base64.Internal.Tail
    Data.ByteString.Base64.Internal.Utils
    Data.ByteString.Base64.Internal.W16.Loop
    Data.ByteString.Base64.Internal.W64.Loop

import-dirs:          /usr/lib/ghc-9.4.8/site-local/base64-1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/base64-1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/base64-1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-base64
hs-libraries:         HSbase64-1.0-HCd4N4HGSTR3ghB8sAevi7
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 text-2.0.2
    text-short-0.1.6-667XBtk7wjZ44SMyYYC3F0

haddock-interfaces:   /usr/share/doc/haskell-base64/html/base64.haddock
haddock-html:         /usr/share/doc/haskell-base64/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

