#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 atomic-write
version:              0.2.1.1
visibility:           public
id:                   atomic-write-0.2.1.1-F1y9kZ9C32y8ybV8D8JKxi
key:                  atomic-write-0.2.1.1-F1y9kZ9C32y8ybV8D8JKxi
license:              MIT
copyright:            2015-2019 Stack Builders Inc.
maintainer:           support@stackbuilders.com
author:               Justin Leitgeb
homepage:             https://github.com/stackbuilders/atomic-write
synopsis:             Atomically write to a file
description:

    Atomically write to a file on POSIX-compliant systems while preserving
    permissions.

    On most Unix systems, `mv` is an atomic operation. This makes it simple to write
    to a file atomically just by using the mv operation. However, this will
    destroy the permissions on the original file. This library does the following
    to preserve permissions while atomically writing to a file:

    * If an original file exists, take those permissions and apply them to the
    temp file before `mv`ing the file into place.

    * If the original file does not exist, create a following with default
    permissions (based on the currently-active umask).

    This way, when the file is `mv`'\''ed into place, the permissions will be the ones
    held by the original file.

    This library is based on similar implementations found in common libraries in
    Ruby and Python:

    * <http://apidock.com/rails/File/atomic_write/class Ruby on Rails includes a similar method called atomic_write>

    * <https://github.com/chef/chef/blob/c4631816132fcfefaba3d123a1d0dfe8bc2866bb/lib/chef/file_content_management/deploy/mv_unix.rb#L23:L71 Chef includes atomic update functionality>

    * <https://github.com/sashka/atomicfile There is a python library for atomically updating a file>

    To use `atomic-write`, import the module corresponding to the type you wish to
    write atomically, e.g., to write a (strict) ByteString atomically:

    > import System.AtomicWrite.Writer.ByteString

    Then you can use the atomicWriteFile function that accepts a `FilePath` and a
    `ByteString`, e.g.:

    > atomicWriteFile myFilePath myByteString

category:             System
abi:                  a8b7d5ce30f1c9cd9123aa3e8cc9fa5e
exposed:              True
exposed-modules:
    System.AtomicWrite.Writer.ByteString
    System.AtomicWrite.Writer.ByteString.Binary
    System.AtomicWrite.Writer.ByteStringBuilder
    System.AtomicWrite.Writer.LazyByteString
    System.AtomicWrite.Writer.LazyByteString.Binary
    System.AtomicWrite.Writer.LazyText
    System.AtomicWrite.Writer.LazyText.Binary
    System.AtomicWrite.Writer.String
    System.AtomicWrite.Writer.String.Binary
    System.AtomicWrite.Writer.Text
    System.AtomicWrite.Writer.Text.Binary

hidden-modules:       System.AtomicWrite.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/atomic-write-0.2.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/atomic-write-0.2.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/atomic-write-0.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-atomic-write
hs-libraries:         HSatomic-write-0.2.1.1-F1y9kZ9C32y8ybV8D8JKxi
depends:
    base-4.17.2.1 bytestring-0.11.5.3 directory-1.3.7.1
    filepath-1.4.2.2 temporary-1.3-KbjBnRExPZiB3fvyB84Pcu text-2.0.2
    unix-compat-0.7.4.1-9iy3Mma5ULC2KPJCZc9N5C

haddock-interfaces:
    /usr/share/doc/haskell-atomic-write/html/atomic-write.haddock

haddock-html:         /usr/share/doc/haskell-atomic-write/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

